/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import java.util.ArrayList;
import parser.ast.ASTElement;
import parser.ast.Expression;
import parser.ast.RewardStructItem;
import parser.visitor.ASTVisitor;
import parser.visitor.DeepCopy;
import prism.PrismLangException;

public class RewardStruct
extends ASTElement {
    private String name = "";
    private ArrayList<RewardStructItem> items = new ArrayList();
    private int numStateItems = 0;
    private int numTransItems = 0;

    public void setName(String string) {
        this.name = string;
    }

    public void addItem(String string, Expression expression, Expression expression2) {
        this.addItem(new RewardStructItem(string, expression, expression2));
    }

    public void addItem(RewardStructItem rewardStructItem) {
        this.items.add(rewardStructItem);
        if (rewardStructItem.isTransitionReward()) {
            ++this.numTransItems;
        } else {
            ++this.numStateItems;
        }
    }

    public void setRewardStructItem(int n, RewardStructItem rewardStructItem) {
        if (this.getRewardStructItem(n).isTransitionReward()) {
            --this.numTransItems;
        } else {
            --this.numStateItems;
        }
        this.items.set(n, rewardStructItem);
        if (rewardStructItem.isTransitionReward()) {
            ++this.numTransItems;
        } else {
            ++this.numStateItems;
        }
    }

    public String getName() {
        return this.name;
    }

    public int getNumItems() {
        return this.items.size();
    }

    public int getNumStateItems() {
        return this.numStateItems;
    }

    public int getNumTransItems() {
        return this.numTransItems;
    }

    public RewardStructItem getRewardStructItem(int n) {
        return this.items.get(n);
    }

    public String getSynch(int n) {
        return this.getRewardStructItem(n).getSynch();
    }

    public Expression getStates(int n) {
        return this.getRewardStructItem(n).getStates();
    }

    public Expression getReward(int n) {
        return this.getRewardStructItem(n).getReward();
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public String toString() {
        Object object = "";
        object = (String)object + "rewards";
        if (this.name != null && this.name.length() > 0) {
            object = (String)object + " \"" + this.name + "\"";
        }
        object = (String)object + " \n\n";
        int n = this.getNumItems();
        for (int i = 0; i < n; ++i) {
            object = (String)object + "\t" + String.valueOf(this.getRewardStructItem(i)) + "\n";
        }
        object = (String)object + "\nendrewards\n";
        return object;
    }

    @Override
    public RewardStruct deepCopy(DeepCopy deepCopy) throws PrismLangException {
        deepCopy.copyAll(this.items);
        return this;
    }

    @Override
    public RewardStruct clone() {
        RewardStruct rewardStruct = (RewardStruct)super.clone();
        rewardStruct.items = (ArrayList)this.items.clone();
        return rewardStruct;
    }
}

