/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import java.util.ArrayList;
import java.util.stream.Collectors;
import parser.ast.ASTElement;
import parser.ast.Expression;
import parser.ast.ExpressionIdent;
import parser.visitor.ASTVisitor;
import parser.visitor.DeepCopy;
import prism.PrismLangException;

public class ObservableVars
extends ASTElement {
    private ArrayList<Expression> vars = new ArrayList();

    public void addVar(Expression expression) {
        this.vars.add(expression);
    }

    public void addVar(String string) {
        this.addVar(new ExpressionIdent(string));
    }

    public void setVar(int n, Expression expression) {
        this.vars.set(n, expression);
    }

    public int getNumVars() {
        return this.vars.size();
    }

    public Expression getVar(int n) {
        return this.vars.get(n);
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public String toString() {
        Object object = "observables";
        if (!this.vars.isEmpty()) {
            object = (String)object + this.vars.stream().map(expression -> expression.toString()).collect(Collectors.joining(", ", " ", ""));
        }
        object = (String)object + " endobservables";
        return object;
    }

    @Override
    public ObservableVars deepCopy(DeepCopy deepCopy) throws PrismLangException {
        deepCopy.copyAll(this.vars);
        return this;
    }

    @Override
    public ObservableVars clone() {
        ObservableVars observableVars = (ObservableVars)super.clone();
        observableVars.vars = (ArrayList)this.vars.clone();
        return observableVars;
    }
}

