/*
 * Decompiled with CFR 0.152.
 */
package jltl2dstar;

import jltl2dstar.RabinAcceptance;
import jltl2dstar.RabinSignature;
import prism.PrismException;

public class UnionAcceptanceCalculator {
    private RabinAcceptance _acc_1;
    private RabinAcceptance _acc_2;
    private int _acc_size_1;
    private int _acc_size_2;

    public UnionAcceptanceCalculator(RabinAcceptance rabinAcceptance, RabinAcceptance rabinAcceptance2) throws PrismException {
        this._acc_1 = rabinAcceptance;
        this._acc_2 = rabinAcceptance2;
        this._acc_size_1 = this._acc_1.size();
        this._acc_size_2 = this._acc_2.size();
    }

    public void prepareAcceptance(RabinAcceptance rabinAcceptance) {
        rabinAcceptance.newAcceptancePairs(this._acc_size_1 + this._acc_size_2);
    }

    RabinSignature calculateAcceptance(int n, int n2) {
        int n3;
        RabinSignature rabinSignature = new RabinSignature(this._acc_size_1 + this._acc_size_2);
        for (n3 = 0; n3 < this._acc_size_1; ++n3) {
            if (this._acc_1.isStateInAcceptance_L(n3, n)) {
                rabinSignature.setL(n3, true);
            }
            if (!this._acc_1.isStateInAcceptance_U(n3, n)) continue;
            rabinSignature.setU(n3, true);
        }
        for (n3 = 0; n3 < this._acc_size_2; ++n3) {
            if (this._acc_2.isStateInAcceptance_L(n3, n2)) {
                rabinSignature.setL(n3 + this._acc_size_1, true);
            }
            if (!this._acc_2.isStateInAcceptance_U(n3, n2)) continue;
            rabinSignature.setU(n3 + this._acc_size_1, true);
        }
        return rabinSignature;
    }
}

