/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import common.IterableStateSet;
import common.iterable.FunctionalPrimitiveIterator;
import explicit.Model;
import explicit.ModelCheckerResult;
import explicit.Pareto;
import explicit.Product;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.IntFunction;
import parser.State;
import parser.ast.ExpressionFilter;
import parser.type.Type;
import parser.type.TypeBool;
import parser.type.TypeDouble;
import parser.type.TypeInt;
import prism.Accuracy;
import prism.AccuracyFactory;
import prism.PrismException;
import prism.PrismLangException;
import prism.PrismLog;
import prism.ResultTesting;
import prism.StateVector;

public class StateValues
implements StateVector,
Iterable<Object> {
    protected Type type;
    protected int size;
    public Accuracy accuracy = null;
    protected List<State> statesList;
    protected BitSet valuesB;
    protected Object[] valuesO;

    public StateValues() {
        this.type = null;
        this.size = 0;
        this.valuesB = null;
        this.valuesO = null;
    }

    public StateValues(Type type, ValueDefinition valueDefinition, Model<?> model) throws PrismException {
        this.initialise(type, model);
        this.setFromValueDefinition(valueDefinition);
    }

    public StateValues(Type type, Object object, Model<?> model) throws PrismException {
        this.initialise(type, model);
        this.setToSingleValue(object);
    }

    public StateValues(Type type, Model<?> model) throws PrismException {
        this(type, type.defaultValue(), model);
    }

    private void initialise(Type type, Model<?> model) {
        this.type = type;
        this.size = model.getNumStates();
        this.statesList = model.getStatesList();
        this.valuesB = null;
        this.valuesO = null;
    }

    private void initialise(Type type, List<State> list) {
        this.type = type;
        this.size = list.size();
        this.statesList = list;
        this.valuesB = null;
        this.valuesO = null;
    }

    private void setFromValueDefinition(ValueDefinition valueDefinition) throws PrismException {
        this.initStorage(this.type);
        for (int i = 0; i < this.size; ++i) {
            this.setValue(i, valueDefinition.apply(i));
        }
    }

    private void setToSingleValue(Object object) throws PrismException {
        this.initStorage(this.type);
        if (this.type instanceof TypeBool) {
            if (((Boolean)object).booleanValue()) {
                this.valuesB = new BitSet(this.size);
                this.valuesB.set(0, this.size);
            } else {
                this.valuesB = new BitSet();
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.valuesO[i] = object;
            }
        }
    }

    private void initStorage(Type type) {
        if (type instanceof TypeBool) {
            if (this.valuesB == null) {
                this.valuesB = new BitSet();
            }
        } else if (this.valuesO == null) {
            this.valuesO = new Object[this.size];
        }
    }

    private void clearOldStorage() {
        if (this.type != null) {
            if (this.type instanceof TypeBool) {
                this.valuesO = null;
            } else {
                this.valuesB = null;
            }
        }
    }

    public static StateValues create(Type type, ValueDefinition valueDefinition, Model<?> model) throws PrismException {
        StateValues stateValues = new StateValues();
        stateValues.initialise(type, model);
        stateValues.setFromValueDefinition(valueDefinition);
        return stateValues;
    }

    public static StateValues createFromSingleValue(Type type, Object object, Model<?> model) throws PrismException {
        StateValues stateValues = new StateValues();
        stateValues.initialise(type, model);
        stateValues.setToSingleValue(object);
        return stateValues;
    }

    public static StateValues createFromObjectArray(Type type, Object[] objectArray, Model<?> model) {
        StateValues stateValues = new StateValues();
        stateValues.initialise(type, model);
        stateValues.valuesO = objectArray;
        return stateValues;
    }

    public static StateValues createFromDoubleArray(double[] dArray, Model<?> model) throws PrismException {
        return StateValues.create(TypeDouble.getInstance(), n -> dArray[n], model);
    }

    public static StateValues createFromDoubleArray(double[] dArray, List<State> list) throws PrismException {
        StateValues stateValues = new StateValues();
        stateValues.initialise((Type)TypeDouble.getInstance(), list);
        stateValues.setFromValueDefinition(n -> dArray[n]);
        return stateValues;
    }

    public static StateValues createFromDoubleArrayResult(ModelCheckerResult modelCheckerResult, Model<?> model) throws PrismException {
        StateValues stateValues = StateValues.createFromDoubleArray(modelCheckerResult.soln, model);
        stateValues.setAccuracy(modelCheckerResult.accuracy);
        return stateValues;
    }

    public static StateValues createFromBitSet(BitSet bitSet, Model<?> model) {
        StateValues stateValues = new StateValues();
        stateValues.initialise((Type)TypeBool.getInstance(), model);
        stateValues.valuesB = bitSet;
        return stateValues;
    }

    public static StateValues createFromBitSetAsDoubles(BitSet bitSet, Model<?> model) throws PrismException {
        StateValues stateValues = StateValues.create(TypeDouble.getInstance(), n -> bitSet.get(n) ? 1.0 : 0.0, model);
        stateValues.setAccuracy(AccuracyFactory.doublesFromQualitative());
        return stateValues;
    }

    public static StateValues createFromArrayResult(ModelCheckerResult modelCheckerResult, Model<?> model) throws PrismException {
        StateValues stateValues = null;
        stateValues = modelCheckerResult.solnObj != null ? StateValues.createFromObjectArray(TypeDouble.getInstance(), modelCheckerResult.solnObj, model) : StateValues.createFromDoubleArray(modelCheckerResult.soln, model);
        stateValues.setAccuracy(modelCheckerResult.accuracy);
        return stateValues;
    }

    public static StateValues createFromFile(Type type, File file, Model<?> model) throws PrismException {
        StateValues stateValues = new StateValues();
        stateValues.initialise(type, model);
        stateValues.readFromFile(file);
        return stateValues;
    }

    public StateValues mapToNewModel(Model<?> model, IntFunction<Integer> intFunction) throws PrismException {
        int n = model.getNumStates();
        StateValues stateValues = StateValues.create(this.type, n2 -> {
            Integer n3 = (Integer)intFunction.apply(n2);
            if (n3 != null) {
                if (n3 >= n) {
                    throw new IndexOutOfBoundsException("State index error when mapping between models");
                }
                return this.getValue(n3);
            }
            return this.type.defaultValue();
        }, model);
        stateValues.setAccuracy(this.getAccuracy());
        return stateValues;
    }

    public StateValues projectToOriginalModel(Product<?> product) throws PrismException {
        Object obj = product.getProductModel();
        Object obj2 = product.getOriginalModel();
        StateValues stateValues = new StateValues(this.type, (Model<?>)obj2);
        for (int n : obj.getInitialStates()) {
            int n2 = product.getModelState(n);
            stateValues.setValue(n2, this.getValue(n));
        }
        stateValues.setAccuracy(this.getAccuracy());
        return stateValues;
    }

    public void setAccuracy(Accuracy accuracy) {
        this.accuracy = accuracy;
    }

    @Override
    public void clear() {
        this.valuesB = null;
        this.valuesO = null;
    }

    public void setValue(int n, Object object) throws PrismLangException {
        if (this.type instanceof TypeBool) {
            this.valuesB.set(n, (Boolean)object);
        } else {
            this.valuesO[n] = object;
        }
    }

    private void setValue(int n, Object object, Type type) throws PrismLangException {
        if (type instanceof TypeBool) {
            this.valuesB.set(n, (Boolean)object);
        } else {
            this.valuesO[n] = object;
        }
    }

    public void applyPredicate(Predicate predicate) throws PrismException {
        this.initStorage(TypeBool.getInstance());
        this.valuesB = this.getBitSetFromPredicate(predicate);
        this.type = TypeBool.getInstance();
        this.clearOldStorage();
    }

    public void applyFunction(Type type, UnaryFunction unaryFunction) throws PrismException {
        this.initStorage(type);
        for (int i = 0; i < this.size; ++i) {
            this.setValue(i, unaryFunction.apply(this.getValue(i)), type);
        }
        this.type = type;
        this.clearOldStorage();
    }

    public void applyFunction(Type type, UnaryFunction unaryFunction, BitSet bitSet) throws PrismException {
        this.initStorage(type);
        FunctionalPrimitiveIterator.OfInt ofInt = new IterableStateSet(bitSet, this.size).iterator();
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            this.setValue(n, unaryFunction.apply(this.getValue(n)), type);
        }
        this.type = type;
        this.clearOldStorage();
    }

    public void applyFunction(Type type, BinaryFunction binaryFunction, StateValues stateValues) throws PrismException {
        this.initStorage(type);
        for (int i = 0; i < this.size; ++i) {
            this.setValue(i, binaryFunction.apply(this.getValue(i), stateValues.getValue(i)), type);
        }
        this.type = type;
        this.clearOldStorage();
    }

    public void applyFunction(Type type, BinaryFunction binaryFunction, StateValues stateValues, BitSet bitSet) throws PrismException {
        this.initStorage(type);
        FunctionalPrimitiveIterator.OfInt ofInt = new IterableStateSet(bitSet, this.size).iterator();
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            this.setValue(n, binaryFunction.apply(this.getValue(n), stateValues.getValue(n)), type);
        }
        this.type = type;
        this.clearOldStorage();
    }

    public void applyFunction(Type type, TernaryFunction ternaryFunction, StateValues stateValues, StateValues stateValues2) throws PrismException {
        this.initStorage(type);
        for (int i = 0; i < this.size; ++i) {
            this.setValue(i, ternaryFunction.apply(this.getValue(i), stateValues.getValue(i), stateValues2.getValue(i)), type);
        }
        this.type = type;
        this.clearOldStorage();
    }

    public void applyFunction(Type type, TernaryFunction ternaryFunction, StateValues stateValues, StateValues stateValues2, BitSet bitSet) throws PrismException {
        this.initStorage(type);
        FunctionalPrimitiveIterator.OfInt ofInt = new IterableStateSet(bitSet, this.size).iterator();
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            this.setValue(n, ternaryFunction.apply(this.getValue(n), stateValues.getValue(n), stateValues2.getValue(n)), type);
        }
        this.type = type;
        this.clearOldStorage();
    }

    public void readFromFile(File file) throws PrismException {
        this.initStorage(this.type);
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            String string = bufferedReader.readLine();
            ++n;
            while (string != null) {
                if (!"".equals(string = string.trim())) {
                    if (string.contains("=")) {
                        bl = true;
                        String[] stringArray = string.split("=");
                        n2 = Integer.parseInt(stringArray[0]);
                        string = stringArray[1];
                    }
                    if (n2 + 1 > this.size) {
                        bufferedReader.close();
                        throw new PrismException("Too many values in file \"" + String.valueOf(file) + "\" (more than " + this.size + ")");
                    }
                    if (this.type instanceof TypeInt) {
                        this.setValue(n2, Integer.parseInt(string));
                    } else if (this.type instanceof TypeDouble) {
                        this.setValue(n2, Double.parseDouble(string));
                    } else if (this.type instanceof TypeBool) {
                        this.setValue(n2, Boolean.parseBoolean(string));
                    }
                    ++n2;
                }
                string = bufferedReader.readLine();
                ++n;
            }
            if (!bl && n2 < this.size) {
                throw new PrismException("Too few values in file \"" + String.valueOf(file) + "\" (" + n2 + ", not " + this.size + ")");
            }
        }
        catch (IOException iOException) {
            throw new PrismException("File I/O error reading from \"" + String.valueOf(file) + "\"");
        }
        catch (NumberFormatException numberFormatException) {
            throw new PrismException("Error detected at line " + n + " of file \"" + String.valueOf(file) + "\"");
        }
    }

    public void implies(StateValues stateValues) throws PrismException {
        if (!(this.type instanceof TypeBool) || !(stateValues.getType() instanceof TypeBool)) {
            throw new PrismException("Operator => can only be applied to Boolean vectors");
        }
        this.valuesB.flip(0, this.size);
        this.valuesB.or(stateValues.valuesB);
    }

    public void iff(StateValues stateValues) throws PrismException {
        if (!(this.type instanceof TypeBool) || !(stateValues.getType() instanceof TypeBool)) {
            throw new PrismException("Operator <=> can only be applied to Boolean vectors");
        }
        this.valuesB.xor(stateValues.valuesB);
        this.valuesB.flip(0, this.size);
    }

    public void or(StateValues stateValues) throws PrismException {
        if (!(this.type instanceof TypeBool) || !(stateValues.getType() instanceof TypeBool)) {
            throw new PrismException("Operator | can only be applied to Boolean vectors");
        }
        this.valuesB.or(stateValues.valuesB);
    }

    public void and(StateValues stateValues) throws PrismException {
        if (!(this.type instanceof TypeBool) || !(stateValues.getType() instanceof TypeBool)) {
            throw new PrismException("Operator & can only be applied to Boolean vectors");
        }
        this.valuesB.and(stateValues.valuesB);
    }

    public void complement() throws PrismException {
        if (!(this.type instanceof TypeBool)) {
            throw new PrismException("Can only complement Boolean vectors");
        }
        this.valuesB.flip(0, this.size);
    }

    public void not() throws PrismException {
        if (!(this.type instanceof TypeBool)) {
            throw new PrismException("Operator ! can only be applied to Boolean vectors");
        }
        this.valuesB.flip(0, this.size);
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    public Accuracy getAccuracy() {
        return this.accuracy;
    }

    @Override
    public Object getValue(int n) {
        if (this.type instanceof TypeBool) {
            return this.valuesB.get(n);
        }
        return this.valuesO[n];
    }

    public Object firstFromBitSet(BitSet bitSet) {
        return this.getValue(bitSet.nextSetBit(0));
    }

    @Override
    public Iterator<Object> iterator() {
        return new Iterator<Object>(){
            int i = 0;

            @Override
            public Object next() {
                return StateValues.this.getValue(this.i++);
            }

            @Override
            public boolean hasNext() {
                return this.i < StateValues.this.size;
            }
        };
    }

    public Iterable<Object> filtered(final BitSet bitSet) {
        return new Iterable<Object>(){

            @Override
            public Iterator<Object> iterator() {
                return new Iterator<Object>(){
                    int i;
                    {
                        this.i = bitSet.nextSetBit(0);
                    }

                    @Override
                    public Object next() {
                        Object object = StateValues.this.getValue(this.i);
                        this.i = bitSet.nextSetBit(this.i + 1);
                        return object;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i >= 0;
                    }
                };
            }
        };
    }

    public BitSet getBitSet() {
        return this.valuesB;
    }

    public double[] getDoubleArray() {
        double[] dArray = new double[this.size];
        for (int i = 0; i < this.size; ++i) {
            dArray[i] = (Double)this.valuesO[i];
        }
        return dArray;
    }

    public Pareto[] getParetoArray() {
        Pareto[] paretoArray = new Pareto[this.size];
        for (int i = 0; i < this.size; ++i) {
            paretoArray[i] = (Pareto)this.valuesO[i];
        }
        return paretoArray;
    }

    public BitSet getBitSetFromPredicate(Predicate predicate) throws PrismException {
        BitSet bitSet = new BitSet();
        for (int i = 0; i < this.size; ++i) {
            bitSet.set(i, predicate.test(this.getValue(i)));
        }
        return bitSet;
    }

    public BitSet getBitSetFromCloseValue(Object object) throws PrismException {
        Accuracy accuracy = ResultTesting.getTestingAccuracy(this.getAccuracy());
        return this.getBitSetFromCloseValue(object, accuracy);
    }

    public BitSet getBitSetFromCloseValue(Object object, double d, boolean bl) throws PrismException {
        Accuracy accuracy = new Accuracy(Accuracy.AccuracyLevel.BOUNDED, d, bl);
        return this.getBitSetFromCloseValue(object, accuracy);
    }

    public BitSet getBitSetFromCloseValue(Object object, Accuracy accuracy) throws PrismException {
        return this.getBitSetFromPredicate(object2 -> ExpressionFilter.isClose(object2, object, this.getType(), accuracy));
    }

    public void print(PrismLog prismLog) {
        this.doPrinting(prismLog, -1, null, true, false, true, true);
    }

    public void print(PrismLog prismLog, int n) {
        this.doPrinting(prismLog, n, null, true, false, true, true);
    }

    @Override
    public void print(PrismLog prismLog, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.doPrinting(prismLog, -1, null, bl, bl2, bl3, bl4);
    }

    public void printFiltered(PrismLog prismLog, BitSet bitSet) {
        this.doPrinting(prismLog, -1, bitSet, true, false, true, true);
    }

    public void printFiltered(PrismLog prismLog, BitSet bitSet, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.doPrinting(prismLog, -1, bitSet, bl, bl2, bl3, bl4);
    }

    private void doPrinting(PrismLog prismLog, int n, BitSet bitSet, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n2 = 0;
        if (n == -1) {
            n = Integer.MAX_VALUE;
        }
        if (bl2) {
            prismLog.println((String)(!bl ? "v = [" : "v = sparse(" + this.size + ",1);"));
        }
        if (bitSet == null) {
            int n3 = 0;
            while (n3 < this.size & n2 < n) {
                if (this.printLine(prismLog, n3, bl, bl2, bl3, bl4)) {
                    ++n2;
                }
                ++n3;
            }
        } else {
            int n4 = bitSet.nextSetBit(0);
            while (n4 >= 0 && n2 < n) {
                if (this.printLine(prismLog, n4, bl, bl2, bl3, bl4)) {
                    ++n2;
                }
                n4 = bitSet.nextSetBit(n4 + 1);
            }
        }
        if (bl && !bl2 && n2 == 0) {
            prismLog.println(this.type == TypeBool.getInstance() ? "(none)" : "(all zero)");
            return;
        }
        if (bl2 && !bl) {
            prismLog.println("];");
        }
    }

    private boolean printLine(PrismLog prismLog, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (!bl || this.isValueNonZero(this.getValue(n))) {
            if (bl2) {
                if (bl) {
                    prismLog.println("v(" + (n + 1) + ")=" + String.valueOf(this.getValue(n)) + ";");
                } else {
                    prismLog.println(this.getValue(n));
                }
            } else {
                if (bl4) {
                    prismLog.print(n);
                }
                if (bl3 && this.statesList != null) {
                    if (bl4) {
                        prismLog.print(":");
                    }
                    prismLog.print(this.statesList.get(n).toString());
                }
                if (bl && this.type instanceof TypeBool) {
                    prismLog.println();
                } else {
                    if (bl4 || bl3) {
                        prismLog.print("=");
                    }
                    prismLog.println(this.getValue(n));
                }
            }
            return true;
        }
        return false;
    }

    private boolean isValueNonZero(Object object) {
        if (object instanceof Integer) {
            return (Integer)object != 0;
        }
        if (object instanceof Double) {
            return (Double)object != 0.0;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return true;
    }

    public StateValues deepCopy() throws PrismException {
        StateValues stateValues = new StateValues();
        stateValues.type = this.type;
        stateValues.size = this.size;
        stateValues.accuracy = this.accuracy;
        stateValues.statesList = this.statesList;
        if (this.valuesB != null) {
            stateValues.valuesB = (BitSet)this.valuesB.clone();
        }
        if (this.valuesO != null) {
            stateValues.valuesO = (Object[])this.valuesO.clone();
        }
        return stateValues;
    }

    public String toString() {
        if (this.type instanceof TypeBool) {
            return this.valuesB.toString();
        }
        return Arrays.toString(this.valuesO);
    }

    @FunctionalInterface
    public static interface ValueDefinition {
        public Object apply(int var1) throws PrismException;
    }

    @FunctionalInterface
    public static interface Predicate {
        public boolean test(Object var1) throws PrismException;
    }

    @FunctionalInterface
    public static interface UnaryFunction {
        public Object apply(Object var1) throws PrismException;
    }

    @FunctionalInterface
    public static interface BinaryFunction {
        public Object apply(Object var1, Object var2) throws PrismException;
    }

    @FunctionalInterface
    public static interface TernaryFunction {
        public Object apply(Object var1, Object var2, Object var3) throws PrismException;
    }
}

