/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import acceptance.AcceptanceReach;
import common.IterableBitSet;
import common.iterable.FunctionalPrimitiveIterator;
import explicit.LTLModelChecker;
import explicit.MinMax;
import explicit.Model;
import explicit.ModelCheckerResult;
import explicit.ProbModelChecker;
import explicit.STPG;
import explicit.STPGAbstrSimple;
import explicit.StateModelChecker;
import explicit.StateValues;
import explicit.Utils;
import explicit.rewards.RewardsSimple;
import explicit.rewards.STPGRewards;
import explicit.rewards.StateRewardsConstant;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import parser.ast.Expression;
import prism.AccuracyFactory;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismFileLog;
import prism.PrismLog;
import prism.PrismNotSupportedException;
import prism.PrismUtils;
import strat.BoundedRewardDeterministicStrategy;
import strat.FMDStrategyProduct;
import strat.FMDStrategyStep;
import strat.MDStrategy;
import strat.MDStrategyArray;
import strat.Strategy;

public class STPGModelChecker
extends ProbModelChecker {
    public static final int R_INFINITY = 0;
    public static final int R_CUMULATIVE = 1;
    public static final int R_ZERO = 2;

    public STPGModelChecker(PrismComponent prismComponent) throws PrismException {
        super(prismComponent);
    }

    @Override
    protected StateValues checkProbPathFormulaLTL(Model<?> model, Expression expression, boolean bl, MinMax minMax, BitSet bitSet) throws PrismException {
        throw new PrismNotSupportedException("Full LTL model checking not yet supported for stochastic games");
    }

    @Override
    protected StateValues checkProbPathFormulaCosafeLTL(Model<?> model, Expression expression, boolean bl, MinMax minMax, BitSet bitSet) throws PrismException {
        Object object;
        LTLModelChecker lTLModelChecker = new LTLModelChecker(this);
        LTLModelChecker.LTLProduct<STPG> lTLProduct = lTLModelChecker.constructDFAProductForCosafetyProbLTL(this, (STPG)model, expression, bitSet);
        this.doProductExports(lTLProduct);
        BitSet bitSet2 = ((AcceptanceReach)lTLProduct.getAcceptance()).getGoalStates();
        this.mainLog.println("\nComputing reachability probabilities...");
        STPGModelChecker sTPGModelChecker = new STPGModelChecker(this);
        sTPGModelChecker.inheritSettings(this);
        ModelCheckerResult modelCheckerResult = sTPGModelChecker.computeReachProbs((STPG)lTLProduct.getProductModel(), bitSet2, minMax.isMin1(), minMax.isMin2());
        StateValues stateValues = StateValues.createFromArrayResult(modelCheckerResult, lTLProduct.getProductModel());
        if (this.getExportProductVector()) {
            this.mainLog.println("\nExporting product solution vector matrix to file \"" + this.getExportProductVectorFilename() + "\"...");
            object = new PrismFileLog(this.getExportProductVectorFilename());
            stateValues.print((PrismLog)object, false, false, false, false);
            ((PrismFileLog)object).close();
        }
        if (modelCheckerResult.strat != null) {
            object = new FMDStrategyProduct(lTLProduct, (MDStrategy)modelCheckerResult.strat);
            this.result.setStrategy((Strategy<?>)object);
        }
        object = lTLProduct.projectToOriginalModel(stateValues);
        stateValues.clear();
        return object;
    }

    public ModelCheckerResult computeNextProbs(STPG<Double> sTPG, BitSet bitSet, boolean bl, boolean bl2) throws PrismException {
        ModelCheckerResult modelCheckerResult = null;
        long l = System.currentTimeMillis();
        int n = sTPG.getNumStates();
        double[] dArray = Utils.bitsetToDoubleArray(bitSet, n);
        double[] dArray2 = new double[n];
        int[] nArray = null;
        if (this.genStrat) {
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = bitSet.get(i) ? -2 : -1;
            }
        }
        sTPG.mvMultMinMax(dArray, bl, bl2, dArray2, null, false, nArray);
        modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.accuracy = AccuracyFactory.boundedNumericalIterations();
        modelCheckerResult.soln = dArray2;
        modelCheckerResult.numIters = 1;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        if (this.genStrat) {
            modelCheckerResult.strat = new MDStrategyArray<Double>(sTPG, nArray);
        }
        return modelCheckerResult;
    }

    public ModelCheckerResult computeReachProbs(STPG<Double> sTPG, BitSet bitSet, boolean bl, boolean bl2) throws PrismException {
        return this.computeReachProbs(sTPG, bitSet, bl, bl2, -1.0);
    }

    public ModelCheckerResult computeReachProbs(STPG<Double> sTPG, BitSet bitSet, boolean bl, boolean bl2, double d) throws PrismException {
        return this.computeReachProbs(sTPG, null, bitSet, bl, bl2, null, null, d);
    }

    public ModelCheckerResult computeUntilProbs(STPG<Double> sTPG, BitSet bitSet, BitSet bitSet2, boolean bl, boolean bl2, double d) throws PrismException {
        return this.computeReachProbs(sTPG, bitSet, bitSet2, bl, bl2, null, null, d);
    }

    public ModelCheckerResult computeReachProbs(STPG<Double> sTPG, BitSet bitSet, BitSet bitSet2, boolean bl, boolean bl2, double[] dArray, BitSet bitSet3) throws PrismException {
        return this.computeReachProbs(sTPG, bitSet, bitSet2, bl, bl2, dArray, bitSet3, -1.0);
    }

    public ModelCheckerResult computeReachProbs(STPG<Double> sTPG, BitSet bitSet, BitSet bitSet2, boolean bl, boolean bl2, double[] dArray, BitSet bitSet3, double d) throws PrismException {
        long l;
        long l2;
        long l3;
        ModelCheckerResult modelCheckerResult;
        block11: {
            BitSet bitSet4;
            int n;
            block10: {
                modelCheckerResult = null;
                if (!(this.stpgSolnMethod != ProbModelChecker.STPGSolnMethod.VALUE_ITERATION || this.valIterDir != ProbModelChecker.ValIterDir.ABOVE || this.precomp && this.prob0)) {
                    throw new PrismException("Precomputation (Prob0) must be enabled for value iteration from above");
                }
                l3 = System.currentTimeMillis();
                if (this.verbosity >= 1) {
                    this.mainLog.println("\nStarting probabilistic reachability...");
                }
                sTPG.checkForDeadlocks(bitSet2);
                n = sTPG.getNumStates();
                if (dArray != null && bitSet3 != null && !bitSet3.isEmpty()) {
                    BitSet bitSet5 = (BitSet)bitSet2.clone();
                    FunctionalPrimitiveIterator.OfInt ofInt = new IterableBitSet(bitSet3).iterator();
                    while (ofInt.hasNext()) {
                        int n2 = (Integer)ofInt.next();
                        if (dArray[n2] != 1.0) continue;
                        bitSet5.set(n2);
                    }
                    bitSet2 = bitSet5;
                }
                l2 = System.currentTimeMillis();
                BitSet bitSet6 = this.precomp && this.prob0 ? this.prob0(sTPG, bitSet, bitSet2, bl, bl2) : new BitSet();
                l2 = System.currentTimeMillis() - l2;
                l = System.currentTimeMillis();
                bitSet4 = this.precomp && this.prob1 && !this.genStrat ? this.prob1(sTPG, bitSet, bitSet2, bl, bl2) : (BitSet)bitSet2.clone();
                l = System.currentTimeMillis() - l;
                int n3 = bitSet4.cardinality();
                int n4 = bitSet6.cardinality();
                if (this.verbosity >= 1) {
                    this.mainLog.println("target=" + bitSet2.cardinality() + ", yes=" + n3 + ", no=" + n4 + ", maybe=" + (n - (n3 + n4)));
                }
                if (!(d < 1.0) && this.precomp && this.prob1 && !this.genStrat) break block10;
                switch (this.stpgSolnMethod) {
                    case VALUE_ITERATION: {
                        modelCheckerResult = this.computeReachProbsValIter(sTPG, bitSet6, bitSet4, bl, bl2, dArray, bitSet3);
                        break block11;
                    }
                    case GAUSS_SEIDEL: {
                        modelCheckerResult = this.computeReachProbsGaussSeidel(sTPG, bitSet6, bitSet4, bl, bl2, dArray, bitSet3);
                        break block11;
                    }
                    default: {
                        throw new PrismException("Unknown STPG solution method " + String.valueOf((Object)this.stpgSolnMethod));
                    }
                }
            }
            modelCheckerResult = new ModelCheckerResult();
            modelCheckerResult.numIters = 0;
            modelCheckerResult.soln = Utils.bitsetToDoubleArray(bitSet4, n);
            modelCheckerResult.accuracy = AccuracyFactory.doublesFromQualitative();
            this.mainLog.println("Bound is 1, hence I am skipping the computation of other values than 1.");
        }
        l3 = System.currentTimeMillis() - l3;
        if (this.verbosity >= 1) {
            this.mainLog.println("Probabilistic reachability took " + (double)l3 / 1000.0 + " seconds.");
        }
        modelCheckerResult.timeTaken = (double)l3 / 1000.0;
        modelCheckerResult.timeProb0 = (double)l2 / 1000.0;
        modelCheckerResult.timePre = (double)(l2 + l) / 1000.0;
        return modelCheckerResult;
    }

    public BitSet prob0(STPG<?> sTPG, BitSet bitSet, BitSet bitSet2, boolean bl, boolean bl2) {
        long l = System.currentTimeMillis();
        if (this.verbosity >= 1) {
            this.mainLog.println("Starting Prob0 (" + (bl ? "min" : "max") + (bl2 ? "min" : "max") + ")...");
        }
        if (bitSet2.cardinality() == 0) {
            BitSet bitSet3 = new BitSet(sTPG.getNumStates());
            bitSet3.set(0, sTPG.getNumStates());
            return bitSet3;
        }
        int n = sTPG.getNumStates();
        BitSet bitSet4 = new BitSet(n);
        BitSet bitSet5 = new BitSet(n);
        BitSet bitSet6 = new BitSet();
        bitSet6.set(0, n);
        bitSet6.andNot(bitSet2);
        if (bitSet != null) {
            bitSet6.and(bitSet);
        }
        int n2 = 0;
        boolean bl3 = false;
        bitSet4.or(bitSet2);
        bitSet5.or(bitSet2);
        while (!bl3) {
            ++n2;
            sTPG.prob0step(bitSet6, bitSet4, bl, bl2, bitSet5);
            bl3 = bitSet5.equals(bitSet4);
            bitSet4.clear();
            bitSet4.or(bitSet5);
        }
        bitSet4.flip(0, n);
        l = System.currentTimeMillis() - l;
        if (this.verbosity >= 1) {
            this.mainLog.print("Prob0 (" + (bl ? "min" : "max") + (bl2 ? "min" : "max") + ")");
            this.mainLog.println(" took " + n2 + " iterations and " + (double)l / 1000.0 + " seconds.");
        }
        return bitSet4;
    }

    public BitSet prob1(STPG<?> sTPG, BitSet bitSet, BitSet bitSet2, boolean bl, boolean bl2) {
        long l = System.currentTimeMillis();
        if (this.verbosity >= 1) {
            this.mainLog.println("Starting Prob1 (" + (bl ? "min" : "max") + (bl2 ? "min" : "max") + ")...");
        }
        if (bitSet2.cardinality() == 0) {
            return new BitSet(sTPG.getNumStates());
        }
        int n = sTPG.getNumStates();
        BitSet bitSet3 = new BitSet(n);
        BitSet bitSet4 = new BitSet(n);
        BitSet bitSet5 = new BitSet(n);
        BitSet bitSet6 = new BitSet();
        bitSet6.set(0, n);
        bitSet6.andNot(bitSet2);
        if (bitSet != null) {
            bitSet6.and(bitSet);
        }
        int n2 = 0;
        boolean bl3 = false;
        bitSet3.set(0, n);
        while (!bl3) {
            boolean bl4 = false;
            bitSet4.clear();
            bitSet4.or(bitSet2);
            bitSet5.clear();
            bitSet5.or(bitSet2);
            while (!bl4) {
                ++n2;
                sTPG.prob1step(bitSet6, bitSet3, bitSet4, bl, bl2, bitSet5);
                bl4 = bitSet5.equals(bitSet4);
                bitSet4.clear();
                bitSet4.or(bitSet5);
            }
            bl3 = bitSet4.equals(bitSet3);
            bitSet3.clear();
            bitSet3.or(bitSet4);
        }
        l = System.currentTimeMillis() - l;
        if (this.verbosity >= 1) {
            this.mainLog.print("Prob1 (" + (bl ? "min" : "max") + (bl2 ? "min" : "max") + ")");
            this.mainLog.println(" took " + n2 + " iterations and " + (double)l / 1000.0 + " seconds.");
        }
        return bitSet3;
    }

    protected ModelCheckerResult computeReachProbsValIter(STPG<Double> sTPG, BitSet bitSet, BitSet bitSet2, boolean bl, boolean bl2, double[] dArray, BitSet bitSet3) throws PrismException {
        int n;
        int n2;
        double d;
        ModelCheckerResult modelCheckerResult = null;
        long l = System.currentTimeMillis();
        if (this.verbosity >= 1) {
            this.mainLog.println("Starting value iteration (" + (bl ? "min" : "max") + (bl2 ? "min" : "max") + ")...");
        }
        int n3 = sTPG.getNumStates();
        double[] dArray2 = new double[n3];
        double[] dArray3 = dArray == null ? new double[n3] : dArray;
        double d2 = d = this.valIterDir == ProbModelChecker.ValIterDir.BELOW ? 0.0 : 1.0;
        if (dArray != null) {
            if (bitSet3 != null) {
                for (n2 = 0; n2 < n3; ++n2) {
                    dArray3[n2] = bitSet3.get(n2) ? dArray[n2] : (bitSet2.get(n2) ? 1.0 : (bitSet.get(n2) ? 0.0 : dArray[n2]));
                    dArray2[n2] = dArray3[n2];
                }
            } else {
                for (n2 = 0; n2 < n3; ++n2) {
                    dArray3[n2] = bitSet2.get(n2) ? 1.0 : (bitSet.get(n2) ? 0.0 : dArray[n2]);
                    dArray2[n2] = dArray3[n2];
                }
            }
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                dArray3[n2] = bitSet2.get(n2) ? 1.0 : (bitSet.get(n2) ? 0.0 : d);
                dArray2[n2] = dArray3[n2];
            }
        }
        BitSet bitSet4 = new BitSet();
        bitSet4.set(0, n3);
        bitSet4.andNot(bitSet2);
        bitSet4.andNot(bitSet);
        if (bitSet3 != null) {
            bitSet4.andNot(bitSet3);
        }
        int[] nArray = null;
        if (this.genStrat) {
            nArray = new int[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                nArray[n2] = -1;
            }
            n2 = bitSet.nextSetBit(0);
            while (n2 >= 0) {
                int n4 = sTPG.getNumChoices(n2);
                for (int i = 0; i < n4; ++i) {
                    if (!sTPG.allSuccessorsInSet(n2, i, bitSet)) continue;
                    nArray[n2] = i;
                    break;
                }
                n2 = bitSet.nextSetBit(n2 + 1);
            }
        }
        boolean bl3 = false;
        for (n = 0; !bl3 && n < this.maxIters; ++n) {
            sTPG.mvMultMinMax(dArray2, bl, bl2, dArray3, bitSet4, false, nArray);
            bl3 = PrismUtils.doublesAreClose(dArray2, dArray3, this.termCritParam, this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE);
            double[] dArray4 = dArray2;
            dArray2 = dArray3;
            dArray3 = dArray4;
        }
        l = System.currentTimeMillis() - l;
        if (this.verbosity >= 1) {
            this.mainLog.print("Value iteration (" + (bl ? "min" : "max") + (bl2 ? "min" : "max") + ")");
            this.mainLog.println(" took " + n + " iterations and " + (double)l / 1000.0 + " seconds.");
        }
        if (!bl3 && this.errorOnNonConverge) {
            String string = "Iterative method did not converge within " + n + " iterations.";
            string = string + "\nConsider using a different numerical method or increasing the maximum number of iterations";
            throw new PrismException(string);
        }
        modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray2;
        double d3 = PrismUtils.measureSupNorm(dArray2, dArray3, this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE);
        modelCheckerResult.accuracy = AccuracyFactory.valueIteration(this.termCritParam, d3, this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE);
        modelCheckerResult.numIters = n;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        if (this.genStrat) {
            modelCheckerResult.strat = new MDStrategyArray<Double>(sTPG, nArray);
        }
        return modelCheckerResult;
    }

    protected ModelCheckerResult computeReachProbsGaussSeidel(STPG<Double> sTPG, BitSet bitSet, BitSet bitSet2, boolean bl, boolean bl2, double[] dArray, BitSet bitSet3) throws PrismException {
        int n;
        int n2;
        double d;
        double d2 = Double.POSITIVE_INFINITY;
        long l = System.currentTimeMillis();
        if (this.verbosity >= 1) {
            this.mainLog.println("Starting value iteration (Gauss-Seidel, " + (bl ? "min" : "max") + (bl2 ? "min" : "max") + ")...");
        }
        int n3 = sTPG.getNumStates();
        double[] dArray2 = dArray == null ? new double[n3] : dArray;
        double d3 = d = this.valIterDir == ProbModelChecker.ValIterDir.BELOW ? 0.0 : 1.0;
        if (dArray != null) {
            if (bitSet3 != null) {
                for (n2 = 0; n2 < n3; ++n2) {
                    dArray2[n2] = bitSet3.get(n2) ? dArray[n2] : (bitSet2.get(n2) ? 1.0 : (bitSet.get(n2) ? 0.0 : dArray[n2]));
                }
            } else {
                for (n2 = 0; n2 < n3; ++n2) {
                    dArray2[n2] = bitSet2.get(n2) ? 1.0 : (bitSet.get(n2) ? 0.0 : dArray[n2]);
                }
            }
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                dArray2[n2] = bitSet2.get(n2) ? 1.0 : (bitSet.get(n2) ? 0.0 : d);
            }
        }
        BitSet bitSet4 = new BitSet();
        bitSet4.set(0, n3);
        bitSet4.andNot(bitSet2);
        bitSet4.andNot(bitSet);
        if (bitSet3 != null) {
            bitSet4.andNot(bitSet3);
        }
        int[] nArray = null;
        if (this.genStrat) {
            nArray = new int[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                nArray[n2] = -1;
            }
            n2 = bitSet.nextSetBit(0);
            while (n2 >= 0) {
                int n4 = sTPG.getNumChoices(n2);
                for (int i = 0; i < n4; ++i) {
                    if (!sTPG.allSuccessorsInSet(n2, i, bitSet)) continue;
                    nArray[n2] = i;
                    break;
                }
                n2 = bitSet.nextSetBit(n2 + 1);
            }
        }
        boolean bl3 = false;
        for (n = 0; !bl3 && n < this.maxIters; ++n) {
            d2 = sTPG.mvMultGSMinMax(dArray2, bl, bl2, bitSet4, false, this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE, nArray);
            bl3 = d2 < this.termCritParam;
        }
        l = System.currentTimeMillis() - l;
        if (this.verbosity >= 1) {
            this.mainLog.print("Value iteration (Gauss-Seidel, " + (bl ? "min" : "max") + (bl2 ? "min" : "max") + ")");
            this.mainLog.println(" took " + n + " iterations and " + (double)l / 1000.0 + " seconds.");
        }
        if (!bl3 && this.errorOnNonConverge) {
            String string = "Iterative method did not converge within " + n + " iterations.";
            string = string + "\nConsider using a different numerical method or increasing the maximum number of iterations";
            throw new PrismException(string);
        }
        ModelCheckerResult modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray2;
        modelCheckerResult.accuracy = AccuracyFactory.valueIteration(this.termCritParam, d2, this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE);
        modelCheckerResult.numIters = n;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        if (this.genStrat) {
            modelCheckerResult.strat = new MDStrategyArray<Double>(sTPG, nArray);
        }
        return modelCheckerResult;
    }

    public List<Integer> probReachStrategy(STPG<Double> sTPG, int n, BitSet bitSet, boolean bl, boolean bl2, double[] dArray) throws PrismException {
        double d = sTPG.mvMultMinMaxSingle(n, dArray, bl, bl2);
        return sTPG.mvMultMinMaxSingleChoices(n, dArray, bl, bl2, d);
    }

    public ModelCheckerResult computeBoundedReachProbs(STPG<Double> sTPG, BitSet bitSet, int n, boolean bl, boolean bl2) throws PrismException {
        return this.computeBoundedReachProbs(sTPG, null, bitSet, n, bl, bl2, null, null);
    }

    public ModelCheckerResult computeBoundedUntilProbs(STPG<Double> sTPG, BitSet bitSet, BitSet bitSet2, int n, boolean bl, boolean bl2) throws PrismException {
        return this.computeBoundedReachProbs(sTPG, bitSet, bitSet2, n, bl, bl2, null, null);
    }

    public ModelCheckerResult computeBoundedReachProbs(STPG<Double> sTPG, BitSet bitSet, BitSet bitSet2, int n, boolean bl, boolean bl2, double[] dArray, double[] dArray2) throws PrismException {
        int n2;
        ModelCheckerResult modelCheckerResult = null;
        FMDStrategyStep<Double> fMDStrategyStep = null;
        long l = System.currentTimeMillis();
        if (this.verbosity >= 1) {
            this.mainLog.println("\nStarting bounded probabilistic reachability...");
        }
        int n3 = sTPG.getNumStates();
        double[] dArray3 = new double[n3];
        double[] dArray4 = dArray == null ? new double[n3] : dArray;
        int[] nArray = null;
        if (this.genStrat) {
            nArray = new int[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                nArray[n2] = bitSet2.get(n2) ? -2 : -1;
            }
            fMDStrategyStep = new FMDStrategyStep<Double>(sTPG, n);
        }
        if (dArray != null) {
            for (n2 = 0; n2 < n3; ++n2) {
                dArray4[n2] = bitSet2.get(n2) ? 1.0 : dArray[n2];
                dArray3[n2] = dArray4[n2];
            }
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                dArray4[n2] = bitSet2.get(n2) ? 1.0 : 0.0;
                dArray3[n2] = dArray4[n2];
            }
        }
        if (dArray2 != null) {
            dArray2[0] = Utils.minMaxOverArraySubset(dArray4, sTPG.getInitialStates(), bl2);
        }
        int n4 = 0;
        while (n4 < n) {
            ++n4;
            sTPG.mvMultMinMax(dArray3, bl, bl2, dArray4, bitSet2, true, nArray);
            if (this.genStrat) {
                fMDStrategyStep.setStepChoices(n - n4, nArray);
            }
            if (dArray2 != null) {
                dArray2[n4] = Utils.minMaxOverArraySubset(dArray4, sTPG.getInitialStates(), bl2);
            }
            double[] dArray5 = dArray3;
            dArray3 = dArray4;
            dArray4 = dArray5;
        }
        l = System.currentTimeMillis() - l;
        if (this.verbosity >= 1) {
            this.mainLog.print("Bounded probabilistic reachability (" + (bl ? "min" : "max") + (bl2 ? "min" : "max") + ")");
            this.mainLog.println(" took " + n4 + " iterations and " + (double)l / 1000.0 + " seconds.");
        }
        modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray3;
        modelCheckerResult.lastSoln = dArray4;
        modelCheckerResult.accuracy = AccuracyFactory.boundedNumericalIterations();
        modelCheckerResult.numIters = n4;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        modelCheckerResult.timePre = 0.0;
        if (this.genStrat) {
            modelCheckerResult.strat = fMDStrategyStep;
        }
        return modelCheckerResult;
    }

    public ModelCheckerResult computeReachRewards(STPG<Double> sTPG, STPGRewards<Double> sTPGRewards, BitSet bitSet, boolean bl, boolean bl2) throws PrismException {
        return this.computeReachRewards(sTPG, sTPGRewards, bitSet, bl, bl2, null, null);
    }

    public ModelCheckerResult computeReachRewards(STPG<Double> sTPG, STPGRewards<Double> sTPGRewards, BitSet bitSet, boolean bl, boolean bl2, double[] dArray, BitSet bitSet2) throws PrismException {
        return this.computeReachRewards(sTPG, sTPGRewards, bitSet, bl, bl2, dArray, bitSet2, 0);
    }

    public ModelCheckerResult computeReachRewards(STPG<Double> sTPG, STPGRewards<Double> sTPGRewards, BitSet bitSet, boolean bl, boolean bl2, double[] dArray, BitSet bitSet2, int n) throws PrismException {
        switch (n) {
            case 0: {
                return this.computeReachRewardsInfinity(sTPG, sTPGRewards, bitSet, bl, bl2, dArray, bitSet2);
            }
            case 1: {
                return this.computeReachRewardsCumulative(sTPG, sTPGRewards, bitSet, bl, bl2, dArray, bitSet2);
            }
            case 2: {
                return this.computeReachRewardsZero(sTPG, sTPGRewards, bitSet, bl, bl2, dArray, bitSet2);
            }
        }
        throw new PrismException("Unknown semantics for runs unreaching the target in STPGModelChecker: " + n);
    }

    protected ModelCheckerResult computeReachRewardsValIter(STPG<Double> sTPG, STPGRewards<Double> sTPGRewards, BitSet bitSet, BitSet bitSet2, boolean bl, boolean bl2, double[] dArray, BitSet bitSet3) throws PrismException {
        int n;
        int n2;
        double[] dArray2;
        long l = System.currentTimeMillis();
        if (this.verbosity >= 1) {
            this.mainLog.println("Starting value iteration (" + (bl ? "min" : "max") + (bl2 ? "min" : "max") + ")...");
        }
        int n3 = sTPG.getNumStates();
        double[] dArray3 = new double[n3];
        double[] dArray4 = dArray2 = dArray == null ? new double[n3] : dArray;
        if (dArray != null) {
            if (bitSet3 != null) {
                for (n2 = 0; n2 < n3; ++n2) {
                    dArray2[n2] = bitSet3.get(n2) ? dArray[n2] : (bitSet.get(n2) ? 0.0 : (bitSet2.get(n2) ? Double.POSITIVE_INFINITY : dArray[n2]));
                    dArray3[n2] = dArray2[n2];
                }
            } else {
                for (n2 = 0; n2 < n3; ++n2) {
                    dArray2[n2] = bitSet.get(n2) ? 0.0 : (bitSet2.get(n2) ? Double.POSITIVE_INFINITY : dArray[n2]);
                    dArray3[n2] = dArray2[n2];
                }
            }
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                dArray2[n2] = bitSet.get(n2) ? 0.0 : (bitSet2.get(n2) ? Double.POSITIVE_INFINITY : 0.0);
                dArray3[n2] = dArray2[n2];
            }
        }
        BitSet bitSet4 = new BitSet();
        bitSet4.set(0, n3);
        bitSet4.andNot(bitSet);
        bitSet4.andNot(bitSet2);
        if (bitSet3 != null) {
            bitSet4.andNot(bitSet3);
        }
        BitSet bitSet5 = (BitSet)bitSet2.clone();
        bitSet5.flip(0, n3);
        int[] nArray = null;
        if (this.genStrat) {
            nArray = new int[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                nArray[n2] = -1;
            }
        }
        boolean bl3 = false;
        for (n = 0; !bl3 && n < this.maxIters; ++n) {
            sTPG.mvMultRewMinMax(dArray3, sTPGRewards, bl, bl2, dArray2, bitSet4, false, nArray, this.useDiscounting ? this.discountFactor : 1.0);
            bl3 = PrismUtils.doublesAreClose(dArray3, dArray2, this.termCritParam, this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE);
            double[] dArray5 = dArray3;
            dArray3 = dArray2;
            dArray2 = dArray5;
        }
        l = System.currentTimeMillis() - l;
        if (this.verbosity >= 1) {
            this.mainLog.print("Value iteration (" + (bl ? "min" : "max") + (bl2 ? "min" : "max") + ")");
            this.mainLog.println(" took " + n + " iterations and " + (double)l / 1000.0 + " seconds.");
        }
        if (!bl3 && this.errorOnNonConverge) {
            String string = "Iterative method did not converge within " + n + " iterations.";
            string = string + "\nConsider using a different numerical method or increasing the maximum number of iterations";
            throw new PrismException(string);
        }
        ModelCheckerResult modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray3;
        double d = PrismUtils.measureSupNorm(dArray3, dArray2, this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE);
        modelCheckerResult.accuracy = AccuracyFactory.valueIteration(this.termCritParam, d, this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE);
        modelCheckerResult.numIters = n;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        if (this.genStrat) {
            modelCheckerResult.strat = new MDStrategyArray<Double>(sTPG, nArray);
        }
        return modelCheckerResult;
    }

    public ModelCheckerResult computeReachRewardsInfinity(STPG<Double> sTPG, STPGRewards<Double> sTPGRewards, BitSet bitSet, boolean bl, boolean bl2, double[] dArray, BitSet bitSet2) throws PrismException {
        ModelCheckerResult modelCheckerResult = null;
        long l = System.currentTimeMillis();
        if (this.verbosity >= 1) {
            this.mainLog.println("\nStarting expected reachability...");
        }
        sTPG.checkForDeadlocks(bitSet);
        int n = sTPG.getNumStates();
        if (dArray != null && bitSet2 != null && !bitSet2.isEmpty()) {
            BitSet bitSet3 = (BitSet)bitSet.clone();
            FunctionalPrimitiveIterator.OfInt ofInt = new IterableBitSet(bitSet2).iterator();
            while (ofInt.hasNext()) {
                int n2 = (Integer)ofInt.next();
                if (dArray[n2] != 1.0) continue;
                bitSet3.set(n2);
            }
            bitSet = bitSet3;
        }
        long l2 = System.currentTimeMillis();
        BitSet bitSet4 = this.prob1(sTPG, null, bitSet, !bl, !bl2);
        bitSet4.flip(0, n);
        l2 = System.currentTimeMillis() - l2;
        int n3 = bitSet.cardinality();
        int n4 = bitSet4.cardinality();
        if (this.verbosity >= 1) {
            this.mainLog.println("target=" + n3 + ", inf=" + n4 + ", rest=" + (n - (n3 + n4)));
        }
        double d = Double.POSITIVE_INFINITY;
        double d2 = 0.0;
        boolean bl3 = true;
        for (int i = 0; i < n; ++i) {
            double d3 = (Double)sTPGRewards.getStateReward(i);
            if (d3 > 0.0 && d3 < d) {
                d = d3;
            }
            if (d3 > d2) {
                d2 = d3;
            }
            bl3 = bl3 && d3 > 0.0;
            for (int j = 0; j < sTPG.getNumChoices(i); ++j) {
                d3 = (Double)sTPGRewards.getTransitionReward(i, j);
                if (d3 > 0.0 && d3 < d) {
                    d = d3;
                }
                if (d3 > d2) {
                    d2 = d3;
                }
                bl3 = bl3 && (Double)sTPGRewards.getTransitionReward(i, j) > 0.0;
            }
        }
        if (!bl3 && !(sTPGRewards instanceof StateRewardsConstant)) {
            long l3 = System.currentTimeMillis();
            double d4 = Math.min(d, d2 * 0.01);
            if (this.verbosity >= 1) {
                this.mainLog.println("Computing the upper bound where " + d4 + " is used instead of 0.0");
            }
            switch (this.stpgSolnMethod) {
                case VALUE_ITERATION: 
                case GAUSS_SEIDEL: {
                    modelCheckerResult = this.computeReachRewardsValIter(sTPG, this.replaceZeroRewards(sTPGRewards, d4), bitSet, bitSet4, bl, bl2, dArray, bitSet2);
                    break;
                }
                default: {
                    throw new PrismException("Unknown STPG solution method " + String.valueOf((Object)this.stpgSolnMethod));
                }
            }
            dArray = modelCheckerResult.soln;
            l3 = System.currentTimeMillis() - l3;
            if (this.verbosity >= 1) {
                this.mainLog.println("Computed an over-approximation of the solution (in " + l3 / 1000L + " seconds), this will now be used to get the solution");
            }
        }
        switch (this.stpgSolnMethod) {
            case VALUE_ITERATION: 
            case GAUSS_SEIDEL: {
                modelCheckerResult = this.computeReachRewardsValIter(sTPG, sTPGRewards, bitSet, bitSet4, bl, bl2, dArray, bitSet2);
                break;
            }
            default: {
                throw new PrismException("Unknown STPG solution method " + String.valueOf((Object)this.stpgSolnMethod));
            }
        }
        l = System.currentTimeMillis() - l;
        if (this.verbosity >= 1) {
            this.mainLog.println("Expected reachability took " + (double)l / 1000.0 + " seconds.");
        }
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        modelCheckerResult.timePre = (double)l2 / 1000.0;
        return modelCheckerResult;
    }

    public ModelCheckerResult computeReachRewardsCumulative(STPG<Double> sTPG, STPGRewards<Double> sTPGRewards, BitSet bitSet, boolean bl, boolean bl2, double[] dArray, BitSet bitSet2) throws PrismException {
        int n;
        BitSet bitSet3;
        ModelCheckerResult modelCheckerResult = null;
        long l = System.currentTimeMillis();
        if (this.verbosity >= 1) {
            this.mainLog.println("\nStarting expected reachability...");
        }
        sTPG.checkForDeadlocks(bitSet);
        int n2 = sTPG.getNumStates();
        if (dArray != null && bitSet2 != null) {
            bitSet3 = new BitSet(n2);
            for (n = 0; n < n2; ++n) {
                bitSet3.set(n, bitSet.get(n) || bitSet2.get(n) && dArray[n] == 0.0);
            }
            bitSet = bitSet3;
        }
        long l2 = System.currentTimeMillis();
        bitSet3 = new BitSet();
        if (!this.useDiscounting) {
            for (n = 0; n < n2; ++n) {
                if (bitSet.get(n)) continue;
                if ((Double)sTPGRewards.getStateReward(n) > 0.0) {
                    bitSet3.set(n);
                }
                int n3 = 0;
                int n4 = 0;
                for (int i = 0; i < sTPG.getNumChoices(n); ++i) {
                    double d = (Double)sTPGRewards.getTransitionReward(n, i);
                    if (d > 0.0 && d != Double.POSITIVE_INFINITY && d != Double.NEGATIVE_INFINITY) {
                        ++n3;
                        bitSet3.set(n);
                        continue;
                    }
                    if (d != Double.POSITIVE_INFINITY && d != Double.NEGATIVE_INFINITY) continue;
                    ++n4;
                }
                if (n3 == 0 || n3 == sTPG.getNumChoices(n) - n4) continue;
                throw new PrismException("If transition reward is nonzero, all transitions going from the state must be.");
            }
        }
        BitSet bitSet4 = bitSet3;
        BitSet bitSet5 = new BitSet();
        BitSet bitSet6 = new BitSet(n2);
        bitSet6.flip(0, n2);
        while (true) {
            bitSet5 = this.prob1(sTPG, null, bitSet4, bl, bl2);
            BitSet bitSet7 = new BitSet();
            sTPG.prob1step(bitSet6, bitSet5, bitSet6, bl, bl2, bitSet7);
            bitSet7.and(bitSet4);
            for (n = 0; n < n2; ++n) {
                if (!bitSet7.get(n) || bitSet4.get(n)) continue;
                throw new PrismException("There is some error in the implementation");
            }
            if (bitSet7.equals(bitSet4)) break;
            BitSet bitSet8 = bitSet7;
            bitSet7 = bitSet4;
            bitSet4 = bitSet8;
        }
        BitSet bitSet9 = this.prob0(sTPG, null, bitSet4, bl, bl2);
        bitSet9.flip(0, n2);
        l2 = System.currentTimeMillis() - l2;
        int n5 = bitSet.cardinality();
        int n6 = bitSet9.cardinality();
        if (this.verbosity >= 1) {
            this.mainLog.println("target=" + n5 + ", inf=" + n6 + ", rest=" + (n2 - (n5 + n6)));
        }
        switch (this.stpgSolnMethod) {
            case VALUE_ITERATION: 
            case GAUSS_SEIDEL: {
                modelCheckerResult = this.computeReachRewardsValIter(sTPG, sTPGRewards, bitSet, bitSet9, bl, bl2, dArray, bitSet2);
                break;
            }
            default: {
                throw new PrismException("Unknown STPG solution method " + String.valueOf((Object)this.stpgSolnMethod));
            }
        }
        l = System.currentTimeMillis() - l;
        if (this.verbosity >= 1) {
            this.mainLog.println("Expected reachability took " + (double)l / 1000.0 + " seconds.");
        }
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        modelCheckerResult.timePre = (double)l2 / 1000.0;
        return modelCheckerResult;
    }

    public ModelCheckerResult computeReachRewardsZero(STPG<Double> sTPG, STPGRewards<Double> sTPGRewards, BitSet bitSet, boolean bl, boolean bl2, double[] dArray, BitSet bitSet2) throws PrismException {
        int n;
        int n2;
        double d;
        Object object;
        double d2;
        int n3;
        double d3;
        Iterator iterator;
        double d4;
        int n4;
        Object object2;
        Object object3;
        RewardsSimple<Double> rewardsSimple;
        int n5;
        int n6;
        Object object4;
        int n7;
        ModelCheckerResult modelCheckerResult = null;
        ArrayList arrayList = null;
        int[] nArray = null;
        long l = System.currentTimeMillis();
        if (this.verbosity >= 1) {
            this.mainLog.println("\nStarting expected reachability...");
        }
        sTPG.checkForDeadlocks(bitSet);
        int n8 = sTPG.getNumStates();
        boolean bl3 = false;
        double d5 = 0.0;
        int n9 = 0;
        block0: for (int i = 0; i < n8; ++i) {
            double d6 = (Double)sTPGRewards.getStateReward(i);
            if (d6 != Math.floor(d6)) {
                bl3 = true;
                d5 = d6;
                break;
            }
            if (d6 > (double)n9) {
                n9 = (int)d6;
            }
            for (int j = 0; j < sTPG.getNumChoices(i); ++j) {
                double d7 = (Double)sTPGRewards.getTransitionReward(i, j);
                if (d7 != Math.floor(d7)) {
                    bl3 = true;
                    d5 = d7;
                    break block0;
                }
                if (!(d7 > (double)n9)) continue;
                n9 = (int)d7;
            }
        }
        if (this.verbosity >= 1) {
            this.mainLog.println("Maximal reward is " + n9);
        }
        if (bl3) {
            throw new PrismException("For 'zero' semantics reachability reward all rewards must be integers.There is at least one non-integer reward: " + d5);
        }
        if (dArray != null && bitSet2 != null) {
            BitSet bitSet3 = new BitSet(n8);
            for (n7 = 0; n7 < n8; ++n7) {
                bitSet3.set(n7, bitSet.get(n7) || bitSet2.get(n7) && dArray[n7] == 0.0);
            }
            bitSet = bitSet3;
        }
        BitSet bitSet4 = this.prob0(sTPG, null, bitSet, bl, bl2);
        BitSet bitSet5 = new BitSet();
        for (int i = 0; i < n8; ++i) {
            bitSet5.set(i, !bitSet4.get(i));
        }
        if (sTPGRewards instanceof RewardsSimple) {
            object4 = new RewardsSimple<Double>((RewardsSimple)sTPGRewards);
            for (n6 = 0; n6 < n8; ++n6) {
                for (n5 = 0; n5 < sTPG.getNumChoices(n6); ++n5) {
                    Iterator iterator2 = sTPG.getTransitionsIterator(n6, n5);
                    boolean bl4 = false;
                    while (iterator2.hasNext()) {
                        if (!bitSet5.get(iterator2.next().getKey())) continue;
                        bl4 = true;
                        break;
                    }
                    if (bl4) continue;
                    ((RewardsSimple)object4).setTransitionReward(n6, n5, 0.0);
                }
                if (bitSet5.get(n6)) continue;
                ((RewardsSimple)object4).setStateReward(n6, 0.0);
            }
            rewardsSimple = object4;
        } else if (sTPGRewards instanceof StateRewardsConstant) {
            object4 = new RewardsSimple(n8);
            for (n6 = 0; n6 < n8; ++n6) {
                if (!bitSet5.get(n6)) continue;
                ((RewardsSimple)object4).setStateReward(n6, (Double)sTPGRewards.getStateReward(n6));
            }
            rewardsSimple = object4;
        } else {
            throw new PrismException("To compute expected reward I need to modify the reward structure. But I don't know how to modify" + sTPGRewards.getClass().getName());
        }
        object4 = new BitSet();
        for (n7 = 0; n7 < n8; ++n7) {
            if (bitSet.get(n7)) continue;
            if ((Double)rewardsSimple.getStateReward(n7) > 0.0) {
                ((BitSet)object4).set(n7);
            }
            n6 = 0;
            n5 = 0;
            for (int i = 0; i < sTPG.getNumChoices(n7); ++i) {
                double d8 = (Double)sTPGRewards.getTransitionReward(n7, i);
                if (d8 > 0.0 && d8 != Double.POSITIVE_INFINITY && d8 != Double.NEGATIVE_INFINITY) {
                    ++n6;
                    ((BitSet)object4).set(n7);
                    continue;
                }
                if (d8 != Double.POSITIVE_INFINITY && d8 != Double.NEGATIVE_INFINITY) continue;
                ++n5;
            }
            if (n6 == 0 || n6 == sTPG.getNumChoices(n7) - n5) continue;
            throw new PrismException("If transition reward is nonzero, all transitions going from the state must be.");
        }
        Object object5 = object4;
        BitSet bitSet6 = new BitSet();
        BitSet bitSet7 = new BitSet(n8);
        bitSet7.flip(0, n8);
        while (true) {
            bitSet6 = this.prob1(sTPG, null, (BitSet)object5, bl, bl2);
            object3 = new BitSet();
            sTPG.prob1step(bitSet7, bitSet6, bitSet7, bl, bl2, (BitSet)object3);
            ((BitSet)object3).and((BitSet)object5);
            for (n7 = 0; n7 < n8; ++n7) {
                if (!((BitSet)object3).get(n7) || ((BitSet)object5).get(n7)) continue;
                throw new PrismException("There is some error in the implementation");
            }
            if (((BitSet)object3).equals(object5)) break;
            BitSet bitSet8 = object3;
            object3 = object5;
            object5 = bitSet8;
        }
        ((BitSet)object5).and(bitSet5);
        BitSet bitSet9 = this.prob0(sTPG, null, (BitSet)object5, bl, bl2);
        bitSet9.flip(0, n8);
        object3 = this.getSTPGSolnMethod();
        this.setSTPGSolnMethod(ProbModelChecker.STPGSolnMethod.VALUE_ITERATION);
        ModelCheckerResult modelCheckerResult2 = this.computeReachProbs(sTPG, bitSet, bl, bl2);
        this.setSTPGSolnMethod((ProbModelChecker.STPGSolnMethod)((Object)object3));
        if (sTPGRewards instanceof RewardsSimple) {
            object2 = new RewardsSimple((RewardsSimple)sTPGRewards);
            for (n4 = 0; n4 < n8; ++n4) {
                for (int i = 0; i < sTPG.getNumChoices(n4); ++i) {
                    d4 = 0.0;
                    iterator = sTPG.getTransitionsIterator(n4, i);
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        d4 += (Double)entry.getValue() * modelCheckerResult2.soln[entry.getKey()];
                    }
                    if (sTPG.getNumChoices(n4) > 1 && d4 < modelCheckerResult2.soln[n4] && (sTPG.getPlayer(n4) == 0 && !bl || sTPG.getPlayer(n4) == 1 && !bl2)) {
                        ((RewardsSimple)object2).setTransitionReward(n4, i, Double.NEGATIVE_INFINITY);
                        continue;
                    }
                    if (sTPG.getNumChoices(n4) > 1 && d4 > modelCheckerResult2.soln[n4] && (sTPG.getPlayer(n4) == 0 && bl || sTPG.getPlayer(n4) == 1 && bl2)) {
                        ((RewardsSimple)object2).setTransitionReward(n4, i, Double.POSITIVE_INFINITY);
                        continue;
                    }
                    double d9 = (Double)sTPGRewards.getTransitionReward(n4, i) * modelCheckerResult2.soln[n4];
                    ((RewardsSimple)object2).setTransitionReward(n4, i, d9);
                }
                d3 = (Double)sTPGRewards.getStateReward(n4) * modelCheckerResult2.soln[n4];
                ((RewardsSimple)object2).setStateReward(n4, d3);
            }
            rewardsSimple = object2;
        } else if (sTPGRewards instanceof StateRewardsConstant) {
            object2 = new RewardsSimple(n8);
            for (n4 = 0; n4 < n8; ++n4) {
                for (int i = 0; i < sTPG.getNumChoices(n4); ++i) {
                    d4 = 0.0;
                    iterator = sTPG.getTransitionsIterator(n4, i);
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        d4 += (Double)entry.getValue() * modelCheckerResult2.soln[entry.getKey()];
                    }
                    if (sTPG.getNumChoices(n4) > 1 && d4 < modelCheckerResult2.soln[n4] && (sTPG.getPlayer(n4) == 0 && !bl || sTPG.getPlayer(n4) == 1 && !bl2)) {
                        ((RewardsSimple)object2).setTransitionReward(n4, i, Double.NEGATIVE_INFINITY);
                        continue;
                    }
                    if (sTPG.getNumChoices(n4) <= 1 || !(d4 > modelCheckerResult2.soln[n4]) || (sTPG.getPlayer(n4) != 0 || !bl) && (sTPG.getPlayer(n4) != 1 || !bl2)) continue;
                    ((RewardsSimple)object2).setTransitionReward(n4, i, Double.POSITIVE_INFINITY);
                }
                d3 = (Double)sTPGRewards.getStateReward(n4) * modelCheckerResult2.soln[n4];
                ((RewardsSimple)object2).setStateReward(n4, d3);
            }
            rewardsSimple = object2;
        } else {
            throw new PrismException("To compute expected reward I need to modify the reward structure. But I don't know how to modify" + sTPGRewards.getClass().getName());
        }
        object2 = this.computeReachRewards(sTPG, rewardsSimple, bitSet, bl, bl2, dArray, bitSet2, 1);
        n4 = 0;
        for (n3 = 0; n3 < n8; ++n3) {
            for (int i = 0; i < sTPG.getNumChoices(n3); ++i) {
                double d10 = ((ModelCheckerResult)object2).soln[n3];
                double d11 = -modelCheckerResult2.soln[n3];
                d2 = (Double)sTPGRewards.getTransitionReward(n3, i);
                object = sTPG.getTransitionsIterator(n3, i);
                while (object.hasNext()) {
                    int n10;
                    Map.Entry entry = object.next();
                    int n11 = entry.getKey();
                    double d12 = (Double)sTPGRewards.getStateReward(n3);
                    d = (Double)entry.getValue();
                    if (n4 >= (n10 = (d11 += d * modelCheckerResult2.soln[n11]) == 0.0 ? 0 : (int)Math.floor((d10 -= d * (modelCheckerResult2.soln[n11] * (d12 + d2) + ((ModelCheckerResult)object2).soln[n11])) / d11))) continue;
                    n4 = n10;
                }
            }
        }
        if (this.verbosity >= 1) {
            this.mainLog.println("Last switching point is when the reward cumulated in the past becomes " + n4);
        }
        n3 = n9 + 1;
        double[][] dArray2 = new double[n3][n8];
        int n12 = 0;
        for (n2 = 0; n2 < n8; ++n2) {
            for (n = 0; n < n3; ++n) {
                dArray2[n][n2] = bitSet9.get(n2) ? Double.POSITIVE_INFINITY : ((ModelCheckerResult)object2).soln[n2] + (double)(n4 + n) * modelCheckerResult2.soln[n2];
            }
        }
        if (this.genStrat) {
            arrayList = new ArrayList(n8);
            for (n7 = 0; n7 < n8; ++n7) {
                arrayList.add(new LinkedList());
            }
        }
        for (n2 = n4; n2 >= 0; --n2) {
            int n13;
            n = 0;
            d2 = 0.0;
            do {
                d2 = 0.0;
                ++n12;
                for (n13 = 0; n13 < n8; ++n13) {
                    if (!bitSet.get(n13)) continue;
                    dArray2[0][n13] = n2;
                }
                if (this.genStrat) {
                    nArray = new int[n8];
                }
                for (n13 = 0; n13 < n8; ++n13) {
                    if (bitSet.get(n13)) continue;
                    boolean bl5 = sTPG.getPlayer(n13) == 0 ? bl : bl2;
                    double d13 = -1.0;
                    for (int i = 0; i < sTPG.getNumChoices(n13); ++i) {
                        d = 0.0;
                        double d14 = (Double)sTPGRewards.getStateReward(n13) + (Double)sTPGRewards.getTransitionReward(n13, i);
                        int n14 = (int)d14;
                        Iterator iterator3 = sTPG.getTransitionsIterator(n13, i);
                        while (iterator3.hasNext()) {
                            Map.Entry entry = iterator3.next();
                            int n15 = entry.getKey();
                            double d15 = (Double)entry.getValue();
                            d += d15 * dArray2[n14][n15];
                        }
                        boolean bl6 = false;
                        if (d13 < 0.0) {
                            d13 = d;
                            if (!this.genStrat) continue;
                            nArray[n13] = i;
                            continue;
                        }
                        if (bl5 && d13 > d) {
                            d13 = d;
                            if (!this.genStrat) continue;
                            nArray[n13] = i;
                            continue;
                        }
                        if (bl5 || !(d13 < d)) continue;
                        d13 = d;
                        if (!this.genStrat) continue;
                        nArray[n13] = i;
                    }
                    double d16 = Math.abs(dArray2[0][n13] - d13);
                    if (d16 > d2) {
                        d2 = d16;
                    }
                    dArray2[0][n13] = d13;
                }
            } while (d2 > 1.0E-5);
            if (this.genStrat) {
                for (n13 = 0; n13 < n8; ++n13) {
                    n7 = ((List)arrayList.get(n13)).size();
                    if (n7 == 0 || (Integer)((List)arrayList.get(n13)).get(n7 - 1) != nArray[n13]) {
                        ((List)arrayList.get(n13)).add(n12);
                        ((List)arrayList.get(n13)).add(nArray[n13]);
                        continue;
                    }
                    ((List)arrayList.get(n13)).set(((List)arrayList.get(n13)).size() - 2, (Integer)((List)arrayList.get(n13)).get(((List)arrayList.get(n13)).size() - 2) + 1);
                }
            }
            object = dArray2[n3 - 1];
            for (n7 = n3 - 1; n7 >= 1; --n7) {
                dArray2[n7] = dArray2[n7 - 1];
            }
            dArray2[0] = (double[])object;
        }
        l = System.currentTimeMillis() - l;
        int[][] nArrayArray = null;
        if (this.genStrat) {
            nArrayArray = new int[n8][];
            for (n7 = 0; n7 < n8; ++n7) {
                nArrayArray[n7] = new int[((List)arrayList.get(n7)).size()];
                n = ((List)arrayList.get(n7)).size() - 2;
                int n16 = 0;
                while (n >= 0) {
                    nArrayArray[n7][n16] = (Integer)((List)arrayList.get(n7)).get(n);
                    nArrayArray[n7][n16 + 1] = (Integer)((List)arrayList.get(n7)).get(n + 1);
                    n -= 2;
                    n16 += 2;
                }
            }
        }
        modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray2.length > 1 ? dArray2[1] : dArray2[0];
        modelCheckerResult.lastSoln = dArray2.length > 2 ? dArray2[2] : null;
        modelCheckerResult.numIters = n4;
        modelCheckerResult.timeTaken = l / 1000L;
        modelCheckerResult.numIters = n12;
        if (this.genStrat) {
            modelCheckerResult.strat = new BoundedRewardDeterministicStrategy<Double>(sTPG, nArrayArray, n4, sTPGRewards);
        }
        return modelCheckerResult;
    }

    public BitSet zeroRewards(STPG<Double> sTPG, STPGRewards<Double> sTPGRewards, BitSet bitSet, BitSet bitSet2, boolean bl, boolean bl2) {
        int n;
        long l = System.currentTimeMillis();
        if (this.verbosity >= 1) {
            this.mainLog.println("Starting zeroRewards (" + (bl ? "min" : "max") + (bl2 ? "min" : "max") + ")...");
        }
        int n2 = sTPG.getNumStates();
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        BitSet bitSet3 = new BitSet();
        bitSet3.set(0, n2);
        if (bitSet2 != null) {
            bitSet3.andNot(bitSet2);
        }
        if (bitSet != null) {
            bitSet3.and(bitSet);
        }
        for (int i = 0; i < n2; ++i) {
            if (bitSet == null || bitSet.get(i) || bitSet2 == null || bitSet2.get(i)) continue;
            dArray[i] = Double.POSITIVE_INFINITY;
        }
        int n3 = 0;
        boolean bl3 = false;
        block1: while (!bl3) {
            assert (++n3 <= n2 + 1);
            sTPG.mvMultRewMinMax(dArray, sTPGRewards, bl, bl2, dArray2, bitSet3, false, null);
            bl3 = true;
            double[] dArray3 = dArray2;
            dArray2 = dArray;
            dArray = dArray3;
            bl3 = true;
            for (n = 0; n < n2; ++n) {
                if (!(dArray[n] > 0.0) || dArray2[n] != 0.0) continue;
                bl3 = false;
                continue block1;
            }
        }
        l = System.currentTimeMillis() - l;
        if (this.verbosity >= 1) {
            this.mainLog.print("Zero Rewards (" + (bl ? "min" : "max") + (bl2 ? "min" : "max") + ")");
            this.mainLog.println(" took " + n3 + " iterations and " + (double)l / 1000.0 + " seconds.");
        }
        BitSet bitSet4 = new BitSet(n2);
        for (n = 0; n < n2; ++n) {
            if (dArray[n] != 0.0) continue;
            bitSet4.set(n);
        }
        return bitSet4;
    }

    public ModelCheckerResult computeInstantaneousRewards(STPG<Double> sTPG, STPGRewards<Double> sTPGRewards, int n, boolean bl, boolean bl2) throws PrismException {
        int n2;
        ModelCheckerResult modelCheckerResult = null;
        int n3 = sTPG.getNumStates();
        long l = System.currentTimeMillis();
        this.mainLog.println("\nStarting backwards instantaneous rewards computation...");
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        for (int i = 0; i < n3; ++i) {
            dArray[i] = (Double)sTPGRewards.getStateReward(i);
        }
        for (n2 = 0; n2 < n; ++n2) {
            sTPG.mvMultMinMax(dArray, bl, bl2, dArray2, null, false, null);
            double[] dArray3 = dArray;
            dArray = dArray2;
            dArray2 = dArray3;
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.print("Backwards transient instantaneous rewards computation");
        this.mainLog.println(" took " + n2 + " iters and " + (double)l / 1000.0 + " seconds.");
        modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray;
        modelCheckerResult.lastSoln = dArray2;
        modelCheckerResult.accuracy = AccuracyFactory.boundedNumericalIterations();
        modelCheckerResult.numIters = n2;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        modelCheckerResult.timePre = 0.0;
        return modelCheckerResult;
    }

    public ModelCheckerResult computeCumulativeRewards(STPG<Double> sTPG, STPGRewards<Double> sTPGRewards, int n, boolean bl, boolean bl2) throws PrismException {
        int n2;
        ModelCheckerResult modelCheckerResult = null;
        long l = System.currentTimeMillis();
        this.mainLog.println("\nStarting expected cumulative reward (" + (bl ? "min" : "max") + (bl2 ? "min" : "max") + ")");
        int n3 = sTPG.getNumStates();
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        for (int i = 0; i < n3; ++i) {
            dArray2[i] = 0.0;
            dArray[i] = 0.0;
        }
        for (n2 = 0; n2 < n; ++n2) {
            sTPG.mvMultRewMinMax(dArray, sTPGRewards, bl, bl2, dArray2, null, false, null);
            double[] dArray3 = dArray;
            dArray = dArray2;
            dArray2 = dArray3;
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.print("Expected cumulative reward (" + (bl ? "min" : "max") + (bl2 ? "min" : "max") + ")");
        this.mainLog.println(" took " + n2 + " iterations and " + (double)l / 1000.0 + " seconds.");
        modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray;
        modelCheckerResult.accuracy = AccuracyFactory.boundedNumericalIterations();
        modelCheckerResult.numIters = n2;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        return modelCheckerResult;
    }

    public static void main(String[] stringArray) {
        BitSet bitSet = new BitSet();
        boolean bl = true;
        boolean bl2 = true;
        try {
            STPGModelChecker sTPGModelChecker = new STPGModelChecker(null);
            STPGAbstrSimple<Double> sTPGAbstrSimple = new STPGAbstrSimple<Double>();
            sTPGAbstrSimple.buildFromPrismExplicit(stringArray[0]);
            sTPGAbstrSimple.addInitialState(0);
            Map<String, BitSet> map = StateModelChecker.loadLabelsFile(stringArray[1]);
            bitSet = map.get(stringArray[2]);
            if (bitSet == null) {
                throw new PrismException("Unknown label \"" + stringArray[2] + "\"");
            }
            for (int i = 3; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-minmin")) {
                    bl = true;
                    bl2 = true;
                    continue;
                }
                if (stringArray[i].equals("-maxmin")) {
                    bl = false;
                    bl2 = true;
                    continue;
                }
                if (stringArray[i].equals("-minmax")) {
                    bl = true;
                    bl2 = false;
                    continue;
                }
                if (!stringArray[i].equals("-maxmax")) continue;
                bl = false;
                bl2 = false;
            }
            ModelCheckerResult modelCheckerResult = sTPGModelChecker.computeReachProbs(sTPGAbstrSimple, bitSet, bl, bl2);
            System.out.println(modelCheckerResult.soln[0]);
        }
        catch (PrismException prismException) {
            System.out.println(prismException);
        }
    }
}

