/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import common.Interval;
import explicit.DTMC;
import explicit.DTMCSimple;
import explicit.DoubleIntervalDistribution;
import explicit.IDTMC;
import explicit.IntervalModelExplicit;
import explicit.IntervalUtils;
import explicit.MinMax;
import explicit.ModelExplicitWrapper;
import explicit.ModelSimple;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import parser.State;
import prism.Evaluator;
import prism.Pair;
import prism.PrismException;

public class IDTMCSimple<Value>
extends ModelExplicitWrapper<Value>
implements ModelSimple<Value>,
IntervalModelExplicit<Value>,
IDTMC<Value> {
    protected DTMCSimple<Interval<Value>> dtmc;

    public IDTMCSimple() {
        this.model = this.dtmc = new DTMCSimple();
        this.createDefaultEvaluatorForDTMC();
    }

    public IDTMCSimple(int n) {
        this.model = this.dtmc = new DTMCSimple(n);
        this.createDefaultEvaluatorForDTMC();
    }

    public IDTMCSimple(IDTMCSimple<Value> iDTMCSimple) {
        this.setEvaluator(iDTMCSimple.getEvaluator());
        this.model = this.dtmc = new DTMCSimple<Interval<Interval<Value>>>(iDTMCSimple.dtmc);
    }

    public IDTMCSimple(IDTMCSimple<Value> iDTMCSimple, int[] nArray) {
        this.setEvaluator(iDTMCSimple.getEvaluator());
        this.model = this.dtmc = new DTMCSimple<Interval<Interval<Value>>>(iDTMCSimple.dtmc, nArray);
    }

    private void createDefaultEvaluatorForDTMC() {
        this.setIntervalEvaluator(Evaluator.forDoubleInterval());
    }

    @Override
    public void setActions(List<Object> list) {
        this.dtmc.setActions(list);
    }

    @Override
    public void clearState(int n) {
        this.dtmc.clearState(n);
    }

    @Override
    public int addState() {
        return this.dtmc.addState();
    }

    @Override
    public void addStates(int n) {
        this.dtmc.addStates(n);
    }

    @Override
    public void setIntervalEvaluator(Evaluator<Interval<Value>> evaluator) {
        this.dtmc.setEvaluator(evaluator);
    }

    public void setProbability(int n, int n2, Interval<Value> interval) {
        this.dtmc.setProbability(n, n2, interval, null);
    }

    public void setProbability(int n, int n2, Interval<Value> interval, Object object) {
        this.dtmc.setProbability(n, n2, interval, object);
    }

    public void addToProbability(int n, int n2, Interval<Value> interval) {
        this.dtmc.addToProbability(n, n2, interval, null);
    }

    public void addToProbability(int n, int n2, Interval<Value> interval, Object object) {
        this.dtmc.addToProbability(n, n2, interval, object);
    }

    public void delimit(int n) throws PrismException {
        IntervalUtils.delimit(this.dtmc.trans.get(n), this.getEvaluator());
    }

    @Override
    public void checkLowerBoundsArePositive() throws PrismException {
        Evaluator<Interval> evaluator = this.dtmc.getEvaluator();
        int n = this.getNumStates();
        for (int i = 0; i < n; ++i) {
            Iterator<Map.Entry<Integer, Interval<Value>>> iterator = this.getIntervalTransitionsIterator(i);
            while (iterator.hasNext()) {
                Map.Entry<Integer, Interval<Value>> entry = iterator.next();
                if (evaluator.gt(entry.getValue(), (Interval)evaluator.zero())) continue;
                List<State> list = this.getStatesList();
                String string = list == null ? "" + i : list.get(i).toString();
                throw new PrismException("Transition probability has lower bound of 0 in state " + string);
            }
        }
    }

    @Override
    public double mvMultUncSingle(int n, double[] dArray, MinMax minMax) {
        DoubleIntervalDistribution doubleIntervalDistribution = IntervalUtils.extractDoubleIntervalDistribution(this.getIntervalTransitionsIterator(n), this.getNumTransitions(n));
        return IDTMC.mvMultUncSingle(doubleIntervalDistribution, dArray, minMax);
    }

    @Override
    public Evaluator<Interval<Value>> getIntervalEvaluator() {
        return this.dtmc.getEvaluator();
    }

    @Override
    public DTMC<Interval<Value>> getIntervalModel() {
        return this.dtmc;
    }

    @Override
    public Iterator<Map.Entry<Integer, Interval<Value>>> getIntervalTransitionsIterator(int n) {
        return this.dtmc.getTransitionsIterator(n);
    }

    @Override
    public Iterator<Map.Entry<Integer, Pair<Interval<Value>, Object>>> getIntervalTransitionsAndActionsIterator(int n) {
        return this.dtmc.getTransitionsAndActionsIterator(n);
    }
}

