/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import com.microsoft.z3.AlgebraicNum;
import com.microsoft.z3.ArithExpr;
import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.IntExpr;
import com.microsoft.z3.IntNum;
import com.microsoft.z3.Model;
import com.microsoft.z3.Optimize;
import com.microsoft.z3.RatNum;
import com.microsoft.z3.RealExpr;
import com.microsoft.z3.Status;
import com.microsoft.z3.Version;
import explicit.CSGCorrelated;
import explicit.CSGModelCheckerEquilibria;
import explicit.Distribution;
import explicit.EquilibriumResult;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;

public class CSGCorrelatedZ3
implements CSGCorrelated {
    private RealExpr[] vars;
    private RealExpr[] payoff_vars;
    private RealExpr obj_var;
    private ArithExpr[] payoffs;
    private HashMap<String, String> cfg = new HashMap();
    private Context ctx;
    private Optimize s;
    private IntExpr zero;
    private IntExpr one;
    private String name;
    private int n_coalitions;

    public CSGCorrelatedZ3() {
        this.cfg.put("model", "true");
        this.ctx = new Context(this.cfg);
        this.s = this.ctx.mkOptimize();
        this.name = Version.getFullVersion();
    }

    public CSGCorrelatedZ3(int n, int n2) {
        this.cfg.put("model", "true");
        this.cfg.put("auto_config", "true");
        this.ctx = new Context(this.cfg);
        this.s = this.ctx.mkOptimize();
        this.name = Version.getFullVersion();
        this.zero = this.ctx.mkInt(0);
        this.one = this.ctx.mkInt(1);
        this.vars = new RealExpr[n];
        this.payoffs = new ArithExpr[n2];
        this.n_coalitions = n2;
        for (int i = 0; i < n; ++i) {
            this.vars[i] = this.ctx.mkRealConst("v" + i);
            this.s.Add(new Expr[]{this.ctx.mkLe((Expr)this.vars[i], (Expr)this.one)});
            this.s.Add(new Expr[]{this.ctx.mkGe((Expr)this.vars[i], (Expr)this.zero)});
        }
        this.payoff_vars = new RealExpr[n2];
        this.obj_var = this.ctx.mkRealConst("ob");
    }

    @Override
    public EquilibriumResult computeEquilibrium(HashMap<BitSet, ArrayList<Double>> hashMap, ArrayList<ArrayList<HashMap<BitSet, Double>>> arrayList, ArrayList<ArrayList<Integer>> arrayList2, HashMap<BitSet, Integer> hashMap2, int n) {
        int n2;
        EquilibriumResult equilibriumResult = new EquilibriumResult();
        ArrayList<Double> arrayList3 = new ArrayList<Double>();
        ArrayList<Distribution<Double>> arrayList4 = new ArrayList<Distribution<Double>>();
        Distribution<Double> distribution = new Distribution<Double>();
        BitSet bitSet = new BitSet();
        BitSet bitSet2 = new BitSet();
        this.s.Push();
        IntNum intNum = this.ctx.mkInt(0);
        for (int i = 0; i < this.n_coalitions; ++i) {
            this.payoffs[i] = this.zero;
        }
        for (BitSet bitSet3 : hashMap.keySet()) {
            double d = 0.0;
            for (n2 = 0; n2 < this.n_coalitions; ++n2) {
                d += hashMap.get(bitSet3).get(n2).doubleValue();
                this.payoffs[n2] = this.ctx.mkAdd(new Expr[]{this.payoffs[n2], this.ctx.mkMul(new Expr[]{this.vars[hashMap2.get(bitSet3)], this.ctx.mkReal(String.valueOf(hashMap.get(bitSet3).get(n2)))})});
            }
            intNum = this.ctx.mkAdd(new Expr[]{intNum, this.ctx.mkMul(new Expr[]{this.vars[hashMap2.get(bitSet3)], this.ctx.mkReal(String.valueOf(d))})});
        }
        for (n2 = 0; n2 < this.n_coalitions; ++n2) {
            this.payoff_vars[n2] = this.ctx.mkRealConst("p " + n2);
            this.s.Add(new Expr[]{this.ctx.mkEq((Expr)this.payoff_vars[n2], (Expr)this.payoffs[n2])});
        }
        switch (n) {
            case 4: {
                BitSet bitSet3;
                RealExpr realExpr = this.ctx.mkRealConst("ph");
                bitSet3 = this.ctx.mkRealConst("pl");
                for (int i = 0; i < this.n_coalitions; ++i) {
                    BoolExpr boolExpr = this.ctx.mkTrue();
                    BoolExpr boolExpr2 = this.ctx.mkTrue();
                    for (int j = 0; j < this.n_coalitions; ++j) {
                        if (i == j) continue;
                        boolExpr = this.ctx.mkAnd(new Expr[]{boolExpr, this.ctx.mkGe((Expr)this.payoffs[i], (Expr)this.payoffs[j])});
                        boolExpr2 = this.ctx.mkAnd(new Expr[]{boolExpr2, this.ctx.mkLe((Expr)this.payoffs[i], (Expr)this.payoffs[j])});
                    }
                    this.s.Add(new Expr[]{this.ctx.mkImplies((Expr)boolExpr, (Expr)this.ctx.mkEq((Expr)realExpr, (Expr)this.payoffs[i]))});
                    this.s.Add(new Expr[]{this.ctx.mkImplies((Expr)boolExpr2, (Expr)this.ctx.mkEq((Expr)bitSet3, (Expr)this.payoffs[i]))});
                }
                this.s.MkMinimize((Expr)this.ctx.mkSub(new Expr[]{realExpr, bitSet3}));
                break;
            }
            default: {
                this.s.Add(new Expr[]{this.ctx.mkEq((Expr)this.obj_var, (Expr)intNum)});
                this.s.MkMaximize((Expr)intNum);
            }
        }
        for (n2 = 0; n2 < this.n_coalitions; ++n2) {
            this.s.MkMaximize((Expr)this.payoffs[n2]);
        }
        for (n2 = 0; n2 < this.n_coalitions; ++n2) {
            for (int i = 0; i < arrayList2.get(n2).size(); ++i) {
                intNum = this.zero;
                bitSet.clear();
                bitSet.set(arrayList2.get(n2).get(i));
                for (int j = 0; j < arrayList2.get(n2).size(); ++j) {
                    bitSet2.clear();
                    for (BitSet bitSet3 : arrayList.get(n2).get(i).keySet()) {
                        bitSet.or(bitSet3);
                        bitSet2.or(bitSet3);
                        if (i != j) {
                            bitSet2.set(arrayList2.get(n2).get(j));
                            intNum = this.ctx.mkAdd(new Expr[]{intNum, this.ctx.mkMul(new Expr[]{this.vars[hashMap2.get(bitSet)], this.ctx.mkSub(new Expr[]{this.ctx.mkReal(String.valueOf(hashMap.get(bitSet).get(n2))), this.ctx.mkReal(String.valueOf(hashMap.get(bitSet2).get(n2)))})})});
                        }
                        bitSet.andNot(bitSet3);
                        bitSet2.andNot(bitSet3);
                    }
                    if (i == j) continue;
                    this.s.Add(new Expr[]{this.ctx.mkGe((Expr)intNum, (Expr)this.zero)});
                }
            }
        }
        for (n2 = hashMap.size(); n2 < this.vars.length; ++n2) {
            this.s.Add(new Expr[]{this.ctx.mkEq((Expr)this.vars[n2], (Expr)this.zero)});
        }
        intNum = this.ctx.mkInt(0);
        for (n2 = 0; n2 < this.vars.length; ++n2) {
            intNum = this.ctx.mkAdd(new Expr[]{intNum, this.vars[n2]});
        }
        this.s.Add(new Expr[]{this.ctx.mkEq((Expr)intNum, (Expr)this.one)});
        if (this.s.Check(new Expr[0]) == Status.SATISFIABLE) {
            for (n2 = 0; n2 < this.vars.length; ++n2) {
                distribution.add(n2, this.getDoubleValue(this.s.getModel(), (Expr)this.vars[n2]));
            }
            for (n2 = 0; n2 < this.payoff_vars.length; ++n2) {
                arrayList3.add(this.getDoubleValue(this.s.getModel(), (Expr)this.payoff_vars[n2]));
            }
            equilibriumResult.setStatus(CSGModelCheckerEquilibria.CSGResultStatus.SAT);
            equilibriumResult.setPayoffVector(arrayList3);
            arrayList4.add(distribution);
            equilibriumResult.setStrategy(arrayList4);
        } else {
            equilibriumResult.setStatus(CSGModelCheckerEquilibria.CSGResultStatus.UNSAT);
        }
        this.s.Pop();
        return equilibriumResult;
    }

    public double getDoubleValue(Model model, Expr expr) {
        if (model.getConstInterp(expr) instanceof RatNum) {
            RatNum ratNum = (RatNum)model.getConstInterp(expr);
            return ratNum.getBigIntNumerator().doubleValue() / ratNum.getBigIntDenominator().doubleValue();
        }
        if (model.getConstInterp(expr) instanceof AlgebraicNum) {
            AlgebraicNum algebraicNum = (AlgebraicNum)model.getConstInterp(expr);
            RatNum ratNum = algebraicNum.toUpper(12);
            return ratNum.getBigIntNumerator().doubleValue() / ratNum.getBigIntDenominator().doubleValue();
        }
        return Double.NaN;
    }

    @Override
    public String getSolverName() {
        return this.name;
    }

    @Override
    public void clear() {
    }

    @Override
    public void printModel() {
    }
}

