/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.ModInt;
import edu.jas.arith.ModIntRing;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.PrimeList;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.structure.Element;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorModular;
import edu.jas.ufd.FactorModularBerlekamp;
import edu.jas.ufd.FactorsMap;
import edu.jas.ufd.PolyUfdUtil;
import java.util.List;
import java.util.SortedMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class FactorModularTest
extends TestCase {
    int rl = 3;
    int kl = 5;
    int ll = 5;
    int el = 3;
    float q = 0.3f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)FactorModularTest.suite());
    }

    public FactorModularTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(FactorModularTest.class);
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
        ComputerThreads.terminate();
    }

    public void testDummy() {
    }

    public void testModularFactorization() {
        PrimeList primeList = new PrimeList(PrimeList.Range.medium);
        TermOrder termOrder = new TermOrder(2);
        ModIntegerRing modIntegerRing = new ModIntegerRing(primeList.get(3));
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, 1, termOrder);
        FactorModular<ModInteger> factorModular = new FactorModular<ModInteger>(modIntegerRing);
        for (int i = 1; i < 4; ++i) {
            int n = 0;
            GenPolynomial<GenPolynomial<ModInteger>> genPolynomial = null;
            GenPolynomial<ModInteger> genPolynomial2 = genPolynomialRing.random(this.kl, this.ll * (i + 1), this.el * (i + 1), this.q);
            GenPolynomial<ModInteger> genPolynomial3 = genPolynomialRing.random(this.kl, this.ll * (i + 1), this.el * (i + 1), this.q);
            if (genPolynomial2.isZERO() || genPolynomial3.isZERO()) continue;
            if (genPolynomial3.degree() > 0L) {
                ++n;
            }
            if (genPolynomial2.degree() > 0L) {
                ++n;
            }
            if ((genPolynomial = genPolynomial3.multiply((ModInteger)((Object)genPolynomial2))).isConstant()) continue;
            SortedMap sortedMap = factorModular.baseFactors(genPolynomial = genPolynomial.monic());
            if (sortedMap.size() >= n) {
                FactorModularTest.assertTrue((String)("#facs < " + n), (sortedMap.size() >= n ? 1 : 0) != 0);
            } else {
                long l = 0L;
                for (Long l2 : sortedMap.values()) {
                    l += l2.longValue();
                }
                FactorModularTest.assertTrue((String)("#facs < " + n), (l >= (long)n ? 1 : 0) != 0);
            }
            boolean bl = factorModular.isFactorization(genPolynomial, sortedMap);
            FactorModularTest.assertTrue((String)"prod(factor(a)) = a", (boolean)bl);
        }
    }

    public void testModularFactorizationExam() {
        TermOrder termOrder = new TermOrder(2);
        ModIntegerRing modIntegerRing = new ModIntegerRing(7L);
        String[] stringArray = new String[]{"x"};
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, 1, termOrder, stringArray);
        FactorModular<ModInteger> factorModular = new FactorModular<ModInteger>(modIntegerRing);
        int n = 3;
        GenPolynomial genPolynomial = genPolynomialRing.parse("(x^12+5)");
        SortedMap sortedMap = factorModular.baseFactors(genPolynomial = genPolynomial.monic());
        if (sortedMap.size() >= n) {
            FactorModularTest.assertTrue((String)("#facs < " + n), (sortedMap.size() >= n ? 1 : 0) != 0);
        } else {
            long l = 0L;
            for (Long l2 : sortedMap.values()) {
                l += l2.longValue();
            }
            FactorModularTest.assertTrue((String)("#facs < " + n), (l >= (long)n ? 1 : 0) != 0);
        }
        boolean bl = factorModular.isFactorization(genPolynomial, sortedMap);
        FactorModularTest.assertTrue((String)"prod(factor(a)) = a", (boolean)bl);
    }

    public void testModular2Factorization() {
        TermOrder termOrder = new TermOrder(2);
        ModIntegerRing modIntegerRing = new ModIntegerRing(2L);
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, new String[]{"x"}, termOrder);
        FactorModular<ModInteger> factorModular = new FactorModular<ModInteger>(modIntegerRing);
        for (int i = 1; i < 4; ++i) {
            int n = 0;
            GenPolynomial<GenPolynomial<ModInteger>> genPolynomial = null;
            GenPolynomial<ModInteger> genPolynomial2 = genPolynomialRing.random(this.kl, this.ll * (i + 1), this.el * (i + 1), this.q);
            GenPolynomial<ModInteger> genPolynomial3 = genPolynomialRing.random(this.kl, this.ll * (i + 1), this.el * (i + 1), this.q);
            if (genPolynomial2.isZERO() || genPolynomial3.isZERO()) continue;
            if (genPolynomial3.degree() > 0L) {
                ++n;
            }
            if (genPolynomial2.degree() > 0L) {
                ++n;
            }
            if ((genPolynomial = genPolynomial3.multiply((ModInteger)((Object)genPolynomial2))).isConstant()) continue;
            SortedMap sortedMap = factorModular.baseFactors(genPolynomial = genPolynomial.monic());
            if (sortedMap.size() >= n) {
                FactorModularTest.assertTrue((String)("#facs < " + n), (sortedMap.size() >= n ? 1 : 0) != 0);
            } else {
                long l = 0L;
                for (Long l2 : sortedMap.values()) {
                    l += l2.longValue();
                }
                FactorModularTest.assertTrue((String)("#facs < " + n), (l >= (long)n ? 1 : 0) != 0);
            }
            boolean bl = factorModular.isFactorization(genPolynomial, sortedMap);
            FactorModularTest.assertTrue((String)"prod(factor(a)) = a", (boolean)bl);
        }
    }

    public void testMultivariateModularFactorization() {
        TermOrder termOrder = new TermOrder(2);
        ModIntegerRing modIntegerRing = new ModIntegerRing(13L);
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, this.rl, termOrder);
        FactorModular<ModInteger> factorModular = new FactorModular<ModInteger>(modIntegerRing);
        for (int i = 1; i < 2; ++i) {
            int n = 0;
            GenPolynomial<GenPolynomial<ModInteger>> genPolynomial = null;
            GenPolynomial<ModInteger> genPolynomial2 = genPolynomialRing.random(this.kl, 2, this.el, this.q);
            GenPolynomial<ModInteger> genPolynomial3 = genPolynomialRing.random(this.kl, 2, this.el, this.q);
            if (genPolynomial2.isZERO() || genPolynomial3.isZERO()) continue;
            if (genPolynomial3.degree() > 0L) {
                ++n;
            }
            if (genPolynomial2.degree() > 0L) {
                ++n;
            }
            if ((genPolynomial = genPolynomial3.multiply((ModInteger)((Object)genPolynomial2))).isConstant()) continue;
            SortedMap sortedMap = factorModular.factors(genPolynomial);
            if (sortedMap.size() >= n) {
                FactorModularTest.assertTrue((String)("#facs < " + n), (sortedMap.size() >= n ? 1 : 0) != 0);
            } else {
                long l = 0L;
                for (Long l2 : sortedMap.values()) {
                    l += l2.longValue();
                }
                FactorModularTest.assertTrue((String)("#facs < " + n), (l >= (long)n ? 1 : 0) != 0);
            }
            boolean bl = factorModular.isFactorization(genPolynomial, sortedMap);
            FactorModularTest.assertTrue((String)"prod(factor(a)) = a", (boolean)bl);
        }
    }

    public void testBaseModularAbsoluteFactorization() {
        TermOrder termOrder = new TermOrder(2);
        ModIntegerRing modIntegerRing = new ModIntegerRing(17L);
        String[] stringArray = new String[]{"alpha"};
        GenPolynomialRing<ModInteger> genPolynomialRing = new GenPolynomialRing<ModInteger>(modIntegerRing, 1, termOrder, stringArray);
        GenPolynomial<ModInteger> genPolynomial = genPolynomialRing.univariate(0, 4L);
        genPolynomial = genPolynomial.sum((ModInteger)genPolynomialRing.fromInteger(1L));
        FactorModular<ModInteger> factorModular = new FactorModular<ModInteger>(modIntegerRing);
        FactorsMap<ModInteger> factorsMap = factorModular.baseFactorsAbsolute(genPolynomial);
        boolean bl = factorModular.isAbsoluteFactorization(factorsMap);
        FactorModularTest.assertTrue((String)"prod(factor(a)) = a", (boolean)bl);
    }

    public void testFactorBerlekampSmallOdd() {
        int n = 11;
        ModIntRing modIntRing = new ModIntRing(n);
        GenPolynomialRing<ModInt> genPolynomialRing = new GenPolynomialRing<ModInt>(modIntRing, new String[]{"x"});
        GenPolynomial genPolynomial = genPolynomialRing.parse("x^6 - 3 x^5 + x^4 - 3 x^3 - x^2 -3 x + 1");
        FactorModularBerlekamp factorModularBerlekamp = new FactorModularBerlekamp(genPolynomialRing.coFac);
        List<GenPolynomial<Object>> list = ((FactorAbstract)factorModularBerlekamp).baseFactorsSquarefree(genPolynomial);
        FactorModularTest.assertTrue((String)("A == prod(factors): " + list), (boolean)factorModularBerlekamp.isFactorization(genPolynomial, list));
        GenPolynomial genPolynomial2 = ((GenPolynomial)genPolynomialRing.random(5)).monic();
        GenPolynomial genPolynomial3 = ((GenPolynomial)genPolynomialRing.random(5)).monic();
        genPolynomial = genPolynomial2.multiply(genPolynomial3);
        list = ((FactorAbstract)factorModularBerlekamp).baseFactorsSquarefree(genPolynomial);
        FactorModularTest.assertTrue((String)("A == prod(factors): " + list), (boolean)factorModularBerlekamp.isFactorization(genPolynomial, list));
    }

    public void testFactorBerlekampBigOdd() {
        int n = 32003;
        ModIntRing modIntRing = new ModIntRing(n);
        GenPolynomialRing<ModInt> genPolynomialRing = new GenPolynomialRing<ModInt>(modIntRing, new String[]{"x"});
        GenPolynomial genPolynomial = genPolynomialRing.parse("x^6 - 3 x^5 + x^4 - 3 x^3 - x^2 -3 x + 1");
        FactorModularBerlekamp factorModularBerlekamp = new FactorModularBerlekamp(genPolynomialRing.coFac);
        List<GenPolynomial<Object>> list = factorModularBerlekamp.baseFactorsSquarefreeBigPrime(genPolynomial);
        FactorModularTest.assertTrue((String)("A == prod(factors): " + list), (boolean)factorModularBerlekamp.isFactorization(genPolynomial, list));
        GenPolynomial genPolynomial2 = ((GenPolynomial)genPolynomialRing.random(5)).monic();
        GenPolynomial genPolynomial3 = ((GenPolynomial)genPolynomialRing.random(5)).monic();
        genPolynomial = genPolynomial2.multiply(genPolynomial3);
        list = factorModularBerlekamp.baseFactorsSquarefreeBigPrime(genPolynomial);
        FactorModularTest.assertTrue((String)("A == prod(factors): " + list), (boolean)factorModularBerlekamp.isFactorization(genPolynomial, list));
    }

    public void testFactorBerlekampBigEven() {
        int n = 2;
        ModIntRing modIntRing = new ModIntRing(n);
        GenPolynomialRing<ModInt> genPolynomialRing = new GenPolynomialRing<ModInt>(modIntRing, new String[]{"x"});
        GenPolynomial genPolynomial = genPolynomialRing.parse("x^6 - 3 x^5 + x^4 - 3 x^3 - x^2 -3 x + 1");
        FactorModularBerlekamp factorModularBerlekamp = new FactorModularBerlekamp(genPolynomialRing.coFac);
        List<GenPolynomial<Object>> list = factorModularBerlekamp.baseFactorsSquarefreeBigPrime(genPolynomial);
        FactorModularTest.assertTrue((String)("A == prod(factors): " + list), (boolean)factorModularBerlekamp.isFactorization(genPolynomial, list));
        GenPolynomial genPolynomial2 = ((GenPolynomial)genPolynomialRing.random(10)).monic();
        GenPolynomial genPolynomial3 = ((GenPolynomial)genPolynomialRing.random(10)).monic();
        genPolynomial = genPolynomial2.multiply(genPolynomial3);
        list = factorModularBerlekamp.baseFactorsSquarefreeBigPrime(genPolynomial);
        FactorModularTest.assertTrue((String)("A == prod(factors): " + list), (boolean)factorModularBerlekamp.isFactorization(genPolynomial, list));
    }

    public void testFactorBerlekampSmallEven() {
        int n = 2;
        ModIntRing modIntRing = new ModIntRing(n);
        GenPolynomialRing<ModInt> genPolynomialRing = new GenPolynomialRing<ModInt>(modIntRing, new String[]{"x"});
        GenPolynomial genPolynomial = genPolynomialRing.parse("x^6 - 3 x^5 + x^4 - 3 x^3 - x^2 -3 x + 1");
        FactorModularBerlekamp factorModularBerlekamp = new FactorModularBerlekamp(genPolynomialRing.coFac);
        List<GenPolynomial<Object>> list = factorModularBerlekamp.baseFactorsSquarefreeSmallPrime(genPolynomial);
        FactorModularTest.assertTrue((String)("A == prod(factors): " + list), (boolean)factorModularBerlekamp.isFactorization(genPolynomial, list));
        GenPolynomial genPolynomial2 = ((GenPolynomial)genPolynomialRing.random(10)).monic();
        GenPolynomial genPolynomial3 = ((GenPolynomial)genPolynomialRing.random(10)).monic();
        genPolynomial = genPolynomial2.multiply(genPolynomial3);
        list = factorModularBerlekamp.baseFactorsSquarefreeSmallPrime(genPolynomial);
        FactorModularTest.assertTrue((String)("A == prod(factors): " + list), (boolean)factorModularBerlekamp.isFactorization(genPolynomial, list));
    }

    public void testFactorBerlekampBigEvenPower() {
        int n = 2;
        ModIntRing modIntRing = new ModIntRing(n);
        GenPolynomialRing<ModInt> genPolynomialRing = new GenPolynomialRing<ModInt>(modIntRing, new String[]{"a"});
        Element element = genPolynomialRing.parse("a^4 + a + 1");
        AlgebraicNumberRing algebraicNumberRing = new AlgebraicNumberRing(element, true);
        GenPolynomialRing genPolynomialRing2 = new GenPolynomialRing(algebraicNumberRing, new String[]{"x"});
        GenPolynomial genPolynomial = genPolynomialRing2.parse("x^5 + (a^3 + a + 1) x^4 + (a^3 + a^2 + 1) x^3 + ( a ) x + (a^3 + a + 1)");
        FactorModularBerlekamp factorModularBerlekamp = new FactorModularBerlekamp(genPolynomialRing2.coFac);
        List<GenPolynomial<Object>> list = factorModularBerlekamp.baseFactorsSquarefreeBigPrime(genPolynomial);
        FactorModularTest.assertTrue((String)("A == prod(factors): " + list), (boolean)factorModularBerlekamp.isFactorization(genPolynomial, list));
        GenPolynomial genPolynomial2 = ((GenPolynomial)genPolynomialRing2.random(5)).monic();
        GenPolynomial genPolynomial3 = ((GenPolynomial)genPolynomialRing2.random(7)).monic();
        genPolynomial = genPolynomial2.multiply(genPolynomial3);
        list = factorModularBerlekamp.baseFactorsSquarefreeBigPrime(genPolynomial);
        FactorModularTest.assertTrue((String)("A == prod(factors): " + list), (boolean)factorModularBerlekamp.isFactorization(genPolynomial, list));
    }

    public void testFactorBerlekampSmallEvenPower() {
        int n = 2;
        ModIntRing modIntRing = new ModIntRing(n);
        GenPolynomialRing<ModInt> genPolynomialRing = new GenPolynomialRing<ModInt>(modIntRing, new String[]{"a"});
        Element element = genPolynomialRing.parse("a^4 + a + 1");
        AlgebraicNumberRing algebraicNumberRing = new AlgebraicNumberRing(element, true);
        GenPolynomialRing genPolynomialRing2 = new GenPolynomialRing(algebraicNumberRing, new String[]{"x"});
        GenPolynomial genPolynomial = genPolynomialRing2.parse("x^5 + (a^3 + a + 1) x^4 + (a^3 + a^2 + 1) x^3 + ( a ) x + (a^3 + a + 1)");
        FactorModularBerlekamp factorModularBerlekamp = new FactorModularBerlekamp(genPolynomialRing2.coFac);
        List<GenPolynomial<Object>> list = factorModularBerlekamp.baseFactorsSquarefreeSmallPrime(genPolynomial);
        FactorModularTest.assertTrue((String)("A == prod(factors): " + list), (boolean)factorModularBerlekamp.isFactorization(genPolynomial, list));
        GenPolynomial genPolynomial2 = ((GenPolynomial)genPolynomialRing2.random(5)).monic();
        GenPolynomial genPolynomial3 = ((GenPolynomial)genPolynomialRing2.random(7)).monic();
        genPolynomial = genPolynomial2.multiply(genPolynomial3);
        list = factorModularBerlekamp.baseFactorsSquarefreeSmallPrime(genPolynomial);
        FactorModularTest.assertTrue((String)("A == prod(factors): " + list), (boolean)factorModularBerlekamp.isFactorization(genPolynomial, list));
    }

    public void testFactorBerlekampSmallOddPower() {
        int n = 3;
        int n2 = 4;
        ModIntRing modIntRing = new ModIntRing(n);
        GenPolynomialRing<ModInt> genPolynomialRing = new GenPolynomialRing<ModInt>(modIntRing, new String[]{"a"});
        AlgebraicNumberRing<ModInt> algebraicNumberRing = PolyUfdUtil.algebraicNumberField(genPolynomialRing, n2);
        GenPolynomialRing<ModInt> genPolynomialRing2 = new GenPolynomialRing<ModInt>(algebraicNumberRing, new String[]{"x"});
        GenPolynomial genPolynomial = genPolynomialRing2.parse("x^5 + (a^3 + a + 1) x^4 + (a^3 + a^2 + 1) x^3 + ( a ) x + (a^3 + a + 1)");
        FactorModularBerlekamp factorModularBerlekamp = new FactorModularBerlekamp(genPolynomialRing2.coFac);
        List<GenPolynomial<Object>> list = factorModularBerlekamp.baseFactorsSquarefreeSmallPrime(genPolynomial);
        FactorModularTest.assertTrue((String)("A == prod(factors): " + list), (boolean)factorModularBerlekamp.isFactorization(genPolynomial, list));
        GenPolynomial genPolynomial2 = ((GenPolynomial)genPolynomialRing2.random(5)).monic();
        GenPolynomial genPolynomial3 = ((GenPolynomial)genPolynomialRing2.random(7)).monic();
        genPolynomial = genPolynomial2.multiply(genPolynomial3);
        list = factorModularBerlekamp.baseFactorsSquarefreeSmallPrime(genPolynomial);
        FactorModularTest.assertTrue((String)("A == prod(factors): " + list), (boolean)factorModularBerlekamp.isFactorization(genPolynomial, list));
    }

    public void testFactorBerlekampBigOddPower() {
        int n = 3;
        int n2 = 4;
        ModIntRing modIntRing = new ModIntRing(n);
        GenPolynomialRing<ModInt> genPolynomialRing = new GenPolynomialRing<ModInt>(modIntRing, new String[]{"a"});
        AlgebraicNumberRing<ModInt> algebraicNumberRing = PolyUfdUtil.algebraicNumberField(genPolynomialRing, n2);
        GenPolynomialRing<ModInt> genPolynomialRing2 = new GenPolynomialRing<ModInt>(algebraicNumberRing, new String[]{"x"});
        GenPolynomial genPolynomial = genPolynomialRing2.parse("x^5 + (a^3 + a + 1) x^4 + (a^3 + a^2 + 1) x^3 + ( a ) x + (a^3 + a + 1)");
        FactorModularBerlekamp factorModularBerlekamp = new FactorModularBerlekamp(genPolynomialRing2.coFac);
        List<GenPolynomial<Object>> list = factorModularBerlekamp.baseFactorsSquarefreeBigPrime(genPolynomial);
        FactorModularTest.assertTrue((String)("A == prod(factors): " + list), (boolean)factorModularBerlekamp.isFactorization(genPolynomial, list));
        GenPolynomial genPolynomial2 = ((GenPolynomial)genPolynomialRing2.random(5)).monic();
        GenPolynomial genPolynomial3 = ((GenPolynomial)genPolynomialRing2.random(7)).monic();
        genPolynomial = genPolynomial2.multiply(genPolynomial3);
        list = factorModularBerlekamp.baseFactorsSquarefreeBigPrime(genPolynomial);
        FactorModularTest.assertTrue((String)("A == prod(factors): " + list), (boolean)factorModularBerlekamp.isFactorization(genPolynomial, list));
    }

    public void testCompareFactorBerlekamp() {
        int n = 32003;
        ModIntRing modIntRing = new ModIntRing(n);
        GenPolynomialRing<ModInt> genPolynomialRing = new GenPolynomialRing<ModInt>(modIntRing, new String[]{"x"});
        GenPolynomial<GenPolynomial<ModInt>> genPolynomial = genPolynomialRing.parse("x^6 - 3 x^5 + x^4 - 3 x^3 - x^2 -3 x + 1");
        FactorModular<GenPolynomial<ModInt>> factorModular = new FactorModular<GenPolynomial<ModInt>>(genPolynomialRing.coFac);
        FactorModularBerlekamp<GenPolynomial<ModInt>> factorModularBerlekamp = new FactorModularBerlekamp<GenPolynomial<ModInt>>(genPolynomialRing.coFac);
        GenPolynomial<ModInt> genPolynomial2 = genPolynomialRing.random(this.kl, this.ll * this.ll + 20, this.el * this.el + 10, n + n).monic();
        GenPolynomial<ModInt> genPolynomial3 = genPolynomialRing.random(this.kl, this.ll * this.ll + 20, this.el * this.el + 10, n + n).monic();
        genPolynomial = genPolynomial2.multiply((ModInt)((Object)genPolynomial3));
        long l = System.currentTimeMillis();
        SortedMap sortedMap = factorModularBerlekamp.baseFactors(genPolynomial);
        l = System.currentTimeMillis() - l;
        FactorModularTest.assertTrue((String)("A == prod(factors): " + sortedMap), (boolean)factorModularBerlekamp.isFactorization(genPolynomial, sortedMap));
        long l2 = System.currentTimeMillis();
        SortedMap<GenPolynomial<GenPolynomial<ModInt>>, Long> sortedMap2 = factorModular.baseFactors(genPolynomial);
        l2 = System.currentTimeMillis() - l2;
        FactorModularTest.assertEquals((String)"factors == f2: ", sortedMap, sortedMap2);
        FactorModularTest.assertTrue((String)("A == prod(factors): " + sortedMap), (boolean)factorModularBerlekamp.isFactorization(genPolynomial, sortedMap));
        FactorModularTest.assertTrue((String)("t >= 0: " + l + ", " + l2), (l >= 0L && l2 >= 0L ? 1 : 0) != 0);
    }
}

