/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigQuaternion;
import edu.jas.arith.BigQuaternionRing;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class QuatGenPolynomialTest
extends TestCase {
    BigQuaternionRing cfac;
    GenPolynomialRing<BigQuaternion> fac;
    GenPolynomial<BigQuaternion> a;
    GenPolynomial<BigQuaternion> b;
    GenPolynomial<BigQuaternion> c;
    GenPolynomial<BigQuaternion> d;
    GenPolynomial<BigQuaternion> e;
    int rl = 4;
    int kl = 3;
    int ll = 7;
    int el = 3;
    float q = 0.4f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)QuatGenPolynomialTest.suite());
    }

    public QuatGenPolynomialTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(QuatGenPolynomialTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.cfac = new BigQuaternionRing();
        this.fac = new GenPolynomialRing<BigQuaternion>(this.cfac, this.rl);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.cfac = null;
        this.fac = null;
    }

    public void testConstruction() {
        this.c = this.fac.getONE();
        QuatGenPolynomialTest.assertTrue((String)"length( c ) = 1", (this.c.length() == 1 ? 1 : 0) != 0);
        QuatGenPolynomialTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        QuatGenPolynomialTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.d = this.fac.getZERO();
        QuatGenPolynomialTest.assertTrue((String)"length( d ) = 0", (this.d.length() == 0 ? 1 : 0) != 0);
        QuatGenPolynomialTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        QuatGenPolynomialTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
    }

    public void testRandom() {
        for (int i = 0; i < 7; ++i) {
            this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
            if (this.a.isZERO()) continue;
            QuatGenPolynomialTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.length() >= 0 ? 1 : 0) != 0);
            QuatGenPolynomialTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            QuatGenPolynomialTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
        }
    }

    public void testAddition() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.a.sum((BigQuaternion)((Object)this.b));
        this.d = this.c.subtract((BigQuaternion)((Object)this.b));
        QuatGenPolynomialTest.assertEquals((String)"a+b-b = a", this.a, this.d);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        ExpVector expVector = ExpVector.random(this.rl, this.el, this.q);
        BigQuaternion bigQuaternion = this.cfac.random(this.kl);
        this.b = new GenPolynomial<BigQuaternion>(this.fac, bigQuaternion, expVector);
        this.c = this.a.sum((BigQuaternion)((Object)this.b));
        this.d = this.a.sum(bigQuaternion, expVector);
        QuatGenPolynomialTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = this.a.subtract((BigQuaternion)((Object)this.b));
        this.d = this.a.subtract(bigQuaternion, expVector);
        QuatGenPolynomialTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
        this.a = new GenPolynomial<BigQuaternion>(this.fac);
        this.b = new GenPolynomial<BigQuaternion>(this.fac, bigQuaternion, expVector);
        this.c = this.b.sum((BigQuaternion)((Object)this.a));
        this.d = this.a.sum(bigQuaternion, expVector);
        QuatGenPolynomialTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = this.a.subtract((BigQuaternion)((Object)this.b));
        this.d = this.a.subtract(bigQuaternion, expVector);
        QuatGenPolynomialTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
    }

    public void testMultiplication() {
        do {
            this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        } while (this.a.isZERO());
        do {
            this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        } while (this.b.isZERO());
        this.c = this.b.multiply((BigQuaternion)((Object)this.a));
        this.d = this.a.multiply((BigQuaternion)((Object)this.b));
        QuatGenPolynomialTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        QuatGenPolynomialTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.e = this.d.subtract((BigQuaternion)((Object)this.c));
        QuatGenPolynomialTest.assertTrue((String)("!isZERO( a*b-b*a ) " + this.e), (!this.e.isZERO() ? 1 : 0) != 0);
        QuatGenPolynomialTest.assertTrue((String)"a*b = b*a", (!this.c.equals(this.d) ? 1 : 0) != 0);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.a.multiply((BigQuaternion)((Object)this.b.multiply((BigQuaternion)((Object)this.c))));
        this.e = this.a.multiply((BigQuaternion)((Object)this.b)).multiply(this.c);
        QuatGenPolynomialTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        BigQuaternion bigQuaternion = this.a.leadingBaseCoefficient().inverse();
        this.c = this.a.monic();
        this.d = this.a.multiplyLeft(bigQuaternion);
        QuatGenPolynomialTest.assertEquals((String)"a.monic() = (1/ldcf(a))a", this.c, this.d);
        BigQuaternion bigQuaternion2 = this.b.leadingBaseCoefficient().inverse();
        this.c = this.b.monic();
        this.d = this.b.multiplyLeft(bigQuaternion2);
        QuatGenPolynomialTest.assertEquals((String)"b.monic() = (1/ldcf(b))b", this.c, this.d);
        this.e = new GenPolynomial<BigQuaternion>(this.fac, bigQuaternion2);
        this.d = this.e.multiply((BigQuaternion)((Object)this.b));
        QuatGenPolynomialTest.assertEquals((String)"b.monic() = (1/ldcf(b))b", this.c, this.d);
        this.d = this.b.multiply(bigQuaternion2);
        QuatGenPolynomialTest.assertTrue((String)"is monic: b(1/ldcf(b))", (boolean)this.d.leadingBaseCoefficient().isONE());
    }

    public void testCoeffMultiplication() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.a.monic();
        BigQuaternion bigQuaternion = this.cfac.random(5);
        BigQuaternion bigQuaternion2 = bigQuaternion.inverse();
        BigQuaternion bigQuaternion3 = bigQuaternion.multiply(bigQuaternion2);
        BigQuaternion bigQuaternion4 = bigQuaternion2.multiply(bigQuaternion);
        QuatGenPolynomialTest.assertEquals((String)"qa*(1/qa) == (1/qa)*qa ", (Object)bigQuaternion3, (Object)bigQuaternion4);
        this.b = this.c.multiply(bigQuaternion).multiply(bigQuaternion2);
        this.d = this.c.multiplyLeft(bigQuaternion).multiplyLeft(bigQuaternion2);
        QuatGenPolynomialTest.assertEquals((String)"c*qa*qb = qb*qa*c", this.b, this.d);
        this.b = this.c.multiply(bigQuaternion).multiplyLeft(bigQuaternion2);
        this.d = this.c.multiplyLeft(bigQuaternion2).multiply(bigQuaternion);
        this.e = this.b.subtract((BigQuaternion)((Object)this.d));
        QuatGenPolynomialTest.assertEquals((String)"qb*(c*qa) == (qb*c)*qa", this.b, this.d);
    }
}

