/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ModGenPolynomialTest
extends TestCase {
    GenPolynomialRing<ModInteger> fac;
    GenPolynomial<ModInteger> a;
    GenPolynomial<ModInteger> b;
    GenPolynomial<ModInteger> c;
    GenPolynomial<ModInteger> d;
    GenPolynomial<ModInteger> e;
    int ml = 19;
    int rl = 7;
    int kl = 10;
    int ll = 10;
    int el = 5;
    float q = 0.5f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)ModGenPolynomialTest.suite());
    }

    public ModGenPolynomialTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(ModGenPolynomialTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = new GenPolynomialRing<ModInteger>(new ModIntegerRing(this.ml), this.rl);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
    }

    public void testConstruction() {
        this.c = this.fac.getONE();
        ModGenPolynomialTest.assertTrue((String)"length( c ) = 1", (this.c.length() == 1 ? 1 : 0) != 0);
        ModGenPolynomialTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        ModGenPolynomialTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.d = this.fac.getZERO();
        ModGenPolynomialTest.assertTrue((String)"length( d ) = 0", (this.d.length() == 0 ? 1 : 0) != 0);
        ModGenPolynomialTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        ModGenPolynomialTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
    }

    public void testRandom() {
        for (int i = 0; i < 7; ++i) {
            this.a = this.fac.random(this.ll);
            ModGenPolynomialTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.length() >= 0 ? 1 : 0) != 0);
            ModGenPolynomialTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            ModGenPolynomialTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
        }
    }

    public void testAddition() {
        this.a = this.fac.random(this.ll);
        this.b = this.fac.random(this.ll);
        this.c = this.a.sum((ModInteger)((Object)this.b));
        this.d = this.c.subtract((ModInteger)((Object)this.b));
        ModGenPolynomialTest.assertEquals((String)"a+b-b = a", this.a, this.d);
        this.c = this.fac.random(this.ll);
        ExpVector expVector = ExpVector.random(this.rl, this.el, this.q);
        ModInteger modInteger = this.c.leadingBaseCoefficient().ring.random(this.kl);
        this.b = new GenPolynomial<ModInteger>(this.fac, modInteger, expVector);
        this.c = this.a.sum((ModInteger)((Object)this.b));
        this.d = this.a.sum(modInteger, expVector);
        ModGenPolynomialTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = this.a.subtract((ModInteger)((Object)this.b));
        this.d = this.a.subtract(modInteger, expVector);
        ModGenPolynomialTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
        this.a = new GenPolynomial<ModInteger>(this.fac);
        this.b = new GenPolynomial<ModInteger>(this.fac, modInteger, expVector);
        this.c = this.b.sum((ModInteger)((Object)this.a));
        this.d = this.a.sum(modInteger, expVector);
        ModGenPolynomialTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = this.a.subtract((ModInteger)((Object)this.b));
        this.d = this.a.subtract(modInteger, expVector);
        ModGenPolynomialTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
    }

    public void testMultiplication() {
        this.a = this.fac.random(this.ll);
        ModGenPolynomialTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.b = this.fac.random(this.ll);
        ModGenPolynomialTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.c = this.b.multiply((ModInteger)((Object)this.a));
        this.d = this.a.multiply((ModInteger)((Object)this.b));
        ModGenPolynomialTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        ModGenPolynomialTest.assertTrue((String)"not isZERO( d )", (!this.d.isZERO() ? 1 : 0) != 0);
        this.e = this.d.subtract((ModInteger)((Object)this.c));
        ModGenPolynomialTest.assertTrue((String)("isZERO( a*b-b*a ) " + this.e), (boolean)this.e.isZERO());
        ModGenPolynomialTest.assertTrue((String)"a*b = b*a", (boolean)this.c.equals(this.d));
        ModGenPolynomialTest.assertEquals((String)"a*b = b*a", this.c, this.d);
        this.c = this.fac.random(this.ll);
        this.d = this.a.multiply((ModInteger)((Object)this.b.multiply((ModInteger)((Object)this.c))));
        this.e = this.a.multiply((ModInteger)((Object)this.b)).multiply(this.c);
        ModGenPolynomialTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        ModGenPolynomialTest.assertTrue((String)"a(bc) = (ab)c", (boolean)this.d.equals(this.e));
        ModInteger modInteger = this.a.leadingBaseCoefficient().inverse();
        this.c = this.a.monic();
        this.d = this.a.multiply(modInteger);
        ModGenPolynomialTest.assertEquals((String)"a.monic() = a(1/ldcf(a))", this.c, this.d);
        ModInteger modInteger2 = this.b.leadingBaseCoefficient().inverse();
        this.c = this.b.monic();
        this.d = this.b.multiply(modInteger2);
        ModGenPolynomialTest.assertEquals((String)"b.monic() = b(1/ldcf(b))", this.c, this.d);
        this.e = new GenPolynomial<ModInteger>(this.fac, modInteger2);
        this.d = this.b.multiply((ModInteger)((Object)this.e));
        ModGenPolynomialTest.assertEquals((String)"b.monic() = b(1/ldcf(b))", this.c, this.d);
        this.d = this.e.multiply((ModInteger)((Object)this.b));
        ModGenPolynomialTest.assertEquals((String)"b.monic() = (1/ldcf(b) (0))*b", this.c, this.d);
    }

    public void testDistributive() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.a.multiply((ModInteger)((Object)this.b.sum((ModInteger)((Object)this.c))));
        this.e = this.a.multiply((ModInteger)((Object)this.b)).sum((GenPolynomial<ModInteger>)this.a.multiply((ModInteger)((Object)this.c)));
        ModGenPolynomialTest.assertEquals((String)"a(b+c) = ab+ac", this.d, this.e);
    }
}

