/*
 * Decompiled with CFR 0.152.
 */
package userinterface.simulator;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import javax.swing.table.AbstractTableModel;
import parser.ast.ModulesFile;
import prism.ModelInfo;
import simulator.PathFullInfo;
import strat.StrategyGenerator;
import userinterface.simulator.GUISimLabelList;
import userinterface.simulator.GUISimulator;
import userinterface.simulator.SimulationView;
import userinterface.util.GUIGroupedTableModel;

public class GUISimulatorPathTableModel
extends AbstractTableModel
implements GUIGroupedTableModel,
Observer {
    private static final long serialVersionUID = 1L;
    private GUISimulator simulator;
    private SimulationView view;
    private List<PathTableModelGroup> visibleGroups;
    private List<PathTableModelColumn> visibleColumns;
    private boolean pathActive;
    private ModulesFile parsedModel;
    private ModelInfo modelInfo;
    private PathFullInfo path;
    private SimulationView.RewardStructureValue rewardStructureValue;
    private SimulationView.VariableValue variableValue;
    private SimulationView.TimeValue timeValue;
    private SimulationView.ActionValue actionValue;
    private SimulationView.MemoryValue memoryValue;

    public GUISimulatorPathTableModel(GUISimulator gUISimulator, SimulationView simulationView) {
        this.simulator = gUISimulator;
        this.view = simulationView;
        this.view.addObserver(this);
        this.visibleGroups = new ArrayList<PathTableModelGroup>();
        this.visibleColumns = new ArrayList<PathTableModelColumn>();
        SimulationView simulationView2 = simulationView;
        Objects.requireNonNull(simulationView2);
        this.rewardStructureValue = new SimulationView.RewardStructureValue(simulationView2, null, null);
        SimulationView simulationView3 = simulationView;
        Objects.requireNonNull(simulationView3);
        this.variableValue = new SimulationView.VariableValue(simulationView3, null, null);
    }

    public void setPathActive(boolean bl) {
        this.pathActive = bl;
    }

    public void setPath(PathFullInfo pathFullInfo) {
        this.path = pathFullInfo;
    }

    public void setParsedModel(ModulesFile modulesFile) {
        this.parsedModel = modulesFile;
    }

    public void setModelInfo(ModelInfo modelInfo) {
        this.modelInfo = modelInfo;
    }

    public boolean canShowTime() {
        return this.modelInfo.getModelType().continuousTime();
    }

    @Override
    public int getGroupCount() {
        if (!this.pathActive) {
            return 0;
        }
        return this.visibleGroups.size();
    }

    @Override
    public void update(Observable observable, Object object) {
        if (observable == this.view) {
            this.setVisibleColumnsAndGroups();
            this.fireTableStructureChanged();
            this.simulator.sortOutColumnSizes();
        }
    }

    @Override
    public String getGroupName(int n) {
        if (!this.pathActive) {
            return "";
        }
        switch (this.visibleGroups.get((int)n).type) {
            case STEP: {
                return "Step";
            }
            case TIME: {
                return "Time";
            }
            case VARIABLES: {
                int n2 = (Integer)this.visibleGroups.get((int)n).info;
                return n2 == -1 ? "Globals" : this.modelInfo.getModuleName(n2);
            }
            case OBSERVABLES: {
                return "Observables";
            }
            case REWARDS: {
                return "Rewards";
            }
            case STRATEGY: {
                return "Strategy";
            }
        }
        return "";
    }

    @Override
    public String getGroupToolTip(int n) {
        if (!this.pathActive) {
            return "";
        }
        switch (this.visibleGroups.get((int)n).type) {
            case STEP: {
                return null;
            }
            case TIME: {
                return null;
            }
            case VARIABLES: {
                int n2 = (Integer)this.visibleGroups.get((int)n).info;
                return n2 == -1 ? "Global variables" : "Variables of module " + this.modelInfo.getModuleName(n2);
            }
            case OBSERVABLES: {
                return null;
            }
            case REWARDS: {
                return "State, transition and cumulative rewards";
            }
            case STRATEGY: {
                return "Status of current strategy";
            }
        }
        return "";
    }

    @Override
    public int getLastColumnOfGroup(int n) {
        if (!this.pathActive) {
            return 0;
        }
        return this.visibleGroups.get((int)n).lastCol;
    }

    @Override
    public int getColumnCount() {
        if (!this.pathActive) {
            return 0;
        }
        return this.visibleColumns.size();
    }

    @Override
    public int getRowCount() {
        return this.pathActive ? (int)this.path.size() + 1 : 0;
    }

    public boolean shouldColourRow(int n) {
        int n2 = this.simulator.getStateLabelList().getSelectedIndex();
        if (n2 != -1) {
            GUISimLabelList.SimLabel simLabel = (GUISimLabelList.SimLabel)this.simulator.getStateLabelList().getModel().getElementAt(n2);
            if (n == this.getRowCount() - 1 ? simLabel.getResult() == 1 : simLabel.getResult(n) == 1) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getColumnName(int n) {
        if (this.pathActive) {
            switch (this.visibleColumns.get((int)n).type) {
                case ACTION: {
                    return this.modelInfo.getActionStringDescription();
                }
                case STEP: {
                    return "#";
                }
                case TIME_CUMUL: {
                    return "Time (+)";
                }
                case TIME: {
                    return "Time";
                }
                case VARIABLE: {
                    SimulationView.Variable variable = (SimulationView.Variable)this.visibleColumns.get((int)n).info;
                    return variable.toString();
                }
                case OBSERVABLE: {
                    SimulationView.Observ observ = (SimulationView.Observ)this.visibleColumns.get((int)n).info;
                    return observ.toString();
                }
                case REWARD: {
                    SimulationView.RewardStructureColumn rewardStructureColumn = (SimulationView.RewardStructureColumn)this.visibleColumns.get((int)n).info;
                    return rewardStructureColumn.getColumnName();
                }
                case MEMORY: {
                    return "Memory";
                }
            }
            return "";
        }
        return "";
    }

    @Override
    public String getColumnToolTip(int n) {
        if (this.pathActive) {
            switch (this.visibleColumns.get((int)n).type) {
                case ACTION: {
                    return "Module name or [action] label";
                }
                case STEP: {
                    return "Index of state in path";
                }
                case TIME_CUMUL: {
                    return "Cumulative time";
                }
                case TIME: {
                    return "Time spent in state";
                }
                case VARIABLE: {
                    SimulationView.Variable variable = (SimulationView.Variable)this.visibleColumns.get((int)n).info;
                    return "Value of variable " + variable.toString();
                }
                case OBSERVABLE: {
                    SimulationView.Observ observ = (SimulationView.Observ)this.visibleColumns.get((int)n).info;
                    return "Value of observable " + observ.toString();
                }
                case REWARD: {
                    SimulationView.RewardStructureColumn rewardStructureColumn = (SimulationView.RewardStructureColumn)this.visibleColumns.get((int)n).info;
                    String string = rewardStructureColumn.getRewardStructure().getColumnName();
                    if (rewardStructureColumn.isStateReward()) {
                        return "State reward of reward structure " + string;
                    }
                    if (rewardStructureColumn.isTransitionReward()) {
                        return "Transition reward of reward structure " + string;
                    }
                    if (rewardStructureColumn.isCumulativeReward()) {
                        return "Cumulative reward of reward structure " + string;
                    }
                }
                case MEMORY: {
                    return "Memory of current strategy";
                }
            }
            return "";
        }
        return "";
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.pathActive) {
            switch (this.visibleColumns.get((int)n2).type) {
                case ACTION: {
                    SimulationView simulationView = this.view;
                    Objects.requireNonNull(simulationView);
                    this.actionValue = new SimulationView.ActionValue(simulationView, n == 0 ? "" : this.path.getActionString(n - 1));
                    this.actionValue.setActionValueUnknown(false);
                    return this.actionValue;
                }
                case STEP: {
                    return "" + n;
                }
                case TIME_CUMUL: {
                    SimulationView simulationView = this.view;
                    Objects.requireNonNull(simulationView);
                    this.timeValue = new SimulationView.TimeValue(simulationView, this.path.getCumulativeTime(n), true);
                    this.timeValue.setTimeValueUnknown((long)n > this.path.size());
                    return this.timeValue;
                }
                case TIME: {
                    SimulationView simulationView = this.view;
                    Objects.requireNonNull(simulationView);
                    this.timeValue = new SimulationView.TimeValue(simulationView, this.path.getTime(n), false);
                    this.timeValue.setTimeValueUnknown((long)n >= this.path.size());
                    return this.timeValue;
                }
                case VARIABLE: {
                    SimulationView.Variable variable = (SimulationView.Variable)this.visibleColumns.get((int)n2).info;
                    Object object = this.path.getState((int)n).varValues[variable.getIndex()];
                    this.variableValue.setVariable(variable);
                    this.variableValue.setValue(object);
                    this.variableValue.setChanged(n == 0 || !this.path.getState((int)(n - 1)).varValues[variable.getIndex()].equals(object));
                    return this.variableValue;
                }
                case OBSERVABLE: {
                    SimulationView.Observ observ = (SimulationView.Observ)this.visibleColumns.get((int)n2).info;
                    Object object = this.path.getObservation((int)n).varValues[observ.getIndex()];
                    this.variableValue.setVariable(observ);
                    this.variableValue.setValue(object);
                    this.variableValue.setChanged(n == 0 || !this.path.getObservation((int)(n - 1)).varValues[observ.getIndex()].equals(object));
                    return this.variableValue;
                }
                case REWARD: {
                    SimulationView.RewardStructureColumn rewardStructureColumn = (SimulationView.RewardStructureColumn)this.visibleColumns.get((int)n2).info;
                    this.rewardStructureValue.setRewardStructureColumn(rewardStructureColumn);
                    this.rewardStructureValue.setRewardValueUnknown(false);
                    if (rewardStructureColumn.isStateReward()) {
                        double d = this.path.getStateReward(n, rewardStructureColumn.getRewardStructure().getIndex());
                        this.rewardStructureValue.setChanged(n == 0 || d != this.path.getStateReward(n - 1, rewardStructureColumn.getRewardStructure().getIndex()));
                        this.rewardStructureValue.setRewardValue(d);
                        this.rewardStructureValue.setRewardValueUnknown((long)n > this.path.size());
                    } else if (rewardStructureColumn.isTransitionReward()) {
                        double d = this.path.getTransitionReward(n, rewardStructureColumn.getRewardStructure().getIndex());
                        this.rewardStructureValue.setChanged(n == 0 || d != this.path.getTransitionReward(n - 1, rewardStructureColumn.getRewardStructure().getIndex()));
                        this.rewardStructureValue.setRewardValue(d);
                        this.rewardStructureValue.setRewardValueUnknown((long)n >= this.path.size());
                    } else {
                        double d = this.path.getCumulativeReward(n, rewardStructureColumn.getRewardStructure().getIndex());
                        this.rewardStructureValue.setChanged(n == 0 || d != this.path.getCumulativeReward(n - 1, rewardStructureColumn.getRewardStructure().getIndex()));
                        this.rewardStructureValue.setRewardValue(d);
                        this.rewardStructureValue.setRewardValueUnknown((long)n > this.path.size());
                    }
                    return this.rewardStructureValue;
                }
                case MEMORY: {
                    int n3 = this.path.getStrategyMemory(n);
                    String string = this.simulator.getSimulatorEngine().getStrategy().getMemoryString(n3);
                    SimulationView simulationView = this.view;
                    Objects.requireNonNull(simulationView);
                    this.memoryValue = new SimulationView.MemoryValue(simulationView, string);
                    this.memoryValue.setMemoryValueUnknown((long)n > this.path.size());
                    return this.memoryValue;
                }
            }
            return "";
        }
        return "";
    }

    public void restartPathTable() {
        this.view.refreshToDefaultView(this.pathActive, this.parsedModel);
    }

    public void updatePathTable() {
        this.setVisibleColumnsAndGroups();
        this.fireTableStructureChanged();
        this.fireTableDataChanged();
    }

    public void setVisibleColumnsAndGroups() {
        this.visibleColumns.clear();
        this.visibleGroups.clear();
        if (this.pathActive) {
            StrategyGenerator<Double> strategyGenerator;
            if (this.view.showActions() || this.view.showSteps()) {
                if (this.view.showActions()) {
                    this.visibleColumns.add(new PathTableModelColumn(GUISimulatorPathTableModelColumn.ACTION, null));
                }
                if (this.view.showSteps()) {
                    this.visibleColumns.add(new PathTableModelColumn(GUISimulatorPathTableModelColumn.STEP, null));
                }
                this.visibleGroups.add(new PathTableModelGroup(PathTableModelGroupType.STEP, null, this.visibleColumns.size() - 1));
            }
            if (this.canShowTime() && (this.view.showTime() || this.view.showCumulativeTime())) {
                if (this.view.showCumulativeTime()) {
                    this.visibleColumns.add(new PathTableModelColumn(GUISimulatorPathTableModelColumn.TIME_CUMUL, null));
                }
                if (this.view.showTime()) {
                    this.visibleColumns.add(new PathTableModelColumn(GUISimulatorPathTableModelColumn.TIME, null));
                }
                this.visibleGroups.add(new PathTableModelGroup(PathTableModelGroupType.TIME, null, this.visibleColumns.size() - 1));
            }
            if (this.view.getVisibleVariables().size() > 0) {
                int n = this.view.getVisibleVariables().size();
                for (int i = 0; i < n; ++i) {
                    SimulationView.Variable variable = this.view.getVisibleVariables().get(i);
                    this.visibleColumns.add(new PathTableModelColumn(GUISimulatorPathTableModelColumn.VARIABLE, variable));
                    if (i != n - 1 && variable.getModuleIndex() == this.view.getVisibleVariables().get(i + 1).getModuleIndex()) continue;
                    this.visibleGroups.add(new PathTableModelGroup(PathTableModelGroupType.VARIABLES, variable.getModuleIndex(), this.visibleColumns.size() - 1));
                }
            }
            if (this.view.getVisibleObservables().size() > 0) {
                for (SimulationView.Observ observ : this.view.getVisibleObservables()) {
                    this.visibleColumns.add(new PathTableModelColumn(GUISimulatorPathTableModelColumn.OBSERVABLE, observ));
                }
                this.visibleGroups.add(new PathTableModelGroup(PathTableModelGroupType.OBSERVABLES, null, this.visibleColumns.size() - 1));
            }
            if (this.view.getVisibleRewardColumns().size() > 0) {
                for (SimulationView.RewardStructureColumn rewardStructureColumn : this.view.getVisibleRewardColumns()) {
                    this.visibleColumns.add(new PathTableModelColumn(GUISimulatorPathTableModelColumn.REWARD, rewardStructureColumn));
                }
                this.visibleGroups.add(new PathTableModelGroup(PathTableModelGroupType.REWARDS, null, this.visibleColumns.size() - 1));
            }
            if (this.simulator.isStrategyShown() && (strategyGenerator = this.simulator.getSimulatorEngine().getStrategy()) != null && strategyGenerator.hasMemory()) {
                this.visibleColumns.add(new PathTableModelColumn(GUISimulatorPathTableModelColumn.MEMORY, null));
                this.visibleGroups.add(new PathTableModelGroup(PathTableModelGroupType.STRATEGY, null, this.visibleColumns.size() - 1));
            }
        }
    }

    public boolean isPathLooping() {
        return this.path.isLooping();
    }

    public int getLoopStart() {
        return (int)this.path.loopStart();
    }

    public int getLoopEnd() {
        return (int)this.path.loopEnd();
    }

    public SimulationView getView() {
        return this.view;
    }

    public void setView(SimulationView simulationView) {
        this.view.deleteObserver(this);
        this.view = simulationView;
        this.view.addObserver(this);
    }

    class PathTableModelGroup {
        public PathTableModelGroupType type;
        public Object info;
        public int lastCol;

        public PathTableModelGroup(PathTableModelGroupType pathTableModelGroupType, Object object, int n) {
            this.type = pathTableModelGroupType;
            this.info = object;
            this.lastCol = n;
        }
    }

    static enum PathTableModelGroupType {
        STEP,
        TIME,
        VARIABLES,
        OBSERVABLES,
        REWARDS,
        STRATEGY;

    }

    class PathTableModelColumn {
        public GUISimulatorPathTableModelColumn type;
        public Object info;

        public PathTableModelColumn(GUISimulatorPathTableModelColumn gUISimulatorPathTableModelColumn, Object object) {
            this.type = gUISimulatorPathTableModelColumn;
            this.info = object;
        }
    }

    static enum GUISimulatorPathTableModelColumn {
        ACTION,
        STEP,
        TIME_CUMUL,
        TIME,
        VARIABLE,
        OBSERVABLE,
        REWARD,
        MEMORY;

    }
}

