/*
 * Decompiled with CFR 0.152.
 */
package symbolic.model;

import io.ModelExportOptions;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Vector;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import parser.VarList;
import prism.ModelType;
import prism.PlayerInfo;
import prism.PlayerInfoOwner;
import prism.PrismException;
import prism.PrismNotSupportedException;
import symbolic.model.ModelVariablesDD;
import symbolic.model.NondetModel;

public class GamesModel
extends NondetModel
implements PlayerInfoOwner {
    private JDDVars allDDPlayerVars;
    private JDDNode[] ddPlayerCubes;
    protected PlayerInfo playerInfo;

    public GamesModel(JDDNode jDDNode, JDDNode jDDNode2, JDDVars jDDVars, JDDVars jDDVars2, JDDVars jDDVars3, ModelVariablesDD modelVariablesDD, VarList varList, JDDVars[] jDDVarsArray, JDDVars[] jDDVarsArray2, JDDVars jDDVars4, JDDNode[] jDDNodeArray, PlayerInfo playerInfo) {
        super(jDDNode, jDDNode2, jDDVars, jDDVars2, jDDVars3, modelVariablesDD, varList, jDDVarsArray, jDDVarsArray2);
        this.allDDPlayerVars = jDDVars4;
        this.ddPlayerCubes = jDDNodeArray;
        this.playerInfo = playerInfo;
    }

    @Override
    public ModelType getModelType() {
        return ModelType.SMG;
    }

    @Override
    public void clear() {
        super.clear();
        this.allDDPlayerVars.derefAll();
        JDD.DerefArray(this.ddPlayerCubes, this.getNumPlayers());
    }

    @Override
    public void exportToFile(int n, boolean bl, File file, int n2) throws FileNotFoundException, PrismException {
        throw new PrismNotSupportedException("Symbolic engine does not support export of " + String.valueOf((Object)this.getModelType()) + "s");
    }

    @Override
    public void exportToFile(File file, ModelExportOptions modelExportOptions) throws FileNotFoundException, PrismException {
        throw new PrismNotSupportedException("Symbolic engine does not support export of " + String.valueOf((Object)this.getModelType()) + "s");
    }

    @Override
    public PlayerInfo getPlayerInfo() {
        return this.playerInfo;
    }

    public JDDVars getAllDDPlayerVars() {
        return this.allDDPlayerVars;
    }

    public JDDNode getDdPlayerCube(int n) {
        return this.ddPlayerCubes[n];
    }

    public NondetModel toMDP() throws PrismException {
        JDDNode jDDNode = JDD.SumAbstract(this.trans.copy(), this.allDDPlayerVars);
        JDDNode[] jDDNodeArray = new JDDNode[this.transRewards.length];
        for (int i = 0; i < this.transRewards.length; ++i) {
            jDDNodeArray[i] = JDD.SumAbstract(this.transRewards[i], this.allDDPlayerVars);
        }
        JDDVars jDDVars = this.allDDNondetVars.copy();
        jDDVars.removeVars(this.allDDPlayerVars);
        NondetModel nondetModel = new NondetModel(jDDNode, this.start, this.allDDRowVars, this.allDDColVars, jDDVars, this.modelVariables, this.varList, this.varDDRowVars, this.varDDColVars);
        nondetModel.setRewards(this.stateRewards, jDDNodeArray, this.rewardStructNames);
        nondetModel.setSynchs((Vector)this.synchs);
        nondetModel.setTransInd(this.transInd);
        nondetModel.setTransSynch(this.transSynch);
        nondetModel.setTransActions(this.transActions);
        nondetModel.doReachability();
        nondetModel.filterReachableStates();
        return nondetModel;
    }
}

