/*
 * Decompiled with CFR 0.152.
 */
package simulator.method;

import cern.jet.stat.Probability;
import prism.PrismException;
import simulator.method.CIMethod;
import simulator.method.SimulationMethod;
import simulator.sampler.Sampler;

public final class ACIiterations
extends CIMethod {
    private int reqIterToConclude;
    private boolean reqIterToConcludeGiven;
    private double maxReward;
    private int computedIterations;
    private double squaredQuantile;

    public ACIiterations(double d, double d2) {
        this.confidence = d;
        this.width = d2;
        this.reqIterToConclude = 0;
        this.reqIterToConcludeGiven = false;
        this.maxReward = 1.0;
        this.computedIterations = 0;
        this.squaredQuantile = 0.0;
    }

    public ACIiterations(double d, double d2, int n) {
        this.confidence = d;
        this.width = d2;
        this.reqIterToConclude = n;
        this.reqIterToConcludeGiven = true;
        this.maxReward = 1.0;
        this.computedIterations = 0;
        this.squaredQuantile = 0.0;
    }

    public ACIiterations(double d, double d2, double d3) {
        this.confidence = d;
        this.width = d2;
        this.maxReward = d3;
        this.reqIterToConclude = 0;
        this.reqIterToConcludeGiven = false;
        this.computedIterations = 0;
        this.squaredQuantile = 0.0;
    }

    @Override
    public String getName() {
        return "ACI";
    }

    @Override
    public String getFullName() {
        return "Asymptotic Confidence Interval";
    }

    @Override
    public void computeMissingParameterAfterSim() {
        this.numSamples = this.computedIterations;
        this.missingParameterComputed = true;
    }

    @Override
    public Object getMissingParameter() throws PrismException {
        if (!this.missingParameterComputed) {
            throw new PrismException("Missing parameter not computed yet");
        }
        return this.numSamples;
    }

    @Override
    public String getParametersString() {
        if (!this.missingParameterComputed) {
            return "width=" + this.width + ", confidence=" + this.confidence + ", number of samples=unknown";
        }
        return "width=" + this.width + ", confidence=" + this.confidence + ", number of samples=" + this.numSamples;
    }

    @Override
    public boolean shouldStopNow(int n, Sampler sampler) {
        double d = 0.0;
        if (n < 2) {
            return false;
        }
        if (sampler.getVariance() <= 0.0) {
            if (!this.reqIterToConcludeGiven && this.maxReward / this.width > (double)n) {
                return false;
            }
            if (this.reqIterToConcludeGiven && this.reqIterToConclude > n) {
                return false;
            }
        }
        d = Probability.normalInverse((double)(1.0 - this.confidence / 2.0));
        this.squaredQuantile = d * d;
        if (sampler.getVariance() > 0.0 && (double)(n + 1) < sampler.getVariance() * this.squaredQuantile / (this.width * this.width)) {
            return false;
        }
        this.computedIterations = n;
        return true;
    }

    @Override
    public int getProgress(int n, Sampler sampler) {
        if (sampler.getVariance() <= 0.0 || n < 2) {
            return 0;
        }
        return 10 * ((int)(100.0 * (double)(n + 1) * this.width * this.width / (sampler.getVariance() * this.squaredQuantile)) / 10);
    }

    @Override
    public SimulationMethod clone() {
        ACIiterations aCIiterations = new ACIiterations(this.confidence, this.width);
        aCIiterations.numSamples = this.numSamples;
        aCIiterations.missingParameterComputed = this.missingParameterComputed;
        aCIiterations.prOp = this.prOp;
        aCIiterations.theta = this.theta;
        aCIiterations.reqIterToConclude = this.reqIterToConclude;
        aCIiterations.reqIterToConcludeGiven = this.reqIterToConcludeGiven;
        aCIiterations.maxReward = this.maxReward;
        aCIiterations.computedIterations = this.computedIterations;
        aCIiterations.squaredQuantile = this.squaredQuantile;
        return aCIiterations;
    }
}

