/*
 * Decompiled with CFR 0.152.
 */
package pta;

import explicit.IndexedSet;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Vector;
import parser.State;
import parser.Values;
import parser.VarList;
import parser.ast.Expression;
import parser.type.TypeClock;
import prism.ModelGenerator;
import prism.ModelType;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismLangException;
import prism.ProgressDisplay;
import pta.Constraint;
import pta.Edge;
import pta.PTA;
import pta.PTAUtils;
import pta.Transition;

public class ConstructPTA
extends PrismComponent {
    public ConstructPTA(PrismComponent prismComponent) throws PrismException {
        super(prismComponent);
    }

    public PTA constructPTA(ModelGenerator<Double> modelGenerator) throws PrismException {
        if (modelGenerator.getModelType() != ModelType.PTA) {
            throw new PrismLangException("Model is not a PTA");
        }
        if (!modelGenerator.hasSingleInitialState()) {
            throw new PrismLangException("Cannot construct PTA models with multiple initial states");
        }
        Values values = modelGenerator.getConstantValues();
        VarList varList = modelGenerator.createVarList();
        this.mainLog.print("\nComputing reachable locations of " + String.valueOf((Object)modelGenerator.getModelType()) + "...");
        this.mainLog.flush();
        ProgressDisplay progressDisplay = new ProgressDisplay(this.mainLog);
        progressDisplay.start();
        long l = System.currentTimeMillis();
        int n = varList.getNumVars();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            if (varList.getType(i) instanceof TypeClock) {
                arrayList.add(varList.getName(i));
            }
            arrayList2.add(varList.getName(i));
        }
        PTA pTA = new PTA(new ArrayList<String>(new Vector()));
        for (String object2 : arrayList) {
            pTA.addClock(object2);
        }
        IndexedSet indexedSet = new IndexedSet(true);
        LinkedList<State> linkedList = new LinkedList<State>();
        for (State state : modelGenerator.getInitialStates()) {
            for (String n3 : arrayList) {
                state.varValues[varList.getIndex((String)n3)] = null;
            }
            linkedList.add(state);
            indexedSet.add(state);
            pTA.addLocation(state);
        }
        int n2 = -1;
        while (!linkedList.isEmpty()) {
            int n3;
            State state;
            state = (State)linkedList.removeFirst();
            ++n2;
            modelGenerator.exploreState(state);
            Expression expression = modelGenerator.getClockInvariant();
            if (expression != null) {
                n3 = n2;
                PTAUtils.exprConjToConstraintConsumer(expression, values, pTA, constraint -> pTA.addInvariantCondition(n3, (Constraint)constraint));
            }
            n3 = modelGenerator.getNumChoices();
            for (int i = 0; i < n3; ++i) {
                Transition transition = pTA.addTransition(n2, modelGenerator.getChoiceActionString(i));
                PTAUtils.exprConjToConstraintConsumer(modelGenerator.getChoiceClockGuard(i), values, pTA, constraint -> transition.addGuardConstraint((Constraint)constraint));
                int n4 = modelGenerator.getNumTransitions(i);
                for (int j = 0; j < n4; ++j) {
                    Edge edge = transition.addEdge(modelGenerator.getTransitionProbability(i, j), -1);
                    State state2 = modelGenerator.computeTransitionTarget(i, j);
                    for (String string : arrayList) {
                        int n5 = varList.getIndex(string);
                        Object object = state2.varValues[n5];
                        if (object == null) continue;
                        int n6 = (int)Math.round((Double)object);
                        edge.addReset(pTA.getClockIndex(string), n6);
                        state2.varValues[n5] = null;
                    }
                    if (indexedSet.add(state2)) {
                        linkedList.add(state2);
                        pTA.addLocation(state2);
                    }
                    int n7 = indexedSet.getIndexOfLastAdd();
                    edge.setDestination(n7);
                }
            }
            progressDisplay.updateIfReady(n2 + 1);
        }
        progressDisplay.update(n2 + 1);
        progressDisplay.end(" locations");
        this.mainLog.print("Reachable locations exploration and model construction");
        this.mainLog.println(" done in " + (double)(System.currentTimeMillis() - l) / 1000.0 + " secs.");
        pTA.setLocationNameVars(arrayList2);
        return pTA;
    }
}

