/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import prism.PrismException;
import prism.PrismLog;
import prism.PrismPrintStreamLog;
import prism.Reactions2Prism;

public class SBML2Prism
extends Reactions2Prism
implements EntityResolver {
    protected String parsedFileName;
    protected Document parsedSBML;

    public SBML2Prism() {
    }

    public SBML2Prism(PrismLog prismLog) {
        super(prismLog);
    }

    @Override
    public String getName() {
        return "sbml";
    }

    @Override
    public void load(File file) throws PrismException {
        this.parsedFileName = file.getPath();
        super.load(file);
    }

    @Override
    public void load(InputStream inputStream) throws PrismException {
        DocumentBuilder documentBuilder;
        this.parsedSBML = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(this);
            documentBuilder.setErrorHandler(new ErrorHandler(){

                @Override
                public void fatalError(SAXParseException sAXParseException) throws SAXException {
                    throw sAXParseException;
                }

                @Override
                public void error(SAXParseException sAXParseException) throws SAXException {
                    throw sAXParseException;
                }

                @Override
                public void warning(SAXParseException sAXParseException) {
                }
            });
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new PrismException("Couldn't create XML parser");
        }
        try {
            this.parsedSBML = documentBuilder.parse(inputStream);
        }
        catch (IOException iOException) {
            throw new PrismException("Error reading SBML: " + iOException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new PrismException("Invalid XML file:\n" + sAXException.getMessage());
        }
    }

    @Override
    public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
        InputStream inputStream;
        InputSource inputSource = null;
        if (string2.endsWith("dtd") && (inputStream = this.getClass().getResourceAsStream("dtds/sbml.dtd")) != null) {
            inputSource = new InputSource(inputStream);
        }
        return inputSource;
    }

    @Override
    public void translate(PrintStream printStream) throws PrismException {
        this.checkSBMLVersion(this.parsedSBML);
        this.extractModelFromSBML(this.parsedSBML);
        this.prismCodeHeader = "// File generated by automatic SBML-to-PRISM conversion\n";
        if (this.parsedFileName != null) {
            this.prismCodeHeader = this.prismCodeHeader + "// Original SBML file: " + this.parsedFileName + "\n\n";
        }
        this.convertToPRISMCode(printStream);
        this.parsedFileName = null;
    }

    private void checkSBMLVersion(Document document) throws PrismException {
        String string = document.getDocumentElement().getAttribute("level");
        if (!"2".equals(string)) {
            String string2 = "The translator only handles Level 2 SBML files - this is a Level " + string + " file";
            throw new PrismException(string2);
        }
    }

    private void extractModelFromSBML(Document document) throws PrismException {
        String string;
        int n;
        Element element;
        Node node = null;
        NodeList nodeList = document.getDocumentElement().getElementsByTagName("model");
        Element element2 = (Element)nodeList.item(0);
        Element element3 = (Element)element2.getElementsByTagName("listOfCompartments").item(0);
        int n2 = (nodeList = element3.getElementsByTagName("compartment")).getLength();
        if (n2 > 1) {
            throw new PrismException("Only one compartment is permitted");
        }
        this.compartmentName = null;
        if (n2 == 1 && !"".equals((element = (Element)nodeList.item(0)).getAttribute("size"))) {
            this.compartmentName = element.getAttribute("id");
            if ("".equals(this.compartmentName)) {
                throw new PrismException("Missing compartment name");
            }
            this.compartmentSize = Double.parseDouble(element.getAttribute("size"));
        }
        this.speciesList = new ArrayList();
        element3 = (Element)element2.getElementsByTagName("listOfSpecies").item(0);
        nodeList = element3.getElementsByTagName("species");
        n2 = nodeList.getLength();
        for (n = 0; n < n2; ++n) {
            double d;
            Element element4 = (Element)nodeList.item(n);
            this.speciesId = element4.getAttribute("id");
            this.initialAmountString = element4.getAttribute("initialAmount");
            if ("".equals(this.initialAmountString)) {
                throw new PrismException("Missing initial amount for species " + this.speciesId);
            }
            try {
                d = Double.parseDouble(this.initialAmountString);
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = "Badly formatted initialAmount \"" + this.initialAmountString + "\" for species " + this.speciesId;
                throw new PrismException(string2);
            }
            Reactions2Prism.Species species = new Reactions2Prism.Species(this.speciesId, element4.getAttribute("name"), d);
            string = element4.getAttribute("boundaryCondition");
            if (string.equals("true")) {
                species.boundaryCondition = true;
            }
            this.speciesList.add(species);
        }
        this.parameterList = new ArrayList();
        nodeList = element2.getChildNodes();
        n2 = nodeList.getLength();
        boolean bl = false;
        for (n = 0; n < n2; ++n) {
            node = nodeList.item(n);
            if (!"listOfParameters".equals(node.getNodeName())) continue;
            bl = true;
            break;
        }
        if (bl) {
            element3 = (Element)node;
            nodeList = element3.getElementsByTagName("parameter");
            n2 = nodeList.getLength();
            for (n = 0; n < n2; ++n) {
                Element element5 = (Element)nodeList.item(n);
                Reactions2Prism.Parameter parameter = new Reactions2Prism.Parameter(element5.getAttribute("id"), element5.getAttribute("value"));
                this.parameterList.add(parameter);
            }
        }
        this.reactionList = new ArrayList();
        element3 = (Element)element2.getElementsByTagName("listOfReactions").item(0);
        nodeList = element3.getElementsByTagName("reaction");
        n2 = nodeList.getLength();
        for (n = 0; n < n2; ++n) {
            int n3;
            String string3;
            Element element6;
            int n4;
            int n5;
            NodeList nodeList2;
            Element element7 = (Element)nodeList.item(n);
            Reactions2Prism.Reaction reaction = new Reactions2Prism.Reaction(element7.getAttribute("id"), element7.getAttribute("name"));
            element3 = (Element)element7.getElementsByTagName("listOfReactants").item(0);
            if (element3 != null) {
                nodeList2 = element3.getElementsByTagName("speciesReference");
                n5 = nodeList2.getLength();
                for (n4 = 0; n4 < n5; ++n4) {
                    element6 = (Element)nodeList2.item(n4);
                    string = element6.getAttribute("species");
                    string3 = element6.getAttribute("stoichiometry");
                    n3 = 1;
                    if (string3.length() > 0) {
                        try {
                            n3 = Integer.parseInt(string3);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new PrismException("Invalid stoichiometry value \"" + string3 + "\"");
                        }
                    }
                    reaction.addReactant(string, n3);
                }
            }
            if ((element3 = (Element)element7.getElementsByTagName("listOfProducts").item(0)) != null) {
                nodeList2 = element3.getElementsByTagName("speciesReference");
                n5 = nodeList2.getLength();
                for (n4 = 0; n4 < n5; ++n4) {
                    element6 = (Element)nodeList2.item(n4);
                    string = element6.getAttribute("species");
                    string3 = element6.getAttribute("stoichiometry");
                    n3 = 1;
                    if (string3.length() > 0) {
                        try {
                            n3 = Integer.parseInt(string3);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new PrismException("Invalid stoichiometry value \"" + string3 + "\"");
                        }
                    }
                    reaction.addProduct(string, n3);
                }
            }
            Element element8 = (Element)element7.getElementsByTagName("kineticLaw").item(0);
            Element element9 = (Element)element8.getElementsByTagName("math").item(0);
            reaction.setKineticLaw(element9);
            element3 = (Element)element8.getElementsByTagName("listOfParameters").item(0);
            if (element3 != null) {
                nodeList2 = element3.getElementsByTagName("parameter");
                n5 = nodeList2.getLength();
                for (n4 = 0; n4 < n5; ++n4) {
                    element6 = (Element)nodeList2.item(n4);
                    reaction.addParameter(element6.getAttribute("id"), element6.getAttribute("value"));
                }
            }
            this.reactionList.add(reaction);
        }
    }

    public static void main(String[] stringArray) {
        PrismPrintStreamLog prismPrintStreamLog = new PrismPrintStreamLog(System.err);
        try {
            if (stringArray.length < 1) {
                System.err.println("Usage: sbml2prism <sbml_file> [max_amount]");
                System.exit(1);
            }
            SBML2Prism sBML2Prism = new SBML2Prism(prismPrintStreamLog);
            try {
                if (stringArray.length > 1) {
                    sBML2Prism.setMaxAmount(Integer.parseInt(stringArray[1]));
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Invalid max amount \"" + stringArray[1] + "\"");
            }
            sBML2Prism.load(new File(stringArray[0]));
            sBML2Prism.translate(System.out);
        }
        catch (PrismException prismException) {
            prismPrintStreamLog.println("Error: " + prismException.getMessage() + ".");
        }
    }
}

