/*
 * Decompiled with CFR 0.152.
 */
package prism;

import prism.PrismException;
import prism.PrismLog;
import prism.PrismNative;

public class PrismFileLog
extends PrismLog {
    protected String filename;
    protected long fp;
    protected boolean stdout;

    public PrismFileLog() {
        this.filename = "";
        this.fp = 0L;
    }

    public PrismFileLog(String string) {
        this.open(string);
    }

    public PrismFileLog(String string, boolean bl) {
        this.open(string, bl);
    }

    public static PrismFileLog create(String string) throws PrismException {
        return PrismFileLog.create(string, false);
    }

    public static PrismFileLog create(String string, boolean bl) throws PrismException {
        PrismFileLog prismFileLog = new PrismFileLog(string, bl);
        if (!prismFileLog.ready()) {
            throw new PrismException("Could not open file \"" + string + "\" for output");
        }
        return prismFileLog;
    }

    public void open(String string) {
        this.open(string, false);
    }

    public void open(String string, boolean bl) {
        this.filename = string;
        if (string.equals("stdout")) {
            this.fp = PrismNative.PN_GetStdout();
            this.stdout = true;
        } else {
            this.fp = bl ? PrismNative.PN_OpenFileAppend(string) : PrismNative.PN_OpenFile(string);
            this.stdout = false;
        }
    }

    @Override
    public boolean ready() {
        return this.fp != 0L;
    }

    @Override
    public long getFilePointer() {
        return this.fp;
    }

    public String getFileName() {
        return this.stdout ? "stdout" : this.filename;
    }

    @Override
    public void flush() {
        if (this.fp == 0L) {
            throw new IllegalStateException("Trying to flush an invalid file handle (already closed?)");
        }
        PrismNative.PN_FlushFile(this.fp);
    }

    @Override
    public void close() {
        if (this.fp == 0L) {
            return;
        }
        if (this.stdout) {
            return;
        }
        PrismNative.PN_CloseFile(this.fp);
        this.fp = 0L;
    }

    @Override
    public void print(boolean bl) {
        this.printToLog("" + bl);
    }

    @Override
    public void print(char c) {
        this.printToLog("" + c);
    }

    @Override
    public void print(double d) {
        this.printToLog("" + d);
    }

    @Override
    public void print(float f) {
        this.printToLog("" + f);
    }

    @Override
    public void print(int n) {
        this.printToLog("" + n);
    }

    @Override
    public void print(long l) {
        this.printToLog("" + l);
    }

    @Override
    public void print(Object object) {
        this.printToLog(String.valueOf(object));
    }

    @Override
    public void print(String string) {
        this.printToLog(string);
    }

    @Override
    public void println() {
        this.printToLog("\n");
    }

    private void printToLog(String string) {
        if (this.fp == 0L) {
            throw new IllegalStateException("Trying to write to an invalid file handle (already closed?)");
        }
        PrismNative.PN_PrintToFile(this.fp, string);
    }
}

