/*
 * Decompiled with CFR 0.152.
 */
package prism;

public class NativeIntArray {
    private long ptr;
    private int size;

    private static native long NIA_CreateArray(int var0);

    private static native void NIA_DeleteArray(long var0);

    private static native int NIA_Get(long var0, int var2);

    private static native void NIA_Set(long var0, int var2, int var3);

    private static native void NIA_SetAll(long var0, int var2, int var3, int var4);

    public NativeIntArray(int n) {
        this.size = n;
        this.ptr = NativeIntArray.NIA_CreateArray(n);
    }

    public long getPtr() {
        return this.ptr;
    }

    public void clear() {
        NativeIntArray.NIA_DeleteArray(this.ptr);
    }

    public int get(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return NativeIntArray.NIA_Get(this.ptr, n);
    }

    public void set(int n, int n2) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        NativeIntArray.NIA_Set(this.ptr, n, n2);
    }

    public void setAllTo(int n) {
        NativeIntArray.NIA_SetAll(this.ptr, 0, this.size, n);
    }

    public int size() {
        return this.size;
    }

    static {
        try {
            System.loadLibrary("prism");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.out.println(unsatisfiedLinkError);
            System.exit(1);
        }
    }
}

