/*
 * Decompiled with CFR 0.152.
 */
package parser;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import parser.Values;
import prism.ModelInfo;
import prism.PrismLangException;

public class State
implements Comparable<State>,
Serializable {
    public Object[] varValues;

    public State(int n) {
        this.varValues = new Object[n];
    }

    public State(State state) {
        this(state.varValues.length);
        this.copy(state);
    }

    public State(State state, State state2) {
        int n;
        Object[] objectArray = state.varValues;
        Object[] objectArray2 = state2.varValues;
        this.varValues = new Object[objectArray.length + objectArray2.length];
        for (n = 0; n < objectArray.length; ++n) {
            this.varValues[n] = objectArray[n];
        }
        for (n = 0; n < objectArray2.length; ++n) {
            this.varValues[objectArray.length + n] = objectArray2[n];
        }
    }

    public State(Values values, ModelInfo modelInfo) throws PrismLangException {
        this(values, modelInfo, true);
    }

    public State(Values values, ModelInfo modelInfo, boolean bl) throws PrismLangException {
        int n;
        int n2 = values.getNumValues();
        if (bl && n2 != modelInfo.getNumVars()) {
            throw new PrismLangException("Wrong number of variables in state");
        }
        this.varValues = new Object[n2];
        for (n = 0; n < n2; ++n) {
            this.varValues[n] = null;
        }
        for (n = 0; n < n2; ++n) {
            int n3 = modelInfo.getVarIndex(values.getName(n));
            if (n3 == -1) {
                throw new PrismLangException("Unknown variable " + values.getName(n) + " in state");
            }
            if (this.varValues[n] != null) {
                throw new PrismLangException("Duplicated variable " + values.getName(n) + " in state");
            }
            this.varValues[n] = values.getValue(n);
        }
    }

    public void clear() {
        int n = this.varValues.length;
        for (int i = 0; i < n; ++i) {
            this.varValues[i] = null;
        }
    }

    public void intersect(State state) {
        int n = this.varValues.length;
        for (int i = 0; i < n; ++i) {
            if (this.varValues[i] != null && this.varValues[i].equals(state.varValues[i])) continue;
            this.varValues[i] = null;
        }
    }

    public State setValue(int n, Object object) {
        this.varValues[n] = object;
        return this;
    }

    public void copy(State state) {
        int n = this.varValues.length;
        for (int i = 0; i < n; ++i) {
            this.varValues[i] = state.varValues[i];
        }
    }

    public int hashCode() {
        return Arrays.hashCode(this.varValues);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof State)) {
            return false;
        }
        State state = (State)object;
        int n = this.varValues.length;
        if (n != state.varValues.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.varValues[i].equals(state.varValues[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(State state) {
        return this.compareTo(state, 0);
    }

    public int compareTo(State state, int n) {
        int n2;
        int n3;
        if (state == null) {
            throw new NullPointerException();
        }
        Object[] objectArray = state.varValues;
        int n4 = this.varValues.length;
        if (this.varValues.length != objectArray.length) {
            throw new ClassCastException("States are of different size");
        }
        if (n4 > objectArray.length) {
            throw new ClassCastException("States do not contain enough values");
        }
        if (n > n4 - 1) {
            throw new ClassCastException("Variable index is incorrect");
        }
        for (n3 = n; n3 < n4; ++n3) {
            n2 = State.compareObjects(this.varValues[n3], objectArray[n3]);
            if (n2 == 0) continue;
            return n2;
        }
        for (n3 = 0; n3 < n; ++n3) {
            n2 = State.compareObjects(this.varValues[n3], objectArray[n3]);
            if (n2 == 0) continue;
            return n2;
        }
        return 0;
    }

    public String toString() {
        Object object = "(";
        int n = this.varValues.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                object = (String)object + ",";
            }
            object = (String)object + State.valueToString(this.varValues[i]);
        }
        object = (String)object + ")";
        return object;
    }

    public String toStringNoParentheses() {
        Object object = "";
        int n = this.varValues.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                object = (String)object + ",";
            }
            object = (String)object + State.valueToString(this.varValues[i]);
        }
        return object;
    }

    public String toString(List<String> list) {
        Object object = "(";
        int n = this.varValues.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                object = (String)object + ",";
            }
            object = (String)object + list.get(i) + "=" + State.valueToString(this.varValues[i]);
        }
        object = (String)object + ")";
        return object;
    }

    public String toString(ModelInfo modelInfo) {
        Object object = "(";
        int n = this.varValues.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                object = (String)object + ",";
            }
            object = (String)object + modelInfo.getVarName(i) + "=" + State.valueToString(this.varValues[i]);
        }
        object = (String)object + ")";
        return object;
    }

    public static String valueToString(Object object) {
        if (object == null) {
            return "?";
        }
        if (object instanceof List) {
            return "[" + ((List)object).stream().map(State::valueToString).collect(Collectors.joining(",")) + "]";
        }
        return object.toString();
    }

    public static int compareObjects(Object object, Object object2) {
        if (object == null) {
            return object2 == null ? 0 : -1;
        }
        if (object2 == null) {
            return 1;
        }
        if (object instanceof Comparable && object2 instanceof Comparable && object.getClass().equals(object2.getClass())) {
            return ((Comparable)object).compareTo((Comparable)object2);
        }
        if (object instanceof List && object2 instanceof List) {
            List list = (List)object;
            List list2 = (List)object2;
            int n = list.size();
            if (list2.size() != n) {
                throw new ClassCastException("Can't compare " + String.valueOf(object) + " and " + String.valueOf(object2) + " since their sizes differ");
            }
            for (int i = 0; i < n; ++i) {
                int n2 = State.compareObjects(list.get(i), list2.get(i));
                if (n2 == 0) continue;
                return n2;
            }
            return 0;
        }
        throw new ClassCastException("Can't compare " + String.valueOf(object.getClass()) + " and " + String.valueOf(object2.getClass()));
    }
}

