/*
 * Decompiled with CFR 0.152.
 */
package parser;

import parser.EvaluateContextConstants;
import parser.Values;

public abstract class EvaluateContext {
    protected EvalMode evalMode = EvalMode.FP;
    protected Values constantValues = null;

    public EvaluateContext setEvaluationMode(EvalMode evalMode) {
        this.evalMode = evalMode;
        return this;
    }

    public EvalMode getEvaluationMode() {
        return this.evalMode;
    }

    public EvaluateContext setConstantValues(Values values) {
        this.constantValues = values;
        return this;
    }

    public EvaluateContext addConstantValues(Values values) {
        this.constantValues = new Values(this.constantValues, values);
        return this;
    }

    public Values getConstantValues() {
        return this.constantValues;
    }

    public EvaluateContext copyFrom(EvaluateContext evaluateContext) {
        this.evalMode = evaluateContext.evalMode;
        this.constantValues = evaluateContext.constantValues == null ? null : new Values(evaluateContext.constantValues);
        return this;
    }

    public Object getConstantValue(String string) {
        if (this.constantValues == null) {
            return null;
        }
        int n = this.constantValues.getIndexOf(string);
        if (n == -1) {
            return null;
        }
        return this.constantValues.getValue(n);
    }

    public abstract Object getVarValue(String var1, int var2);

    public Object getPrimedVarValue(String string, int n) {
        return null;
    }

    public Object getObservableValue(String string, int n) {
        return null;
    }

    public static EvaluateContext create() {
        return new EvaluateContextConstants(null);
    }

    public static EvaluateContext create(EvalMode evalMode) {
        return new EvaluateContextConstants(null).setEvaluationMode(evalMode);
    }

    public static EvaluateContext create(Values values) {
        return new EvaluateContextConstants(values);
    }

    public static EvaluateContext create(Values values, EvalMode evalMode) {
        return new EvaluateContextConstants(values).setEvaluationMode(evalMode);
    }

    public static EvaluateContext create(Values values, boolean bl) {
        return new EvaluateContextConstants(values).setEvaluationMode(bl ? EvalMode.EXACT : EvalMode.FP);
    }

    public static EvaluateContext create(EvaluateContext evaluateContext) {
        return EvaluateContext.create().copyFrom(evaluateContext);
    }

    public static enum EvalMode {
        FP,
        EXACT;

    }
}

