/*
 * Decompiled with CFR 0.152.
 */
package param;

import param.BigRational;

public final class Point {
    private BigRational[] dimensions;

    public Point(BigRational[] bigRationalArray) {
        this.dimensions = new BigRational[bigRationalArray.length];
        System.arraycopy(bigRationalArray, 0, this.dimensions, 0, bigRationalArray.length);
    }

    public BigRational getDimension(int n) {
        return this.dimensions[n];
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        for (int i = 0; i < this.dimensions.length; ++i) {
            stringBuilder.append(this.dimensions[i].doubleValue());
            if (i == this.dimensions.length - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public BigRational[] toArray() {
        BigRational[] bigRationalArray = new BigRational[this.dimensions.length];
        System.arraycopy(this.dimensions, 0, bigRationalArray, 0, this.dimensions.length);
        return bigRationalArray;
    }

    public int size() {
        return this.dimensions.length;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Point)) {
            return false;
        }
        Point point = (Point)object;
        if (this.dimensions.length != point.dimensions.length) {
            return false;
        }
        for (int i = 0; i < this.dimensions.length; ++i) {
            if (this.dimensions[i].equals(point.dimensions[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.dimensions.length; ++i) {
            n = this.dimensions[i].hashCode() + (n << 6) + (n << 16) - n;
        }
        return n;
    }

    double[] doubleValues() {
        double[] dArray = new double[this.dimensions.length];
        for (int i = 0; i < this.dimensions.length; ++i) {
            dArray[i] = this.dimensions[i].doubleValue();
        }
        return dArray;
    }
}

