/*
 * Decompiled with CFR 0.152.
 */
package io;

import common.Interval;
import explicit.DTMC;
import explicit.IDTMC;
import explicit.IntervalModel;
import explicit.LTS;
import explicit.MDP;
import explicit.Model;
import explicit.NondetModel;
import explicit.rewards.Rewards;
import io.ModelExportOptions;
import io.RewardTuple;
import io.Transition;
import java.io.File;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import prism.Evaluator;
import prism.ModelInfo;
import prism.Pair;
import prism.PrismException;
import prism.PrismFileLog;
import prism.PrismLog;

public abstract class ModelExporter<Value> {
    protected Evaluator<Value> eval = Evaluator.forDouble();
    protected ModelExportOptions modelExportOptions;
    protected List<Rewards<Value>> rewards = new ArrayList<Rewards<Value>>();
    protected List<String> rewardNames = new ArrayList<String>();
    protected Evaluator<Value> evalRewards = null;
    protected List<BitSet> labels = new ArrayList<BitSet>();
    protected List<String> labelNames = new ArrayList<String>();
    protected ModelInfo modelInfo;

    public ModelExporter() {
        this(new ModelExportOptions());
    }

    public ModelExporter(ModelExportOptions modelExportOptions) {
        this.setModelExportOptions(modelExportOptions);
    }

    public void setEvaluator(Evaluator<Value> evaluator) {
        this.eval = evaluator;
    }

    public void setModelExportOptions(ModelExportOptions modelExportOptions) {
        this.modelExportOptions = modelExportOptions;
    }

    public void addReward(Rewards<Value> rewards) {
        this.addReward(rewards, "");
    }

    public void addReward(Rewards<Value> rewards, String string) {
        this.rewards.add(rewards);
        this.rewardNames.add(string == null ? "" : string);
    }

    public void addRewards(List<Rewards<Value>> list, List<String> list2) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            this.addReward(list.get(i), list2.get(i));
        }
    }

    public void setRewardEvaluator(Evaluator<Value> evaluator) {
        this.evalRewards = evaluator;
    }

    public void addLabel(BitSet bitSet, String string) {
        this.labels.add(bitSet);
        this.labelNames.add(string);
    }

    public void addLabels(List<BitSet> list, List<String> list2) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            this.addLabel(list.get(i), list2.get(i));
        }
    }

    public void setModelInfo(ModelInfo modelInfo) {
        this.modelInfo = modelInfo;
    }

    public Evaluator<Value> getEvaluator() {
        return this.eval;
    }

    public ModelExportOptions getModelExportOptions() {
        return this.modelExportOptions;
    }

    public int getNumRewards() {
        return this.rewards.size();
    }

    public List<Rewards<Value>> getRewards() {
        return this.rewards;
    }

    public Rewards<Value> getReward(int n) {
        return this.rewards.get(n);
    }

    public List<String> getRewardNames() {
        return this.rewardNames;
    }

    public String getRewardName(int n) {
        return this.rewardNames.get(n);
    }

    public Evaluator<Value> getRewardEvaluator() {
        return this.evalRewards == null ? this.getEvaluator() : this.evalRewards;
    }

    public int getNumLabels() {
        return this.labels.size();
    }

    public List<BitSet> getLabels() {
        return this.labels;
    }

    public BitSet getLabel(int n) {
        return this.labels.get(n);
    }

    public List<String> getLabelNames() {
        return this.labelNames;
    }

    public String getLabelName(int n) {
        return this.labelNames.get(n);
    }

    public ModelInfo getModelInfo() {
        return this.modelInfo;
    }

    public abstract void exportModel(Model<Value> var1, PrismLog var2) throws PrismException;

    public void exportModel(Model<Value> model, File file) throws PrismException {
        try (PrismFileLog prismFileLog = new PrismFileLog(file.getPath());){
            this.exportModel(model, prismFileLog);
        }
    }

    public String formatValue(Value Value2, Evaluator<Value> evaluator) {
        return evaluator.toStringExport(Value2, this.modelExportOptions.getModelPrecision());
    }

    public String formatValue(Value Value2) {
        return this.eval.toStringExport(Value2, this.modelExportOptions.getModelPrecision());
    }

    public <ValueM> Iterable<Transition<Object>> getSortedTransitionsIterator(Model<ValueM> model, int n, int n2, boolean bl) throws PrismException {
        TreeSet<Transition<Object>> treeSet = new TreeSet<Transition<Object>>(Transition::compareTo);
        Object object = null;
        if (model.getModelType().nondeterministic() && bl) {
            object = ((NondetModel)model).getAction(n, n2);
        }
        if (!model.getModelType().uncertain()) {
            if (model instanceof DTMC) {
                Iterator iterator = ((DTMC)model).getTransitionsAndActionsIterator(n);
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (bl) {
                        object = entry.getValue().second;
                    }
                    treeSet.add(new Transition(entry.getKey(), entry.getValue().first, object, model.getEvaluator()));
                }
            } else if (model instanceof LTS) {
                int n3 = ((LTS)model).getSuccessor(n, n2);
                treeSet.add(new Transition<ValueM>(n3, model.getEvaluator().one(), object, model.getEvaluator()));
            } else {
                Iterator iterator = ((MDP)model).getTransitionsIterator(n, n2);
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    treeSet.add(new Transition(entry.getKey(), entry.getValue(), object, model.getEvaluator()));
                }
            }
        } else if (model instanceof IDTMC) {
            Iterator iterator = ((IDTMC)model).getIntervalTransitionsAndActionsIterator(n);
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (bl) {
                    object = entry.getValue().second;
                }
                treeSet.add(new Transition(entry.getKey(), (Interval)entry.getValue().first, object, ((IDTMC)model).getIntervalEvaluator()));
            }
        } else {
            Iterator iterator = ((MDP)((IntervalModel)model).getIntervalModel()).getTransitionsIterator(n, n2);
            Evaluator evaluator = ((IntervalModel)model).getIntervalEvaluator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                treeSet.add(new Transition(entry.getKey(), (Interval)entry.getValue(), object, evaluator));
            }
        }
        return treeSet;
    }

    public <ValueM> Iterable<Transition<Value>> getSortedTransitionRewardsIterator(DTMC<ValueM> dTMC, Rewards<Value> rewards, int n, boolean bl) {
        TreeSet<Transition<Value>> treeSet = new TreeSet<Transition<Value>>(Transition::compareTo);
        Object var6_6 = null;
        Iterator<Map.Entry<Integer, Pair<ValueM, Object>>> iterator = dTMC.getTransitionsAndActionsIterator(n);
        int n2 = 0;
        while (iterator.hasNext()) {
            Map.Entry<Integer, Pair<ValueM, Object>> entry = iterator.next();
            if (bl) {
                var6_6 = entry.getValue().second;
            }
            treeSet.add(new Transition<Value>(entry.getKey(), rewards.getTransitionReward(n, n2), var6_6, rewards.getEvaluator()));
            ++n2;
        }
        return treeSet;
    }

    protected RewardTuple<Value> getStateRewardTuple(List<Rewards<Value>> list, int n) {
        int n2 = list.size();
        RewardTuple<Value> rewardTuple = new RewardTuple<Value>(n2);
        for (Rewards<Value> rewards : list) {
            rewardTuple.add(rewards.getStateReward(n));
        }
        return rewardTuple;
    }

    protected RewardTuple<Value> getTransitionRewardTuple(List<Rewards<Value>> list, int n, int n2) {
        int n3 = list.size();
        RewardTuple<Value> rewardTuple = new RewardTuple<Value>(n3);
        for (Rewards<Value> rewards : list) {
            rewardTuple.add(rewards.getTransitionReward(n, n2));
        }
        return rewardTuple;
    }
}

