/*
 * Decompiled with CFR 0.152.
 */
package explicit.rewards;

import explicit.ListNestedSimple;
import explicit.ListSimple;
import explicit.Model;
import explicit.NondetModel;
import explicit.Product;
import explicit.rewards.Rewards;
import explicit.rewards.RewardsExplicit;
import java.util.function.Function;
import prism.Evaluator;

public class RewardsSimple<Value>
extends RewardsExplicit<Value> {
    protected int numStates;
    protected ListSimple<Value> stateRewards;
    protected ListNestedSimple<Value> transRewards;

    public RewardsSimple(int n) {
        this.numStates = n;
        this.stateRewards = new ListSimple<Object>(this.getEvaluator().zero(), this.getEvaluator()::isZero);
        this.transRewards = new ListNestedSimple<Object>(this.getEvaluator().zero(), this.getEvaluator()::isZero);
    }

    public RewardsSimple(RewardsSimple<Value> rewardsSimple) {
        this.numStates = rewardsSimple.numStates;
        this.stateRewards = new ListSimple<Value>(rewardsSimple.stateRewards);
        this.transRewards = new ListNestedSimple<Value>(rewardsSimple.transRewards);
        this.setEvaluator(rewardsSimple.getEvaluator());
    }

    public <T> RewardsSimple(Rewards<T> rewards, Model<?> model, Function<? super T, ? extends Value> function, Evaluator<Value> evaluator) {
        int n;
        this.numStates = model.getNumStates();
        this.stateRewards = new ListSimple<Object>(evaluator.zero(), evaluator::isZero);
        if (rewards.hasStateRewards()) {
            for (n = this.numStates - 1; n >= 0; --n) {
                this.stateRewards.setValue(n, function.apply(rewards.getStateReward(n)));
            }
        }
        this.transRewards = new ListNestedSimple<Object>(evaluator.zero(), evaluator::isZero);
        if (rewards.hasTransitionRewards()) {
            for (n = this.numStates - 1; n >= 0; --n) {
                int n2 = model.getModelType().nondeterministic() ? ((NondetModel)model).getNumChoices(n) : model.getNumTransitions(n);
                for (int i = n2; i >= 0; --i) {
                    this.transRewards.setValue(n, i, function.apply(rewards.getTransitionReward(n, i)));
                }
            }
        }
        this.setEvaluator(evaluator);
    }

    @Override
    public void setEvaluator(Evaluator<Value> evaluator) {
        super.setEvaluator(evaluator);
        this.stateRewards.setZero(this.getEvaluator().zero(), this.getEvaluator()::isZero);
        this.transRewards.setZero(this.getEvaluator().zero(), this.getEvaluator()::isZero);
    }

    @Override
    public void setStateReward(int n, Value Value2) {
        this.stateRewards.setValue(n, Value2);
    }

    @Override
    public void setTransitionReward(int n, int n2, Value Value2) {
        this.transRewards.setValue(n, n2, Value2);
    }

    public void clearRewards(int n) {
        this.setStateReward(n, this.getEvaluator().zero());
        this.transRewards.clear(n);
    }

    @Override
    public boolean hasStateRewards() {
        return !this.stateRewards.allZero();
    }

    @Override
    public boolean hasTransitionRewards() {
        return !this.transRewards.allZero();
    }

    @Override
    public Value getStateReward(int n) {
        return this.stateRewards.getValue(n);
    }

    @Override
    public Value getTransitionReward(int n, int n2) {
        return this.transRewards.getValue(n, n2);
    }

    @Override
    public RewardsSimple<Value> liftFromModel(Product<?> product) {
        int n;
        Object obj = product.getProductModel();
        int n2 = obj.getNumStates();
        RewardsSimple<Value> rewardsSimple = new RewardsSimple<Value>(n2);
        rewardsSimple.setEvaluator(this.getEvaluator());
        if (!this.stateRewards.allZero()) {
            for (n = 0; n < n2; ++n) {
                rewardsSimple.setStateReward(n, this.stateRewards.getValue(product.getModelState(n)));
            }
        }
        if (!this.transRewards.allZero()) {
            for (n = 0; n < n2; ++n) {
                rewardsSimple.transRewards.copyFrom(n, this.transRewards, product.getModelState(n));
            }
        }
        return rewardsSimple;
    }

    public String toString() {
        return "st: " + String.valueOf(this.stateRewards) + "; tr: " + String.valueOf(this.transRewards);
    }
}

