/*
 * Decompiled with CFR 0.152.
 */
package explicit.rewards;

import explicit.CSG;
import explicit.DTMC;
import explicit.IDTMC;
import explicit.MDP;
import explicit.Model;
import explicit.NondetModel;
import explicit.rewards.CSGRewards;
import explicit.rewards.CSGRewardsSimple;
import explicit.rewards.MCRewards;
import explicit.rewards.MDPRewards;
import explicit.rewards.MDPRewardsSimple;
import explicit.rewards.Rewards;
import explicit.rewards.RewardsExplicit;
import explicit.rewards.RewardsSimple;
import explicit.rewards.StateRewardsArray;
import explicit.rewards.StateRewardsConstant;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import parser.State;
import parser.Values;
import parser.ast.ASTElement;
import parser.ast.Expression;
import parser.ast.ModulesFile;
import parser.ast.RewardStruct;
import prism.Evaluator;
import prism.ModelType;
import prism.Pair;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismLangException;
import prism.PrismNotSupportedException;
import prism.RewardGenerator;

public class ConstructRewards
extends PrismComponent {
    protected ModulesFile modulesFile;
    protected boolean allowNegative = false;
    protected boolean expectedRewards = false;

    public ConstructRewards(PrismComponent prismComponent) {
        super(prismComponent);
    }

    public void allowNegativeRewards() {
        this.allowNegative = true;
    }

    public void setExpectedRewards(boolean bl) {
        this.expectedRewards = bl;
    }

    public <Value> Rewards<Value> buildRewardStructure(Model<Value> model, RewardGenerator<Value> rewardGenerator, int n) throws PrismException {
        if (model.getModelType() == ModelType.CSG) {
            return this.buildCSGRewardStructure((CSG)model, rewardGenerator, n);
        }
        if (rewardGenerator.isRewardLookupSupported(RewardGenerator.RewardLookup.BY_REWARD_OBJECT)) {
            Rewards<Value> rewards = rewardGenerator.getRewardObject(n);
            rewards = this.checkRewardObject(rewards, rewardGenerator.getRewardObjectModel(), rewardGenerator.getRewardEvaluator());
            return rewards;
        }
        int n2 = model.getNumStates();
        List<State> list = model.getStatesList();
        boolean bl = model.getModelType().nondeterministic();
        boolean bl2 = rewardGenerator.getRewardEvaluator().one() instanceof Double;
        boolean bl3 = !rewardGenerator.rewardStructHasTransitionRewards(n) || this.expectedRewards && !bl;
        RewardsExplicit rewardsExplicit = bl2 && bl3 && !model.getModelType().multiplePlayers() ? new StateRewardsArray(n2) : new RewardsSimple<Value>(n2);
        rewardsExplicit.setEvaluator(rewardGenerator.getRewardEvaluator());
        for (int i = 0; i < n2; ++i) {
            Value Value2;
            Map.Entry<Integer, Pair<Object, Object>> entry;
            int n3;
            Object object;
            if (rewardGenerator.rewardStructHasStateRewards(n)) {
                object = this.getAndCheckStateReward(i, rewardGenerator, n, list);
                rewardsExplicit.addToStateReward(i, object);
            }
            if (!rewardGenerator.rewardStructHasTransitionRewards(n) || model.isDeadlockState(i)) continue;
            if (bl) {
                object = (NondetModel)model;
                int n4 = object.getNumChoices(i);
                for (n3 = 0; n3 < n4; ++n3) {
                    entry = this.getAndCheckStateActionReward(i, object.getAction(i, n3), rewardGenerator, n, list);
                    rewardsExplicit.addToTransitionReward(i, n3, entry);
                }
                continue;
            }
            if (model instanceof DTMC) {
                object = (DTMC)model;
                Iterator iterator = object.getTransitionsAndActionsIterator(i);
                n3 = 0;
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    Value2 = this.getAndCheckStateActionReward(i, entry.getValue().second, rewardGenerator, n, list);
                    if (rewardGenerator.getRewardEvaluator().isZero(Value2)) {
                        ++n3;
                        continue;
                    }
                    if (this.expectedRewards) {
                        Value Value3 = rewardGenerator.getRewardEvaluator().multiply(entry.getValue().first, Value2);
                        rewardsExplicit.addToStateReward(i, Value3);
                    } else {
                        rewardsExplicit.addToTransitionReward(i, n3, Value2);
                    }
                    ++n3;
                }
                continue;
            }
            if (model.getModelType() == ModelType.IDTMC) {
                object = (IDTMC)model;
                Iterator iterator = object.getIntervalTransitionsAndActionsIterator(i);
                n3 = 0;
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    Value2 = this.getAndCheckStateActionReward(i, entry.getValue().second, rewardGenerator, n, list);
                    if (rewardGenerator.getRewardEvaluator().isZero(Value2)) {
                        ++n3;
                        continue;
                    }
                    if (this.expectedRewards) {
                        throw new PrismException("Can't construct expected rewards for IDTMCs");
                    }
                    rewardsExplicit.addToTransitionReward(i, n3, Value2);
                    ++n3;
                }
                continue;
            }
            throw new PrismException("Cannot build rewards for " + String.valueOf((Object)model.getModelType()) + "s");
        }
        return rewardsExplicit;
    }

    public <Value> CSGRewards<Value> buildCSGRewardStructure(CSG<Value> cSG, RewardGenerator<Value> rewardGenerator, int n) throws PrismException {
        int n2 = cSG.getNumStates();
        List<State> list = cSG.getStatesList();
        CSGRewardsSimple<Value> cSGRewardsSimple = null;
        cSGRewardsSimple = new CSGRewardsSimple<Value>(n2);
        cSGRewardsSimple.setEvaluator(rewardGenerator.getRewardEvaluator());
        for (int i = 0; i < n2; ++i) {
            if (rewardGenerator.rewardStructHasStateRewards(n)) {
                Value Value2 = this.getAndCheckStateReward(i, rewardGenerator, n, list);
                cSGRewardsSimple.addToStateReward(i, Value2);
            }
            if (!rewardGenerator.rewardStructHasTransitionRewards(n) || cSG.isDeadlockState(i)) continue;
            int n3 = cSG.getNumChoices(i);
            for (int j = 0; j < n3; ++j) {
                Value Value3 = this.getAndCheckStateActionReward(i, cSG.getIndexes(i, j), rewardGenerator, n, list);
                cSGRewardsSimple.addToTransitionReward(i, j, Value3);
            }
        }
        return cSGRewardsSimple;
    }

    private <Value> Value getAndCheckStateReward(int n, RewardGenerator<Value> rewardGenerator, int n2, List<State> list) throws PrismException {
        Evaluator<Value> evaluator = rewardGenerator.getRewardEvaluator();
        Value Value2 = evaluator.zero();
        Comparable<State> comparable = null;
        if (rewardGenerator.isRewardLookupSupported(RewardGenerator.RewardLookup.BY_STATE)) {
            State state;
            comparable = state = list.get(n);
            Value2 = rewardGenerator.getStateReward(n2, state, this.allowNegative);
        } else if (rewardGenerator.isRewardLookupSupported(RewardGenerator.RewardLookup.BY_STATE_INDEX)) {
            comparable = n;
            Value2 = rewardGenerator.getStateReward(n2, n, this.allowNegative);
        } else {
            throw new PrismException("Unknown reward lookup mechanism for reward generator");
        }
        this.checkStateReward(Value2, evaluator, comparable, null);
        return Value2;
    }

    private <Value> Value getAndCheckStateActionReward(int n, Object object, RewardGenerator<Value> rewardGenerator, int n2, List<State> list) throws PrismException {
        Evaluator<Value> evaluator = rewardGenerator.getRewardEvaluator();
        Value Value2 = evaluator.zero();
        Comparable<State> comparable = null;
        if (rewardGenerator.isRewardLookupSupported(RewardGenerator.RewardLookup.BY_STATE)) {
            State state;
            comparable = state = list.get(n);
            Value2 = rewardGenerator.getStateActionReward(n2, state, object, this.allowNegative);
        } else if (rewardGenerator.isRewardLookupSupported(RewardGenerator.RewardLookup.BY_STATE_INDEX)) {
            comparable = n;
            Value2 = rewardGenerator.getStateActionReward(n2, n, object, this.allowNegative);
        } else {
            throw new PrismException("Unknown reward lookup mechanism for reward generator");
        }
        this.checkTransitionReward(Value2, evaluator, comparable, null);
        return Value2;
    }

    public Rewards<Double> buildRewardStructure(Model<Double> model, RewardStruct rewardStruct, Values values) throws PrismException {
        if (model.getModelType() == ModelType.CSG) {
            return this.buildCSGRewardStructure((CSG)model, rewardStruct, values);
        }
        if (rewardStruct.getNumStateItems() == 1 && Expression.isTrue(rewardStruct.getStates(0)) && rewardStruct.getReward(0).isConstant()) {
            double d = rewardStruct.getReward(0).evaluateDouble(values);
            this.checkStateReward(d, null, rewardStruct.getReward(0));
            return new StateRewardsConstant<Double>(d);
        }
        int n = model.getNumStates();
        List<State> list = model.getStatesList();
        boolean bl = model.getModelType().nondeterministic();
        boolean bl2 = rewardStruct.getNumTransItems() <= 0 || this.expectedRewards && !bl;
        RewardsExplicit rewardsExplicit = bl2 ? new StateRewardsArray(n) : new RewardsSimple(n);
        int n2 = rewardStruct.getNumItems();
        for (int i = 0; i < n2; ++i) {
            Expression expression = rewardStruct.getStates(i);
            String string = rewardStruct.getSynch(i);
            for (int j = 0; j < n; ++j) {
                if (!expression.evaluateBoolean(values, list.get(j))) continue;
                if (rewardStruct.getRewardStructItem(i).isTransitionReward()) {
                    Object object;
                    int n3;
                    if (model.isDeadlockState(j)) continue;
                    if (bl) {
                        NondetModel nondetModel = (NondetModel)model;
                        int n4 = nondetModel.getNumChoices(j);
                        for (n3 = 0; n3 < n4; ++n3) {
                            object = nondetModel.getAction(j, n3);
                            if (!(object == null ? string.isEmpty() : object.equals(string))) continue;
                            double d = rewardStruct.getReward(i).evaluateDouble(values, list.get(j));
                            this.checkTransitionReward(d, list.get(j), rewardStruct.getReward(i));
                            rewardsExplicit.addToTransitionReward(j, n3, d);
                        }
                        continue;
                    }
                    DTMC dTMC = (DTMC)model;
                    Iterator iterator = dTMC.getTransitionsAndActionsIterator(j);
                    n3 = 0;
                    while (iterator.hasNext()) {
                        object = iterator.next();
                        Object y = ((Pair)object.getValue()).second;
                        if (y == null ? string.isEmpty() : y.equals(string)) {
                            double d = rewardStruct.getReward(i).evaluateDouble(values, list.get(j));
                            if (this.expectedRewards) {
                                double d2 = (Double)((Pair)object.getValue()).first * d;
                                rewardsExplicit.addToStateReward(j, d2);
                            } else {
                                rewardsExplicit.addToTransitionReward(j, n3, d);
                            }
                        }
                        ++n3;
                    }
                    continue;
                }
                double d = rewardStruct.getReward(i).evaluateDouble(values, list.get(j));
                this.checkStateReward(d, list.get(j), rewardStruct.getReward(i));
                rewardsExplicit.addToStateReward(j, d);
            }
        }
        return rewardsExplicit;
    }

    public CSGRewards<Double> buildCSGRewardStructure(CSG<Double> cSG, RewardStruct rewardStruct, Values values) throws PrismException {
        BitSet bitSet = new BitSet();
        BitSet bitSet2 = new BitSet();
        if (rewardStruct.getNumStateItems() == 1 && Expression.isTrue(rewardStruct.getStates(0)) && rewardStruct.getReward(0).isConstant()) {
            double d = rewardStruct.getReward(0).evaluateDouble(values);
            this.checkStateReward(d, null, rewardStruct.getReward(0));
            return new StateRewardsConstant<Double>(d);
        }
        int n = cSG.getNumStates();
        List<State> list = cSG.getStatesList();
        CSGRewardsSimple<Double> cSGRewardsSimple = new CSGRewardsSimple<Double>(n);
        int n2 = rewardStruct.getNumItems();
        for (int i = 0; i < n2; ++i) {
            Expression expression = rewardStruct.getStates(i);
            bitSet2.clear();
            if (rewardStruct.getRewardStructItem(i).isTransitionReward()) {
                Iterator<Integer> iterator = rewardStruct.getRewardStructItem(i).getSynchIndices().iterator();
                while (iterator.hasNext()) {
                    int n3 = iterator.next();
                    if (n3 == 0) continue;
                    bitSet2.set(n3);
                }
            }
            for (int j = 0; j < n; ++j) {
                double d;
                if (!expression.evaluateBoolean(values, list.get(j))) continue;
                if (rewardStruct.getRewardStructItem(i).isTransitionReward()) {
                    int n4 = cSG.getNumChoices(j);
                    for (int k = 0; k < n4; ++k) {
                        bitSet.clear();
                        for (Object object : (Iterator<Integer>)cSG.getIndexes(j, k)) {
                            if (object == -1) continue;
                            bitSet.set((int)object);
                        }
                        BitSet bitSet3 = (BitSet)bitSet2.clone();
                        bitSet3.andNot(bitSet);
                        if (!bitSet2.isEmpty() && (bitSet2.isEmpty() || !bitSet3.isEmpty())) continue;
                        d = rewardStruct.getReward(i).evaluateDouble(values, list.get(j));
                        this.checkTransitionReward(d, list.get(j), rewardStruct.getReward(i));
                        cSGRewardsSimple.addToTransitionReward(j, k, d);
                    }
                    continue;
                }
                d = rewardStruct.getReward(i).evaluateDouble(values, list.get(j));
                this.checkStateReward(d, list.get(j), rewardStruct.getReward(i));
                cSGRewardsSimple.addToStateReward(j, d);
            }
        }
        return cSGRewardsSimple;
    }

    public MCRewards<Double> buildMCRewardsFromPrismExplicit(DTMC<Double> dTMC, File file, File file2) throws PrismException {
        int n = 0;
        StateRewardsArray stateRewardsArray = new StateRewardsArray(dTMC.getNumStates());
        if (file != null) {
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
                String string = bufferedReader.readLine();
                n = 1;
                if (string == null) {
                    throw new PrismException("Missing first line of state rewards file");
                }
                string = bufferedReader.readLine();
                ++n;
                while (string != null) {
                    if ((string = string.trim()).length() > 0) {
                        String[] stringArray = string.split(" ");
                        int n2 = Integer.parseInt(stringArray[0]);
                        double d = Double.parseDouble(stringArray[1]);
                        this.checkStateReward(d, n2, null);
                        stateRewardsArray.setStateReward(n2, d);
                    }
                    string = bufferedReader.readLine();
                    ++n;
                }
            }
            catch (IOException iOException) {
                throw new PrismException("Could not read state rewards from file \"" + String.valueOf(file) + "\"" + String.valueOf(iOException));
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Problem in state rewards file (line " + n + ") for MDP");
            }
        }
        if (file2 != null) {
            throw new PrismNotSupportedException("Explicit engine does not yet handle transition rewards for D/CTMCs");
        }
        return stateRewardsArray;
    }

    public MDPRewards<Double> buildMDPRewardsFromPrismExplicit(MDP<Double> mDP, File file, File file2) throws PrismException {
        double d;
        int n;
        String[] stringArray;
        String string;
        BufferedReader bufferedReader;
        int n2 = 0;
        MDPRewardsSimple<Double> mDPRewardsSimple = new MDPRewardsSimple<Double>(mDP.getNumStates());
        if (file != null) {
            try {
                bufferedReader = new BufferedReader(new FileReader(file));
                try {
                    string = bufferedReader.readLine();
                    n2 = 1;
                    if (string == null) {
                        throw new PrismException("Missing first line of state rewards file");
                    }
                    string = bufferedReader.readLine();
                    ++n2;
                    while (string != null) {
                        if ((string = string.trim()).length() > 0) {
                            stringArray = string.split(" ");
                            n = Integer.parseInt(stringArray[0]);
                            d = Double.parseDouble(stringArray[1]);
                            this.checkStateReward(d, n, null);
                            mDPRewardsSimple.setStateReward(n, d);
                        }
                        string = bufferedReader.readLine();
                        ++n2;
                    }
                }
                finally {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                throw new PrismException("Could not read state rewards from file \"" + String.valueOf(file) + "\"" + String.valueOf(iOException));
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Problem in state rewards file (line " + n2 + ") for MDP");
            }
        }
        if (file2 != null) {
            try {
                bufferedReader = new BufferedReader(new FileReader(file2));
                try {
                    string = bufferedReader.readLine();
                    n2 = 1;
                    if (string == null) {
                        throw new PrismException("Missing first line of transition rewards file");
                    }
                    string = bufferedReader.readLine();
                    ++n2;
                    while (string != null) {
                        if ((string = string.trim()).length() > 0) {
                            stringArray = string.split(" ");
                            n = Integer.parseInt(stringArray[0]);
                            int n3 = Integer.parseInt(stringArray[1]);
                            d = Double.parseDouble(stringArray[3]);
                            this.checkTransitionReward(d, n, null);
                            mDPRewardsSimple.setTransitionReward(n, n3, d);
                        }
                        string = bufferedReader.readLine();
                        ++n2;
                    }
                }
                finally {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                throw new PrismException("Could not read transition rewards from file \"" + String.valueOf(file2) + "\"" + String.valueOf(iOException));
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Problem in transition rewards file (line " + n2 + ") for MDP");
            }
        }
        return mDPRewardsSimple;
    }

    private <Value> void checkStateReward(Value Value2, Evaluator<Value> evaluator, Object object, ASTElement aSTElement) throws PrismException {
        Object object2 = null;
        if (!evaluator.isSymbolic()) {
            if (!evaluator.isFinite(Value2)) {
                object2 = "State reward is not finite";
            } else if (!this.allowNegative && !evaluator.geq(Value2, evaluator.zero())) {
                object2 = "State reward is negative (" + String.valueOf(Value2) + ")";
            }
        }
        if (object2 != null) {
            if (object != null) {
                object2 = (String)object2 + " at state " + String.valueOf(object);
            }
            if (aSTElement != null) {
                throw new PrismLangException((String)object2, aSTElement);
            }
            throw new PrismException((String)object2);
        }
    }

    private <Value> void checkTransitionReward(Value Value2, Evaluator<Value> evaluator, Object object, ASTElement aSTElement) throws PrismException {
        Object object2 = null;
        if (!evaluator.isSymbolic()) {
            if (!evaluator.isFinite(Value2)) {
                object2 = "Transition reward is not finite";
            } else if (!this.allowNegative && !evaluator.geq(Value2, evaluator.zero())) {
                object2 = "Transition reward is negative (" + String.valueOf(Value2) + ")";
            }
        }
        if (object2 != null) {
            if (object != null) {
                object2 = (String)object2 + " at state " + String.valueOf(object);
            }
            if (aSTElement != null) {
                throw new PrismLangException((String)object2, aSTElement);
            }
            throw new PrismException((String)object2);
        }
    }

    private <Value> Rewards<Value> checkRewardObject(Rewards<Value> rewards, Model<Value> model, Evaluator<Value> evaluator) throws PrismException {
        int n;
        boolean bl;
        int n2 = model.getNumStates();
        RewardsSimple<Value> rewardsSimple = null;
        boolean bl2 = bl = !model.getModelType().nondeterministic() && rewards.hasTransitionRewards() && this.expectedRewards;
        if (bl) {
            rewardsSimple = new RewardsSimple<Value>(n2);
            ((RewardsExplicit)rewardsSimple).setEvaluator(rewards.getEvaluator());
        }
        for (n = 0; n < n2; ++n) {
            Value Value2 = rewards.getStateReward(n);
            this.checkStateReward(Value2, evaluator, n, null);
            if (!bl) continue;
            ((RewardsExplicit)rewardsSimple).setStateReward(n, Value2);
        }
        if (model.getModelType().nondeterministic()) {
            for (n = 0; n < n2; ++n) {
                int n3 = ((NondetModel)model).getNumChoices(n);
                for (int i = 0; i < n3; ++i) {
                    this.checkTransitionReward(rewards.getTransitionReward(n, i), evaluator, n, null);
                }
            }
        } else {
            for (n = 0; n < n2; ++n) {
                if (!bl) {
                    int n4 = model.getNumTransitions(n);
                    for (int i = 0; i < n4; ++i) {
                        this.checkTransitionReward(rewards.getTransitionReward(n, i), evaluator, n, null);
                    }
                    continue;
                }
                DTMC dTMC = (DTMC)model;
                Iterator iterator = dTMC.getTransitionsIterator(n);
                int n5 = 0;
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    Value Value3 = rewards.getTransitionReward(n, n5);
                    this.checkTransitionReward(Value3, evaluator, n, null);
                    if (rewards.getEvaluator().isZero(Value3)) {
                        ++n5;
                        continue;
                    }
                    Value Value4 = rewards.getEvaluator().multiply(entry.getValue(), Value3);
                    rewardsSimple.addToStateReward(n, Value4);
                    ++n5;
                }
            }
        }
        return bl ? rewardsSimple : rewards;
    }

    private <Value> void checkStateReward(double d, Object object, ASTElement aSTElement) throws PrismException {
        this.checkStateReward(d, Evaluator.forDouble(), object, aSTElement);
    }

    private <Value> void checkTransitionReward(double d, Object object, ASTElement aSTElement) throws PrismException {
        this.checkTransitionReward(d, Evaluator.forDouble(), object, aSTElement);
    }
}

