/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.Bisimulation;
import explicit.CSGModelChecker;
import explicit.CTMCModelChecker;
import explicit.CTMDPModelChecker;
import explicit.DTMCModelChecker;
import explicit.LTLModelChecker;
import explicit.MDPModelChecker;
import explicit.Model;
import explicit.ModelExplicit;
import explicit.MultiParameters;
import explicit.NonProbModelChecker;
import explicit.POMDPModelChecker;
import explicit.Pareto;
import explicit.PartiallyObservableModel;
import explicit.Product;
import explicit.SMGModelChecker;
import explicit.STPGModelChecker;
import explicit.StateValues;
import explicit.UDTMCModelChecker;
import explicit.UMDPModelChecker;
import explicit.rewards.ConstructRewards;
import explicit.rewards.Rewards;
import io.DRNExporter;
import io.DotExporter;
import io.MatlabExporter;
import io.ModelExportFormat;
import io.ModelExportOptions;
import io.ModelExportTask;
import io.ModelExporter;
import io.PrismExplicitExporter;
import io.PrismExplicitImporter;
import io.UMBExporter;
import java.io.File;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import parser.EvaluateContext;
import parser.State;
import parser.Values;
import parser.VarList;
import parser.ast.Declaration;
import parser.ast.DeclarationIntUnbounded;
import parser.ast.Expression;
import parser.ast.ExpressionBinaryOp;
import parser.ast.ExpressionConstant;
import parser.ast.ExpressionFilter;
import parser.ast.ExpressionFormula;
import parser.ast.ExpressionFunc;
import parser.ast.ExpressionITE;
import parser.ast.ExpressionIdent;
import parser.ast.ExpressionLabel;
import parser.ast.ExpressionLiteral;
import parser.ast.ExpressionObs;
import parser.ast.ExpressionProp;
import parser.ast.ExpressionUnaryOp;
import parser.ast.ExpressionVar;
import parser.ast.LabelList;
import parser.ast.ModulesFile;
import parser.ast.PropertiesFile;
import parser.ast.Property;
import parser.type.TypeBool;
import parser.type.TypeDouble;
import parser.visitor.ASTTraverseModify;
import parser.visitor.ReplaceLabels;
import prism.Accuracy;
import prism.Filter;
import prism.ModelInfo;
import prism.ModelType;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismFileLog;
import prism.PrismLangException;
import prism.PrismLog;
import prism.PrismNotSupportedException;
import prism.Result;
import prism.RewardGenerator;

public class StateModelChecker
extends PrismComponent {
    protected int verbosity = 0;
    protected boolean exportTarget = false;
    protected String exportTargetFilename = null;
    protected boolean exportProductTrans = false;
    protected String exportProductTransFilename = null;
    protected boolean exportProductStates = false;
    protected String exportProductStatesFilename = null;
    protected boolean exportProductVector = false;
    protected String exportProductVectorFilename = null;
    protected boolean storeVector = false;
    protected boolean genStrat = false;
    protected boolean restrictStratToReach = true;
    protected Pareto pareto_set = null;
    protected MultiParameters parsed_params = null;
    protected boolean computePareto = true;
    protected boolean doBisim = false;
    protected boolean doTopologicalValueIteration = false;
    protected boolean doPmaxQuotient = false;
    protected boolean doIntervalIteration = false;
    protected ModulesFile modulesFile = null;
    protected ModelInfo modelInfo = null;
    protected RewardGenerator<?> rewardGen = null;
    protected PropertiesFile propertiesFile = null;
    protected Values constantValues;
    protected Filter currentFilter;
    protected Result result;
    protected double tolerance = 0.0;

    public StateModelChecker(PrismComponent prismComponent) throws PrismException {
        super(prismComponent);
        if (prismComponent == null || prismComponent.getSettings() == null) {
            this.setSettings(null);
        }
        if (this.settings != null) {
            this.verbosity = this.settings.getBoolean("prism.verbose") ? 10 : 1;
            this.setDoIntervalIteration(this.settings.getBoolean("prism.intervalIter"));
            this.setDoTopologicalValueIteration(this.settings.getBoolean("prism.topologicalVI"));
            this.setDoPmaxQuotient(this.settings.getBoolean("prism.pmaxQuotient"));
            this.tolerance = this.settings.getDouble("prism.paretoEpsilon");
        }
    }

    public static StateModelChecker createModelChecker(ModelType modelType) throws PrismException {
        return StateModelChecker.createModelChecker(modelType, null);
    }

    public static StateModelChecker createModelChecker(ModelType modelType, PrismComponent prismComponent) throws PrismException {
        NonProbModelChecker nonProbModelChecker = null;
        switch (modelType) {
            case DTMC: {
                nonProbModelChecker = new DTMCModelChecker(prismComponent);
                break;
            }
            case MDP: {
                nonProbModelChecker = new MDPModelChecker(prismComponent);
                break;
            }
            case CTMC: {
                nonProbModelChecker = new CTMCModelChecker(prismComponent);
                break;
            }
            case POMDP: {
                nonProbModelChecker = new POMDPModelChecker(prismComponent);
                break;
            }
            case CTMDP: {
                nonProbModelChecker = new CTMDPModelChecker(prismComponent);
                break;
            }
            case CSG: {
                nonProbModelChecker = new CSGModelChecker(prismComponent);
                break;
            }
            case STPG: {
                nonProbModelChecker = new STPGModelChecker(prismComponent);
                break;
            }
            case SMG: {
                nonProbModelChecker = new SMGModelChecker(prismComponent);
                break;
            }
            case IDTMC: {
                nonProbModelChecker = new UDTMCModelChecker(prismComponent);
                break;
            }
            case IMDP: {
                nonProbModelChecker = new UMDPModelChecker(prismComponent);
                break;
            }
            case IPOMDP: {
                nonProbModelChecker = new UMDPModelChecker(prismComponent);
                break;
            }
            case LTS: {
                nonProbModelChecker = new NonProbModelChecker(prismComponent);
                break;
            }
            default: {
                throw new PrismException("Cannot create model checker for model type " + String.valueOf((Object)modelType));
            }
        }
        return nonProbModelChecker;
    }

    public void inheritSettings(StateModelChecker stateModelChecker) {
        this.setModelCheckingInfo(stateModelChecker.modelInfo, stateModelChecker.propertiesFile, stateModelChecker.rewardGen);
        this.setLog(stateModelChecker.getLog());
        this.result = stateModelChecker.result;
        this.setVerbosity(stateModelChecker.getVerbosity());
        this.setExportTarget(stateModelChecker.getExportTarget());
        this.setExportTargetFilename(stateModelChecker.getExportTargetFilename());
        this.setExportProductTrans(stateModelChecker.getExportProductTrans());
        this.setExportProductTransFilename(stateModelChecker.getExportProductTransFilename());
        this.setExportProductStates(stateModelChecker.getExportProductStates());
        this.setExportProductStatesFilename(stateModelChecker.getExportProductStatesFilename());
        this.setExportProductVector(stateModelChecker.getExportProductVector());
        this.setExportProductVectorFilename(stateModelChecker.getExportProductVectorFilename());
        this.setStoreVector(stateModelChecker.getStoreVector());
        this.setGenStrat(stateModelChecker.getGenStrat());
        this.setRestrictStratToReach(stateModelChecker.getRestrictStratToReach());
        this.setDoBisim(stateModelChecker.getDoBisim());
        this.tolerance = stateModelChecker.tolerance;
        this.setDoIntervalIteration(stateModelChecker.getDoIntervalIteration());
        this.setDoPmaxQuotient(stateModelChecker.getDoPmaxQuotient());
    }

    public void printSettings() {
        this.mainLog.print("verbosity = " + this.verbosity + " ");
        this.mainLog.print("tolerance = " + this.tolerance + " ");
    }

    public void setComputeParetoSet(boolean bl) {
        this.computePareto = bl;
    }

    public void setVerbosity(int n) {
        this.verbosity = n;
    }

    public void setExportTarget(boolean bl) {
        this.exportTarget = bl;
    }

    public void setExportTargetFilename(String string) {
        this.exportTargetFilename = string;
    }

    public void setExportProductTrans(boolean bl) {
        this.exportProductTrans = bl;
    }

    public void setExportProductTransFilename(String string) {
        this.exportProductTransFilename = string;
    }

    public void setExportProductStates(boolean bl) {
        this.exportProductStates = bl;
    }

    public void setExportProductStatesFilename(String string) {
        this.exportProductStatesFilename = string;
    }

    public void setExportProductVector(boolean bl) {
        this.exportProductVector = bl;
    }

    public void setExportProductVectorFilename(String string) {
        this.exportProductVectorFilename = string;
    }

    public void setStoreVector(boolean bl) {
        this.storeVector = bl;
    }

    public void setGenStrat(boolean bl) {
        this.genStrat = bl;
    }

    public void setRestrictStratToReach(boolean bl) {
        this.restrictStratToReach = bl;
    }

    public void setDoBisim(boolean bl) {
        this.doBisim = bl;
    }

    public void setDoTopologicalValueIteration(boolean bl) {
        this.doTopologicalValueIteration = bl;
    }

    public void setDoPmaxQuotient(boolean bl) {
        this.doPmaxQuotient = bl;
    }

    public void setDoIntervalIteration(boolean bl) {
        this.doIntervalIteration = bl;
    }

    public int getVerbosity() {
        return this.verbosity;
    }

    public boolean getExportTarget() {
        return this.exportTarget;
    }

    public String getExportTargetFilename() {
        return this.exportTargetFilename;
    }

    public boolean getExportProductTrans() {
        return this.exportProductTrans;
    }

    public String getExportProductTransFilename() {
        return this.exportProductTransFilename;
    }

    public boolean getExportProductStates() {
        return this.exportProductStates;
    }

    public String getExportProductStatesFilename() {
        return this.exportProductStatesFilename;
    }

    public boolean getExportProductVector() {
        return this.exportProductVector;
    }

    public String getExportProductVectorFilename() {
        return this.exportProductVectorFilename;
    }

    public boolean getStoreVector() {
        return this.storeVector;
    }

    public boolean getGenStrat() {
        return this.genStrat;
    }

    public boolean getRestrictStratToReach() {
        return this.restrictStratToReach;
    }

    public boolean getDoBisim() {
        return this.doBisim;
    }

    public boolean getDoTopologicalValueIteration() {
        return this.doTopologicalValueIteration;
    }

    public boolean getDoPmaxQuotient() {
        return this.doPmaxQuotient;
    }

    public boolean getDoIntervalIteration() {
        return this.doIntervalIteration;
    }

    public Values getConstantValues() {
        return this.constantValues;
    }

    public LabelList getLabelList() {
        if (this.propertiesFile != null) {
            return this.propertiesFile.getCombinedLabelList();
        }
        if (this.modulesFile != null) {
            return this.modulesFile.getLabelList();
        }
        return null;
    }

    public Set<String> getDefinedLabelNames() {
        TreeSet<String> treeSet = new TreeSet<String>();
        LabelList labelList = this.getLabelList();
        if (labelList != null) {
            treeSet.addAll(labelList.getLabelNames());
        }
        if (this.modelInfo != null) {
            treeSet.addAll(this.modelInfo.getLabelNames());
        }
        return treeSet;
    }

    public void setModelCheckingInfo(ModelInfo modelInfo, PropertiesFile propertiesFile, RewardGenerator<?> rewardGenerator) {
        this.modelInfo = modelInfo;
        if (modelInfo instanceof ModulesFile) {
            this.modulesFile = (ModulesFile)modelInfo;
        }
        this.propertiesFile = propertiesFile;
        this.rewardGen = rewardGenerator;
        this.constantValues = new Values();
        if (modelInfo != null) {
            this.constantValues.addValues(modelInfo.getConstantValues());
        }
        if (propertiesFile != null) {
            this.constantValues.addValues(propertiesFile.getConstantValues());
        }
    }

    public <Value> Result check(Model<Value> model, Expression expression) throws PrismException {
        Cloneable cloneable;
        long l = 0L;
        this.result = new Result();
        this.currentFilter = null;
        if (this.storeVector) {
            cloneable = new ExpressionFilter("store", expression);
            cloneable.setInvisible(true);
            cloneable.typeCheck();
            expression = cloneable;
        }
        expression = ExpressionFilter.addDefaultFilterIfNeeded(expression, model.getNumInitialStates() == 1);
        if (this.doBisim) {
            this.mainLog.println("\nPerforming bisimulation minimisation...");
            cloneable = new ArrayList();
            ArrayList<BitSet> arrayList = new ArrayList<BitSet>();
            Expression expression2 = this.checkMaximalPropositionalFormulas(model, expression.deepCopy(), (List<String>)((Object)cloneable), arrayList);
            Bisimulation<Value> bisimulation = new Bisimulation<Value>(this);
            model = bisimulation.minimise(model, (List<String>)((Object)cloneable), arrayList);
            this.mainLog.println("Modified property: " + String.valueOf(expression2));
            expression = expression2;
        }
        l = System.currentTimeMillis();
        StateValues stateValues = this.checkExpression(model, expression, null);
        l = System.currentTimeMillis() - l;
        this.mainLog.println("\nTime for model checking: " + (double)l / 1000.0 + " seconds.");
        Object object = "Result";
        if (!"Result".equals(expression.getResultName())) {
            object = (String)object + " (" + expression.getResultName().toLowerCase() + ")";
        }
        object = (String)object + ": " + this.result.getResultAndAccuracy();
        this.mainLog.print("\n" + (String)object + "\n");
        return this.result;
    }

    public StateValues checkExpression(Model<?> model, Expression expression, BitSet bitSet) throws PrismException {
        StateValues stateValues = null;
        if (expression instanceof ExpressionITE) {
            stateValues = this.checkExpressionITE(model, (ExpressionITE)expression, bitSet);
        } else if (expression instanceof ExpressionBinaryOp) {
            stateValues = this.checkExpressionBinaryOp(model, (ExpressionBinaryOp)expression, bitSet);
        } else if (expression instanceof ExpressionUnaryOp) {
            stateValues = this.checkExpressionUnaryOp(model, (ExpressionUnaryOp)expression, bitSet);
        } else if (expression instanceof ExpressionFunc) {
            stateValues = this.checkExpressionFunc(model, (ExpressionFunc)expression, bitSet);
        } else {
            if (expression instanceof ExpressionIdent) {
                throw new PrismException("Unknown identifier \"" + ((ExpressionIdent)expression).getName() + "\"");
            }
            if (expression instanceof ExpressionLiteral) {
                stateValues = this.checkExpressionLiteral(model, (ExpressionLiteral)expression);
            } else if (expression instanceof ExpressionConstant) {
                stateValues = this.checkExpressionConstant(model, (ExpressionConstant)expression);
            } else {
                if (expression instanceof ExpressionFormula) {
                    if (((ExpressionFormula)expression).getDefinition() != null) {
                        return this.checkExpression(model, ((ExpressionFormula)expression).getDefinition(), bitSet);
                    }
                    throw new PrismException("Unexpanded formula \"" + ((ExpressionFormula)expression).getName() + "\"");
                }
                if (expression instanceof ExpressionVar) {
                    stateValues = this.checkExpressionVar(model, (ExpressionVar)expression, bitSet);
                } else if (expression instanceof ExpressionObs) {
                    stateValues = this.checkExpressionObs(model, (ExpressionObs)expression, bitSet);
                } else if (expression instanceof ExpressionLabel) {
                    stateValues = this.checkExpressionLabel(model, (ExpressionLabel)expression, bitSet);
                } else if (expression instanceof ExpressionProp) {
                    stateValues = this.checkExpressionProp(model, (ExpressionProp)expression, bitSet);
                } else if (expression instanceof ExpressionFilter) {
                    stateValues = this.checkExpressionFilter(model, (ExpressionFilter)expression, bitSet);
                } else {
                    throw new PrismNotSupportedException("Couldn't check " + String.valueOf(expression.getClass()));
                }
            }
        }
        return stateValues;
    }

    protected StateValues checkExpressionITE(Model<?> model, ExpressionITE expressionITE, BitSet bitSet) throws PrismException {
        StateValues stateValues = null;
        StateValues stateValues2 = null;
        StateValues stateValues3 = null;
        try {
            stateValues = this.checkExpression(model, expressionITE.getOperand1(), bitSet);
            BitSet bitSet2 = (BitSet)stateValues.getBitSet().clone();
            BitSet bitSet3 = (BitSet)bitSet2.clone();
            bitSet3.flip(0, model.getNumStates());
            if (bitSet != null) {
                bitSet2.and(bitSet);
                bitSet3.and(bitSet);
            }
            stateValues2 = this.checkExpression(model, expressionITE.getOperand2(), bitSet2);
            stateValues3 = this.checkExpression(model, expressionITE.getOperand3(), bitSet3);
        }
        catch (PrismException prismException) {
            if (stateValues != null) {
                stateValues.clear();
            }
            if (stateValues2 != null) {
                stateValues2.clear();
            }
            throw prismException;
        }
        stateValues.applyFunction(expressionITE.getType(), (object, object2, object3) -> expressionITE.apply(object, object2, object3, EvaluateContext.EvalMode.FP), stateValues2, stateValues3, bitSet);
        stateValues2.clear();
        stateValues3.clear();
        return stateValues;
    }

    protected StateValues checkExpressionBinaryOp(Model<?> model, ExpressionBinaryOp expressionBinaryOp, BitSet bitSet) throws PrismException {
        StateValues stateValues = null;
        StateValues stateValues2 = null;
        try {
            stateValues = this.checkExpression(model, expressionBinaryOp.getOperand1(), bitSet);
            BitSet bitSet2 = null;
            switch (expressionBinaryOp.getOperator()) {
                case 1: 
                case 4: {
                    bitSet2 = (BitSet)stateValues.getBitSet().clone();
                    break;
                }
                case 3: {
                    bitSet2 = (BitSet)stateValues.getBitSet().clone();
                    bitSet2.flip(0, model.getNumStates());
                    break;
                }
                default: {
                    bitSet2 = bitSet;
                }
            }
            if (bitSet2 != null && bitSet != null) {
                bitSet2.and(bitSet);
            }
            stateValues2 = this.checkExpression(model, expressionBinaryOp.getOperand2(), bitSet2);
        }
        catch (PrismException prismException) {
            if (stateValues != null) {
                stateValues.clear();
            }
            throw prismException;
        }
        stateValues.applyFunction(expressionBinaryOp.getType(), (object, object2) -> expressionBinaryOp.apply(object, object2, EvaluateContext.EvalMode.FP), stateValues2, bitSet);
        stateValues2.clear();
        return stateValues;
    }

    protected StateValues checkExpressionUnaryOp(Model<?> model, ExpressionUnaryOp expressionUnaryOp, BitSet bitSet) throws PrismException {
        StateValues stateValues = null;
        int n = expressionUnaryOp.getOperator();
        stateValues = this.checkExpression(model, expressionUnaryOp.getOperand(), bitSet);
        if (n == 3) {
            return stateValues;
        }
        stateValues.applyFunction(expressionUnaryOp.getType(), object -> expressionUnaryOp.apply(object, EvaluateContext.EvalMode.FP), bitSet);
        return stateValues;
    }

    protected StateValues checkExpressionFunc(Model<?> model, ExpressionFunc expressionFunc, BitSet bitSet) throws PrismException {
        switch (expressionFunc.getNameCode()) {
            case 0: 
            case 1: {
                return this.checkExpressionFuncNary(model, expressionFunc, bitSet);
            }
            case 2: 
            case 3: 
            case 4: {
                return this.checkExpressionFuncUnary(model, expressionFunc, bitSet);
            }
            case 5: 
            case 6: 
            case 7: {
                return this.checkExpressionFuncBinary(model, expressionFunc, bitSet);
            }
            case 8: {
                throw new PrismNotSupportedException("Multi-objective model checking is not supported for " + String.valueOf((Object)model.getModelType()) + "s with the explicit engine");
            }
        }
        throw new PrismException("Unrecognised function \"" + expressionFunc.getName() + "\"");
    }

    protected StateValues checkExpressionFuncUnary(Model<?> model, ExpressionFunc expressionFunc, BitSet bitSet) throws PrismException {
        StateValues stateValues = this.checkExpression(model, expressionFunc.getOperand(0), bitSet);
        try {
            stateValues.applyFunction(expressionFunc.getType(), object -> expressionFunc.applyUnary(object, EvaluateContext.EvalMode.FP), bitSet);
        }
        catch (PrismException prismException) {
            if (stateValues != null) {
                stateValues.clear();
            }
            if (prismException instanceof PrismLangException) {
                ((PrismLangException)prismException).setASTElement(expressionFunc);
            }
            throw prismException;
        }
        return stateValues;
    }

    protected StateValues checkExpressionFuncBinary(Model<?> model, ExpressionFunc expressionFunc, BitSet bitSet) throws PrismException {
        StateValues stateValues = null;
        StateValues stateValues2 = null;
        try {
            stateValues = this.checkExpression(model, expressionFunc.getOperand(0), bitSet);
            stateValues2 = this.checkExpression(model, expressionFunc.getOperand(1), bitSet);
        }
        catch (PrismException prismException) {
            if (stateValues != null) {
                stateValues.clear();
            }
            throw prismException;
        }
        try {
            stateValues.applyFunction(expressionFunc.getType(), (object, object2) -> expressionFunc.applyBinary(object, object2, EvaluateContext.EvalMode.FP), stateValues2, bitSet);
            stateValues2.clear();
        }
        catch (PrismException prismException) {
            if (stateValues != null) {
                stateValues.clear();
            }
            if (stateValues2 != null) {
                stateValues2.clear();
            }
            if (prismException instanceof PrismLangException) {
                ((PrismLangException)prismException).setASTElement(expressionFunc);
            }
            throw prismException;
        }
        return stateValues;
    }

    protected StateValues checkExpressionFuncNary(Model<?> model, ExpressionFunc expressionFunc, BitSet bitSet) throws PrismException {
        StateValues stateValues = null;
        StateValues stateValues2 = null;
        stateValues = this.checkExpression(model, expressionFunc.getOperand(0), bitSet);
        int n = expressionFunc.getNumOperands();
        for (int i = 1; i < n; ++i) {
            try {
                stateValues2 = this.checkExpression(model, expressionFunc.getOperand(i), bitSet);
            }
            catch (PrismException prismException) {
                if (stateValues2 != null) {
                    stateValues2.clear();
                }
                throw prismException;
            }
            try {
                stateValues.applyFunction(expressionFunc.getType(), (object, object2) -> expressionFunc.applyBinary(object, object2, EvaluateContext.EvalMode.FP), stateValues2, bitSet);
                stateValues2.clear();
                continue;
            }
            catch (PrismException prismException) {
                if (stateValues != null) {
                    stateValues.clear();
                }
                if (stateValues2 != null) {
                    stateValues2.clear();
                }
                if (prismException instanceof PrismLangException) {
                    ((PrismLangException)prismException).setASTElement(expressionFunc);
                }
                throw prismException;
            }
        }
        return stateValues;
    }

    protected StateValues checkExpressionLiteral(Model<?> model, ExpressionLiteral expressionLiteral) throws PrismException {
        return StateValues.createFromSingleValue(expressionLiteral.getType(), expressionLiteral.evaluate(), model);
    }

    protected StateValues checkExpressionConstant(Model<?> model, ExpressionConstant expressionConstant) throws PrismException {
        return StateValues.createFromSingleValue(expressionConstant.getType(), expressionConstant.evaluate(this.constantValues), model);
    }

    protected StateValues checkExpressionVar(Model<?> model, ExpressionVar expressionVar, BitSet bitSet) throws PrismException {
        List<State> list = model.getStatesList();
        return StateValues.create(expressionVar.getType(), n -> expressionVar.evaluate((State)list.get(n)), model);
    }

    protected StateValues checkExpressionObs(Model<?> model, ExpressionObs expressionObs, BitSet bitSet) throws PrismException {
        PartiallyObservableModel partiallyObservableModel = (PartiallyObservableModel)model;
        int n = this.modelInfo.getObservableIndex(expressionObs.getName());
        return StateValues.create(expressionObs.getType(), n2 -> partiallyObservableModel.getObservationAsState((int)n2).varValues[n], model);
    }

    protected StateValues checkExpressionLabel(Model<?> model, ExpressionLabel expressionLabel, BitSet bitSet) throws PrismException {
        int n;
        if (expressionLabel.isDeadlockLabel()) {
            int n2 = model.getNumStates();
            BitSet bitSet2 = new BitSet(n2);
            for (int i = 0; i < n2; ++i) {
                bitSet2.set(i, model.isDeadlockState(i));
            }
            return StateValues.createFromBitSet(bitSet2, model);
        }
        if (expressionLabel.isInitLabel()) {
            int n3 = model.getNumStates();
            BitSet bitSet3 = new BitSet(n3);
            for (int i = 0; i < n3; ++i) {
                bitSet3.set(i, model.isInitialState(i));
            }
            return StateValues.createFromBitSet(bitSet3, model);
        }
        BitSet bitSet4 = model.getLabelStates(expressionLabel.getName());
        if (bitSet4 != null) {
            return StateValues.createFromBitSet((BitSet)bitSet4.clone(), model);
        }
        LabelList labelList = this.getLabelList();
        if (labelList != null && (n = labelList.getLabelIndex(expressionLabel.getName())) != -1) {
            return this.checkExpression(model, labelList.getLabel(n), bitSet);
        }
        throw new PrismException("Unknown label \"" + expressionLabel.getName() + "\"");
    }

    protected StateValues checkExpressionProp(Model<?> model, ExpressionProp expressionProp, BitSet bitSet) throws PrismException {
        Property property = this.propertiesFile.lookUpPropertyObjectByName(expressionProp.getName());
        if (property != null) {
            this.mainLog.println("\nModel checking : " + String.valueOf(property));
            return this.checkExpression(model, property.getExpression(), bitSet);
        }
        throw new PrismException("Unknown property reference " + String.valueOf(expressionProp));
    }

    protected StateValues checkExpressionFilter(Model<?> model, ExpressionFilter expressionFilter, BitSet bitSet) throws PrismException {
        ExpressionFilter.FilterOperator filterOperator;
        boolean bl;
        Expression expression = expressionFilter.getFilter();
        if (expression == null) {
            expression = Expression.True();
        }
        String string = (bl = Expression.isTrue(expression)) ? "all states" : "states satisfying filter";
        BitSet bitSet2 = this.checkExpression(model, expression, null).getBitSet();
        if (bitSet2.isEmpty()) {
            throw new PrismException("Filter satisfies no states");
        }
        boolean bl2 = expression instanceof ExpressionLabel && ((ExpressionLabel)expression).isInitLabel();
        boolean bl3 = bl2 & model.getNumInitialStates() == 1;
        if (!bl2 && !expressionFilter.isInvisible()) {
            this.mainLog.println("\nStates satisfying filter " + String.valueOf(expression) + ": " + bitSet2.cardinality());
        }
        if ((filterOperator = expressionFilter.getOperatorType()) == ExpressionFilter.FilterOperator.FIRST) {
            bitSet2.clear(bitSet2.nextSetBit(0) + 1, bitSet2.length());
        }
        if (filterOperator == ExpressionFilter.FilterOperator.STATE) {
            if (bitSet2.cardinality() != 1) {
                Object object = "Filter should be satisfied in exactly 1 state";
                object = (String)object + " (but \"" + String.valueOf(expression) + "\" is true in " + bitSet2.cardinality() + " states)";
                throw new PrismException((String)object);
            }
            this.currentFilter = new Filter(Filter.FilterOperator.STATE, bitSet2.nextSetBit(0));
        } else {
            this.currentFilter = filterOperator == ExpressionFilter.FilterOperator.FORALL && bl2 && bl3 ? new Filter(Filter.FilterOperator.STATE, bitSet2.nextSetBit(0)) : (filterOperator == ExpressionFilter.FilterOperator.FIRST && bl2 && bl3 ? new Filter(Filter.FilterOperator.STATE, bitSet2.nextSetBit(0)) : null);
        }
        StateValues stateValues = this.checkExpression(model, expressionFilter.getOperand(), bitSet2);
        StateValues stateValues2 = null;
        BitSet bitSet3 = null;
        BitSet bitSet4 = null;
        boolean bl4 = false;
        Object object = null;
        Object object2 = null;
        Accuracy accuracy = null;
        switch (filterOperator) {
            case PRINT: 
            case PRINTALL: {
                if (expressionFilter.getType() instanceof TypeBool) {
                    this.mainLog.print("\nSatisfying states");
                    this.mainLog.println((String)(bl ? ":" : " that are also in filter " + String.valueOf(expression) + ":"));
                    stateValues.printFiltered(this.mainLog, bitSet2);
                } else if (filterOperator == ExpressionFilter.FilterOperator.PRINT) {
                    this.mainLog.println("\nResults (non-zero only) for filter " + String.valueOf(expression) + ":");
                    stateValues.printFiltered(this.mainLog, bitSet2);
                } else {
                    this.mainLog.println("\nResults (including zeros) for filter " + String.valueOf(expression) + ":");
                    stateValues.printFiltered(this.mainLog, bitSet2, false, false, true, true);
                }
                stateValues2 = stateValues;
                stateValues = null;
                break;
            }
            case STORE: {
                stateValues2 = stateValues;
                stateValues = null;
                break;
            }
            case MIN: {
                object2 = expressionFilter.apply(stateValues.filtered(bitSet2));
                stateValues2 = StateValues.createFromSingleValue(expressionFilter.getType(), object2, model);
                object = "Minimum value over " + string;
                this.mainLog.println("\n" + (String)object + ": " + String.valueOf(object2));
                bitSet3 = stateValues.getBitSetFromCloseValue(object2);
                bitSet3.and(bitSet2);
                break;
            }
            case MAX: {
                object2 = expressionFilter.apply(stateValues.filtered(bitSet2));
                stateValues2 = StateValues.createFromSingleValue(expressionFilter.getType(), object2, model);
                object = "Maximum value over " + string;
                this.mainLog.println("\n" + (String)object + ": " + String.valueOf(object2));
                bitSet3 = stateValues.getBitSetFromCloseValue(object2);
                bitSet3.and(bitSet2);
                break;
            }
            case ARGMIN: {
                object2 = ExpressionFilter.applyMin(stateValues.filtered(bitSet2), stateValues.getType());
                this.mainLog.print("\nMinimum value over " + string + ": " + String.valueOf(object2));
                bitSet3 = stateValues.getBitSetFromCloseValue(object2);
                bitSet3.and(bitSet2);
                stateValues2 = StateValues.createFromBitSet(bitSet3, model);
                this.mainLog.println("\nNumber of states with minimum value: " + bitSet3.cardinality());
                bitSet3 = null;
                break;
            }
            case ARGMAX: {
                object2 = ExpressionFilter.applyMax(stateValues.filtered(bitSet2), stateValues.getType());
                this.mainLog.print("\nMaximum value over " + string + ": " + String.valueOf(object2));
                bitSet3 = stateValues.getBitSetFromCloseValue(object2);
                bitSet3.and(bitSet2);
                stateValues2 = StateValues.createFromBitSet(bitSet3, model);
                this.mainLog.println("\nNumber of states with maximum value: " + bitSet3.cardinality());
                bitSet3 = null;
                break;
            }
            case COUNT: {
                object2 = expressionFilter.apply(stateValues.filtered(bitSet2));
                stateValues2 = StateValues.createFromSingleValue(expressionFilter.getType(), object2, model);
                object = bl ? "Count of satisfying states" : "Count of satisfying states also in filter";
                this.mainLog.println("\n" + (String)object + ": " + String.valueOf(object2));
                break;
            }
            case SUM: {
                object2 = expressionFilter.apply(stateValues.filtered(bitSet2));
                stateValues2 = StateValues.createFromSingleValue(expressionFilter.getType(), object2, model);
                object = "Sum over " + string;
                this.mainLog.println("\n" + (String)object + ": " + String.valueOf(object2));
                break;
            }
            case AVG: {
                object2 = expressionFilter.apply(stateValues.filtered(bitSet2));
                stateValues2 = StateValues.createFromSingleValue(expressionFilter.getType(), object2, model);
                object = "Average over " + string;
                this.mainLog.println("\n" + (String)object + ": " + String.valueOf(object2));
                break;
            }
            case FIRST: {
                object2 = stateValues.firstFromBitSet(bitSet2);
                stateValues2 = StateValues.createFromSingleValue(expressionFilter.getType(), object2, model);
                object = "Value in ";
                object = bl2 ? (String)object + (bl3 ? "the initial state" : "first initial state") : (String)object + (bl ? "the first state" : "first state satisfying filter");
                this.mainLog.println("\n" + (String)object + ": " + String.valueOf(object2));
                break;
            }
            case RANGE: {
                object2 = expressionFilter.apply(stateValues.filtered(bitSet2));
                stateValues2 = stateValues;
                stateValues = null;
                object = "Range of values over ";
                object = (String)object + (bl2 ? "initial states" : string);
                this.mainLog.println("\n" + (String)object + ": " + String.valueOf(object2));
                break;
            }
            case FORALL: {
                bitSet4 = stateValues.getBitSet();
                if (bitSet4 == null) {
                    this.mainLog.print("\nPareto set computation result evaluated");
                    object2 = stateValues.getParetoArray();
                    stateValues2 = StateValues.createFromSingleValue(expressionFilter.getType(), true, model);
                    break;
                }
                bl4 = (Boolean)expressionFilter.apply(stateValues.filtered(bitSet2));
                object2 = bl4;
                stateValues2 = StateValues.createFromSingleValue(expressionFilter.getType(), object2, model);
                object = "Property " + (bl4 ? "" : "not ") + "satisfied in ";
                this.mainLog.print("\nProperty satisfied in " + String.valueOf(ExpressionFilter.applyCount(stateValues.filtered(bitSet2), stateValues.getType())));
                if (bl2) {
                    object = bl3 ? (String)object + "the initial state" : (String)object + "all initial states";
                    this.mainLog.println(" of " + model.getNumInitialStates() + " initial states.");
                    break;
                }
                if (bl) {
                    object = (String)object + "all states";
                    this.mainLog.println(" of all " + model.getNumStates() + " states.");
                    break;
                }
                object = (String)object + "all filter states";
                this.mainLog.println(" of " + bitSet2.cardinality() + " filter states.");
                break;
            }
            case EXISTS: {
                bitSet4 = stateValues.getBitSet();
                bl4 = (Boolean)expressionFilter.apply(stateValues.filtered(bitSet2));
                object2 = bl4;
                stateValues2 = StateValues.createFromSingleValue(expressionFilter.getType(), object2, model);
                object = "Property satisfied in ";
                object = bl ? (String)object + (bl4 ? "at least one state" : "no states") : (String)object + (bl4 ? "at least one filter state" : "no filter states");
                this.mainLog.println("\n" + (String)object);
                break;
            }
            case STATE: {
                object2 = stateValues.firstFromBitSet(bitSet2);
                accuracy = stateValues.accuracy;
                stateValues2 = StateValues.createFromSingleValue(expressionFilter.getType(), object2, model);
                object = "Value in ";
                object = bl2 ? (String)object + "the initial state" : (String)object + "the filter state";
                this.mainLog.println("\n" + (String)object + ": " + String.valueOf(object2));
                break;
            }
            default: {
                throw new PrismException("Unrecognised filter type \"" + expressionFilter.getOperatorName() + "\"");
            }
        }
        if (bitSet3 != null) {
            boolean bl5;
            StateValues stateValues3 = StateValues.createFromBitSet(bitSet3, model);
            this.mainLog.print("\nThere are " + bitSet3.cardinality() + " states with ");
            this.mainLog.print((expressionFilter.getType() instanceof TypeDouble ? "(approximately) " : "") + "this value");
            boolean bl6 = bl5 = this.verbosity > 0;
            if (!bl5 && bitSet3.cardinality() > 10) {
                this.mainLog.print(".\nThe first 10 states are displayed below. To view them all, enable verbose mode or use a print filter.\n");
                stateValues3.print(this.mainLog, 10);
            } else {
                this.mainLog.print(":\n");
                stateValues3.print(this.mainLog);
            }
        }
        this.result.setResult(object2);
        this.result.setParameterString(this.parsed_params != null ? this.parsed_params.getParameterString() : null);
        this.result.setAccuracy(accuracy);
        if (expressionFilter.getExplanationEnabled() && object != null) {
            this.result.setExplanation(((String)object).toLowerCase());
        } else {
            this.result.setExplanation(null);
        }
        if (filterOperator == ExpressionFilter.FilterOperator.STORE) {
            this.result.setVector(stateValues2);
        }
        if (stateValues != null && !Expression.isFilter(expressionFilter.getOperand(), ExpressionFilter.FilterOperator.STORE)) {
            stateValues.clear();
        }
        return stateValues2;
    }

    public Expression handleMaximalStateFormulas(ModelExplicit<?> modelExplicit, Expression expression) throws PrismException {
        Vector<BitSet> vector = new Vector<BitSet>();
        LTLModelChecker lTLModelChecker = new LTLModelChecker(this);
        Expression expression2 = lTLModelChecker.checkMaximalStateFormulas(this, modelExplicit, expression.deepCopy(), vector);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < vector.size(); ++i) {
            String string = "L" + i;
            String string2 = modelExplicit.addUniqueLabel("phi", vector.get(i), this.getDefinedLabelNames());
            hashMap.put(string, string2);
        }
        return (Expression)expression2.accept(new ReplaceLabels(hashMap));
    }

    public Expression checkMaximalPropositionalFormulas(Model<?> model, Expression expression, List<String> list, List<BitSet> list2) throws PrismException {
        Expression expression2 = (Expression)expression.accept(new CheckMaximalPropositionalFormulas(this, model, list, list2));
        return expression2;
    }

    protected <Value> Rewards<Value> constructRewards(Model<Value> model, int n) throws PrismException {
        return this.constructRewards(model, n, model.getModelType() == ModelType.CSG);
    }

    protected <Value> Rewards<Value> constructRewards(Model<Value> model, int n, boolean bl) throws PrismException {
        ConstructRewards constructRewards = new ConstructRewards(this);
        if (bl) {
            constructRewards.allowNegativeRewards();
        }
        return constructRewards.buildRewardStructure(model, this.rewardGen, n);
    }

    protected <Value> Rewards<Value> constructExpectedRewards(Model<Value> model, int n) throws PrismException {
        if (model.getModelType() == ModelType.IDTMC && this.rewardGen.rewardStructHasTransitionRewards(n)) {
            throw new PrismNotSupportedException("Transition rewards not supported for " + String.valueOf((Object)model.getModelType()) + "s");
        }
        ConstructRewards constructRewards = new ConstructRewards(this);
        constructRewards.setExpectedRewards(true);
        if (model.getModelType() == ModelType.CSG) {
            constructRewards.allowNegativeRewards();
        }
        return constructRewards.buildRewardStructure(model, this.rewardGen, n);
    }

    public static Map<String, BitSet> loadLabelsFile(String string) throws PrismException {
        PrismExplicitImporter prismExplicitImporter = new PrismExplicitImporter(null, null, new File(string), null, null, null);
        return prismExplicitImporter.extractAllLabels();
    }

    public <Value> void exportModel(Model<Value> model, ModelExportTask modelExportTask) throws PrismException {
        Object object;
        ModelExporter modelExporter;
        ModelExportOptions modelExportOptions = modelExportTask.getExportOptions();
        switch (modelExportOptions.getFormat()) {
            case EXPLICIT: {
                if (modelExportOptions.getExplicitRows()) {
                    throw new PrismNotSupportedException("Export in rows format not yet supported by explicit engine");
                }
                modelExporter = new PrismExplicitExporter(modelExportOptions);
                break;
            }
            case DOT: {
                modelExporter = new DotExporter(modelExportOptions);
                break;
            }
            case DRN: {
                modelExporter = new DRNExporter(modelExportOptions);
                break;
            }
            case UMB: {
                modelExporter = new UMBExporter(modelExportOptions);
                break;
            }
            default: {
                throw new PrismNotSupportedException("Export " + modelExportOptions.getFormat().description() + " not supported by explicit engine");
            }
        }
        modelExporter.setModelInfo(this.modelInfo);
        File file = modelExportTask.getFile();
        if (modelExportOptions.getFormat().isBinary() && !modelExportOptions.getBinaryAsText() && file == null) {
            throw new PrismNotSupportedException("Export " + modelExportOptions.getFormat().description() + " must be to a file");
        }
        if (modelExportOptions.getFormat() == ModelExportFormat.DRN || modelExportOptions.getFormat() == ModelExportFormat.UMB) {
            object = new ArrayList();
            for (int i = 0; i < this.rewardGen.getNumRewardStructs(); ++i) {
                object.add(this.constructRewards(model, i, true));
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            if (modelExportTask.initLabelIncluded()) {
                arrayList.add("init");
            }
            if (modelExportTask.deadlockLabelIncluded() && model.getNumDeadlockStates() > 0) {
                arrayList.add("deadlock");
            }
            arrayList.addAll(this.modelInfo.getLabelNames());
            List<BitSet> list = this.checkLabels(model, arrayList);
            modelExporter.addRewards(object, this.rewardGen.getRewardStructNames());
            modelExporter.setRewardEvaluator(this.rewardGen.getRewardEvaluator());
            modelExporter.addLabels(list, arrayList);
        }
        if (modelExportOptions.getFormat().isBinary() && !modelExportOptions.getBinaryAsText()) {
            modelExporter.exportModel(model, file);
        } else {
            object = this.getPrismLogForFile(file);
            try {
                modelExporter.exportModel(model, (PrismLog)object);
            }
            finally {
                if (object != null) {
                    ((PrismLog)object).close();
                }
            }
        }
    }

    public <Value> void exportTransitions(Model<Value> model, File file, ModelExportOptions modelExportOptions) throws PrismException {
        this.exportModel(model, ModelExportTask.fromOptions(file, modelExportOptions));
    }

    public <Value> void exportStateRewards(Model<Value> model, int n, File file, ModelExportOptions modelExportOptions) throws PrismException {
        if (modelExportOptions.getFormat() != ModelExportFormat.EXPLICIT) {
            throw new PrismNotSupportedException("Exporting state rewards in the requested format is currently not supported by the explicit engine");
        }
        try (PrismLog prismLog = this.getPrismLogForFile(file);){
            Rewards<Value> rewards = this.constructRewards(model, n, true);
            PrismExplicitExporter<Value> prismExplicitExporter = new PrismExplicitExporter<Value>(modelExportOptions);
            prismExplicitExporter.exportStateRewards(model, rewards, this.rewardGen.getRewardStructName(n), prismLog);
        }
    }

    public <Value> void exportTransRewards(Model<Value> model, int n, File file, ModelExportOptions modelExportOptions) throws PrismException {
        if (modelExportOptions.getFormat() != ModelExportFormat.EXPLICIT) {
            throw new PrismNotSupportedException("Exporting transition rewards in the requested format is currently not supported by the explicit engine");
        }
        try (PrismLog prismLog = this.getPrismLogForFile(file);){
            Rewards<Value> rewards = this.constructRewards(model, n, true);
            PrismExplicitExporter<Value> prismExplicitExporter = new PrismExplicitExporter<Value>(modelExportOptions);
            prismExplicitExporter.exportTransRewards(model, rewards, this.rewardGen.getRewardStructName(n), prismLog);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <Value> void exportStates(Model<Value> model, File file, ModelExportOptions modelExportOptions) throws PrismException {
        try (PrismLog prismLog = this.getPrismLogForFile(file);){
            switch (modelExportOptions.getFormat()) {
                case EXPLICIT: {
                    new PrismExplicitExporter<Value>(modelExportOptions).exportStates(model, this.modelInfo.createVarList(), prismLog);
                    return;
                }
                case MATLAB: {
                    new MatlabExporter<Value>(modelExportOptions).exportStates(model, this.modelInfo.createVarList(), prismLog);
                    return;
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <Value> void exportObservations(Model<Value> model, File file, ModelExportOptions modelExportOptions) throws PrismException {
        try (PrismLog prismLog = this.getPrismLogForFile(file);){
            switch (modelExportOptions.getFormat()) {
                case EXPLICIT: {
                    new PrismExplicitExporter(modelExportOptions).exportObservations((PartiallyObservableModel)model, this.modelInfo, prismLog);
                    return;
                }
                case MATLAB: {
                    new MatlabExporter(modelExportOptions).exportObservations((PartiallyObservableModel)model, this.modelInfo, prismLog);
                    return;
                }
            }
            return;
        }
    }

    public <Value> void exportLabels(Model<Value> model, List<String> list, File file, ModelExportOptions modelExportOptions) throws PrismException {
        List<BitSet> list2 = this.checkLabels(model, list);
        this.exportLabels(model, list, list2, file, modelExportOptions);
    }

    private List<BitSet> checkLabels(Model<?> model, List<String> list) throws PrismException {
        ArrayList<BitSet> arrayList = new ArrayList<BitSet>();
        for (String string : list) {
            StateValues stateValues = this.checkExpression(model, new ExpressionLabel(string), null);
            arrayList.add(stateValues.getBitSet());
        }
        return arrayList;
    }

    public <Value> void exportLabels(Model<Value> model, List<String> list, List<BitSet> list2, File file, ModelExportFormat modelExportFormat) throws PrismException {
        this.exportLabels(model, list, list2, file, new ModelExportOptions(modelExportFormat));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <Value> void exportLabels(Model<Value> model, List<String> list, List<BitSet> list2, File file, ModelExportOptions modelExportOptions) throws PrismException {
        try (PrismLog prismLog = this.getPrismLogForFile(file);){
            switch (modelExportOptions.getFormat()) {
                case EXPLICIT: {
                    new PrismExplicitExporter<Value>(modelExportOptions).exportLabels(model, list, list2, prismLog);
                    return;
                }
                case MATLAB: {
                    new MatlabExporter<Value>(modelExportOptions).exportLabels(model, list, list2, prismLog);
                    return;
                }
            }
            return;
        }
    }

    public void doProductExports(Product<?> product) throws PrismException {
        if (this.getExportProductTrans()) {
            this.mainLog.println("\nExporting product transition matrix to file \"" + this.getExportProductTransFilename() + "\"...");
            int n = this.settings.getInteger("prism.exportModelPrecision");
            product.getProductModel().exportToPrismExplicitTra(this.getExportProductTransFilename(), n);
        }
        if (this.getExportProductStates()) {
            this.mainLog.println("\nExporting product state space to file \"" + this.getExportProductStatesFilename() + "\"...");
            PrismFileLog prismFileLog = new PrismFileLog(this.getExportProductStatesFilename());
            VarList varList = (VarList)this.modelInfo.createVarList().clone();
            Object object = "_da";
            while (varList.exists((String)object)) {
                object = "_" + (String)object;
            }
            varList.addVarAtStart(new Declaration((String)object, new DeclarationIntUnbounded()), 1);
            product.getProductModel().exportStates(varList, prismFileLog, new ModelExportOptions());
            prismFileLog.close();
        }
    }

    class CheckMaximalPropositionalFormulas
    extends ASTTraverseModify {
        private StateModelChecker mc;
        private Model<?> model;
        private List<String> propNames;
        private List<BitSet> propBSs;

        public CheckMaximalPropositionalFormulas(StateModelChecker stateModelChecker2, Model<?> model, List<String> list, List<BitSet> list2) {
            this.mc = stateModelChecker2;
            this.model = model;
            this.propNames = list;
            this.propBSs = list2;
        }

        @Override
        public Object visit(ExpressionITE expressionITE) throws PrismLangException {
            return expressionITE.getType() instanceof TypeBool && expressionITE.isProposition() ? this.replaceWithLabel(expressionITE) : super.visit(expressionITE);
        }

        @Override
        public Object visit(ExpressionBinaryOp expressionBinaryOp) throws PrismLangException {
            return expressionBinaryOp.getType() instanceof TypeBool && expressionBinaryOp.isProposition() ? this.replaceWithLabel(expressionBinaryOp) : super.visit(expressionBinaryOp);
        }

        @Override
        public Object visit(ExpressionUnaryOp expressionUnaryOp) throws PrismLangException {
            return expressionUnaryOp.getType() instanceof TypeBool && expressionUnaryOp.isProposition() ? this.replaceWithLabel(expressionUnaryOp) : super.visit(expressionUnaryOp);
        }

        @Override
        public Object visit(ExpressionFunc expressionFunc) throws PrismLangException {
            return expressionFunc.getType() instanceof TypeBool && expressionFunc.isProposition() ? this.replaceWithLabel(expressionFunc) : super.visit(expressionFunc);
        }

        @Override
        public Object visit(ExpressionIdent expressionIdent) throws PrismLangException {
            return expressionIdent.getType() instanceof TypeBool && expressionIdent.isProposition() ? this.replaceWithLabel(expressionIdent) : super.visit(expressionIdent);
        }

        @Override
        public Object visit(ExpressionLiteral expressionLiteral) throws PrismLangException {
            return expressionLiteral.getType() instanceof TypeBool && expressionLiteral.isProposition() ? this.replaceWithLabel(expressionLiteral) : super.visit(expressionLiteral);
        }

        @Override
        public Object visit(ExpressionConstant expressionConstant) throws PrismLangException {
            return expressionConstant.getType() instanceof TypeBool && expressionConstant.isProposition() ? this.replaceWithLabel(expressionConstant) : super.visit(expressionConstant);
        }

        @Override
        public Object visit(ExpressionFormula expressionFormula) throws PrismLangException {
            return expressionFormula.getType() instanceof TypeBool && expressionFormula.isProposition() ? this.replaceWithLabel(expressionFormula) : super.visit(expressionFormula);
        }

        @Override
        public Object visit(ExpressionVar expressionVar) throws PrismLangException {
            return expressionVar.getType() instanceof TypeBool && expressionVar.isProposition() ? this.replaceWithLabel(expressionVar) : super.visit(expressionVar);
        }

        @Override
        public Object visit(ExpressionLabel expressionLabel) throws PrismLangException {
            return expressionLabel.getType() instanceof TypeBool && expressionLabel.isProposition() ? this.replaceWithLabel(expressionLabel) : super.visit(expressionLabel);
        }

        @Override
        public Object visit(ExpressionProp expressionProp) throws PrismLangException {
            Property property = StateModelChecker.this.propertiesFile.lookUpPropertyObjectByName(expressionProp.getName());
            if (property != null) {
                return expressionProp.accept(this);
            }
            throw new PrismLangException("Unknown property reference " + String.valueOf(expressionProp), expressionProp);
        }

        @Override
        public Object visit(ExpressionFilter expressionFilter) throws PrismLangException {
            return expressionFilter.getType() instanceof TypeBool && expressionFilter.isProposition() ? this.replaceWithLabel(expressionFilter) : super.visit(expressionFilter);
        }

        private Object replaceWithLabel(Expression expression) throws PrismLangException {
            StateValues stateValues;
            try {
                stateValues = this.mc.checkExpression(this.model, expression, null);
            }
            catch (PrismException prismException) {
                throw new PrismLangException(prismException.getMessage());
            }
            BitSet bitSet = stateValues.getBitSet();
            if (bitSet.isEmpty()) {
                return Expression.False();
            }
            if (bitSet.cardinality() == this.model.getNumStates()) {
                return Expression.True();
            }
            int n = this.propBSs.indexOf(bitSet);
            if (n != -1) {
                stateValues.clear();
                return new ExpressionLabel("L" + n);
            }
            String string = "L" + this.propBSs.size();
            this.propNames.add(string);
            this.propBSs.add(bitSet);
            return new ExpressionLabel(string);
        }
    }
}

