/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import prism.PrismException;

public class Partition {
    private List<List<Integer>> partition;
    private Map<Integer, Integer> f;
    private List<Double> weightsP1;
    private List<Double> weightsP2;
    public BitSet marked;

    public Partition() {
        this.partition = new ArrayList<List<Integer>>();
        this.f = new HashMap<Integer, Integer>();
        this.marked = new BitSet();
    }

    public Partition(int n) {
        this.partition = new ArrayList<List<Integer>>(n);
        this.f = new HashMap<Integer, Integer>();
        this.marked = new BitSet(n);
    }

    public Partition(Partition partition) {
        this(partition.partition);
        this.marked = new BitSet(partition.marked.size());
        this.marked.or(partition.marked);
    }

    public Partition(List<List<Integer>> list) {
        this();
        int n = 0;
        for (List<Integer> list2 : list) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (Integer n2 : list2) {
                this.f.put(n2, n);
                arrayList.add(n2);
            }
            this.partition.add(arrayList);
            ++n;
        }
    }

    public void clear() {
        this.partition.clear();
        this.f.clear();
    }

    public int size() {
        return this.partition.size();
    }

    public int size(int n) {
        return this.partition.get(n).size();
    }

    public Iterator<Integer> getComponent(int n) throws PrismException {
        if (this.partition.get(n) == null || this.partition.get(n).size() == 0) {
            throw new PrismException("Empty component");
        }
        return this.partition.get(n).iterator();
    }

    public Iterator<List<Integer>> iterator() {
        return this.partition.iterator();
    }

    public List<Double> getWeightsP1() {
        return this.weightsP1;
    }

    public List<Double> getWeightsP2() {
        return this.weightsP2;
    }

    public void setWeightsP1(List<Double> list) {
        this.weightsP1 = list;
    }

    public void setWeightsP2(List<Double> list) {
        this.weightsP2 = list;
    }

    public int get(int n, int n2) {
        return this.partition.get(n).get(n2);
    }

    public List<Integer> get(int n) {
        return this.partition.get(n);
    }

    public void merge() {
        Partition partition = new Partition();
        int n = -1;
        int n2 = 0;
        for (List<Integer> list : this.partition) {
            if (!this.marked.get(n2)) {
                partition.add(list);
                n = n2;
                break;
            }
            ++n2;
        }
        if (n < 0) {
            for (List<Integer> list : this.partition) {
                if (partition.size() == 0) {
                    partition.add(list);
                    continue;
                }
                partition.add(0, list);
            }
        } else {
            n2 = 0;
            for (List<Integer> list : this.partition) {
                if (this.marked.get(n2) && partition.size() == 1) {
                    partition.add(list);
                } else if (this.marked.get(n2)) {
                    partition.add(1, list);
                } else if (n2 != n) {
                    partition.add(0, list);
                }
                ++n2;
            }
        }
        this.weightsP1.clear();
        this.weightsP2.clear();
        this.partition = partition.partition;
        this.f = partition.f;
    }

    public void mergeUnmarked() {
        Partition partition = new Partition();
        int n = -1;
        int n2 = 0;
        for (List<Integer> list : this.partition) {
            if (!this.marked.get(n2)) {
                partition.add(list);
                n = n2;
                break;
            }
            ++n2;
        }
        n2 = 0;
        for (List<Integer> list : this.partition) {
            if (this.marked.get(n2)) {
                partition.add(list);
            } else if (n2 != n) {
                partition.add(0, list);
            }
            ++n2;
        }
        if (this.weightsP1 != null) {
            this.weightsP1.clear();
        }
        if (this.weightsP2 != null) {
            this.weightsP2.clear();
        }
        this.partition = partition.partition;
        this.f = partition.f;
    }

    public Map<Integer, Integer> getf() {
        return this.f;
    }

    public Map<Integer, Integer> getf(Map<Integer, Integer> map) throws PrismException {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, Integer> entry : this.f.entrySet()) {
            int n = entry.getValue();
            int n2 = map.get(entry.getKey());
            if (hashMap.get(n2) == null) {
                hashMap.put(n2, n);
                continue;
            }
            if ((Integer)hashMap.get(n2) == n) continue;
            throw new PrismException("Partition is not a valid refinement");
        }
        return hashMap;
    }

    public boolean add(List<Integer> list) {
        for (Integer n : list) {
            this.f.put(n, this.partition.size());
        }
        return this.partition.add(list);
    }

    public boolean add(int n, List<Integer> list) {
        for (Integer n2 : list) {
            this.f.put(n2, n);
        }
        return this.partition.get(n).addAll(list);
    }

    public boolean add(int n, int n2) {
        this.f.put(n2, n);
        if (this.partition.size() <= n) {
            for (int i = this.partition.size(); i <= n; ++i) {
                this.partition.add(new ArrayList());
            }
        }
        return this.partition.get(n).add(n2);
    }

    public void split(int n, Partition partition) {
        this.split(n, partition, false);
    }

    public void split(int n, Partition partition, boolean bl) {
        Iterator<Double> iterator = null;
        Iterator<Double> iterator2 = null;
        if (bl) {
            int n2;
            if (this.weightsP1 == null) {
                this.weightsP1 = new ArrayList<Double>();
                for (n2 = 0; n2 < this.partition.size() + partition.size() - 1; ++n2) {
                    this.weightsP1.add(0.0);
                }
            }
            if (this.weightsP2 == null) {
                this.weightsP2 = new ArrayList<Double>();
                for (n2 = 0; n2 < this.partition.size() + partition.size() - 1; ++n2) {
                    this.weightsP2.add(0.0);
                }
            }
            this.weightsP1.remove(n);
            this.weightsP2.remove(n);
            iterator = partition.weightsP1.iterator();
            iterator2 = partition.weightsP2.iterator();
        }
        this.partition.remove(n);
        Iterator<List<Integer>> iterator3 = partition.iterator();
        boolean bl2 = true;
        while (iterator3.hasNext()) {
            List<Integer> list = iterator3.next();
            if (bl2) {
                this.partition.add(n, list);
                if (bl) {
                    this.weightsP1.add(n, iterator.next());
                    this.weightsP2.add(n, iterator2.next());
                }
                bl2 = false;
                for (Integer n3 : list) {
                    this.f.put(n3, n);
                }
                continue;
            }
            if (bl) {
                this.weightsP1.add(iterator.next());
                this.weightsP2.add(iterator2.next());
            }
            this.partition.add(list);
            for (Integer n3 : list) {
                this.f.put(n3, this.partition.size() - 1);
            }
        }
    }

    public String toString() {
        Object object = "[";
        boolean bl = true;
        for (int i = 0; i < this.partition.size(); ++i) {
            String string;
            List<Integer> list = this.partition.get(i);
            if (!bl) {
                object = (String)object + ", ";
            } else {
                bl = false;
            }
            String string2 = string = this.marked.get(i) ? "*" : "";
            object = this.weightsP1 != null && i < this.weightsP1.size() && this.weightsP2 != null && i < this.weightsP2.size() ? (String)object + String.format("%d(%f|%f)%s:%s", i, this.weightsP1.get(i), this.weightsP2.get(i), string, list.toString()) : (this.weightsP1 != null && i < this.weightsP1.size() ? (String)object + String.format("%d(%f|_)%s:%s", i, this.weightsP1.get(i), string, list.toString()) : (this.weightsP2 != null && i < this.weightsP2.size() ? (String)object + String.format("%d(_|%f)%s:%s", i, this.weightsP2.get(i), string, list.toString()) : (String)object + String.format("%d%s:%s", i, string, list.toString())));
        }
        return (String)object + "]";
    }
}

