/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.NondetModel;
import java.util.ArrayList;
import java.util.List;
import parser.State;
import prism.PrismException;

public class ObservationsSimple {
    protected int numStates;
    protected List<State> observationsList;
    protected List<State> unobservationsList;
    protected List<Integer> observationStates;
    protected List<Integer> observablesMap;
    protected List<Integer> unobservablesMap;

    public ObservationsSimple() {
        this.numStates = 0;
        this.observationsList = new ArrayList<State>();
        this.unobservationsList = new ArrayList<State>();
        this.observationStates = new ArrayList<Integer>();
        this.observablesMap = new ArrayList<Integer>();
        this.unobservablesMap = new ArrayList<Integer>();
    }

    public ObservationsSimple(int n) {
        this();
        this.addStates(n);
    }

    public ObservationsSimple(int n, int n2) {
        this();
        this.addStates(n);
        this.addObservations(n2);
    }

    public ObservationsSimple(ObservationsSimple observationsSimple) {
        this.numStates = observationsSimple.numStates;
        this.observationsList = new ArrayList<State>(observationsSimple.observationsList);
        this.unobservationsList = new ArrayList<State>(observationsSimple.unobservationsList);
        this.observationStates = new ArrayList<Integer>(observationsSimple.observationStates);
        this.observablesMap = new ArrayList<Integer>(observationsSimple.observablesMap);
        this.unobservablesMap = new ArrayList<Integer>(observationsSimple.unobservablesMap);
    }

    public ObservationsSimple(ObservationsSimple observationsSimple, int[] nArray) {
        int n;
        this.numStates = observationsSimple.numStates;
        this.observationsList = new ArrayList<State>(observationsSimple.observationsList);
        this.unobservationsList = new ArrayList<State>(observationsSimple.unobservationsList);
        int n2 = observationsSimple.observationsList.size();
        this.observationStates = new ArrayList<Integer>(n2);
        for (n = 0; n < n2; ++n) {
            int n3 = observationsSimple.observationStates.get(n);
            this.observationStates.add(n3 == -1 ? -1 : nArray[n3]);
        }
        this.observablesMap = new ArrayList<Integer>(this.numStates);
        this.unobservablesMap = new ArrayList<Integer>(this.numStates);
        for (n = 0; n < this.numStates; ++n) {
            this.observablesMap.add(-1);
            this.unobservablesMap.add(-1);
        }
        for (n = 0; n < this.numStates; ++n) {
            this.observablesMap.set(nArray[n], observationsSimple.observablesMap.get(n));
            this.unobservablesMap.set(nArray[n], observationsSimple.unobservablesMap.get(n));
        }
    }

    public void addObservations(int n) {
        for (int i = 0; i < n; ++i) {
            this.observationsList.add(null);
            this.observationStates.add(-1);
        }
    }

    public void clearState(int n) {
        this.observablesMap.set(n, -1);
        this.unobservablesMap.set(n, -1);
    }

    public void addStates(int n) {
        this.numStates += n;
        for (int i = 0; i < n; ++i) {
            this.observablesMap.add(-1);
            this.unobservablesMap.add(-1);
        }
    }

    public void setObservationsList(List<State> list) {
        this.observationsList = list;
    }

    public void setUnobservationsList(List<State> list) {
        this.unobservationsList = list;
    }

    public void setObservation(int n, State state, State state2, List<String> list, NondetModel nondetModel) throws PrismException {
        int n2 = this.observationsList.indexOf(state);
        if (n2 == -1) {
            this.observationsList.add(state);
            n2 = this.observationsList.size() - 1;
            this.observationStates.add(-1);
        }
        try {
            this.setObservation(n, n2, nondetModel);
        }
        catch (PrismException prismException) {
            String string = list == null ? state.toString() : state.toString(list);
            throw new PrismException("Problem with observation " + string + ": " + prismException.getMessage());
        }
        int n3 = this.unobservationsList.indexOf(state2);
        if (n3 == -1) {
            this.unobservationsList.add(state2);
            n3 = this.unobservationsList.size() - 1;
        }
        this.setUnobservation(n, n3);
    }

    protected void setObservation(int n, int n2, NondetModel nondetModel) throws PrismException {
        this.observablesMap.set(n, n2);
        int n3 = this.observationStates.get(n2);
        if (n3 == -1) {
            this.observationStates.set(n2, n);
        } else if (nondetModel != null) {
            nondetModel.checkActionsMatchExactly(n, n3);
        }
    }

    protected void setUnobservation(int n, int n2) {
        this.unobservablesMap.set(n, n2);
    }

    protected void setIdentityObservations() {
        for (int i = 0; i < this.numStates; ++i) {
            try {
                this.setObservation(i, i, null);
            }
            catch (PrismException prismException) {
                // empty catch block
            }
            this.unobservablesMap.set(i, null);
        }
    }

    public List<State> getObservationsList() {
        return this.observationsList;
    }

    public List<State> getUnobservationsList() {
        return this.unobservationsList;
    }

    public int getObservation(int n) {
        return this.observablesMap == null ? -1 : this.observablesMap.get(n);
    }

    public int getUnobservation(int n) {
        return this.unobservablesMap.get(n);
    }

    public int getObservationState(int n) {
        return this.observationStates.get(n);
    }
}

