/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import automata.LTL2NBA;
import common.IterableBitSet;
import common.IterableStateSet;
import common.iterable.FunctionalPrimitiveIterator;
import explicit.LTLModelChecker;
import explicit.LTSNBAProduct;
import explicit.Model;
import explicit.PredecessorRelation;
import explicit.Product;
import explicit.SCCComputer;
import explicit.SCCConsumerStore;
import explicit.StateModelChecker;
import explicit.StateValues;
import java.io.PrintStream;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Vector;
import jltl2dstar.NBA;
import parser.ast.Expression;
import parser.ast.ExpressionExists;
import parser.ast.ExpressionForAll;
import parser.ast.ExpressionTemporal;
import parser.ast.ExpressionUnaryOp;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismNotSupportedException;
import prism.PrismUtils;

public class NonProbModelChecker
extends StateModelChecker {
    public NonProbModelChecker(PrismComponent prismComponent) throws PrismException {
        super(prismComponent);
    }

    @Override
    public StateValues checkExpression(Model<?> model, Expression expression, BitSet bitSet) throws PrismException {
        if (expression instanceof ExpressionExists) {
            return this.checkExpressionExists(model, ((ExpressionExists)expression).getExpression(), bitSet);
        }
        if (expression instanceof ExpressionForAll) {
            return this.checkExpressionForAll(model, ((ExpressionForAll)expression).getExpression(), bitSet);
        }
        StateValues stateValues = super.checkExpression(model, expression, bitSet);
        return stateValues;
    }

    protected StateValues checkExpressionExists(Model<?> model, Expression expression, BitSet bitSet) throws PrismException {
        if (this.getSettings().getBoolean("prism.pathViaAutomata") || !expression.isSimplePathFormula()) {
            return this.checkExistsLTL(model, expression, bitSet);
        }
        if ((expression = Expression.convertSimplePathFormulaToCanonicalForm(expression)) instanceof ExpressionTemporal && ((ExpressionTemporal)expression).getOperator() == 1) {
            if (((ExpressionTemporal)expression).hasBounds()) {
                throw new PrismNotSupportedException("Model checking of bounded CTL operators is not supported");
            }
            return this.checkExistsNext(model, ((ExpressionTemporal)expression).getOperand2(), bitSet);
        }
        boolean bl = false;
        if (Expression.isNot(expression)) {
            bl = true;
            expression = ((ExpressionUnaryOp)expression).getOperand();
        }
        ExpressionTemporal expressionTemporal = (ExpressionTemporal)expression;
        assert (expressionTemporal.getOperator() == 2);
        if (expressionTemporal.hasBounds()) {
            throw new PrismNotSupportedException("Model checking of bounded CTL operators is not supported");
        }
        StateValues stateValues = bl ? this.checkExistsRelease(model, Expression.Not(expressionTemporal.getOperand1()), Expression.Not(expressionTemporal.getOperand2())) : this.checkExistsUntil(model, expressionTemporal.getOperand1(), expressionTemporal.getOperand2());
        return stateValues;
    }

    protected StateValues checkExpressionForAll(Model<?> model, Expression expression, BitSet bitSet) throws PrismException {
        StateValues stateValues = this.checkExpressionExists(model, Expression.Not(expression), bitSet);
        stateValues.complement();
        return stateValues;
    }

    protected StateValues checkExistsNext(Model<?> model, Expression expression, BitSet bitSet) throws PrismException {
        BitSet bitSet2 = this.checkExpression(model, expression, null).getBitSet();
        BitSet bitSet3 = this.computeExistsNext(model, bitSet2, bitSet);
        return StateValues.createFromBitSet(bitSet3, model);
    }

    public BitSet computeExistsNext(Model<?> model, BitSet bitSet, BitSet bitSet2) throws PrismException {
        BitSet bitSet3 = new BitSet();
        FunctionalPrimitiveIterator.OfInt ofInt = new IterableStateSet(bitSet2, model.getNumStates()).iterator();
        while (ofInt.hasNext()) {
            int n = (Integer)ofInt.next();
            if (!model.someSuccessorsInSet(n, bitSet)) continue;
            bitSet3.set(n);
        }
        return bitSet3;
    }

    protected StateValues checkForAllNext(Model<?> model, Expression expression, BitSet bitSet) throws PrismException {
        BitSet bitSet2 = this.checkExpression(model, expression, null).getBitSet();
        BitSet bitSet3 = new BitSet();
        FunctionalPrimitiveIterator.OfInt ofInt = new IterableStateSet(bitSet, model.getNumStates()).iterator();
        while (ofInt.hasNext()) {
            int n = (Integer)ofInt.next();
            if (!model.allSuccessorsInSet(n, bitSet2)) continue;
            bitSet3.set(n);
        }
        return StateValues.createFromBitSet(bitSet3, model);
    }

    public BitSet computeForAllNext(Model<?> model, BitSet bitSet, BitSet bitSet2) throws PrismException {
        BitSet bitSet3 = new BitSet();
        FunctionalPrimitiveIterator.OfInt ofInt = new IterableStateSet(bitSet2, model.getNumStates()).iterator();
        while (ofInt.hasNext()) {
            int n = (Integer)ofInt.next();
            if (!model.allSuccessorsInSet(n, bitSet)) continue;
            bitSet3.set(n);
        }
        return bitSet3;
    }

    protected StateValues checkExistsUntil(Model<?> model, Expression expression, Expression expression2) throws PrismException {
        BitSet bitSet = this.checkExpression(model, expression, null).getBitSet();
        BitSet bitSet2 = this.checkExpression(model, expression2, null).getBitSet();
        BitSet bitSet3 = this.computeExistsUntil(model, bitSet, bitSet2);
        return StateValues.createFromBitSet(bitSet3, model);
    }

    public BitSet computeExistsUntil(Model<?> model, BitSet bitSet, BitSet bitSet2) throws PrismException {
        PredecessorRelation predecessorRelation = model.getPredecessorRelation(this, true);
        return predecessorRelation.calculatePreStar(bitSet, bitSet2, bitSet2);
    }

    protected StateValues checkExistsGlobally(Model<?> model, Expression expression) throws PrismException {
        return this.checkExistsRelease(model, Expression.False(), expression);
    }

    public BitSet computeExistsGlobally(Model<?> model, BitSet bitSet) throws PrismException {
        return this.computeExistsRelease(model, new BitSet(), bitSet);
    }

    protected StateValues checkExistsRelease(Model<?> model, Expression expression, Expression expression2) throws PrismException {
        BitSet bitSet = this.checkExpression(model, expression, null).getBitSet();
        BitSet bitSet2 = this.checkExpression(model, expression2, null).getBitSet();
        PredecessorRelation predecessorRelation = model.getPredecessorRelation(this, true);
        BitSet bitSet3 = (BitSet)bitSet.clone();
        bitSet3.and(bitSet2);
        BitSet bitSet4 = (BitSet)bitSet2.clone();
        BitSet bitSet5 = (BitSet)bitSet4.clone();
        bitSet5.flip(0, model.getNumStates());
        int[] nArray = new int[model.getNumStates()];
        FunctionalPrimitiveIterator.OfInt ofInt = IterableBitSet.getSetBits(bitSet4).iterator();
        while (ofInt.hasNext()) {
            int n = (Integer)ofInt.next();
            if (bitSet3.get(n)) continue;
            int n2 = 0;
            Iterator<Integer> iterator = model.getSuccessorsIterator(n);
            while (iterator.hasNext()) {
                ++n2;
                iterator.next();
            }
            nArray[n] = n2;
        }
        while (!bitSet5.isEmpty()) {
            int n = bitSet5.nextSetBit(0);
            bitSet5.clear(n);
            for (int n2 : predecessorRelation.getPre(n)) {
                if (!bitSet4.get(n2)) continue;
                int n3 = n2;
                nArray[n3] = nArray[n3] - 1;
                if (nArray[n2] != 0 || bitSet3.get(n2)) continue;
                bitSet4.clear(n2);
                bitSet5.set(n2);
            }
        }
        return StateValues.createFromBitSet(bitSet4, model);
    }

    public BitSet computeExistsRelease(Model<?> model, BitSet bitSet, BitSet bitSet2) throws PrismException {
        PredecessorRelation predecessorRelation = model.getPredecessorRelation(this, true);
        BitSet bitSet3 = (BitSet)bitSet.clone();
        bitSet3.and(bitSet2);
        BitSet bitSet4 = (BitSet)bitSet2.clone();
        BitSet bitSet5 = new BitSet();
        bitSet5.set(0, model.getNumStates(), true);
        bitSet5.andNot(bitSet4);
        int[] nArray = new int[model.getNumStates()];
        FunctionalPrimitiveIterator.OfInt ofInt = IterableBitSet.getSetBits(bitSet4).iterator();
        while (ofInt.hasNext()) {
            int n = (Integer)ofInt.next();
            if (bitSet3.get(n)) continue;
            int n2 = 0;
            Iterator<Integer> iterator = model.getSuccessorsIterator(n);
            while (iterator.hasNext()) {
                ++n2;
                iterator.next();
            }
            nArray[n] = n2;
        }
        while (!bitSet5.isEmpty()) {
            int n = bitSet5.nextSetBit(0);
            bitSet5.clear(n);
            for (int n2 : predecessorRelation.getPre(n)) {
                if (!bitSet4.get(n2)) continue;
                int n3 = n2;
                nArray[n3] = nArray[n3] - 1;
                if (nArray[n2] != 0 || bitSet3.get(n2)) continue;
                bitSet4.clear(n2);
                bitSet5.set(n2);
            }
        }
        return bitSet4;
    }

    protected StateValues checkExistsLTL(Model<?> model, Expression expression, BitSet bitSet) throws PrismException {
        BitSet bitSet22;
        Object object;
        if (Expression.containsTemporalTimeBounds(expression)) {
            throw new PrismNotSupportedException("Time-bounded operators not supported in LTL: " + String.valueOf(expression));
        }
        LTLModelChecker lTLModelChecker = new LTLModelChecker(this);
        Vector<BitSet> vector = new Vector<BitSet>();
        expression = lTLModelChecker.checkMaximalStateFormulas(this, model, expression.deepCopy(), vector);
        this.mainLog.println("Non-probabilistic LTL model checking for E[ " + String.valueOf(expression) + " ]");
        this.mainLog.print("Constructing NBA...");
        this.mainLog.flush();
        LTL2NBA lTL2NBA = new LTL2NBA(this);
        NBA nBA = lTL2NBA.convertLTLFormulaToNBA(expression, this.getConstantValues());
        this.mainLog.println(" NBA has " + nBA.size() + " states");
        if (this.settings.getExportPropAut()) {
            this.mainLog.println("Exporting NBA to file \"" + this.settings.getExportPropAutFilename() + "\"...");
            object = PrismUtils.newPrintStream(this.settings.getExportPropAutFilename());
            nBA.print((PrintStream)object, this.settings.getExportPropAutType());
            ((PrintStream)object).close();
        }
        this.mainLog.print("Constructing " + String.valueOf((Object)model.getModelType()) + "-NBA product as LTS...");
        this.mainLog.flush();
        object = LTSNBAProduct.doProduct(model, nBA, bitSet, vector);
        this.mainLog.println(" " + ((Product)object).getProductModel().infoString() + ", " + ((LTSNBAProduct)object).getAcceptingStates().cardinality() + " states accepting");
        if (((LTSNBAProduct)object).getAcceptingStates().isEmpty()) {
            this.mainLog.print("None of the states in the product are accepting, skipping further computations");
            return StateValues.createFromBitSet(new BitSet(), model);
        }
        this.mainLog.print("Searching for non-trivial, accepting SCCs in product LTS...");
        this.mainLog.flush();
        SCCConsumerStore sCCConsumerStore = new SCCConsumerStore();
        SCCComputer sCCComputer = SCCComputer.createSCCComputer(this, ((Product)object).getProductModel(), sCCConsumerStore);
        sCCComputer.computeSCCs();
        int n = 0;
        int n2 = 0;
        BitSet bitSet3 = new BitSet();
        for (BitSet bitSet22 : sCCConsumerStore.getSCCs()) {
            ++n2;
            if (!bitSet22.intersects(((LTSNBAProduct)object).getAcceptingStates())) continue;
            bitSet3.or(bitSet22);
            ++n;
        }
        this.mainLog.println(" " + n + " of " + n2 + " non-trivial SCCs are accepting");
        BitSet bitSet4 = new BitSet();
        bitSet4.set(0, ((Product)object).getProductModel().getNumStates());
        this.mainLog.println("Computing reachability of accepting SCCs...");
        bitSet22 = this.computeExistsUntil((Model<?>)((Product)object).getProductModel(), bitSet4, bitSet3);
        StateValues stateValues = StateValues.createFromBitSet(bitSet22, ((Product)object).getProductModel());
        StateValues stateValues2 = ((Product)object).projectToOriginalModel(stateValues);
        return stateValues2;
    }
}

