/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.ChoiceActionsSimple;
import explicit.DTMCSimple;
import explicit.Distribution;
import explicit.MDP;
import explicit.MDPExplicit;
import explicit.NondetModelSimple;
import explicit.SuccessorsIterator;
import io.ExplicitModelImporter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import prism.Evaluator;
import prism.PrismException;

public class MDPSimple<Value>
extends MDPExplicit<Value>
implements NondetModelSimple<Value> {
    protected List<List<Distribution<Value>>> trans;
    protected ChoiceActionsSimple actions;
    protected boolean allowDupes = false;
    protected int numDistrs;
    protected int numTransitions;
    protected int maxNumDistrs;
    protected boolean maxNumDistrsOk;

    public MDPSimple() {
        this.initialise(0);
    }

    public MDPSimple(int n) {
        this.initialise(n);
    }

    public MDPSimple(MDPSimple<Value> mDPSimple) {
        this(mDPSimple.numStates);
        this.copyFrom(mDPSimple);
        for (int i = 0; i < this.numStates; ++i) {
            List<Distribution<Value>> list = this.trans.get(i);
            for (Distribution<Value> distribution : mDPSimple.trans.get(i)) {
                list.add(new Distribution<Value>(distribution));
            }
        }
        this.actions = new ChoiceActionsSimple(mDPSimple.actions);
        this.allowDupes = mDPSimple.allowDupes;
        this.numDistrs = mDPSimple.numDistrs;
        this.numTransitions = mDPSimple.numTransitions;
        this.maxNumDistrs = mDPSimple.maxNumDistrs;
        this.maxNumDistrsOk = mDPSimple.maxNumDistrsOk;
    }

    public MDPSimple(DTMCSimple<Value> dTMCSimple) {
        this(dTMCSimple.getNumStates());
        this.copyFrom(dTMCSimple);
        this.actionList.clear();
        for (int i = 0; i < this.numStates; ++i) {
            this.addChoice(i, new Distribution<Value>(dTMCSimple.getTransitions(i)));
        }
    }

    public MDPSimple(MDPSimple<Value> mDPSimple, int[] nArray) {
        this(mDPSimple.numStates);
        this.copyFrom(mDPSimple, nArray);
        for (int i = 0; i < this.numStates; ++i) {
            List<Distribution<Value>> list = this.trans.get(nArray[i]);
            for (Distribution<Value> distribution : mDPSimple.trans.get(i)) {
                list.add(new Distribution<Value>(distribution, nArray));
            }
        }
        this.actions = new ChoiceActionsSimple(mDPSimple.actions, nArray);
        this.allowDupes = mDPSimple.allowDupes;
        this.numDistrs = mDPSimple.numDistrs;
        this.numTransitions = mDPSimple.numTransitions;
        this.maxNumDistrs = mDPSimple.maxNumDistrs;
        this.maxNumDistrsOk = mDPSimple.maxNumDistrsOk;
    }

    public MDPSimple(MDP<Value> mDP) {
        this(mDP, object -> object);
    }

    public MDPSimple(MDP<Value> mDP, Function<? super Value, ? extends Value> function) {
        this(mDP, function, mDP.getEvaluator());
    }

    public <T> MDPSimple(MDP<T> mDP, Function<? super T, ? extends Value> function, Evaluator<Value> evaluator) {
        this(mDP.getNumStates());
        this.copyFrom(mDP);
        this.setEvaluator(evaluator);
        int n = this.getNumStates();
        for (int i = 0; i < n; ++i) {
            int n2 = mDP.getNumChoices(i);
            for (int j = 0; j < n2; ++j) {
                Object object = mDP.getAction(i, j);
                Distribution<Value> distribution = new Distribution<Value>(evaluator);
                Iterator<Map.Entry<Integer, T>> iterator = mDP.getTransitionsIterator(i, j);
                while (iterator.hasNext()) {
                    Map.Entry<Integer, T> entry = iterator.next();
                    distribution.set(entry.getKey(), function.apply(entry.getValue()));
                }
                if (distribution.isEmpty()) continue;
                if (object != null) {
                    this.addActionLabelledChoice(i, distribution, object);
                    continue;
                }
                this.addChoice(i, distribution);
            }
        }
    }

    @Override
    public void initialise(int n) {
        super.initialise(n);
        this.maxNumDistrs = 0;
        this.numTransitions = 0;
        this.numDistrs = 0;
        this.maxNumDistrsOk = true;
        this.trans = new ArrayList<List<Distribution<Value>>>(n);
        for (int i = 0; i < n; ++i) {
            this.trans.add(new ArrayList());
        }
        this.actions = new ChoiceActionsSimple();
    }

    @Override
    public void clearState(int n) {
        if (n >= this.numStates || n < 0) {
            return;
        }
        List<Distribution<Value>> list = this.trans.get(n);
        this.numDistrs -= list.size();
        for (Distribution<Value> distribution : list) {
            this.numTransitions -= distribution.size();
        }
        this.maxNumDistrsOk = false;
        this.trans.get(n).clear();
        this.actions.clearState(n);
        this.actionList.markNeedsRecomputing();
    }

    @Override
    public int addState() {
        this.addStates(1);
        return this.numStates - 1;
    }

    @Override
    public void addStates(int n) {
        for (int i = 0; i < n; ++i) {
            this.trans.add(new ArrayList());
            ++this.numStates;
        }
    }

    @Override
    public void buildFromExplicitImport(ExplicitModelImporter explicitModelImporter) throws PrismException {
        this.allowDupes = true;
        this.initialise(explicitModelImporter.getNumStates());
        explicitModelImporter.extractMDPTransitions((n, n2, n3, object, object2) -> {
            while (n2 >= this.getNumChoices(n)) {
                this.addChoice(n, new Distribution(this.getEvaluator()));
            }
            if (!this.getChoice(n, n2).add(n3, object)) {
                ++this.numTransitions;
            }
            if (object2 != null) {
                this.setAction(n, n2, object2);
            }
        }, this.getEvaluator());
        for (int i = 0; i < this.numStates; ++i) {
            for (Distribution<Value> distribution : this.getChoices(i)) {
                if (!distribution.isEmpty()) continue;
                throw new PrismException("Empty distribution in state " + i + " when importing transitions");
            }
        }
    }

    public int addChoice(int n, Distribution<Value> distribution) {
        int n2;
        if (n >= this.numStates || n < 0) {
            return -1;
        }
        if (!this.allowDupes && (n2 = this.indexOfChoice(n, distribution)) != -1) {
            return n2;
        }
        List<Distribution<Value>> list = this.trans.get(n);
        list.add(distribution);
        this.actionList.markNeedsRecomputing();
        ++this.numDistrs;
        this.maxNumDistrs = Math.max(this.maxNumDistrs, list.size());
        this.numTransitions += distribution.size();
        return list.size() - 1;
    }

    public int addActionLabelledChoice(int n, Distribution<Value> distribution, Object object) {
        int n2;
        if (n >= this.numStates || n < 0) {
            return -1;
        }
        if (!this.allowDupes && (n2 = this.indexOfActionLabelledChoice(n, distribution, object)) != -1) {
            return n2;
        }
        List<Distribution<Value>> list = this.trans.get(n);
        list.add(distribution);
        this.actions.setAction(n, list.size() - 1, object);
        this.actionList.markNeedsRecomputing();
        ++this.numDistrs;
        this.maxNumDistrs = Math.max(this.maxNumDistrs, list.size());
        this.numTransitions += distribution.size();
        return list.size() - 1;
    }

    public void setAction(int n, int n2, Object object) {
        this.actions.setAction(n, n2, object);
        this.actionList.markNeedsRecomputing();
    }

    @Override
    public List<Object> findActionsUsed() {
        return this.actions.findActionsUsed(this.getNumStates(), this::getNumChoices);
    }

    @Override
    public boolean onlyNullActionUsed() {
        return this.actions.onlyNullActionUsed();
    }

    @Override
    public int getNumTransitions() {
        return this.numTransitions;
    }

    @Override
    public int getNumTransitions(int n) {
        int n2 = 0;
        int n3 = this.getNumChoices(n);
        for (int i = 0; i < n3; ++i) {
            n2 += this.trans.get(n).get(i).size();
        }
        return n2;
    }

    @Override
    public void findDeadlocks(boolean bl) throws PrismException {
        int n = 0;
        for (int i = 0; i < this.numStates; ++i) {
            if (!this.trans.get(i).isEmpty()) continue;
            this.addDeadlockState(i);
            if (!bl) continue;
            Distribution distribution = new Distribution(this.getEvaluator());
            distribution.add(i, this.getEvaluator().one());
            this.addChoice(i, distribution);
            ++n;
        }
        if (n > 0) {
            this.actionList.addAction(null);
        }
    }

    @Override
    public void checkForDeadlocks(BitSet bitSet) throws PrismException {
        for (int i = 0; i < this.numStates; ++i) {
            if (!this.trans.get(i).isEmpty() || bitSet != null && bitSet.get(i)) continue;
            throw new PrismException("MDP has a deadlock in state " + i);
        }
    }

    @Override
    public int getNumChoices(int n) {
        return this.trans.get(n).size();
    }

    @Override
    public int getMaxNumChoices() {
        if (!this.maxNumDistrsOk) {
            this.maxNumDistrs = 0;
            for (int i = 0; i < this.numStates; ++i) {
                this.maxNumDistrs = Math.max(this.maxNumDistrs, this.getNumChoices(i));
            }
        }
        return this.maxNumDistrs;
    }

    @Override
    public int getNumChoices() {
        return this.numDistrs;
    }

    @Override
    public Object getAction(int n, int n2) {
        return this.actions.getAction(n, n2);
    }

    @Override
    public boolean allSuccessorsInSet(int n, int n2, BitSet bitSet) {
        return this.trans.get(n).get(n2).isSubsetOf(bitSet);
    }

    @Override
    public boolean someSuccessorsInSet(int n, int n2, BitSet bitSet) {
        return this.trans.get(n).get(n2).containsOneOf(bitSet);
    }

    @Override
    public Iterator<Integer> getSuccessorsIterator(int n, int n2) {
        return this.trans.get(n).get(n2).getSupport().iterator();
    }

    @Override
    public SuccessorsIterator getSuccessors(int n, int n2) {
        return SuccessorsIterator.from(this.getSuccessorsIterator(n, n2), true);
    }

    @Override
    public int getNumTransitions(int n, int n2) {
        return this.trans.get(n).get(n2).size();
    }

    @Override
    public Iterator<Map.Entry<Integer, Value>> getTransitionsIterator(int n, int n2) {
        return this.trans.get(n).get(n2).iterator();
    }

    public List<Distribution<Value>> getChoices(int n) {
        return this.trans.get(n);
    }

    public Distribution<Value> getChoice(int n, int n2) {
        return this.trans.get(n).get(n2);
    }

    public int indexOfChoice(int n, Distribution<Value> distribution) {
        return this.trans.get(n).indexOf(distribution);
    }

    public int indexOfActionLabelledChoice(int n, Distribution<Value> distribution, Object object) {
        List<Distribution<Value>> list = this.trans.get(n);
        int n2 = list.size();
        if (distribution == null) {
            for (int i = 0; i < n2; ++i) {
                if (list.get(i) != null) continue;
                Object object2 = this.getAction(n, i);
                if (!(object == null ? object2 == null : object.equals(object2))) continue;
                return i;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                if (!distribution.equals(list.get(i))) continue;
                Object object3 = this.getAction(n, i);
                if (!(object == null ? object3 == null : object.equals(object3))) continue;
                return i;
            }
        }
        return -1;
    }

    public String toString() {
        Object object = "";
        object = "[ ";
        for (int i = 0; i < this.numStates; ++i) {
            if (i > 0) {
                object = (String)object + ", ";
            }
            object = (String)object + i + ": ";
            object = (String)object + "[";
            int n = this.getNumChoices(i);
            for (int j = 0; j < n; ++j) {
                Object object2;
                if (j > 0) {
                    object = (String)object + ",";
                }
                if ((object2 = this.getAction(i, j)) != null) {
                    object = (String)object + String.valueOf(object2) + ":";
                }
                object = (String)object + String.valueOf(this.trans.get(i).get(j));
            }
            object = (String)object + "]";
        }
        object = (String)object + " ]\n";
        return object;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof MDPSimple)) {
            return false;
        }
        MDPSimple mDPSimple = (MDPSimple)object;
        if (this.numStates != mDPSimple.numStates) {
            return false;
        }
        if (!this.initialStates.equals(mDPSimple.initialStates)) {
            return false;
        }
        return this.trans.equals(mDPSimple.trans);
    }
}

