/*
 * Decompiled with CFR 0.152.
 */
package csv;

import csv.BasicReader;
import csv.CsvFormatException;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CsvReader
implements AutoCloseable,
Iterable<String[]> {
    public static final int CR_LF = -2;
    public static final int EOL = -2;
    public static final int COMMA = 44;
    public static final char DOUBLE_QUOTES = '\"';
    public static final String[] STRING_ARRAY = new String[0];
    protected final BasicReader.PeekableReader input;
    protected final String lineSeparator;
    protected final int fieldSeparator;
    protected final String[] header;
    protected boolean hasNextRecord = true;
    protected int numFields;
    protected int line = 1;
    protected int column = 0;

    public CsvReader(BasicReader basicReader) throws CsvFormatException, IOException {
        this(basicReader, true, true, true, 44, -2);
    }

    public CsvReader(BasicReader basicReader, int n, int n2) throws CsvFormatException, IOException {
        this(basicReader, true, true, true, n, n2);
    }

    public CsvReader(BasicReader basicReader, boolean bl, boolean bl2, boolean bl3) throws CsvFormatException, IOException {
        this(basicReader, bl, bl2, bl3, 44, -2);
    }

    public CsvReader(BasicReader basicReader, boolean bl, boolean bl2, boolean bl3, int n, int n2) throws CsvFormatException, IOException {
        this.fieldSeparator = n;
        switch (n2) {
            case 13: {
                this.lineSeparator = "\r";
                this.input = basicReader.convert(13).to(-2).peekable();
                break;
            }
            case 10: {
                this.lineSeparator = "\n";
                this.input = basicReader.convert(10).to(-2).peekable();
                break;
            }
            case -2: {
                this.lineSeparator = "\r\n";
                this.input = basicReader.convert(13, 10).to(-2).peekable();
                break;
            }
            default: {
                throw new IllegalArgumentException("Expected lineSeparator to be either CR (13), LF (10) or CR_LF-2) but got: " + n2);
            }
        }
        this.line = 1;
        this.column = 0;
        int n3 = this.numFields = bl2 ? 0 : -1;
        if (bl) {
            this.header = this.nextRecord();
            if (!this.hasNextRecord()) {
                throw new CsvFormatException("no record found except for header", this.line);
            }
            if (bl3) {
                HashSet hashSet = new HashSet();
                Collections.addAll(hashSet, this.header);
                if (hashSet.size() != this.header.length) {
                    throw new CsvFormatException("duplicated field names: " + Arrays.toString(this.header), 1);
                }
            }
        } else {
            this.header = null;
        }
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    public String[] getHeader() {
        return this.header;
    }

    public int getNumberOfFields() {
        return this.numFields;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    protected int read() throws IOException {
        int n = this.input.read();
        if (n == -2) {
            ++this.line;
            this.column = 0;
        } else {
            ++this.column;
        }
        return n;
    }

    public boolean hasNextRecord() {
        return this.hasNextRecord;
    }

    public String[] nextRecord() throws CsvFormatException, IOException {
        if (!this.hasNextRecord()) {
            throw new NoSuchElementException();
        }
        String[] stringArray = this.readRecord();
        if (this.peek() == -2) {
            this.read();
        }
        if (this.peek() == -1) {
            this.hasNextRecord = false;
        }
        if (this.numFields > 0 && stringArray.length != this.numFields) {
            throw new CsvFormatException("records contain different numbers of fields", this.line);
        }
        if (this.numFields == 0) {
            this.numFields = stringArray.length;
        }
        return stringArray;
    }

    @Override
    public Iterator<String[]> iterator() {
        return new Iterator<String[]>(){

            @Override
            public boolean hasNext() {
                return CsvReader.this.hasNextRecord();
            }

            @Override
            public String[] next() {
                try {
                    return CsvReader.this.nextRecord();
                }
                catch (Exception exception) {
                    throw CsvReader.throwUnchecked(exception);
                }
            }
        };
    }

    protected String[] readRecord() throws CsvFormatException, IOException {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        do {
            String string = this.readField();
            arrayList.add(string);
            n = this.peek();
            if (n != this.fieldSeparator) continue;
            this.read();
        } while (!this.isEndOfRecord(n));
        return arrayList.toArray(STRING_ARRAY);
    }

    protected int peek() {
        return this.input.peek();
    }

    protected String readField() throws CsvFormatException, IOException {
        String string = this.readQuotedField();
        if (string == null) {
            return this.readPlainField();
        }
        return string;
    }

    protected String readQuotedField() throws CsvFormatException, IOException {
        if (this.peek() != 34) {
            return null;
        }
        this.read();
        StringBuilder stringBuilder = new StringBuilder();
        while (this.peek() != -1) {
            int n = this.read();
            if (n == 34) {
                int n2 = this.peek();
                if (n2 == 34) {
                    this.read();
                } else {
                    if (this.isEndOfField(n2)) {
                        return stringBuilder.toString();
                    }
                    throw new CsvFormatException("double quotes (\") in quoted field not escaped (\"\")", this.line, this.column);
                }
            }
            if (n == -2) {
                stringBuilder.append(this.lineSeparator);
                continue;
            }
            stringBuilder.append((char)n);
        }
        throw new CsvFormatException("double quotes (\") missing to close quoted field", this.line, this.column);
    }

    protected String readPlainField() throws CsvFormatException, IOException {
        StringBuilder stringBuilder = new StringBuilder();
        while (!this.isEndOfField(this.peek())) {
            int n = this.read();
            if (n == 34) {
                throw new CsvFormatException("double quotes (\") found in non-quoted field", this.line, this.column);
            }
            stringBuilder.append((char)n);
        }
        return stringBuilder.toString();
    }

    protected boolean isEndOfField(int n) {
        return n == this.fieldSeparator || this.isEndOfRecord(n);
    }

    protected boolean isEndOfRecord(int n) {
        return n == -2 || n == -1;
    }

    public static String printRecord(String[] stringArray) {
        Object[] objectArray = new String[stringArray.length];
        for (int i = stringArray.length - 1; i >= 0; --i) {
            objectArray[i] = "\"" + stringArray[i].replaceAll("\\\"", "\\\\\"") + "\"";
        }
        return Arrays.toString(objectArray);
    }

    protected static <T extends Throwable> RuntimeException throwUnchecked(Throwable throwable) throws T {
        throw throwable;
    }

    public static void main(String[] stringArray) throws CsvFormatException, IOException {
        AutoCloseable autoCloseable;
        String string = "";
        System.out.println("CSV with single empty line:\n---");
        System.out.println(string);
        System.out.println("---\nRecords:");
        try (Object object = BasicReader.wrap(new StringReader(string)).normalizeLineEndings();){
            autoCloseable = new CsvReader((BasicReader)object, false, true, true, 44, 10);
            try {
                int n = 1;
                while (((CsvReader)autoCloseable).hasNextRecord()) {
                    System.out.println(n++ + ": " + CsvReader.printRecord(((CsvReader)autoCloseable).nextRecord()));
                }
            }
            finally {
                ((CsvReader)autoCloseable).close();
            }
        }
        object = "h1;h2;h3\rplain;\"quoted\";\"quotes\"\"\";\"\"\n;1;2;3;4\n\r\n;;\n";
        System.out.println();
        System.out.println("CSV with mixed and quoted records:\n---");
        System.out.println((String)object);
        System.out.println("---\nRecords:");
        autoCloseable = BasicReader.wrap(new StringReader((String)object)).normalizeLineEndings();
        try (CsvReader csvReader = new CsvReader((BasicReader)autoCloseable, true, false, true, 59, 10);){
            System.out.println("H: " + Arrays.toString(csvReader.getHeader()));
            int n = 1;
            while (csvReader.hasNextRecord()) {
                System.out.println(n++ + ": " + CsvReader.printRecord(csvReader.nextRecord()));
            }
        }
        finally {
            if (autoCloseable != null) {
                autoCloseable.close();
            }
        }
    }
}

