/*
 * Decompiled with CFR 0.152.
 */
package parma_polyhedra_library;

import java.math.BigInteger;
import javax.management.RuntimeErrorException;
import parma_polyhedra_library.Coefficient;
import parma_polyhedra_library.Generator_Type;
import parma_polyhedra_library.Linear_Expression;

public class Generator {
    private Generator_Type gt;
    private Linear_Expression le;
    private Coefficient div;

    private Generator(Linear_Expression linear_Expression, Generator_Type generator_Type) {
        this.le = linear_Expression.clone();
        this.gt = generator_Type;
    }

    public static Generator closure_point(Linear_Expression linear_Expression, Coefficient coefficient) {
        if (coefficient.getBigInteger().equals(BigInteger.ZERO)) {
            Error error = new Error("parma_polyhedra_library.Generator::Generator(e, d):\nthe divisor can not be zero.");
            throw new RuntimeErrorException(error);
        }
        Generator generator = new Generator(linear_Expression, Generator_Type.CLOSURE_POINT);
        generator.div = new Coefficient(coefficient);
        return generator;
    }

    public static Generator line(Linear_Expression linear_Expression) {
        return new Generator(linear_Expression, Generator_Type.LINE);
    }

    public static Generator point(Linear_Expression linear_Expression, Coefficient coefficient) {
        if (coefficient.getBigInteger().equals(BigInteger.ZERO)) {
            Error error = new Error("parma_polyhedra_library.Generator::Generator(e, d):\nthe divisor can not be zero.");
            throw new RuntimeErrorException(error);
        }
        Generator generator = new Generator(linear_Expression, Generator_Type.POINT);
        generator.div = new Coefficient(coefficient);
        return generator;
    }

    public static Generator ray(Linear_Expression linear_Expression) {
        return new Generator(linear_Expression, Generator_Type.RAY);
    }

    public Generator_Type type() {
        return this.gt;
    }

    public Linear_Expression linear_expression() {
        return this.le;
    }

    public Coefficient divisor() {
        if (this.gt == Generator_Type.POINT || this.gt == Generator_Type.CLOSURE_POINT) {
            return this.div;
        }
        Error error = new Error("parma_polyhedra_library.Generator::divisor:\nthis is neither a point nor a closure point.");
        throw new RuntimeErrorException(error);
    }

    public native String ascii_dump();

    public native String toString();

    private static native void initIDs();

    static {
        Generator.initIDs();
    }
}

