/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.DistributedList;
import edu.jas.util.DistributedListServer;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class DistributedListTest
extends TestCase {
    private static final String host = "localhost";
    private DistributedList l1;
    private DistributedList l2;
    private DistributedList l3;
    private DistributedListServer dls;
    int rl = 7;
    int kl = 10;
    int ll = 10;
    int el = 5;
    float q = 0.5f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)DistributedListTest.suite());
    }

    public DistributedListTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(DistributedListTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.dls = new DistributedListServer();
        this.dls.init();
    }

    protected void tearDown() {
        this.dls.terminate();
        this.dls = null;
        if (this.l1 != null) {
            this.l1.terminate();
        }
        if (this.l2 != null) {
            this.l2.terminate();
        }
        if (this.l3 != null) {
            this.l3.terminate();
        }
        this.l3 = null;
        this.l2 = null;
        this.l1 = null;
    }

    public void testDistributedList1() {
        this.l1 = new DistributedList(host);
        this.l1.init();
        DistributedListTest.assertTrue((String)"l1==empty", (boolean)this.l1.isEmpty());
        this.l1.add(1);
        DistributedListTest.assertFalse((String)"l1!=empty", (boolean)this.l1.isEmpty());
        DistributedListTest.assertTrue((String)"#l1==1", (this.l1.size() == 1 ? 1 : 0) != 0);
        this.l1.add(2);
        DistributedListTest.assertTrue((String)"#l1==2", (this.l1.size() == 2 ? 1 : 0) != 0);
        this.l1.add(3);
        DistributedListTest.assertTrue((String)"#l1==3", (this.l1.size() == 3 ? 1 : 0) != 0);
        Iterator iterator = null;
        iterator = this.l1.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Integer n2 = ++n;
            DistributedListTest.assertEquals((String)"l1(i)==(i)", (Object)n2, e);
        }
        this.l1.clear();
        DistributedListTest.assertTrue((String)"#l1==0", (this.l1.size() == 0 ? 1 : 0) != 0);
    }

    public void testDistributedList2() {
        Object object;
        this.l2 = new DistributedList(host);
        this.l2.init();
        DistributedListTest.assertTrue((String)"l2==empty", (boolean)this.l2.isEmpty());
        this.l1 = new DistributedList(host);
        this.l1.init();
        DistributedListTest.assertTrue((String)"l1==empty", (boolean)this.l1.isEmpty());
        int n = 0;
        int n2 = 10;
        while (n < n2) {
            object = ++n;
            this.l1.add(object);
            DistributedListTest.assertTrue((String)"#l1==i", (this.l1.size() == n ? 1 : 0) != 0);
        }
        DistributedListTest.assertTrue((String)"#l1==10", (this.l1.size() == n2 ? 1 : 0) != 0);
        while (this.l2.size() < n2) {
            try {
                System.out.print("2");
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        object = null;
        object = this.l2.iterator();
        n = 0;
        while (object.hasNext()) {
            Object e = object.next();
            Integer n3 = ++n;
            DistributedListTest.assertEquals((String)"l2(i)==(i)", (Object)n3, e);
        }
        DistributedListTest.assertTrue((String)"#l2==10", (this.l2.size() == n2 ? 1 : 0) != 0);
    }

    public void testDistributedList3() {
        Object object;
        this.l1 = new DistributedList(host);
        this.l1.init();
        DistributedListTest.assertTrue((String)"l1==empty", (boolean)this.l1.isEmpty());
        this.l2 = new DistributedList(host);
        this.l2.init();
        DistributedListTest.assertTrue((String)"l2==empty", (boolean)this.l2.isEmpty());
        this.l3 = new DistributedList(host);
        this.l3.init();
        DistributedListTest.assertTrue((String)"l3==empty", (boolean)this.l3.isEmpty());
        int n = 0;
        int n2 = 10;
        while (n < n2) {
            object = ++n;
            this.l3.add(object);
            DistributedListTest.assertTrue((String)"#l3==i", (this.l3.size() == n ? 1 : 0) != 0);
        }
        DistributedListTest.assertTrue((String)"#l3==10", (this.l3.size() == n2 ? 1 : 0) != 0);
        while (this.l2.size() < n2 || this.l1.size() < n2 - 1) {
            try {
                System.out.print("3");
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        DistributedListTest.assertTrue((String)"#l2==10", (this.l2.size() == n2 ? 1 : 0) != 0);
        DistributedListTest.assertTrue((String)"#l1==10", (this.l1.size() == n2 ? 1 : 0) != 0);
        object = null;
        object = this.l2.iterator();
        Iterator iterator = null;
        iterator = this.l1.iterator();
        n = 0;
        while (object.hasNext() && iterator.hasNext()) {
            Object e = object.next();
            Object e2 = iterator.next();
            Integer n3 = ++n;
            DistributedListTest.assertEquals((String)"l2(i)==(i)", (Object)n3, e);
            DistributedListTest.assertEquals((String)"l1(i)==(i)", (Object)n3, e2);
        }
    }

    public void testDistributedList6() {
        Object object;
        this.l1 = new DistributedList(host);
        this.l1.init();
        DistributedListTest.assertTrue((String)"l1==empty", (boolean)this.l1.isEmpty());
        int n = 0;
        int n2 = 10;
        while (n < n2) {
            object = ++n;
            this.l1.add(object);
            DistributedListTest.assertTrue((String)"#l1==i", (this.l1.size() == n ? 1 : 0) != 0);
        }
        DistributedListTest.assertTrue((String)"#l1==10", (this.l1.size() == n2 ? 1 : 0) != 0);
        this.l2 = new DistributedList(host);
        this.l2.init();
        while (this.l2.size() < n2) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        object = null;
        object = this.l2.iterator();
        n = 0;
        while (object.hasNext()) {
            Object e = object.next();
            Integer n3 = ++n;
            DistributedListTest.assertEquals((String)"l2(i)==(i)", (Object)n3, e);
        }
        DistributedListTest.assertTrue((String)"#l2==10", (this.l2.size() == n2 ? 1 : 0) != 0);
    }
}

