/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ps;

import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.ps.ExpVectorIterable;
import edu.jas.ps.MultiVarPowerSeriesRing;
import edu.jas.structure.Element;
import edu.jas.structure.RingElem;
import java.io.Serializable;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;

public abstract class MultiVarCoefficients<C extends RingElem<C>>
implements Serializable {
    public final GenPolynomialRing<C> pfac;
    public final HashMap<Long, GenPolynomial<C>> coeffCache;
    public final BitSet homCheck;
    public final HashSet<ExpVector> zeroCache;

    public MultiVarCoefficients(MultiVarPowerSeriesRing<C> multiVarPowerSeriesRing) {
        this(multiVarPowerSeriesRing.polyRing(), new HashMap<Long, GenPolynomial<C>>(), new HashSet<ExpVector>());
    }

    public MultiVarCoefficients(GenPolynomialRing<C> genPolynomialRing) {
        this(genPolynomialRing, new HashMap<Long, GenPolynomial<C>>(), new HashSet<ExpVector>());
    }

    public MultiVarCoefficients(GenPolynomialRing<C> genPolynomialRing, HashMap<Long, GenPolynomial<C>> hashMap) {
        this(genPolynomialRing, hashMap, new HashSet<ExpVector>());
    }

    public MultiVarCoefficients(GenPolynomialRing<C> genPolynomialRing, HashMap<Long, GenPolynomial<C>> hashMap, HashSet<ExpVector> hashSet) {
        this(genPolynomialRing, hashMap, hashSet, new BitSet());
    }

    public MultiVarCoefficients(GenPolynomialRing<C> genPolynomialRing, HashMap<Long, GenPolynomial<C>> hashMap, BitSet bitSet) {
        this(genPolynomialRing, hashMap, new HashSet<ExpVector>(), bitSet);
    }

    public MultiVarCoefficients(GenPolynomialRing<C> genPolynomialRing, HashMap<Long, GenPolynomial<C>> hashMap, HashSet<ExpVector> hashSet, BitSet bitSet) {
        this.pfac = genPolynomialRing;
        this.coeffCache = hashMap;
        this.zeroCache = hashSet;
        this.homCheck = bitSet;
    }

    public C get(ExpVector expVector) {
        C c;
        long l = expVector.totalDeg();
        Element<GenPolynomial<C>> element = this.coeffCache.get(l);
        if (element == null) {
            element = ((GenPolynomial)this.pfac.getZERO()).copy();
            this.coeffCache.put(l, (GenPolynomial<C>)element);
        }
        if (!(c = ((GenPolynomial)element).coefficient(expVector)).isZERO()) {
            return c;
        }
        if (this.homCheck.get((int)l)) {
            return c;
        }
        if (this.zeroCache.contains(expVector)) {
            return c;
        }
        C c2 = this.generate(expVector);
        if (c2.isZERO()) {
            this.zeroCache.add(expVector);
        } else {
            ((GenPolynomial)element).doPutToMap(expVector, (GenPolynomial<C>)c2);
        }
        return c2;
    }

    public GenPolynomial<C> getHomPart(long l) {
        if (this.coeffCache == null) {
            throw new IllegalArgumentException("null cache not allowed");
        }
        Element<GenPolynomial<C>> element = this.coeffCache.get(l);
        if (element == null) {
            element = ((GenPolynomial)this.pfac.getZERO()).copy();
            this.coeffCache.put(l, (GenPolynomial<C>)element);
        }
        if (this.homCheck.get((int)l)) {
            return element;
        }
        ExpVectorIterable expVectorIterable = new ExpVectorIterable(this.pfac.nvar, l);
        for (ExpVector expVector : expVectorIterable) {
            C c;
            if (this.zeroCache.contains(expVector)) {
                if (this.zeroCache.remove(expVector)) continue;
                System.out.println("not removed e = " + expVector);
                continue;
            }
            if (!((GenPolynomial)element).coefficient(expVector).isZERO() || (c = this.generate(expVector)).isZERO()) continue;
            ((GenPolynomial)element).doPutToMap(expVector, (GenPolynomial<C>)c);
        }
        this.homCheck.set((int)l);
        return element;
    }

    protected abstract C generate(ExpVector var1);
}

