/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRationalIterator;
import edu.jas.arith.BigRationalUniqueIterator;
import edu.jas.arith.Rational;
import edu.jas.kern.Scripting;
import edu.jas.kern.StringUtil;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import java.io.Reader;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public final class BigRational
implements GcdRingElem<BigRational>,
RingFactory<BigRational>,
Rational,
Iterable<BigRational> {
    public final java.math.BigInteger num;
    public final java.math.BigInteger den;
    public static final BigRational ZERO = new BigRational(java.math.BigInteger.ZERO);
    public static final BigRational ONE = new BigRational(java.math.BigInteger.ONE);
    public static final BigRational HALF = new BigRational(1L, 2L);
    private static final Random random = new Random();
    private boolean nonNegative = true;
    private boolean duplicates = true;

    protected BigRational(java.math.BigInteger bigInteger, java.math.BigInteger bigInteger2) {
        this.num = bigInteger;
        this.den = bigInteger2;
    }

    public BigRational(java.math.BigInteger bigInteger) {
        this.num = bigInteger;
        this.den = java.math.BigInteger.ONE;
    }

    public BigRational(BigInteger bigInteger) {
        this(bigInteger.getVal());
    }

    public BigRational(BigInteger bigInteger, BigInteger bigInteger2) {
        java.math.BigInteger bigInteger3 = bigInteger.getVal();
        java.math.BigInteger bigInteger4 = bigInteger2.getVal();
        BigRational bigRational = BigRational.RNRED(bigInteger3, bigInteger4);
        this.num = bigRational.num;
        this.den = bigRational.den;
    }

    public BigRational(long l, long l2) {
        java.math.BigInteger bigInteger = java.math.BigInteger.valueOf(l);
        java.math.BigInteger bigInteger2 = java.math.BigInteger.valueOf(l2);
        BigRational bigRational = BigRational.RNRED(bigInteger, bigInteger2);
        this.num = bigRational.num;
        this.den = bigRational.den;
    }

    public BigRational(long l) {
        this.num = java.math.BigInteger.valueOf(l);
        this.den = java.math.BigInteger.ONE;
    }

    public BigRational() {
        this.num = java.math.BigInteger.ZERO;
        this.den = java.math.BigInteger.ONE;
    }

    public BigRational(String string) throws NumberFormatException {
        if (string == null) {
            this.num = java.math.BigInteger.ZERO;
            this.den = java.math.BigInteger.ONE;
            return;
        }
        if (string.length() == 0) {
            this.num = java.math.BigInteger.ZERO;
            this.den = java.math.BigInteger.ONE;
            return;
        }
        int n = (string = string.trim()).indexOf(47);
        if (n < 0) {
            n = string.indexOf(46);
            if (n < 0) {
                this.num = new java.math.BigInteger(string);
                this.den = java.math.BigInteger.ONE;
                return;
            }
        } else {
            BigRational bigRational;
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1, string.length());
            if (string.indexOf(".") < 0) {
                java.math.BigInteger bigInteger = new java.math.BigInteger(string2);
                java.math.BigInteger bigInteger2 = new java.math.BigInteger(string3);
                bigRational = BigRational.RNRED(bigInteger, bigInteger2);
            } else {
                BigRational bigRational2 = new BigRational(string2);
                BigRational bigRational3 = new BigRational(string3);
                bigRational = bigRational2.divide(bigRational3);
            }
            this.num = bigRational.num;
            this.den = bigRational.den;
            return;
        }
        java.math.BigInteger bigInteger = string.charAt(0) == '-' ? new java.math.BigInteger(string.substring(1, n)) : new java.math.BigInteger(string.substring(0, n));
        BigRational bigRational = new BigRational(bigInteger);
        java.math.BigInteger bigInteger3 = new java.math.BigInteger(string.substring(n + 1, string.length()));
        int n2 = string.length() - n - 1;
        BigRational bigRational4 = new BigRational(1L, 10L);
        bigRational4 = (BigRational)bigRational4.power(n2);
        BigRational bigRational5 = new BigRational(bigInteger3);
        bigRational5 = bigRational5.multiply(bigRational4);
        bigRational = bigRational.sum(bigRational5);
        this.num = string.charAt(0) == '-' ? bigRational.num.negate() : bigRational.num;
        this.den = bigRational.den;
    }

    public BigRational factory() {
        return this;
    }

    @Override
    public List<BigRational> generators() {
        ArrayList<BigRational> arrayList = new ArrayList<BigRational>(1);
        arrayList.add(this.getONE());
        return arrayList;
    }

    @Override
    public boolean isFinite() {
        return false;
    }

    @Override
    public BigRational copy() {
        return new BigRational(this.num, this.den);
    }

    @Override
    public BigRational copy(BigRational bigRational) {
        return new BigRational(bigRational.num, bigRational.den);
    }

    @Override
    public BigRational getRational() {
        return this;
    }

    public java.math.BigInteger numerator() {
        return this.num;
    }

    public java.math.BigInteger denominator() {
        return this.den;
    }

    public String toString() {
        if (Scripting.getPrecision() >= 0) {
            return this.toString(Scripting.getPrecision());
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.num);
        if (!this.den.equals(java.math.BigInteger.ONE)) {
            stringBuffer.append("/").append(this.den);
        }
        return stringBuffer.toString();
    }

    public String toString(int n) {
        if (n < 0) {
            return this.toString();
        }
        MathContext mathContext = new MathContext(n);
        BigDecimal bigDecimal = new BigDecimal(this, mathContext);
        return bigDecimal.toString();
    }

    public BigDecimal getDecimal() {
        BigDecimal bigDecimal = new BigDecimal(this);
        return bigDecimal;
    }

    public double doubleValue() {
        BigDecimal bigDecimal = new BigDecimal(this, MathContext.DECIMAL64);
        return bigDecimal.doubleValue();
    }

    @Override
    public String toScript() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.den.equals(java.math.BigInteger.ONE)) {
            stringBuffer.append(this.num.toString());
            return stringBuffer.toString();
        }
        if (Scripting.getPrecision() >= 0) {
            return this.toString(Scripting.getPrecision());
        }
        switch (Scripting.getLang()) {
            case Python: {
                stringBuffer.append("(");
                stringBuffer.append(this.num.toString());
                stringBuffer.append(",");
                stringBuffer.append(this.den.toString());
                stringBuffer.append(")");
                break;
            }
            default: {
                stringBuffer.append(this.num.toString());
                stringBuffer.append("/");
                stringBuffer.append(this.den.toString());
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public String toScriptFactory() {
        return "QQ()";
    }

    @Override
    public BigRational getZERO() {
        return ZERO;
    }

    @Override
    public BigRational getONE() {
        return ONE;
    }

    @Override
    public boolean isCommutative() {
        return true;
    }

    @Override
    public boolean isAssociative() {
        return true;
    }

    @Override
    public boolean isField() {
        return true;
    }

    @Override
    public java.math.BigInteger characteristic() {
        return java.math.BigInteger.ZERO;
    }

    @Override
    public BigRational fromInteger(java.math.BigInteger bigInteger) {
        return new BigRational(bigInteger);
    }

    public BigRational fromInteger(BigInteger bigInteger) {
        return new BigRational(bigInteger);
    }

    public static BigRational valueOf(java.math.BigInteger bigInteger) {
        return new BigRational(bigInteger);
    }

    @Override
    public BigRational fromInteger(long l) {
        return new BigRational(l);
    }

    public static BigRational valueOf(long l) {
        return new BigRational(l);
    }

    @Override
    public boolean isZERO() {
        return this.num.signum() == 0;
    }

    @Override
    public boolean isONE() {
        return this.num.equals(this.den);
    }

    @Override
    public boolean isUnit() {
        return !this.isZERO();
    }

    public boolean isEntier() {
        return this.isZERO() || this.den.equals(java.math.BigInteger.ONE);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof BigRational)) {
            return false;
        }
        BigRational bigRational = (BigRational)object;
        return this.num.equals(bigRational.num) && this.den.equals(bigRational.den);
    }

    @Override
    public int hashCode() {
        return 37 * this.num.hashCode() + this.den.hashCode();
    }

    public static BigRational RNRED(java.math.BigInteger bigInteger, java.math.BigInteger bigInteger2) {
        java.math.BigInteger bigInteger3;
        java.math.BigInteger bigInteger4;
        if (bigInteger.equals(java.math.BigInteger.ZERO)) {
            java.math.BigInteger bigInteger5 = bigInteger;
            java.math.BigInteger bigInteger6 = java.math.BigInteger.ONE;
            return new BigRational(bigInteger5, bigInteger6);
        }
        if (bigInteger.equals(bigInteger2)) {
            java.math.BigInteger bigInteger7 = java.math.BigInteger.ONE;
            java.math.BigInteger bigInteger8 = java.math.BigInteger.ONE;
            return new BigRational(bigInteger7, bigInteger8);
        }
        java.math.BigInteger bigInteger9 = bigInteger.gcd(bigInteger2);
        if (bigInteger9.equals(java.math.BigInteger.ONE)) {
            bigInteger4 = bigInteger;
            bigInteger3 = bigInteger2;
        } else {
            bigInteger4 = bigInteger.divide(bigInteger9);
            bigInteger3 = bigInteger2.divide(bigInteger9);
        }
        if (bigInteger3.signum() < 0) {
            bigInteger4 = bigInteger4.negate();
            bigInteger3 = bigInteger3.negate();
        }
        return new BigRational(bigInteger4, bigInteger3);
    }

    public static BigRational reduction(java.math.BigInteger bigInteger, java.math.BigInteger bigInteger2) {
        return BigRational.RNRED(bigInteger, bigInteger2);
    }

    @Override
    public BigRational abs() {
        if (this.signum() >= 0) {
            return this;
        }
        return this.negate();
    }

    public static BigRational RNABS(BigRational bigRational) {
        if (bigRational == null) {
            return null;
        }
        return bigRational.abs();
    }

    @Override
    public int compareTo(BigRational bigRational) {
        int n;
        if (this.equals(ZERO)) {
            return -bigRational.signum();
        }
        if (bigRational.equals(ZERO)) {
            return this.signum();
        }
        java.math.BigInteger bigInteger = this.num;
        java.math.BigInteger bigInteger2 = this.den;
        java.math.BigInteger bigInteger3 = bigRational.num;
        java.math.BigInteger bigInteger4 = bigRational.den;
        int n2 = bigInteger.signum();
        int n3 = n2 - (n = bigInteger3.signum());
        int n4 = n3 / 2;
        if (n4 != 0) {
            return n4;
        }
        java.math.BigInteger bigInteger5 = bigInteger.multiply(bigInteger4);
        java.math.BigInteger bigInteger6 = bigInteger2.multiply(bigInteger3);
        n4 = bigInteger5.compareTo(bigInteger6);
        return n4;
    }

    public static int RNCOMP(BigRational bigRational, BigRational bigRational2) {
        if (bigRational == null) {
            return Integer.MAX_VALUE;
        }
        return bigRational.compareTo(bigRational2);
    }

    public static java.math.BigInteger RNDEN(BigRational bigRational) {
        if (bigRational == null) {
            return null;
        }
        return bigRational.den;
    }

    @Override
    public BigRational subtract(BigRational bigRational) {
        return this.sum(bigRational.negate());
    }

    public static BigRational RNDIF(BigRational bigRational, BigRational bigRational2) {
        if (bigRational == null) {
            return bigRational2.negate();
        }
        return bigRational.subtract(bigRational2);
    }

    public static void RNDWR(BigRational bigRational, int n) {
        MathContext mathContext = new MathContext(n);
        BigDecimal bigDecimal = new BigDecimal(bigRational, mathContext);
        System.out.print(bigDecimal.toString());
    }

    public static BigRational RNINT(java.math.BigInteger bigInteger) {
        return new BigRational(bigInteger);
    }

    @Override
    public BigRational inverse() {
        java.math.BigInteger bigInteger;
        java.math.BigInteger bigInteger2;
        java.math.BigInteger bigInteger3 = this.num;
        java.math.BigInteger bigInteger4 = this.den;
        if (bigInteger3.signum() >= 0) {
            bigInteger2 = bigInteger4;
            bigInteger = bigInteger3;
        } else {
            bigInteger2 = bigInteger4.negate();
            bigInteger = bigInteger3.negate();
        }
        return new BigRational(bigInteger2, bigInteger);
    }

    public static BigRational RNINV(BigRational bigRational) {
        if (bigRational == null) {
            return null;
        }
        return bigRational.inverse();
    }

    @Override
    public BigRational negate() {
        java.math.BigInteger bigInteger = this.num.negate();
        return new BigRational(bigInteger, this.den);
    }

    public static BigRational RNNEG(BigRational bigRational) {
        if (bigRational == null) {
            return null;
        }
        return bigRational.negate();
    }

    public static java.math.BigInteger RNNUM(BigRational bigRational) {
        if (bigRational == null) {
            return null;
        }
        return bigRational.num;
    }

    @Override
    public BigRational multiply(BigRational bigRational) {
        java.math.BigInteger bigInteger = null;
        java.math.BigInteger bigInteger2 = null;
        java.math.BigInteger bigInteger3 = null;
        java.math.BigInteger bigInteger4 = null;
        java.math.BigInteger bigInteger5 = null;
        java.math.BigInteger bigInteger6 = null;
        java.math.BigInteger bigInteger7 = null;
        java.math.BigInteger bigInteger8 = null;
        java.math.BigInteger bigInteger9 = null;
        java.math.BigInteger bigInteger10 = null;
        if (this.equals(ZERO) || bigRational.equals(ZERO)) {
            BigRational bigRational2 = ZERO;
            return bigRational2;
        }
        bigInteger3 = this.num;
        bigInteger4 = this.den;
        bigInteger7 = bigRational.num;
        bigInteger8 = bigRational.den;
        if (bigInteger4.equals(java.math.BigInteger.ONE) && bigInteger8.equals(java.math.BigInteger.ONE)) {
            java.math.BigInteger bigInteger11 = bigInteger3.multiply(bigInteger7);
            BigRational bigRational3 = new BigRational(bigInteger11, java.math.BigInteger.ONE);
            return bigRational3;
        }
        if (bigInteger4.equals(java.math.BigInteger.ONE)) {
            bigInteger = bigInteger3.equals(bigInteger8) ? bigInteger3 : bigInteger3.gcd(bigInteger8);
            bigInteger5 = bigInteger3.divide(bigInteger);
            bigInteger10 = bigInteger8.divide(bigInteger);
            java.math.BigInteger bigInteger12 = bigInteger5.multiply(bigInteger7);
            BigRational bigRational4 = new BigRational(bigInteger12, bigInteger10);
            return bigRational4;
        }
        if (bigInteger8.equals(java.math.BigInteger.ONE)) {
            bigInteger2 = bigInteger7.equals(bigInteger4) ? bigInteger7 : bigInteger7.gcd(bigInteger4);
            bigInteger9 = bigInteger7.divide(bigInteger2);
            bigInteger6 = bigInteger4.divide(bigInteger2);
            java.math.BigInteger bigInteger13 = bigInteger9.multiply(bigInteger3);
            BigRational bigRational5 = new BigRational(bigInteger13, bigInteger6);
            return bigRational5;
        }
        bigInteger = bigInteger3.equals(bigInteger8) ? bigInteger3 : bigInteger3.gcd(bigInteger8);
        bigInteger5 = bigInteger3.divide(bigInteger);
        bigInteger10 = bigInteger8.divide(bigInteger);
        bigInteger2 = bigInteger7.equals(bigInteger4) ? bigInteger7 : bigInteger7.gcd(bigInteger4);
        bigInteger9 = bigInteger7.divide(bigInteger2);
        bigInteger6 = bigInteger4.divide(bigInteger2);
        java.math.BigInteger bigInteger14 = bigInteger5.multiply(bigInteger9);
        java.math.BigInteger bigInteger15 = bigInteger6.multiply(bigInteger10);
        BigRational bigRational6 = new BigRational(bigInteger14, bigInteger15);
        return bigRational6;
    }

    public static BigRational RNPROD(BigRational bigRational, BigRational bigRational2) {
        if (bigRational == null) {
            return bigRational;
        }
        return bigRational.multiply(bigRational2);
    }

    @Override
    public BigRational divide(BigRational bigRational) {
        return this.multiply(bigRational.inverse());
    }

    public static BigRational RNQ(BigRational bigRational, BigRational bigRational2) {
        if (bigRational == null) {
            return bigRational;
        }
        return bigRational.divide(bigRational2);
    }

    @Override
    public BigRational remainder(BigRational bigRational) {
        if (bigRational.isZERO()) {
            throw new ArithmeticException("division by zero");
        }
        return ZERO;
    }

    public BigRational[] quotientRemainder(BigRational bigRational) {
        return new BigRational[]{this.divide(bigRational), ZERO};
    }

    @Override
    public BigRational random(int n) {
        return this.random(n, random);
    }

    @Override
    public BigRational random(int n, Random random) {
        java.math.BigInteger bigInteger = new java.math.BigInteger(n, random);
        if (random.nextBoolean()) {
            bigInteger = bigInteger.negate();
        }
        java.math.BigInteger bigInteger2 = new java.math.BigInteger(n, random);
        bigInteger2 = bigInteger2.add(java.math.BigInteger.ONE);
        return BigRational.RNRED(bigInteger, bigInteger2);
    }

    public static BigRational RNRAND(int n) {
        return ONE.random(n, random);
    }

    @Override
    public int signum() {
        return this.num.signum();
    }

    public static int RNSIGN(BigRational bigRational) {
        if (bigRational == null) {
            return 0;
        }
        return bigRational.signum();
    }

    @Override
    public BigRational sum(BigRational bigRational) {
        java.math.BigInteger bigInteger;
        java.math.BigInteger bigInteger2 = null;
        java.math.BigInteger bigInteger3 = null;
        java.math.BigInteger bigInteger4 = null;
        java.math.BigInteger bigInteger5 = null;
        java.math.BigInteger bigInteger6 = null;
        java.math.BigInteger bigInteger7 = null;
        java.math.BigInteger bigInteger8 = null;
        if (this.equals(ZERO)) {
            return bigRational;
        }
        if (bigRational.equals(ZERO)) {
            return this;
        }
        bigInteger3 = this.num;
        bigInteger4 = this.den;
        bigInteger6 = bigRational.num;
        bigInteger7 = bigRational.den;
        if (bigInteger4.equals(java.math.BigInteger.ONE) && bigInteger7.equals(java.math.BigInteger.ONE)) {
            java.math.BigInteger bigInteger9 = bigInteger3.add(bigInteger6);
            BigRational bigRational2 = new BigRational(bigInteger9, java.math.BigInteger.ONE);
            return bigRational2;
        }
        if (bigInteger4.equals(java.math.BigInteger.ONE)) {
            java.math.BigInteger bigInteger10 = bigInteger3.multiply(bigInteger7);
            bigInteger10 = bigInteger10.add(bigInteger6);
            BigRational bigRational3 = new BigRational(bigInteger10, bigInteger7);
            return bigRational3;
        }
        if (bigInteger7.equals(java.math.BigInteger.ONE)) {
            java.math.BigInteger bigInteger11 = bigInteger4.multiply(bigInteger6);
            bigInteger11 = bigInteger11.add(bigInteger3);
            BigRational bigRational4 = new BigRational(bigInteger11, bigInteger4);
            return bigRational4;
        }
        bigInteger2 = bigInteger4.equals(bigInteger7) ? bigInteger4 : bigInteger4.gcd(bigInteger7);
        if (bigInteger2.equals(java.math.BigInteger.ONE)) {
            bigInteger5 = bigInteger4;
            bigInteger8 = bigInteger7;
        } else {
            bigInteger5 = bigInteger4.divide(bigInteger2);
            bigInteger8 = bigInteger7.divide(bigInteger2);
        }
        java.math.BigInteger bigInteger12 = bigInteger3.multiply(bigInteger8);
        java.math.BigInteger bigInteger13 = bigInteger5.multiply(bigInteger6);
        java.math.BigInteger bigInteger14 = bigInteger12.add(bigInteger13);
        if (bigInteger14.equals(java.math.BigInteger.ZERO)) {
            return ZERO;
        }
        if (!bigInteger2.equals(java.math.BigInteger.ONE) && !(bigInteger = bigInteger14.equals(bigInteger2) ? bigInteger2 : bigInteger14.gcd(bigInteger2)).equals(java.math.BigInteger.ONE)) {
            bigInteger14 = bigInteger14.divide(bigInteger);
            bigInteger4 = bigInteger4.divide(bigInteger);
        }
        java.math.BigInteger bigInteger15 = bigInteger4.multiply(bigInteger8);
        BigRational bigRational5 = new BigRational(bigInteger14, bigInteger15);
        return bigRational5;
    }

    public static BigRational RNSUM(BigRational bigRational, BigRational bigRational2) {
        if (bigRational == null) {
            return bigRational2;
        }
        return bigRational.sum(bigRational2);
    }

    @Override
    public BigRational parse(String string) {
        return new BigRational(string);
    }

    @Override
    public BigRational parse(Reader reader) {
        return this.parse(StringUtil.nextString(reader));
    }

    @Override
    public BigRational gcd(BigRational bigRational) {
        if (bigRational == null || bigRational.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return bigRational;
        }
        return ONE;
    }

    public BigRational[] egcd(BigRational bigRational) {
        BigRational[] bigRationalArray = new BigRational[]{null, null, null};
        if (bigRational == null || bigRational.isZERO()) {
            bigRationalArray[0] = this;
            return bigRationalArray;
        }
        if (this.isZERO()) {
            bigRationalArray[0] = bigRational;
            return bigRationalArray;
        }
        BigRational bigRational2 = new BigRational(1L, 2L);
        bigRationalArray[0] = ONE;
        bigRationalArray[1] = this.inverse().multiply(bigRational2);
        bigRationalArray[2] = bigRational.inverse().multiply(bigRational2);
        return bigRationalArray;
    }

    public java.math.BigInteger ceil() {
        if (this.isEntier()) {
            return this.num;
        }
        java.math.BigInteger[] bigIntegerArray = this.num.divideAndRemainder(this.den);
        java.math.BigInteger bigInteger = bigIntegerArray[0];
        if (bigIntegerArray[1].signum() > 0) {
            bigInteger = bigInteger.add(java.math.BigInteger.ONE);
        }
        return bigInteger;
    }

    public java.math.BigInteger floor() {
        if (this.isEntier()) {
            return this.num;
        }
        java.math.BigInteger[] bigIntegerArray = this.num.divideAndRemainder(this.den);
        java.math.BigInteger bigInteger = bigIntegerArray[0];
        if (bigIntegerArray[1].signum() < 0) {
            bigInteger = bigInteger.subtract(java.math.BigInteger.ONE);
        }
        return bigInteger;
    }

    public long bitLength() {
        long l = this.num.bitLength();
        if (this.num.signum() < 0) {
            ++l;
        }
        ++l;
        l += (long)this.den.bitLength();
        return ++l;
    }

    public void setAllIterator() {
        this.nonNegative = false;
    }

    public void setNonNegativeIterator() {
        this.nonNegative = true;
    }

    public void setNoDuplicatesIterator() {
        this.duplicates = false;
    }

    public void setDuplicatesIterator() {
        this.duplicates = true;
    }

    @Override
    public Iterator<BigRational> iterator() {
        if (this.duplicates) {
            return new BigRationalIterator(this.nonNegative);
        }
        return new BigRationalUniqueIterator(new BigRationalIterator(this.nonNegative));
    }

    public Iterator<BigRational> uniqueIterator() {
        return new BigRationalUniqueIterator(new BigRationalIterator(this.nonNegative));
    }
}

