/*
 * Decompiled with CFR 0.152.
 */
package userinterface.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import userinterface.GUIPrism;
import userinterface.util.FontChooser;
import userinterface.util.FontColorPair;
import userinterface.util.PropertyException;
import userinterface.util.PropertyOwner;
import userinterface.util.SingleProperty;

public class FontColorProperty
extends SingleProperty {
    private ArrayList<ActionListener> actionListeners;
    JPanel pan = new JPanel();
    JLabel renderer = new JLabel();
    JButton edit;
    boolean editDocked = false;
    private FontColorPair editValue;

    public FontColorProperty(PropertyOwner propertyOwner, String string, FontColorPair fontColorPair) {
        this(propertyOwner, string, fontColorPair, "");
    }

    public FontColorProperty(PropertyOwner propertyOwner, String string, FontColorPair fontColorPair, String string2) {
        super(propertyOwner, string, fontColorPair, "", false, string2);
        this.pan.setLayout(new BorderLayout());
        this.renderer.setBorder(null);
        this.pan.add(this.renderer);
        this.actionListeners = new ArrayList();
        this.edit = new JButton("...");
        this.edit.setPreferredSize(new Dimension(20, 30));
        this.editValue = new FontColorPair(new Font("monospaced", 0, 12), Color.black);
        this.edit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontColorProperty.this.editValue = FontChooser.getFont(GUIPrism.getGUI(), FontColorProperty.this.getFontColorPair().f, FontColorProperty.this.getFontColorPair().c, FontColorProperty.this.getFontColorPair().f, FontColorProperty.this.getFontColorPair().c);
                FontColorProperty.this.fireActionPerformed(actionEvent);
            }
        });
    }

    public void setFontColorPair(FontColorPair fontColorPair) {
        try {
            this.setProperty(fontColorPair);
        }
        catch (PropertyException propertyException) {
            // empty catch block
        }
    }

    public FontColorPair getFontColorPair() {
        return (FontColorPair)this.getProperty();
    }

    @Override
    public void setProperty(Object object) throws PropertyException {
        if (!(object instanceof FontColorPair)) {
            throw new PropertyException("Value must be of type FontColorPair");
        }
        super.setProperty(object);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.renderer != null) {
            this.renderer.setEnabled(bl);
        }
        if (this.edit != null) {
            this.edit.setEnabled(bl);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (this.editDocked) {
            // empty if block
        }
        this.pan.remove(this.edit);
        this.editDocked = false;
        this.renderer.setOpaque(true);
        this.renderer.setFont(this.getFontColorPair().f);
        this.renderer.setHorizontalTextPosition(2);
        this.renderer.setText(this.getFontColorPair().f.getFontName() + " " + this.getFontColorPair().f.getSize());
        if (bl) {
            this.renderer.setForeground(this.getFontColorPair().c);
            this.renderer.setBackground(jTable.getSelectionBackground());
        } else {
            this.renderer.setForeground(this.getFontColorPair().c);
            this.renderer.setBackground(jTable.getBackground());
        }
        if (bl2) {
            this.pan.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (jTable.isCellEditable(n, n2)) {
                this.pan.setForeground(UIManager.getColor("Table.focusCellForeground"));
                this.pan.setBackground(UIManager.getColor("Table.focusCellBackground"));
            }
        } else {
            this.pan.setBorder(new EmptyBorder(0, 2, 2, 1));
            this.pan.setForeground(UIManager.getColor("Table.focusCellForeground"));
            this.pan.setBackground(UIManager.getColor("Table.focusCellBackground"));
        }
        return this.pan;
    }

    @Override
    public Component getTableCellRendererComponentMulti(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2, boolean bl3) {
        if (bl3) {
            return this.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
        if (this.editDocked) {
            // empty if block
        }
        this.pan.remove(this.edit);
        this.editDocked = false;
        this.renderer.setOpaque(true);
        this.renderer.setFont(this.pan.getFont());
        this.renderer.setText("...");
        if (bl) {
            this.renderer.setForeground(Color.lightGray);
            this.renderer.setBackground(jTable.getSelectionBackground());
        } else {
            this.renderer.setForeground(Color.lightGray);
            this.renderer.setBackground(jTable.getBackground());
        }
        if (bl2) {
            this.pan.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (jTable.isCellEditable(n, n2)) {
                this.pan.setForeground(UIManager.getColor("Table.focusCellForeground"));
                this.pan.setBackground(UIManager.getColor("Table.focusCellBackground"));
            }
        } else {
            this.pan.setBorder(new EmptyBorder(0, 2, 2, 1));
            this.pan.setForeground(UIManager.getColor("Table.focusCellForeground"));
            this.pan.setBackground(UIManager.getColor("Table.focusCellBackground"));
        }
        return this.pan;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.editValue = this.getFontColorPair();
        if (!this.editDocked) {
            this.pan.add((Component)this.edit, "East");
            this.editDocked = true;
        }
        this.pan.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        this.pan.setForeground(UIManager.getColor("Table.focusCellForeground"));
        this.pan.setBackground(UIManager.getColor("Table.focusCellBackground"));
        return this.pan;
    }

    public FontColorPair getEditorValue() {
        return this.editValue;
    }

    public void addListenerToEditor(ActionListener actionListener) {
        this.actionListeners.add(actionListener);
    }

    public void removeListenerFromEditor(ActionListener actionListener) {
        this.actionListeners.remove(actionListener);
    }

    public void fireActionPerformed(ActionEvent actionEvent) {
        for (int i = 0; i < this.actionListeners.size(); ++i) {
            this.actionListeners.get(i).actionPerformed(actionEvent);
        }
    }
}

