/*
 * Decompiled with CFR 0.152.
 */
package userinterface.model.computation;

import io.ModelExportTask;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import userinterface.GUIComputationThread;
import userinterface.GUIPlugin;
import userinterface.model.GUIMultiModelHandler;
import userinterface.util.GUIComputationEvent;

public class ExportBuiltModelThread
extends GUIComputationThread {
    private ModelExportTask exportTask;

    public ExportBuiltModelThread(GUIMultiModelHandler gUIMultiModelHandler, ModelExportTask modelExportTask) {
        this(gUIMultiModelHandler.getGUIPlugin(), modelExportTask);
    }

    public ExportBuiltModelThread(GUIPlugin gUIPlugin, ModelExportTask modelExportTask) {
        super(gUIPlugin);
        this.exportTask = modelExportTask;
    }

    @Override
    public void run() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ExportBuiltModelThread.this.plug.startProgress();
                    ExportBuiltModelThread.this.plug.setTaskBarText("Exporting...");
                    ExportBuiltModelThread.this.plug.notifyEventListeners(new GUIComputationEvent(0, ExportBuiltModelThread.this.plug));
                }
            });
            try {
                this.prism.exportBuiltModelTask(this.exportTask);
            }
            catch (Throwable throwable) {
                this.error(throwable);
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ExportBuiltModelThread.this.plug.stopProgress();
                        ExportBuiltModelThread.this.plug.setTaskBarText("Exporting... error.");
                        ExportBuiltModelThread.this.plug.notifyEventListeners(new GUIComputationEvent(2, ExportBuiltModelThread.this.plug));
                    }
                });
                return;
            }
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ExportBuiltModelThread.this.plug.stopProgress();
                    ExportBuiltModelThread.this.plug.setTaskBarText("Exporting... done.");
                    ExportBuiltModelThread.this.plug.notifyEventListeners(new GUIComputationEvent(1, ExportBuiltModelThread.this.plug));
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }
}

