/*
 * Decompiled with CFR 0.152.
 */
package userinterface.graph;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Observable;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.Range;
import org.jfree.data.xy.XYSeries;
import org.w3c.dom.Element;
import settings.BooleanSetting;
import settings.ChoiceSetting;
import settings.ColorSetting;
import settings.DoubleSetting;
import settings.FontColorPair;
import settings.FontColorSetting;
import settings.NumericConstraint;
import settings.RangeConstraint;
import settings.Setting;
import settings.SettingDisplay;
import settings.SettingException;
import settings.SettingOwner;
import settings.SingleLineStringSetting;
import userinterface.graph.Graph;
import userinterface.graph.PrismLogarithmicAxis;
import userinterface.graph.PrismXYSeries;

public class AxisSettings
extends Observable
implements SettingOwner {
    private String name;
    private SettingDisplay display;
    private Graph graph;
    private JFreeChart chart;
    private XYPlot plot;
    private ValueAxis axis;
    private boolean isDomain;
    private SingleLineStringSetting heading;
    private FontColorSetting headingFont;
    private FontColorSetting numberFont;
    private BooleanSetting showGrid;
    private ColorSetting gridColour;
    private ChoiceSetting scaleType;
    private BooleanSetting autoScale;
    private DoubleSetting minValue;
    private DoubleSetting maxValue;
    private DoubleSetting gridInterval;
    private DoubleSetting minimumPower;
    private DoubleSetting maximumPower;
    private DoubleSetting logBase;
    private ChoiceSetting logStyle;
    public static final int NORMAL_SCALE = 0;
    public static final int LOGARITHMIC_SCALE = 1;
    public static final int VALUES = 0;
    public static final int BASE_AND_EXPONENT = 1;
    public NumberFormat valuesFormatter;
    boolean activated = false;

    public AxisSettings(String string, boolean bl, Graph graph) {
        this.name = string;
        this.isDomain = bl;
        this.graph = graph;
        this.chart = graph.getChart();
        this.plot = this.chart.getXYPlot();
        this.axis = bl ? this.plot.getDomainAxis() : this.plot.getRangeAxis();
        this.valuesFormatter = NumberFormat.getInstance(Locale.UK);
        if (this.valuesFormatter instanceof DecimalFormat) {
            ((DecimalFormat)this.valuesFormatter).applyPattern("###,###,###,###,###,###,###,###.########################");
        }
        this.heading = new SingleLineStringSetting("heading", string, "The heading for this axis", (SettingOwner)this, true);
        this.headingFont = new FontColorSetting("heading font", new FontColorPair(new Font("SansSerif", 0, 12), Color.black), "The font for this axis' heading.", (SettingOwner)this, true);
        this.numberFont = new FontColorSetting("numbering font", new FontColorPair(new Font("SansSerif", 0, 12), Color.black), "The font used to number the axis.", (SettingOwner)this, true);
        this.showGrid = new BooleanSetting("show gridlines", true, "Should the gridlines be visible", (SettingOwner)this, true);
        this.gridColour = new ColorSetting("gridline colour", new Color(204, 204, 204), "The colour of the gridlines", (SettingOwner)this, true);
        String[] stringArray = new String[]{"Normal", "Logarithmic"};
        this.scaleType = new ChoiceSetting("scale type", stringArray, stringArray[0], "Should the scale be normal, or logarithmic", this, true);
        this.autoScale = new BooleanSetting("auto-scale", true, "When set to true, all minimum values, maximum values, grid intervals, maximum logarithmic powers and minimum logarithmic powers are automatically set and maintained when the data changes.", (SettingOwner)this, true);
        this.minValue = new DoubleSetting("minimum value", 0.0, "The minimum value for the axis", (SettingOwner)this, true);
        this.maxValue = new DoubleSetting("maximum value", 1.0, "The maximum value for the axis", (SettingOwner)this, true);
        this.gridInterval = new DoubleSetting("gridline interval", 0.2, "The interval between gridlines", (SettingOwner)this, false, new RangeConstraint(0.0, Double.POSITIVE_INFINITY, false, true));
        this.logBase = new DoubleSetting("log base", 10.0, "The base for the logarithmic scale", (SettingOwner)this, false, new RangeConstraint("1,"));
        this.minimumPower = new DoubleSetting("minimum power", Double.valueOf("0.0"), "The minimum logarithmic power that should be displayed on the scale", (SettingOwner)this, true);
        this.maximumPower = new DoubleSetting("maximum power", Double.valueOf("1.0"), "The maximum logarithmic power that should be displayed on the scale", (SettingOwner)this, true);
        String[] stringArray2 = new String[]{"Values", "Base and exponent"};
        this.logStyle = new ChoiceSetting("logarithmic number style", stringArray2, stringArray2[1], "Should the style of the logarithmic scale show the actual values, or the base with the exponent.", this, false);
        this.minValue.addConstraint(new NumericConstraint(){

            @Override
            public void checkValueDouble(double d) throws SettingException {
                if (AxisSettings.this.activated && d >= AxisSettings.this.maxValue.getDoubleValue()) {
                    throw new SettingException("Minimum value should be < Maximum value");
                }
            }

            @Override
            public void checkValueInteger(int n) throws SettingException {
                if (AxisSettings.this.activated && (double)n >= AxisSettings.this.maxValue.getDoubleValue()) {
                    throw new SettingException("Minimum value should be < Maximum value");
                }
            }

            @Override
            public void checkValueLong(long l) throws SettingException {
                if (AxisSettings.this.activated && (double)l >= AxisSettings.this.maxValue.getDoubleValue()) {
                    throw new SettingException("Minimum value should be < Maximum value");
                }
            }
        });
        this.maxValue.addConstraint(new NumericConstraint(){

            @Override
            public void checkValueDouble(double d) throws SettingException {
                if (AxisSettings.this.activated && d <= AxisSettings.this.minValue.getDoubleValue()) {
                    throw new SettingException("Maximum value should be > Minimum value");
                }
            }

            @Override
            public void checkValueInteger(int n) throws SettingException {
                if (AxisSettings.this.activated && (double)n <= AxisSettings.this.minValue.getDoubleValue()) {
                    throw new SettingException("Maximum value should be > Minimum value");
                }
            }

            @Override
            public void checkValueLong(long l) throws SettingException {
                if (AxisSettings.this.activated && (double)l <= AxisSettings.this.maxValue.getDoubleValue()) {
                    throw new SettingException("Minimum value should be > Maximum value");
                }
            }
        });
        this.minimumPower.addConstraint(new NumericConstraint(){

            @Override
            public void checkValueDouble(double d) throws SettingException {
                if (AxisSettings.this.activated && d >= AxisSettings.this.maximumPower.getDoubleValue()) {
                    throw new SettingException("Minimum power should be < Maximum power");
                }
            }

            @Override
            public void checkValueInteger(int n) throws SettingException {
                if (AxisSettings.this.activated && (double)n >= AxisSettings.this.maximumPower.getDoubleValue()) {
                    throw new SettingException("Minimum power should be < Maximum power");
                }
            }

            @Override
            public void checkValueLong(long l) throws SettingException {
                if (AxisSettings.this.activated && (double)l >= AxisSettings.this.maximumPower.getDoubleValue()) {
                    throw new SettingException("Minimum power should be < Maximum power");
                }
            }
        });
        this.maximumPower.addConstraint(new NumericConstraint(){

            @Override
            public void checkValueDouble(double d) throws SettingException {
                if (AxisSettings.this.activated && d <= AxisSettings.this.minimumPower.getDoubleValue()) {
                    throw new SettingException("Maximum power should be > Minimum power");
                }
            }

            @Override
            public void checkValueInteger(int n) throws SettingException {
                if (AxisSettings.this.activated && (double)n <= AxisSettings.this.minimumPower.getDoubleValue()) {
                    throw new SettingException("Maximum power should be > Minimum power");
                }
            }

            @Override
            public void checkValueLong(long l) throws SettingException {
                if (AxisSettings.this.activated && (double)l <= AxisSettings.this.minimumPower.getDoubleValue()) {
                    throw new SettingException("Maximum power should be > Minimum power");
                }
            }
        });
        this.doEnables();
        this.display = null;
        this.activated = true;
        this.updateAxis();
        this.setChanged();
        this.notifyObservers();
    }

    public int compareTo(Object object) {
        if (object instanceof SettingOwner) {
            SettingOwner settingOwner = (SettingOwner)object;
            if (this.getSettingOwnerID() < settingOwner.getSettingOwnerID()) {
                return -1;
            }
            if (this.getSettingOwnerID() > settingOwner.getSettingOwnerID()) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    public String getClassDescriptor() {
        return "Axis";
    }

    public String getDescriptor() {
        return this.name;
    }

    @Override
    public int getNumSettings() {
        return 14;
    }

    @Override
    public String getSettingOwnerName() {
        return this.heading.getStringValue();
    }

    @Override
    public Setting getSetting(int n) {
        switch (n) {
            case 0: {
                return this.heading;
            }
            case 1: {
                return this.headingFont;
            }
            case 2: {
                return this.numberFont;
            }
            case 3: {
                return this.showGrid;
            }
            case 4: {
                return this.gridColour;
            }
            case 5: {
                return this.scaleType;
            }
            case 6: {
                return this.autoScale;
            }
            case 7: {
                return this.minValue;
            }
            case 8: {
                return this.maxValue;
            }
            case 9: {
                return this.gridInterval;
            }
            case 10: {
                return this.minimumPower;
            }
            case 11: {
                return this.maximumPower;
            }
            case 12: {
                return this.logBase;
            }
            case 13: {
                return this.logStyle;
            }
        }
        return null;
    }

    @Override
    public int getSettingOwnerID() {
        return 7;
    }

    @Override
    public String getSettingOwnerClassName() {
        return "Axis";
    }

    public void doEnables() {
        this.minimumPower.setEnabled(!this.autoScale.getBooleanValue() && this.scaleType.getCurrentIndex() == 1);
        this.maximumPower.setEnabled(!this.autoScale.getBooleanValue() && this.scaleType.getCurrentIndex() == 1);
        this.logBase.setEnabled(this.scaleType.getCurrentIndex() == 1);
        this.logStyle.setEnabled(this.scaleType.getCurrentIndex() == 1);
        this.minValue.setEnabled(!this.autoScale.getBooleanValue() && this.scaleType.getCurrentIndex() == 0);
        this.maxValue.setEnabled(!this.autoScale.getBooleanValue() && this.scaleType.getCurrentIndex() == 0);
        this.gridInterval.setEnabled(!this.autoScale.getBooleanValue() && this.scaleType.getCurrentIndex() == 0);
    }

    @Override
    public void notifySettingChanged(Setting setting) {
        this.doEnables();
        this.updateAxis();
        this.setChanged();
        this.notifyObservers(this);
    }

    public String getHeading() {
        return this.heading.getStringValue();
    }

    public void setHeading(String string) {
        try {
            this.heading.setValue(string);
            this.doEnables();
            this.updateAxis();
            this.setChanged();
            this.notifyObservers(this);
        }
        catch (SettingException settingException) {
            // empty catch block
        }
    }

    public FontColorPair getHeadingFont() {
        return this.headingFont.getFontColorValue();
    }

    public void setHeadingFont(FontColorPair fontColorPair) {
        try {
            this.headingFont.setValue(fontColorPair);
            this.doEnables();
            this.updateAxis();
            this.setChanged();
            this.notifyObservers(this);
        }
        catch (SettingException settingException) {
            // empty catch block
        }
    }

    public FontColorPair getNumberFont() {
        return this.numberFont.getFontColorValue();
    }

    public void setNumberFont(FontColorPair fontColorPair) {
        try {
            this.numberFont.setValue(fontColorPair);
            this.doEnables();
            this.updateAxis();
            this.setChanged();
            this.notifyObservers(this);
        }
        catch (SettingException settingException) {
            // empty catch block
        }
    }

    public boolean isAutoScale() {
        return this.autoScale.getBooleanValue();
    }

    public void setAutoScale(boolean bl) {
        try {
            this.autoScale.setValue(bl);
            this.doEnables();
            this.updateAxis();
            this.setChanged();
            this.notifyObservers(this);
        }
        catch (SettingException settingException) {
            // empty catch block
        }
    }

    public boolean showGrid() {
        return this.showGrid.getBooleanValue();
    }

    public void showGrid(boolean bl) {
        try {
            this.showGrid.setValue(bl);
            this.doEnables();
            this.updateAxis();
            this.setChanged();
            this.notifyObservers(this);
        }
        catch (SettingException settingException) {
            // empty catch block
        }
    }

    public Color getGridColour() {
        return this.gridColour.getColorValue();
    }

    public void setGridColour(Color color) {
        try {
            this.gridColour.setValue(color);
            this.doEnables();
            this.updateAxis();
            this.setChanged();
            this.notifyObservers(this);
        }
        catch (SettingException settingException) {
            // empty catch block
        }
    }

    public int getScaleType() {
        return this.scaleType.getCurrentIndex();
    }

    public void setScaleType(int n) throws SettingException {
        this.scaleType.setSelectedIndex(n);
        this.doEnables();
        this.updateAxis();
        this.setChanged();
        this.notifyObservers(this);
    }

    public boolean isLogarithmic() {
        return this.scaleType.getCurrentIndex() == 1;
    }

    public int getLogStyle() {
        return this.logStyle.getCurrentIndex();
    }

    public void setLogStyle(int n) throws SettingException {
        this.logStyle.setSelectedIndex(n);
        this.doEnables();
        this.updateAxis();
        this.setChanged();
        this.notifyObservers(this);
    }

    public double getMinValue() {
        return this.minValue.getDoubleValue();
    }

    public void setMinValue(double d) throws SettingException {
        this.minValue.setValue(d);
        this.doEnables();
        this.updateAxis();
        this.setChanged();
        this.notifyObservers(this);
    }

    public double getMaxValue() {
        return this.maxValue.getDoubleValue();
    }

    public void setMaxValue(double d) throws SettingException {
        this.maxValue.setValue(d);
        this.doEnables();
        this.updateAxis();
        this.setChanged();
        this.notifyObservers(this);
    }

    public double getGridInterval() {
        return this.gridInterval.getDoubleValue();
    }

    public void setGridInterval(Double d) {
        try {
            this.gridInterval.setValue(d);
            this.doEnables();
            this.updateAxis();
            this.setChanged();
            this.notifyObservers(this);
        }
        catch (SettingException settingException) {
            // empty catch block
        }
    }

    public double getLogBase() {
        return this.logBase.getDoubleValue();
    }

    public void setLogBase(double d) throws SettingException {
        this.logBase.setValue(d);
        this.doEnables();
        this.updateAxis();
        this.setChanged();
        this.notifyObservers(this);
    }

    public double getMinimumPower() {
        return this.minimumPower.getDoubleValue();
    }

    public void setMinimumPower(double d) throws SettingException {
        this.minimumPower.setValue(d);
        this.doEnables();
        this.updateAxis();
        this.setChanged();
        this.notifyObservers(this);
    }

    public double getMaximumPower() {
        return this.maximumPower.getDoubleValue();
    }

    public void setMaximumPower(double d) throws SettingException {
        this.maximumPower.setValue(d);
        this.doEnables();
        this.updateAxis();
        this.setChanged();
        this.notifyObservers(this);
    }

    @Override
    public SettingDisplay getDisplay() {
        return this.display;
    }

    @Override
    public void setDisplay(SettingDisplay settingDisplay) {
        this.display = settingDisplay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAxis() {
        XYSeries xYSeries;
        Range range;
        Object object;
        if (this.axis instanceof NumberAxis && this.isLogarithmic()) {
            object = new PrismLogarithmicAxis(this.getHeading());
            range = this.graph.getSeriesLock();
            synchronized (range) {
                for (Graph.SeriesKey seriesKey : this.graph.getAllSeriesKeys()) {
                    xYSeries = this.graph.getXYSeries(seriesKey);
                    if (!(xYSeries instanceof PrismXYSeries)) continue;
                    PrismXYSeries prismXYSeries = (PrismXYSeries)xYSeries;
                    if (this.isDomain) {
                        prismXYSeries.setLogarithmicDomainAxis(true);
                        continue;
                    }
                    prismXYSeries.setLogarithmicRangeAxis(true);
                }
            }
            if (this.isDomain) {
                this.plot.setDomainAxis((ValueAxis)object);
                this.axis = this.plot.getDomainAxis();
            } else {
                this.plot.setRangeAxis((ValueAxis)object);
                this.axis = this.plot.getRangeAxis();
            }
        }
        if (this.axis instanceof PrismLogarithmicAxis && !this.isLogarithmic()) {
            if (this.isDomain) {
                this.plot.setDomainAxis((ValueAxis)new NumberAxis(this.getHeading()));
                this.axis = this.plot.getDomainAxis();
            } else {
                this.plot.setRangeAxis((ValueAxis)new NumberAxis(this.getHeading()));
                this.axis = this.plot.getRangeAxis();
            }
            object = this.graph.getSeriesLock();
            synchronized (object) {
                range = this.graph.getAllSeriesKeys().iterator();
                while (range.hasNext()) {
                    Graph.SeriesKey seriesKey;
                    Graph.SeriesKey seriesKey2 = range.next();
                    seriesKey = this.graph.getXYSeries(seriesKey2);
                    if (!(seriesKey instanceof PrismXYSeries)) continue;
                    xYSeries = (PrismXYSeries)((Object)seriesKey);
                    if (this.isDomain) {
                        xYSeries.setLogarithmicDomainAxis(false);
                        continue;
                    }
                    xYSeries.setLogarithmicRangeAxis(false);
                }
            }
        }
        if (!this.axis.getLabel().equals(this.getHeading())) {
            this.axis.setLabel(this.getHeading());
        }
        if (!this.axis.getLabelFont().equals(this.getHeadingFont().f)) {
            this.axis.setLabelFont(this.getHeadingFont().f);
        }
        if (!this.axis.getLabelPaint().equals(this.getHeadingFont().c)) {
            this.axis.setLabelPaint((Paint)this.getHeadingFont().c);
        }
        if (!this.axis.getTickLabelFont().equals(this.getNumberFont().f)) {
            this.axis.setTickLabelFont(this.getNumberFont().f);
        }
        if (!this.axis.getTickLabelPaint().equals(this.getNumberFont().c)) {
            this.axis.setTickLabelPaint((Paint)this.getNumberFont().c);
        }
        if (this.isDomain && this.plot.isDomainGridlinesVisible() != this.showGrid.getBooleanValue()) {
            this.plot.setDomainGridlinesVisible(this.showGrid.getBooleanValue());
        }
        if (!this.isDomain && this.plot.isRangeGridlinesVisible() != this.showGrid.getBooleanValue()) {
            this.plot.setRangeGridlinesVisible(this.showGrid.getBooleanValue());
        }
        if (this.isDomain && !this.plot.getDomainGridlinePaint().equals(this.gridColour.getColorValue())) {
            this.plot.setDomainGridlinePaint((Paint)this.gridColour.getColorValue());
        }
        if (!this.isDomain && !this.plot.getRangeGridlinePaint().equals(this.gridColour.getColorValue())) {
            this.plot.setRangeGridlinePaint((Paint)this.gridColour.getColorValue());
        }
        if (this.axis instanceof PrismLogarithmicAxis) {
            object = (PrismLogarithmicAxis)this.axis;
            if (this.logStyle.getCurrentIndex() == 1 != ((PrismLogarithmicAxis)((Object)object)).isBaseAndExponentFormatOverride()) {
                ((PrismLogarithmicAxis)((Object)object)).setBaseAndExponentFormatOverride(this.logStyle.getCurrentIndex() == 1);
            }
            if (this.logStyle.getCurrentIndex() == 0 && ((PrismLogarithmicAxis)((Object)object)).getNumberFormatOverride() != this.valuesFormatter) {
                ((PrismLogarithmicAxis)((Object)object)).setNumberFormatOverride(this.valuesFormatter);
            }
            if (object.isAutoRange() && !this.autoScale.getBooleanValue()) {
                range = object.getRange();
                object.setAutoRange(false);
                try {
                    this.minimumPower.setValue(((PrismLogarithmicAxis)((Object)object)).calculateLog(range.getLowerBound()));
                    this.maximumPower.setValue(((PrismLogarithmicAxis)((Object)object)).calculateLog(range.getUpperBound()));
                }
                catch (SettingException settingException) {
                    // empty catch block
                }
            }
            if (!this.axis.isAutoRange() && this.autoScale.getBooleanValue()) {
                this.axis.setAutoRange(true);
            }
            if (this.logBase.getDoubleValue() != ((PrismLogarithmicAxis)((Object)object)).getBase()) {
                range = this.axis.getRange();
                ((PrismLogarithmicAxis)((Object)object)).setBase(this.logBase.getDoubleValue());
                try {
                    this.minimumPower.setValue(((PrismLogarithmicAxis)((Object)object)).calculateLog(range.getLowerBound()));
                    this.maximumPower.setValue(((PrismLogarithmicAxis)((Object)object)).calculateLog(range.getUpperBound()));
                }
                catch (SettingException settingException) {
                    // empty catch block
                }
                if ((double)Math.round(this.logBase.getDoubleValue()) == this.logBase.getDoubleValue()) {
                    ((PrismLogarithmicAxis)((Object)object)).setMinorTickCount((int)this.logBase.getDoubleValue());
                } else {
                    ((PrismLogarithmicAxis)((Object)object)).setMinorTickCount(1);
                }
            }
            if (!(this.axis.isAutoRange() || (range = object.getRange()).getLowerBound() == ((PrismLogarithmicAxis)((Object)object)).calculateValue(this.minimumPower.getDoubleValue()) && range.getUpperBound() == ((PrismLogarithmicAxis)((Object)object)).calculateValue(this.maximumPower.getDoubleValue()))) {
                this.axis.setRange(((PrismLogarithmicAxis)((Object)object)).calculateValue(this.minimumPower.getDoubleValue()), ((PrismLogarithmicAxis)((Object)object)).calculateValue(this.maximumPower.getDoubleValue()));
            }
        }
        if (this.axis instanceof NumberAxis) {
            object = (NumberAxis)this.axis;
            if (this.axis.isAutoRange() && !this.autoScale.getBooleanValue()) {
                range = this.axis.getRange();
                this.axis.setAutoRange(false);
                this.axis.setAutoTickUnitSelection(false);
                try {
                    this.minValue.setValue(range.getLowerBound());
                    this.maxValue.setValue(range.getUpperBound());
                    this.gridInterval.setValue(object.getTickUnit().getSize());
                }
                catch (SettingException settingException) {
                    // empty catch block
                }
            }
            if (!this.axis.isAutoRange() && this.autoScale.getBooleanValue()) {
                this.axis.setAutoRange(true);
                this.axis.setAutoTickUnitSelection(true);
            }
            if (!this.axis.isAutoRange()) {
                range = this.axis.getRange();
                if (range.getLowerBound() != this.minValue.getDoubleValue() || range.getUpperBound() != this.maxValue.getDoubleValue()) {
                    this.axis.setRange(this.minValue.getDoubleValue(), this.maxValue.getDoubleValue());
                }
                if (this.gridInterval.getDoubleValue() != object.getTickUnit().getSize()) {
                    object.setTickUnit(new NumberTickUnit(this.gridInterval.getDoubleValue()));
                }
            }
        }
    }

    public void save(Element element) throws SettingException {
        element.setAttribute("heading", this.getHeading());
        Font font = this.getHeadingFont().f;
        element.setAttribute("headingFontName", font.getName());
        element.setAttribute("headingFontSize", "" + font.getSize());
        element.setAttribute("headingFontStyle", "" + font.getStyle());
        Color color = this.getHeadingFont().c;
        element.setAttribute("headingFontColourR", "" + color.getRed());
        element.setAttribute("headingFontColourG", "" + color.getGreen());
        element.setAttribute("headingFontColourB", "" + color.getBlue());
        Font font2 = this.getNumberFont().f;
        element.setAttribute("numberFontName", font2.getName());
        element.setAttribute("numberFontSize", "" + font2.getSize());
        element.setAttribute("numberFontStyle", "" + font2.getStyle());
        Color color2 = this.getHeadingFont().c;
        element.setAttribute("numberFontColourR", "" + color2.getRed());
        element.setAttribute("numberFontColourG", "" + color2.getGreen());
        element.setAttribute("numberFontColourB", "" + color2.getBlue());
        element.setAttribute("showMajor", this.showGrid() ? "true" : "false");
        Color color3 = this.gridColour.getColorValue();
        element.setAttribute("majorColourR", "" + color3.getRed());
        element.setAttribute("majorColourG", "" + color3.getGreen());
        element.setAttribute("majorColourB", "" + color3.getBlue());
        element.setAttribute("logarithmic", this.isLogarithmic() ? "true" : "false");
        element.setAttribute("minValue", "" + this.getMinValue());
        element.setAttribute("maxValue", "" + this.getMaxValue());
        element.setAttribute("majorGridInterval", "" + this.getGridInterval());
        element.setAttribute("logBase", "" + this.getLogBase());
        element.setAttribute("logStyle", "" + this.getLogStyle());
        element.setAttribute("minimumPower", "" + this.getMinimumPower());
        element.setAttribute("maximumPower", "" + this.getMaximumPower());
        element.setAttribute("autoscale", this.isAutoScale() ? "true" : "false");
    }

    public void load(Element element) throws SettingException {
        this.setHeading(element.getAttribute("heading"));
        String string = element.getAttribute("headingFontName");
        String string2 = element.getAttribute("headingFontSize");
        String string3 = element.getAttribute("headingFontStyle");
        Font font = Graph.parseFont(string, string3, string2);
        String string4 = element.getAttribute("headingFontColourR");
        String string5 = element.getAttribute("headingFontColourG");
        String string6 = element.getAttribute("headingFontColourB");
        Color color = Graph.parseColor(string4, string5, string6);
        this.setHeadingFont(new FontColorPair(font, color));
        String string7 = element.getAttribute("numberFontName");
        String string8 = element.getAttribute("numberFontSize");
        String string9 = element.getAttribute("numberFontStyle");
        Font font2 = Graph.parseFont(string7, string9, string8);
        String string10 = element.getAttribute("numberFontColourR");
        String string11 = element.getAttribute("numberFontColourG");
        String string12 = element.getAttribute("numberFontColourB");
        Color color2 = Graph.parseColor(string10, string11, string12);
        this.setNumberFont(new FontColorPair(font2, color2));
        boolean bl = Graph.parseBoolean(element.getAttribute("autoscale"));
        this.setAutoScale(bl);
        double d = Graph.parseDouble(element.getAttribute("minValue"));
        double d2 = Graph.parseDouble(element.getAttribute("maxValue"));
        double d3 = Graph.parseDouble(element.getAttribute("majorGridInterval"));
        if (!Double.isNaN(d) && !Double.isNaN(d2)) {
            if (d > this.getMaxValue()) {
                this.setMaxValue(d2);
                this.setMinValue(d);
            } else {
                this.setMinValue(d);
                this.setMaxValue(d2);
            }
        }
        if (!Double.isNaN(d3)) {
            this.setGridInterval(d3);
        }
        String string13 = element.getAttribute("majorColourR");
        String string14 = element.getAttribute("majorColourG");
        String string15 = element.getAttribute("majorColourB");
        Color color3 = Graph.parseColor(string13, string14, string15);
        this.showGrid(Graph.parseBoolean(element.getAttribute("showMajor")));
        this.setScaleType(Graph.parseBoolean(element.getAttribute("logarithmic")) ? 1 : 0);
        this.setLogBase(Graph.parseDouble(element.getAttribute("logBase")));
        this.setLogStyle(Graph.parseInt(element.getAttribute("logStyle")));
        double d4 = Graph.parseDouble(element.getAttribute("minimumPower"));
        double d5 = Graph.parseDouble(element.getAttribute("maximumPower"));
        if (!Double.isNaN(d4) && !Double.isNaN(d5)) {
            if (d4 > this.getMaximumPower()) {
                this.setMaximumPower(d5);
                this.setMinimumPower(d4);
            } else {
                this.setMinimumPower(d4);
                this.setMaximumPower(d5);
            }
        }
        this.setAutoScale(bl);
    }
}

