/*
 * Decompiled with CFR 0.152.
 */
package symbolic.model;

import jdd.JDDNode;
import jdd.JDDVars;
import prism.PrismException;
import symbolic.model.NondetModel;

public abstract class NondetModelTransformationOperator {
    protected NondetModel originalModel;
    protected JDDVars extraRowVars;
    protected JDDVars extraColVars;
    protected JDDVars extraActionVars;

    public NondetModelTransformationOperator(NondetModel nondetModel) {
        this.originalModel = nondetModel;
    }

    public void clear() {
        if (this.extraRowVars != null) {
            this.extraRowVars.derefAll();
        }
        if (this.extraColVars != null) {
            this.extraColVars.derefAll();
        }
        if (this.extraActionVars != null) {
            this.extraActionVars.derefAll();
        }
    }

    public String getExtraStateVariableName() {
        return "extra";
    }

    public String getExtraActionVariableName() {
        return "tau";
    }

    public abstract int getExtraStateVariableCount();

    public abstract int getExtraActionVariableCount();

    public void hookExtraStateVariableAllocation(JDDVars jDDVars, JDDVars jDDVars2) {
        this.extraRowVars = jDDVars;
        this.extraColVars = jDDVars2;
    }

    public void hookExtraActionVariableAllocation(JDDVars jDDVars) {
        this.extraActionVars = jDDVars;
    }

    public abstract JDDNode getTransformedTrans() throws PrismException;

    public abstract JDDNode getTransformedStart() throws PrismException;

    public JDDNode getTransformedStateReward(JDDNode jDDNode) throws PrismException {
        return jDDNode.copy();
    }

    public JDDNode getTransformedTransReward(JDDNode jDDNode) throws PrismException {
        return jDDNode.copy();
    }

    public JDDNode getTransformedTransActions() throws PrismException {
        if (this.originalModel.getTransActions() == null) {
            return null;
        }
        return this.originalModel.getTransActions().copy();
    }

    public JDDNode getTransformedLabelStates(JDDNode jDDNode, JDDNode jDDNode2) {
        return jDDNode.copy();
    }

    public JDDNode getReachableStates() throws PrismException {
        return null;
    }

    public JDDNode getReachableStateSeed() throws PrismException {
        return null;
    }

    public boolean deadlocksAreFine() {
        return false;
    }
}

