/*
 * Decompiled with CFR 0.152.
 */
package strat;

import java.util.function.Function;
import parser.State;
import prism.PrismException;
import strat.Strategy;
import strat.StrategyGenerator;

public abstract class StrategyWithStates<Value>
implements Strategy<Value>,
StrategyGenerator<Value> {
    protected Function<State, Integer> stateLookUp = null;
    protected State currentState = null;
    protected int currentStateIndex = -1;
    protected int currentMemory = -1;

    public void setStateLookUp(Function<State, Integer> function) {
        this.stateLookUp = function;
    }

    public int getStateIndex(State state) throws PrismException {
        if (this.stateLookUp == null) {
            throw new PrismException("Strategy does not support state look-up");
        }
        return this.stateLookUp.apply(state);
    }

    @Override
    public StrategyGenerator<Value> initialise(State state) {
        this.currentState = state;
        this.currentStateIndex = this.stateLookUp.apply(state);
        this.currentMemory = this.getInitialMemory(this.currentStateIndex);
        return this;
    }

    @Override
    public StrategyGenerator<Value> update(Object object, State state) {
        this.currentState = state;
        this.currentStateIndex = this.stateLookUp.apply(state);
        this.currentMemory = this.getUpdatedMemory(this.currentMemory, null, this.currentStateIndex);
        return this;
    }

    @Override
    public StrategyGenerator<Value> reset(State state, int n) {
        this.currentState = state;
        this.currentStateIndex = this.stateLookUp.apply(state);
        this.currentMemory = n;
        return this;
    }

    @Override
    public Object getCurrentChoiceAction() {
        return this.getChoiceAction(this.currentStateIndex, this.currentMemory);
    }

    @Override
    public int getCurrentMemory() {
        return this.currentMemory;
    }
}

