/*
 * Decompiled with CFR 0.152.
 */
package sparse;

import jdd.JDDNode;
import jdd.JDDVars;
import odd.ODDNode;
import prism.PrismException;
import sparse.PrismSparse;

public class NDSparseMatrix {
    private long ptr;

    private static native int PS_NDGetActionIndex(long var0, int var2, int var3);

    private static native long PS_BuildNDSparseMatrix(long var0, long var2, long var4, int var6, long var7, int var9, long var10, int var12);

    private static native long PS_BuildSubNDSparseMatrix(long var0, long var2, long var4, int var6, long var7, int var9, long var10, int var12, long var13);

    private static native void PS_AddActionsToNDSparseMatrix(long var0, long var2, long var4, long var6, int var8, long var9, int var11, long var12, int var14, long var15);

    private static native void PS_DeleteNDSparseMatrix(long var0);

    private NDSparseMatrix(long l) {
        this.ptr = l;
    }

    public long getPtr() {
        return this.ptr;
    }

    public int getActionIndex(int n, int n2) {
        return NDSparseMatrix.PS_NDGetActionIndex(this.ptr, n, n2);
    }

    public void delete() {
        NDSparseMatrix.PS_DeleteNDSparseMatrix(this.ptr);
    }

    public static NDSparseMatrix BuildNDSparseMatrix(JDDNode jDDNode, ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDVars jDDVars3) throws PrismException {
        long l = NDSparseMatrix.PS_BuildNDSparseMatrix(jDDNode.ptr(), oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDVars3.array(), jDDVars3.n());
        if (l == 0L) {
            throw new PrismException(PrismSparse.getErrorMessage());
        }
        return new NDSparseMatrix(l);
    }

    public static NDSparseMatrix BuildSubNDSparseMatrix(JDDNode jDDNode, ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDVars jDDVars3, JDDNode jDDNode2) throws PrismException {
        long l = NDSparseMatrix.PS_BuildSubNDSparseMatrix(jDDNode.ptr(), oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDVars3.array(), jDDVars3.n(), jDDNode2.ptr());
        if (l == 0L) {
            throw new PrismException(PrismSparse.getErrorMessage());
        }
        return new NDSparseMatrix(l);
    }

    public static void AddActionsToNDSparseMatrix(JDDNode jDDNode, JDDNode jDDNode2, ODDNode oDDNode, JDDVars jDDVars, JDDVars jDDVars2, JDDVars jDDVars3, NDSparseMatrix nDSparseMatrix) throws PrismException {
        NDSparseMatrix.PS_AddActionsToNDSparseMatrix(jDDNode.ptr(), jDDNode2.ptr(), oDDNode.ptr(), jDDVars.array(), jDDVars.n(), jDDVars2.array(), jDDVars2.n(), jDDVars3.array(), jDDVars3.n(), nDSparseMatrix.getPtr());
    }

    static {
        try {
            System.loadLibrary("prismsparse");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.out.println(unsatisfiedLinkError);
            System.exit(1);
        }
    }
}

