/*
 * Decompiled with CFR 0.152.
 */
package simulator.method;

import cern.jet.stat.Probability;
import prism.PrismException;
import simulator.method.CIMethod;
import simulator.method.SimulationMethod;
import simulator.sampler.Sampler;

public final class CIiterations
extends CIMethod {
    private int reqIterToConclude;
    private boolean reqIterToConcludeGiven;
    private double maxReward;
    private int computedIterations;
    private double squaredQuantile;

    public CIiterations(double d, double d2) {
        this.confidence = d;
        this.width = d2;
        this.reqIterToConclude = 0;
        this.reqIterToConcludeGiven = false;
        this.maxReward = 1.0;
        this.computedIterations = 0;
        this.squaredQuantile = 0.0;
    }

    public CIiterations(double d, double d2, int n) {
        this.confidence = d;
        this.width = d2;
        this.reqIterToConclude = n;
        this.reqIterToConcludeGiven = true;
        this.maxReward = 1.0;
        this.computedIterations = 0;
        this.squaredQuantile = 0.0;
    }

    public CIiterations(double d, double d2, double d3) {
        this.confidence = d;
        this.width = d2;
        this.maxReward = d3;
        this.reqIterToConclude = 0;
        this.reqIterToConcludeGiven = false;
        this.computedIterations = 0;
        this.squaredQuantile = 0.0;
    }

    @Override
    public void computeMissingParameterAfterSim() {
        this.numSamples = this.computedIterations;
        this.missingParameterComputed = true;
    }

    @Override
    public Object getMissingParameter() throws PrismException {
        if (!this.missingParameterComputed) {
            throw new PrismException("Missing parameter not computed yet");
        }
        return this.numSamples;
    }

    @Override
    public String getParametersString() {
        if (!this.missingParameterComputed) {
            return "width=" + this.width + ", confidence=" + this.confidence + ", number of samples=unknown";
        }
        return "width=" + this.width + ", confidence=" + this.confidence + ", number of samples=" + this.numSamples;
    }

    @Override
    public boolean shouldStopNow(int n, Sampler sampler) {
        double d = 0.0;
        if (n < 2) {
            return false;
        }
        if (sampler.getVariance() <= 0.0) {
            if (!this.reqIterToConcludeGiven && this.maxReward / this.width > (double)n) {
                return false;
            }
            if (this.reqIterToConcludeGiven && this.reqIterToConclude > n) {
                return false;
            }
        }
        d = n - 1 > 1 ? Probability.studentTInverse((double)this.confidence, (int)(n - 1)) : Math.tan((0.5 - this.confidence / 2.0) * Math.PI);
        this.squaredQuantile = d * d;
        if (sampler.getVariance() > 0.0 && (double)n < sampler.getVariance() * this.squaredQuantile / (this.width * this.width)) {
            return false;
        }
        this.computedIterations = n;
        return true;
    }

    @Override
    public int getProgress(int n, Sampler sampler) {
        if (sampler.getVariance() <= 0.0 || n < 2) {
            return 0;
        }
        return 10 * ((int)(100.0 * (double)(n + 1) / (sampler.getVariance() * this.squaredQuantile / (this.width * this.width))) / 10);
    }

    @Override
    public SimulationMethod clone() {
        CIiterations cIiterations = new CIiterations(this.confidence, this.width);
        cIiterations.numSamples = this.numSamples;
        cIiterations.missingParameterComputed = this.missingParameterComputed;
        cIiterations.prOp = this.prOp;
        cIiterations.theta = this.theta;
        cIiterations.reqIterToConclude = this.reqIterToConclude;
        cIiterations.reqIterToConcludeGiven = this.reqIterToConcludeGiven;
        cIiterations.maxReward = this.maxReward;
        cIiterations.computedIterations = this.computedIterations;
        cIiterations.squaredQuantile = this.squaredQuantile;
        return cIiterations;
    }
}

