/*
 * Decompiled with CFR 0.152.
 */
package simulator;

import java.util.ArrayList;
import parser.State;
import parser.VarList;
import prism.Evaluator;
import prism.ModelType;
import prism.PrismException;
import prism.PrismLangException;
import simulator.Choice;

public class TransitionList<Value> {
    public Evaluator<Value> eval;
    private ArrayList<Choice<Value>> choices;
    private ArrayList<Integer> transitionIndices;
    private ArrayList<Integer> transitionOffsets;
    private int numChoices;
    private int numTransitions;

    public TransitionList(Evaluator<Value> evaluator) {
        this.eval = evaluator;
        this.choices = new ArrayList();
        this.transitionIndices = new ArrayList();
        this.transitionOffsets = new ArrayList();
        this.numChoices = 0;
        this.numTransitions = 0;
    }

    public void clear() {
        this.choices.clear();
        this.transitionIndices.clear();
        this.transitionOffsets.clear();
        this.numChoices = 0;
        this.numTransitions = 0;
    }

    public void add(Choice<Value> choice) {
        this.choices.add(choice);
        int n = choice.size();
        for (int i = 0; i < n; ++i) {
            this.transitionIndices.add(this.choices.size() - 1);
            this.transitionOffsets.add(i);
        }
        ++this.numChoices;
        this.numTransitions += choice.size();
    }

    public void scaleProbabilitiesBy(Value Value2) {
        for (int i = 0; i < this.numChoices; ++i) {
            this.getChoice(i).scaleProbabilitiesBy(Value2);
        }
    }

    public int getNumChoices() {
        return this.numChoices;
    }

    public int getNumTransitions() {
        return this.numTransitions;
    }

    public Value getProbabilitySum() {
        Value Value2 = this.eval.zero();
        for (Choice<Value> choice : this.choices) {
            Value2 = this.eval.add(Value2, choice.getProbabilitySum());
        }
        return Value2;
    }

    public Choice<Value> getChoice(int n) {
        return this.choices.get(n);
    }

    public Choice<Value> getChoiceOfTransition(int n) {
        return this.choices.get(this.transitionIndices.get(n));
    }

    public int getChoiceIndexOfTransition(int n) {
        return this.transitionIndices.get(n);
    }

    public int getChoiceOffsetOfTransition(int n) {
        return this.transitionOffsets.get(n);
    }

    public int getTotalIndexOfTransition(int n, int n2) {
        return this.transitionIndices.indexOf(n) + n2;
    }

    public void getChoiceIndexByProbabilitySum(Value Value2, Ref ref) {
        int n;
        Value Value3 = this.eval.zero();
        Value Value4 = this.eval.zero();
        for (n = 0; this.eval.geq(Value2, Value4) && n < this.numChoices; ++n) {
            Value3 = this.getChoice(n).getProbabilitySum();
            Value4 = this.eval.add(Value4, Value3);
        }
        ref.i = n - 1;
        Choice<Value> choice = this.getChoice(n - 1);
        ref.offset = choice.size() > 1 ? choice.getIndexByProbabilitySum(this.eval.subtract(Value2, this.eval.subtract(Value4, Value3))) : 0;
    }

    public String getTransitionModuleOrAction(int n) {
        return this.getChoiceOfTransition(n).getModuleOrAction();
    }

    public int getTransitionModuleOrActionIndex(int n) {
        return this.getChoiceOfTransition(n).getModuleOrActionIndex();
    }

    public String getChoiceModuleOrAction(int n) {
        return this.getChoice(n).getModuleOrAction();
    }

    public int getChoiceModuleOrActionIndex(int n) {
        return this.getChoice(n).getModuleOrActionIndex();
    }

    public Value getTransitionProbability(int n) {
        return this.getChoiceOfTransition(n).getProbability(this.transitionOffsets.get(n));
    }

    public String getTransitionUpdateString(int n, State state) throws PrismLangException {
        return this.getChoiceOfTransition(n).getUpdateString(this.transitionOffsets.get(n), state);
    }

    public String getTransitionUpdateStringFull(int n) {
        return this.getChoiceOfTransition(n).getUpdateStringFull(this.transitionOffsets.get(n));
    }

    public State computeTransitionTarget(int n, State state, VarList varList) throws PrismLangException {
        return this.getChoiceOfTransition(n).computeTarget(this.transitionOffsets.get(n), state, varList);
    }

    public boolean isDeadlock() {
        return this.numChoices == 0;
    }

    public boolean isDeterministic() {
        return this.numTransitions == 1 && this.eval.isOne(this.getChoice(0).getProbability(0));
    }

    public boolean isDeterministicSelfLoop(State state, VarList varList) {
        State state2 = new State(state);
        try {
            for (Choice<Value> choice : this.choices) {
                int n = choice.size();
                for (int i = 0; i < n; ++i) {
                    choice.computeTarget(i, state, state2, varList);
                    if (state.equals(state2)) continue;
                    return false;
                }
            }
        }
        catch (PrismLangException prismLangException) {
            return false;
        }
        return true;
    }

    public void checkValid(ModelType modelType) throws PrismException {
        for (Choice<Value> choice : this.choices) {
            choice.checkValid(modelType);
        }
    }

    public void checkForErrors(State state, VarList varList) throws PrismException {
        for (Choice<Value> choice : this.choices) {
            choice.checkForErrors(state, varList);
        }
    }

    public String toString() {
        Object object = "";
        boolean bl = true;
        for (Choice<Value> choice : this.choices) {
            if (bl) {
                bl = false;
            } else {
                object = (String)object + ", ";
            }
            object = (String)object + choice.toString();
        }
        return object;
    }

    public class Ref {
        public int i;
        public int offset;
    }
}

