/*
 * Decompiled with CFR 0.152.
 */
package pta;

import explicit.Distribution;
import explicit.MDP;
import explicit.MDPSimple;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import prism.PrismException;
import prism.PrismLog;
import pta.DBM;
import pta.DBMList;
import pta.Edge;
import pta.LocZone;
import pta.PTA;
import pta.SymbolicTransition;
import pta.Transition;
import pta.Zone;

public class ReachabilityGraph {
    PTA pta;
    List<LocZone> states;
    ArrayList<ArrayList<SymbolicTransition>> trans;

    public ReachabilityGraph(PTA pTA) {
        this.pta = pTA;
        this.states = null;
        this.trans = new ArrayList();
    }

    public void addState() {
        this.trans.add(new ArrayList());
    }

    public void copyState(int n) {
        ArrayList<SymbolicTransition> arrayList = this.trans.get(n);
        ArrayList<SymbolicTransition> arrayList2 = new ArrayList<SymbolicTransition>(arrayList.size());
        for (SymbolicTransition symbolicTransition : arrayList) {
            arrayList2.add(new SymbolicTransition(symbolicTransition));
        }
        this.trans.add(arrayList2);
    }

    public void addTransition(int n, Transition transition, int[] nArray, Zone zone) {
        this.trans.get(n).add(new SymbolicTransition(transition, nArray, zone));
    }

    public boolean isSuccessor(int n, int n2) {
        for (SymbolicTransition symbolicTransition : this.trans.get(n)) {
            if (!symbolicTransition.hasSuccessor(n2)) continue;
            return true;
        }
        return false;
    }

    public void computeAllValidities() {
        int n = this.trans.size();
        for (int i = 0; i < n; ++i) {
            ArrayList<SymbolicTransition> arrayList = this.trans.get(i);
            for (SymbolicTransition symbolicTransition : arrayList) {
                symbolicTransition.valid = this.computeValidity(i, symbolicTransition.tr, symbolicTransition.dests);
            }
        }
    }

    public void printStates(PrismLog prismLog) {
        int n = 0;
        for (LocZone locZone : this.states) {
            if (n > 0) {
                prismLog.print(" ");
            }
            prismLog.print("#" + n++ + ":" + String.valueOf(locZone));
        }
    }

    public String toString() {
        Object object = "";
        int n = this.trans.size();
        boolean bl = true;
        object = "[ ";
        for (int i = 0; i < n; ++i) {
            if (bl) {
                bl = false;
            } else {
                object = (String)object + ", ";
            }
            object = (String)object + i + ":" + String.valueOf(this.trans.get(i));
        }
        object = (String)object + " ]";
        return object;
    }

    public Zone computeValidity(int n, Transition transition, int[] nArray) {
        DBMList dBMList = new DBMList(DBM.createTrue(this.pta));
        int n2 = 0;
        for (Edge edge : transition.getEdges()) {
            LocZone locZone = this.states.get(nArray[n2]).deepCopy();
            locZone.dPre(edge);
            ((Zone)dBMList).intersect(locZone.zone);
            ++n2;
        }
        dBMList.down();
        ((Zone)dBMList).intersect(this.states.get((int)n).zone);
        return dBMList;
    }

    public MDP buildMDP(List<Integer> list) throws PrismException {
        MDPSimple<Double> mDPSimple = new MDPSimple<Double>();
        mDPSimple.addStates(this.states.size());
        int n = this.states.size();
        for (int i = 0; i < n; ++i) {
            for (SymbolicTransition symbolicTransition : this.trans.get(i)) {
                Distribution<Double> distribution = Distribution.ofDouble();
                int n2 = -1;
                for (Edge edge : symbolicTransition.tr.getEdges()) {
                    int n3 = symbolicTransition.dests[++n2];
                    distribution.add(n3, edge.getProbability());
                }
                if (distribution.isEmpty()) continue;
                mDPSimple.addChoice(i, distribution);
            }
        }
        Iterator<Object> iterator = list.iterator();
        while (iterator.hasNext()) {
            int n4 = (Integer)iterator.next();
            mDPSimple.addInitialState(n4);
        }
        return mDPSimple;
    }
}

