/*
 * Decompiled with CFR 0.152.
 */
package pta;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import parser.ParserUtils;
import parser.Values;
import parser.VarList;
import parser.ast.ASTElement;
import parser.ast.Command;
import parser.ast.Declaration;
import parser.ast.DeclarationClock;
import parser.ast.DeclarationInt;
import parser.ast.DeclarationType;
import parser.ast.Expression;
import parser.ast.ExpressionBinaryOp;
import parser.ast.ExpressionConstant;
import parser.ast.ExpressionFunc;
import parser.ast.ExpressionIdent;
import parser.ast.ExpressionLabel;
import parser.ast.ExpressionProb;
import parser.ast.ExpressionProp;
import parser.ast.ExpressionTemporal;
import parser.ast.ExpressionVar;
import parser.ast.LabelList;
import parser.ast.Module;
import parser.ast.ModulesFile;
import parser.ast.Observable;
import parser.ast.PropertiesFile;
import parser.ast.Property;
import parser.ast.RewardStruct;
import parser.ast.RewardStructItem;
import parser.ast.Update;
import parser.ast.Updates;
import parser.type.TypeClock;
import parser.type.TypeInt;
import parser.visitor.ASTTraverse;
import parser.visitor.ASTTraverseModify;
import prism.ModelType;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismLangException;

public class DigitalClocks
extends PrismComponent {
    private Values constantValues;
    private VarList varList;
    private int timeBound = -1;
    private boolean doScaling = true;
    private ComputeClockInformation cci;
    private String timeAction;
    private Expression allInVariants = null;
    private ModulesFile mf = null;
    private PropertiesFile pf = null;
    private Expression prop = null;

    public DigitalClocks(PrismComponent prismComponent) throws PrismException {
        super(prismComponent);
    }

    public ModulesFile getNewModulesFile() {
        return this.mf;
    }

    public PropertiesFile getNewPropertiesFile() {
        return this.pf;
    }

    public Expression getNewPropertyToCheck() {
        return this.prop;
    }

    /*
     * WARNING - void declaration
     */
    public void translate(ModulesFile modulesFile, PropertiesFile propertiesFile, Expression expression) throws PrismException {
        ASTElement aSTElement;
        ASTElement aSTElement2;
        this.mainLog.println("\nPerforming digital clocks translation...");
        this.constantValues = modulesFile.getConstantValues();
        if (propertiesFile != null) {
            this.constantValues = new Values(this.constantValues, propertiesFile.getConstantValues());
        }
        this.varList = modulesFile.createVarList();
        ASTElement aSTElement3 = this.findAStrictClockConstraint(modulesFile, null);
        if (aSTElement3 != null) {
            throw new PrismLangException("Strict clock constraints are not allowed when using the digital clocks method", aSTElement3);
        }
        aSTElement3 = this.findADiagonalClockConstraint(modulesFile, null);
        if (aSTElement3 != null) {
            throw new PrismLangException("Diagonal clock constraints are not allowed when using the digital clocks method", aSTElement3);
        }
        for (RewardStruct object : modulesFile.getRewardStructs()) {
            object.accept(new ASTTraverseModify(){

                @Override
                public Object visit(ExpressionVar expressionVar) throws PrismLangException {
                    if (expressionVar.getType() instanceof TypeClock) {
                        throw new PrismLangException("Reward structures cannot contain references to clocks", expressionVar);
                    }
                    return expressionVar;
                }
            });
        }
        for (int i = 0; i < modulesFile.getNumGlobals(); ++i) {
            modulesFile.getGlobal(i).accept(new ASTTraverse(){

                @Override
                public void visitPost(Declaration declaration) throws PrismLangException {
                    if (declaration.getDeclType() instanceof DeclarationClock) {
                        throw new PrismLangException("Global clock variables are not allowed when using the digital clocks method", declaration);
                    }
                }
            });
        }
        if (expression != null) {
            this.checkProperty(expression, propertiesFile);
        }
        this.timeAction = "time";
        while (modulesFile.getSynchs().contains(this.timeAction)) {
            this.timeAction = this.timeAction + "_";
        }
        this.cci = new ComputeClockInformation(modulesFile, propertiesFile, expression);
        this.mainLog.println("Computed clock maximums: " + String.valueOf(this.cci.getClockMaxs()));
        if (this.doScaling) {
            this.mainLog.println("Computed GCD: " + this.cci.getScaleFactor());
        }
        this.mf = (ModulesFile)modulesFile.deepCopy();
        this.pf = propertiesFile == null ? null : (PropertiesFile)propertiesFile.deepCopy();
        this.prop = expression.deepCopy();
        this.mf.setModelTypeInFile(modulesFile.getModelType() == ModelType.PTA ? ModelType.MDP : ModelType.POMDP);
        this.mf = (ModulesFile)this.mf.accept(new ASTTraverseModify(){

            @Override
            public Object visit(Declaration declaration) throws PrismLangException {
                if (declaration.getDeclType() instanceof DeclarationClock) {
                    int n = DigitalClocks.this.cci.getScaledClockMax(declaration.getName());
                    if (n < 0) {
                        throw new PrismLangException("Clock " + declaration.getName() + " is unbounded since there are no references to it in the model");
                    }
                    DeclarationInt declarationInt = new DeclarationInt(Expression.Int(0), Expression.Int(n + 1));
                    Declaration declaration2 = new Declaration(declaration.getName(), declarationInt);
                    return declaration2;
                }
                return declaration;
            }
        });
        this.allInVariants = null;
        this.mf = (ModulesFile)this.mf.accept(new ASTTraverseModify(){

            @Override
            public Object visit(Module module) throws PrismLangException {
                Expression expression = module.getInvariant();
                Expression expression2 = expression = expression == null ? Expression.True() : expression.deepCopy();
                if (!Expression.isTrue(expression)) {
                    DigitalClocks.this.allInVariants = DigitalClocks.this.allInVariants == null ? expression.deepCopy() : Expression.And(DigitalClocks.this.allInVariants, expression.deepCopy());
                }
                expression = (Expression)expression.accept(new ASTTraverseModify(){

                    @Override
                    public Object visit(ExpressionVar expressionVar) throws PrismLangException {
                        if (expressionVar.getType() instanceof TypeClock) {
                            return Expression.Plus(expressionVar, Expression.Int(1));
                        }
                        return expressionVar;
                    }
                });
                Command command = new Command();
                command.setSynch(DigitalClocks.this.timeAction);
                command.setGuard(expression);
                Update update = new Update();
                for (String string : DigitalClocks.this.cci.getClocksForModule(module.getName())) {
                    int n = DigitalClocks.this.cci.getScaledClockMax(string);
                    ExpressionFunc expressionFunc = new ExpressionFunc("min");
                    expressionFunc.addOperand(Expression.Plus(new ExpressionVar(string, TypeInt.getInstance()), Expression.Int(1)));
                    expressionFunc.addOperand(Expression.Int(n + 1));
                    update.addElement(new ExpressionIdent(string), expressionFunc);
                }
                Updates updates = new Updates();
                updates.addUpdate(Expression.Double(1.0), update);
                command.setUpdates(updates);
                module.addCommand(command);
                module.setInvariant(null);
                return module;
            }
        });
        this.mf.getLabelList().addLabel(new ExpressionIdent("invariants"), this.allInVariants == null ? Expression.True() : this.allInVariants);
        ASTTraverseModify aSTTraverseModify = new ASTTraverseModify(){

            @Override
            public Object visit(Update update) throws PrismLangException {
                int n = update.getNumElements();
                for (int i = 0; i < n; ++i) {
                    if (!(update.getType(i) instanceof TypeClock)) continue;
                    update.setType(i, TypeInt.getInstance());
                    if (DigitalClocks.this.cci.getScaleFactor() <= 1) continue;
                    ExpressionFunc expressionFunc = new ExpressionFunc("floor");
                    expressionFunc.addOperand(Expression.Divide(update.getExpression(i), Expression.Int(DigitalClocks.this.cci.getScaleFactor())));
                    update.setExpression(i, (Expression)expressionFunc.simplify());
                }
                return update;
            }

            @Override
            public Object visit(ExpressionVar expressionVar) throws PrismLangException {
                if (expressionVar.getType() instanceof TypeClock) {
                    expressionVar.setType(TypeInt.getInstance());
                    if (!DigitalClocks.this.doScaling || DigitalClocks.this.cci.getScaleFactor() == 1) {
                        return expressionVar;
                    }
                    return Expression.Times(expressionVar, Expression.Int(DigitalClocks.this.cci.getScaleFactor()));
                }
                return expressionVar;
            }
        };
        this.mf = (ModulesFile)this.mf.accept(aSTTraverseModify);
        if (this.pf != null) {
            this.pf = (PropertiesFile)this.pf.accept(aSTTraverseModify);
        }
        this.prop = (Expression)this.prop.accept(aSTTraverseModify);
        for (RewardStruct rewardStruct : this.mf.getRewardStructs()) {
            int n = rewardStruct.getNumItems();
            for (int i = 0; i < n; ++i) {
                aSTElement2 = rewardStruct.getRewardStructItem(i);
                if (((RewardStructItem)aSTElement2).isTransitionReward()) continue;
                aSTElement = ((RewardStructItem)aSTElement2).getReward().deepCopy();
                if (this.cci.getScaleFactor() > 1) {
                    aSTElement = Expression.Times(aSTElement, Expression.Int(this.cci.getScaleFactor()));
                }
                aSTElement2 = new RewardStructItem(this.timeAction, ((RewardStructItem)aSTElement2).getStates().deepCopy(), (Expression)aSTElement);
                rewardStruct.setRewardStructItem(i, (RewardStructItem)aSTElement2);
            }
        }
        if (this.timeBound != -1) {
            void var7_13;
            int n = this.timeBound / this.cci.getScaleFactor();
            String string = "timer";
            while (this.mf.getModuleIndex((String)var7_13) != -1) {
                String string2 = "_" + (String)var7_13;
            }
            Object object = "timer";
            while (this.mf.isIdentUsed((String)object) || this.pf != null && this.pf.isIdentUsed((String)object)) {
                object = "_" + (String)object;
            }
            Object object2 = "T";
            while (this.mf.isIdentUsed((String)object2) || this.pf != null && this.pf.isIdentUsed((String)object2)) {
                object2 = "_" + (String)object2;
            }
            this.mf.getConstantList().addConstant(new ExpressionIdent((String)object2), Expression.Int(n), TypeInt.getInstance());
            aSTElement2 = new Module((String)var7_13);
            aSTElement = new DeclarationInt(Expression.Int(0), Expression.Plus(new ExpressionConstant((String)object2, TypeInt.getInstance()), Expression.Int(1)));
            Declaration declaration = new Declaration((String)object, (DeclarationType)aSTElement);
            ((Module)aSTElement2).addDeclaration(declaration);
            Command command = new Command();
            command.setSynch(this.timeAction);
            command.setGuard(Expression.True());
            Update update = new Update();
            ExpressionFunc expressionFunc = new ExpressionFunc("min");
            expressionFunc.addOperand(Expression.Plus(new ExpressionVar((String)object, TypeInt.getInstance()), Expression.Int(1)));
            expressionFunc.addOperand(Expression.Plus(new ExpressionConstant((String)object2, TypeInt.getInstance()), Expression.Literal(1)));
            update.addElement(new ExpressionIdent((String)object), expressionFunc);
            Updates updates = new Updates();
            updates.addUpdate(Expression.Double(1.0), update);
            command.setUpdates(updates);
            ((Module)aSTElement2).addCommand(command);
            this.mf.addModule((Module)aSTElement2);
            if (modulesFile.getModelType().partiallyObservable()) {
                this.mf.addObservableDefinition(new Observable((String)object, new ExpressionVar((String)object, TypeInt.getInstance())));
            }
            ExpressionVar expressionVar = new ExpressionVar((String)object, TypeInt.getInstance());
            final ExpressionBinaryOp expressionBinaryOp = new ExpressionBinaryOp(10, expressionVar, new ExpressionConstant((String)object2, TypeInt.getInstance()));
            this.prop.accept(new ASTTraverseModify(){

                @Override
                public Object visit(ExpressionTemporal expressionTemporal) throws PrismLangException {
                    expressionTemporal.setUpperBound(null);
                    ExpressionBinaryOp expressionBinaryOp2 = Expression.And(expressionTemporal.getOperand2().deepCopy(), expressionBinaryOp);
                    expressionTemporal.setOperand2(expressionBinaryOp2);
                    return expressionTemporal;
                }
            });
        }
        this.mf.tidyUp();
        if (this.pf != null) {
            this.pf.setModelInfo(this.mf);
            this.pf.tidyUp();
        }
        this.prop.findAllVars(this.mf.getVarNames(), this.mf.getVarTypes());
        this.mf.setSomeUndefinedConstants(modulesFile.getUndefinedEvaluateContext());
        this.pf.setSomeUndefinedConstants(propertiesFile.getUndefinedEvaluateContext());
    }

    public void checkProperty(Expression expression, PropertiesFile propertiesFile) throws PrismLangException {
        LabelList labelList = propertiesFile == null ? null : propertiesFile.getLabelList();
        try {
            expression.accept(new ASTTraverse(){

                @Override
                public void visitPost(ExpressionProb expressionProb) throws PrismLangException {
                    if (!expressionProb.getExpression().isSimplePathFormula()) {
                        throw new PrismLangException("The digital clocks method does not support LTL properties");
                    }
                }
            });
        }
        catch (PrismLangException prismLangException) {
            prismLangException.setASTElement(expression);
            throw prismLangException;
        }
        this.timeBound = -1;
        try {
            expression.accept(new ASTTraverse(){

                @Override
                public void visitPost(ExpressionTemporal expressionTemporal) throws PrismLangException {
                    if (expressionTemporal.getLowerBound() != null) {
                        throw new PrismLangException("The digital clocks method does not yet support lower time bounds");
                    }
                    if (expressionTemporal.getUpperBound() != null) {
                        if (!ExpressionTemporal.isFinally(expressionTemporal)) {
                            throw new PrismLangException("The digital clocks method only ssupport time bounds on F");
                        }
                        DigitalClocks.this.timeBound = expressionTemporal.getUpperBound().evaluateInt(DigitalClocks.this.constantValues);
                    }
                }
            });
        }
        catch (PrismLangException prismLangException) {
            prismLangException.setASTElement(expression);
            throw prismLangException;
        }
        if (expression.computeProbNesting(propertiesFile) > 1) {
            throw new PrismLangException("Nested P/R operators are not allowed when using the digital clocks method", expression);
        }
        ASTElement aSTElement = this.findAStrictClockConstraint(expression, labelList);
        if (aSTElement != null) {
            throw new PrismLangException("Strict clock constraints are not allowed when using the digital clocks method", aSTElement);
        }
        aSTElement = this.findADiagonalClockConstraint(expression, labelList);
        if (aSTElement != null) {
            throw new PrismLangException("Diagonal clock constraints are not allowed when using the digital clocks method", aSTElement);
        }
    }

    public ASTElement findAStrictClockConstraint(ASTElement aSTElement, final LabelList labelList) throws PrismLangException {
        try {
            ASTTraverse aSTTraverse = new ASTTraverse(){

                @Override
                public void visitPost(ExpressionBinaryOp expressionBinaryOp) throws PrismLangException {
                    if (expressionBinaryOp.getOperand1().getType() instanceof TypeClock ? expressionBinaryOp.getOperator() == 7 || expressionBinaryOp.getOperator() == 9 : expressionBinaryOp.getOperand2().getType() instanceof TypeClock && (expressionBinaryOp.getOperator() == 7 || expressionBinaryOp.getOperator() == 9)) {
                        throw new PrismLangException("Found one", expressionBinaryOp);
                    }
                }

                @Override
                public void visitPost(ExpressionLabel expressionLabel) throws PrismLangException {
                    int n;
                    if (labelList != null && (n = labelList.getLabelIndex(expressionLabel.getName())) != -1) {
                        labelList.getLabel(n).accept(this);
                    }
                }
            };
            aSTElement.accept(aSTTraverse);
        }
        catch (PrismLangException prismLangException) {
            return prismLangException.getASTElement();
        }
        return null;
    }

    public ASTElement findADiagonalClockConstraint(ASTElement aSTElement, final LabelList labelList) throws PrismLangException {
        try {
            ASTTraverse aSTTraverse = new ASTTraverse(){

                @Override
                public void visitPost(ExpressionBinaryOp expressionBinaryOp) throws PrismLangException {
                    if (expressionBinaryOp.getOperand1().getType() instanceof TypeClock && expressionBinaryOp.getOperand2().getType() instanceof TypeClock) {
                        throw new PrismLangException("Found one", expressionBinaryOp);
                    }
                }

                @Override
                public void visitPost(ExpressionLabel expressionLabel) throws PrismLangException {
                    int n;
                    if (labelList != null && (n = labelList.getLabelIndex(expressionLabel.getName())) != -1) {
                        labelList.getLabel(n).accept(this);
                    }
                }
            };
            aSTElement.accept(aSTTraverse);
        }
        catch (PrismLangException prismLangException) {
            return prismLangException.getASTElement();
        }
        return null;
    }

    class ComputeClockInformation
    extends ASTTraverse {
        PropertiesFile propertiesFile = null;
        LabelList labelList = null;
        private Map<String, List<String>> clockLists;
        private List<String> currentClockList;
        private Map<String, Integer> clockMaxs;
        private Set<Integer> allClockVals;
        private int scaleFactor;

        public ComputeClockInformation(ModulesFile modulesFile, PropertiesFile propertiesFile, Expression expression) throws PrismLangException {
            this.propertiesFile = propertiesFile;
            this.labelList = propertiesFile == null ? null : propertiesFile.getLabelList();
            this.clockLists = new HashMap<String, List<String>>();
            this.clockMaxs = new HashMap<String, Integer>();
            this.allClockVals = new HashSet<Integer>();
            modulesFile.accept(this);
            expression.accept(this);
            this.scaleFactor = this.computeGCD(this.allClockVals);
        }

        private void updateMax(String string, int n) {
            Integer n2 = this.clockMaxs.get(string);
            if (n2 == null || n > n2) {
                this.clockMaxs.put(string, n);
            }
        }

        public List<String> getClocksForModule(String string) {
            ArrayList arrayList = this.clockLists.get(string);
            return arrayList == null ? new ArrayList() : arrayList;
        }

        public int getClockMax(String string) {
            Integer n = this.clockMaxs.get(string);
            return n == null ? -1 : n;
        }

        public Map<String, Integer> getClockMaxs() {
            return this.clockMaxs;
        }

        public int getScaledClockMax(String string) {
            Integer n = this.clockMaxs.get(string);
            return n == null ? -1 : (DigitalClocks.this.doScaling ? n / this.scaleFactor : n);
        }

        public int getScaleFactor() {
            return this.scaleFactor;
        }

        private int computeGCD(Iterable<Integer> iterable) {
            int n = 0;
            for (int n2 : iterable) {
                n = this.computeGCD(n, n2);
            }
            if (n == 0) {
                n = 1;
            }
            return n;
        }

        private int computeGCD(int n, int n2) {
            return n2 == 0 ? n : this.computeGCD(n2, n % n2);
        }

        @Override
        public void visitPre(Module module) throws PrismLangException {
            this.currentClockList = new ArrayList<String>();
            this.clockLists.put(module.getName(), this.currentClockList);
        }

        @Override
        public void visitPost(Declaration declaration) throws PrismLangException {
            if (declaration.getDeclType() instanceof DeclarationClock) {
                this.currentClockList.add(declaration.getName());
            }
        }

        @Override
        public Object visit(Update update) throws PrismLangException {
            int n = update.getNumElements();
            for (int i = 0; i < n; ++i) {
                if (!(update.getType(i) instanceof TypeClock)) continue;
                String string = update.getVar(i);
                int n2 = ParserUtils.findMaxForIntExpression(update.getExpression(i), DigitalClocks.this.varList, DigitalClocks.this.constantValues);
                this.updateMax(string, n2);
                Collection<Integer> collection = ParserUtils.findAllValsForIntExpression(update.getExpression(i), DigitalClocks.this.varList, DigitalClocks.this.constantValues);
                this.allClockVals.addAll(collection);
            }
            return update;
        }

        @Override
        public void visitPost(ExpressionBinaryOp expressionBinaryOp) throws PrismLangException {
            if (expressionBinaryOp.getOperand1().getType() instanceof TypeClock) {
                if (!(expressionBinaryOp.getOperand2().getType() instanceof TypeClock)) {
                    String string = ((ExpressionVar)expressionBinaryOp.getOperand1()).getName();
                    int n = ParserUtils.findMaxForIntExpression(expressionBinaryOp.getOperand2(), DigitalClocks.this.varList, DigitalClocks.this.constantValues);
                    this.updateMax(string, n);
                    Collection<Integer> collection = ParserUtils.findAllValsForIntExpression(expressionBinaryOp.getOperand2(), DigitalClocks.this.varList, DigitalClocks.this.constantValues);
                    this.allClockVals.addAll(collection);
                }
            } else if (expressionBinaryOp.getOperand2().getType() instanceof TypeClock) {
                String string = ((ExpressionVar)expressionBinaryOp.getOperand2()).getName();
                int n = ParserUtils.findMaxForIntExpression(expressionBinaryOp.getOperand1(), DigitalClocks.this.varList, DigitalClocks.this.constantValues);
                this.updateMax(string, n);
                Collection<Integer> collection = ParserUtils.findAllValsForIntExpression(expressionBinaryOp.getOperand1(), DigitalClocks.this.varList, DigitalClocks.this.constantValues);
                this.allClockVals.addAll(collection);
            }
        }

        @Override
        public void visitPost(ExpressionTemporal expressionTemporal) throws PrismLangException {
            if (expressionTemporal.getLowerBound() != null) {
                this.allClockVals.add(expressionTemporal.getLowerBound().evaluateInt(DigitalClocks.this.constantValues));
            }
            if (expressionTemporal.getUpperBound() != null) {
                this.allClockVals.add(expressionTemporal.getUpperBound().evaluateInt(DigitalClocks.this.constantValues));
            }
        }

        @Override
        public void visitPost(ExpressionLabel expressionLabel) throws PrismLangException {
            int n;
            if (this.labelList != null && (n = this.labelList.getLabelIndex(expressionLabel.getName())) != -1) {
                this.labelList.getLabel(n).accept(this);
            }
        }

        @Override
        public void visitPost(ExpressionProp expressionProp) throws PrismLangException {
            if (this.propertiesFile != null) {
                Property property = this.propertiesFile.lookUpPropertyObjectByName(expressionProp.getName());
                if (property != null) {
                    property.accept(this);
                } else {
                    throw new PrismLangException("Unknown property reference " + String.valueOf(expressionProp), expressionProp);
                }
            }
        }
    }
}

