/*
 * Decompiled with CFR 0.152.
 */
package prism;

import explicit.ConstructModel;
import explicit.DTMCModelChecker;
import explicit.Model;
import io.ModelExportFormat;
import io.ModelExportOptions;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import parser.State;
import parser.ast.DeclarationInt;
import parser.ast.DeclarationType;
import parser.ast.Expression;
import parser.ast.PropertiesFile;
import parser.type.Type;
import parser.type.TypeInt;
import prism.ModelGenerator;
import prism.ModelType;
import prism.Prism;
import prism.PrismException;
import prism.PrismFileLog;
import prism.PrismLog;
import prism.PrismPrintStreamLog;
import prism.Result;

public class TestModelGenerator
implements ModelGenerator<Double> {
    protected State exploreState;
    protected int x;
    protected int n;
    protected List<String> varNames = Arrays.asList("x");
    protected List<Type> varTypes = Arrays.asList(TypeInt.getInstance());

    public TestModelGenerator(int n) {
        this.n = n;
    }

    @Override
    public ModelType getModelType() {
        return ModelType.DTMC;
    }

    @Override
    public List<String> getVarNames() {
        return this.varNames;
    }

    @Override
    public List<Type> getVarTypes() {
        return this.varTypes;
    }

    @Override
    public DeclarationType getVarDeclarationType(int n) throws PrismException {
        return new DeclarationInt(Expression.Int(0), Expression.Int(this.n));
    }

    @Override
    public List<String> getLabelNames() {
        return Arrays.asList("goal");
    }

    @Override
    public State getInitialState() throws PrismException {
        State state = new State(1);
        state.varValues[0] = this.n / 2;
        return state;
    }

    @Override
    public void exploreState(State state) throws PrismException {
        this.exploreState = state;
        this.x = (Integer)state.varValues[0];
    }

    @Override
    public int getNumChoices() throws PrismException {
        return 1;
    }

    @Override
    public int getNumTransitions(int n) throws PrismException {
        return this.x > 0 && this.x < this.n ? 2 : 1;
    }

    @Override
    public Object getTransitionAction(int n, int n2) throws PrismException {
        return null;
    }

    @Override
    public Double getTransitionProbability(int n, int n2) throws PrismException {
        return this.x > 0 && this.x < this.n ? 0.5 : 1.0;
    }

    @Override
    public State computeTransitionTarget(int n, int n2) throws PrismException {
        State state = new State(1);
        state.varValues[n] = this.x == 0 || this.x == this.n ? Integer.valueOf(this.x) : Integer.valueOf(n2 == 0 ? this.x - 1 : this.x + 1);
        return state;
    }

    @Override
    public boolean isLabelTrue(int n) throws PrismException {
        if (n == 0) {
            return this.x == this.n;
        }
        throw new PrismException("Label number \"" + n + "\" not defined");
    }

    public static void main(String[] stringArray) {
        try {
            Prism prism = new Prism(new PrismPrintStreamLog(System.out));
            prism.setMainLog(new PrismFileLog("stdout"));
            prism.initialise();
            int n = 2;
            if (n == 1) {
                TestModelGenerator testModelGenerator = new TestModelGenerator(10);
                ConstructModel constructModel = new ConstructModel(prism);
                constructModel.setSortStates(true);
                Model<Double> model = constructModel.constructModel(testModelGenerator);
                model.exportToDotFile((PrismLog)new PrismFileLog("test.dot"), null, true);
                DTMCModelChecker dTMCModelChecker = new DTMCModelChecker(prism);
                PropertiesFile propertiesFile = prism.parsePropertiesString(testModelGenerator, "P=? [F \"goal\"]");
                Expression expression = propertiesFile.getProperty(0);
                Result result = dTMCModelChecker.check(model, expression);
                System.out.println(result);
            } else {
                TestModelGenerator testModelGenerator = new TestModelGenerator(10);
                prism.loadModelGenerator(testModelGenerator);
                prism.exportBuiltModelTransitions(new File("test2.dot"), new ModelExportOptions(ModelExportFormat.DOT));
                PropertiesFile propertiesFile = prism.parsePropertiesString(testModelGenerator, "P=? [F x=10]");
                Expression expression = propertiesFile.getProperty(0);
                Result result = prism.modelCheck(propertiesFile, expression);
                System.out.println(result);
            }
            prism.closeDown(true);
        }
        catch (PrismException prismException) {
            System.err.println("Error: " + prismException.getMessage());
        }
    }
}

