/*
 * Decompiled with CFR 0.152.
 */
package prism;

import explicit.Model;
import explicit.rewards.Rewards;
import parser.State;
import parser.ast.RewardStruct;
import prism.Evaluator;
import prism.PrismException;
import prism.RewardInfo;

public interface RewardGenerator<Value>
extends RewardInfo {
    default public Evaluator<Value> getRewardEvaluator() {
        return Evaluator.forDouble();
    }

    default public boolean isRewardLookupSupported(RewardLookup rewardLookup) {
        return rewardLookup == RewardLookup.BY_STATE;
    }

    default public Value getStateReward(int n, State state) throws PrismException {
        if (!this.isRewardLookupSupported(RewardLookup.BY_STATE)) {
            throw new PrismException("Reward lookup by State not supported");
        }
        if (n < 0 || n >= this.getNumRewardStructs()) {
            throw new PrismException("Invalid reward index " + n);
        }
        throw new PrismException("Reward has not been defined");
    }

    default public Value getStateActionReward(int n, State state, Object object) throws PrismException {
        if (!this.isRewardLookupSupported(RewardLookup.BY_STATE)) {
            throw new PrismException("Reward lookup by State not supported");
        }
        if (n < 0 || n >= this.getNumRewardStructs()) {
            throw new PrismException("Invalid reward index " + n);
        }
        throw new PrismException("Reward has not been defined");
    }

    default public Value getStateReward(int n, int n2) throws PrismException {
        if (!this.isRewardLookupSupported(RewardLookup.BY_STATE_INDEX)) {
            throw new PrismException("Reward lookup by state index not supported");
        }
        if (n < 0 || n >= this.getNumRewardStructs()) {
            throw new PrismException("Invalid reward index " + n);
        }
        throw new PrismException("Reward has not been defined");
    }

    default public Value getStateActionReward(int n, int n2, Object object) throws PrismException {
        if (!this.isRewardLookupSupported(RewardLookup.BY_STATE_INDEX)) {
            throw new PrismException("Reward lookup by state index not supported");
        }
        if (n < 0 || n >= this.getNumRewardStructs()) {
            throw new PrismException("Invalid reward index " + n);
        }
        throw new PrismException("Reward has not been defined");
    }

    default public RewardStruct getRewardStruct(int n) throws PrismException {
        if (!this.isRewardLookupSupported(RewardLookup.BY_REWARD_STRUCT)) {
            throw new PrismException("Reward lookup by reward struct not supported");
        }
        if (n < 0 || n >= this.getNumRewardStructs()) {
            throw new PrismException("Invalid reward index " + n);
        }
        throw new PrismException("Reward has not been defined");
    }

    default public Rewards<Value> getRewardObject(int n) throws PrismException {
        if (!this.isRewardLookupSupported(RewardLookup.BY_REWARD_OBJECT)) {
            throw new PrismException("Reward lookup by reward object not supported");
        }
        if (n < 0 || n >= this.getNumRewardStructs()) {
            throw new PrismException("Invalid reward index " + n);
        }
        throw new PrismException("Reward has not been defined");
    }

    default public Model<Value> getRewardObjectModel() throws PrismException {
        if (!this.isRewardLookupSupported(RewardLookup.BY_REWARD_OBJECT)) {
            throw new PrismException("Reward lookup by reward object not supported");
        }
        throw new PrismException("Model for rewards has not been defined");
    }

    public static enum RewardLookup {
        BY_STATE,
        BY_STATE_INDEX,
        BY_REWARD_STRUCT,
        BY_REWARD_OBJECT;

    }
}

