/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import prism.PrismException;

public abstract class PrismLanguageTranslator {
    public abstract String getName();

    public abstract void load(InputStream var1) throws PrismException;

    public void load(String string) throws PrismException {
        this.load(new ByteArrayInputStream(string.getBytes()));
    }

    public void load(File file) throws PrismException {
        FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new PrismException("File \"" + file.getPath() + "\" not found");
        }
        this.load(fileInputStream);
    }

    public abstract void translate(PrintStream var1) throws PrismException;

    public String translateToString() throws PrismException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        this.translate(printStream);
        try {
            return byteArrayOutputStream.toString("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new PrismException("Error translating output stream to string: " + unsupportedEncodingException.getMessage());
        }
    }
}

