/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.io.File;
import prism.PrismException;
import prism.PrismFileLog;
import prism.PrismLog;
import prism.PrismPrintStreamLog;
import prism.PrismSettings;

public class PrismComponent {
    protected PrismLog mainLog = new PrismPrintStreamLog(System.out);
    protected PrismSettings settings = null;

    public PrismComponent() {
        this.settings = new PrismSettings();
    }

    public PrismComponent(PrismComponent prismComponent) {
        if (prismComponent == null) {
            return;
        }
        this.setLog(prismComponent.getLog());
        this.setSettings(prismComponent.getSettings());
    }

    public final void setLog(PrismLog prismLog) {
        this.mainLog = prismLog;
    }

    public final void setSettings(PrismSettings prismSettings) {
        this.settings = prismSettings;
    }

    public PrismLog getLog() {
        return this.mainLog;
    }

    public PrismSettings getSettings() {
        return this.settings;
    }

    public PrismLog getPrismLogForFile(File file) throws PrismException {
        return this.getPrismLogForFile(file, false);
    }

    public PrismLog getPrismLogForFile(File file, boolean bl) throws PrismException {
        PrismLog prismLog = file != null ? PrismFileLog.create(file.getPath(), bl) : this.mainLog;
        return prismLog;
    }

    public static String getDestinationStringForFile(File file) {
        return file == null ? "below:" : "to file \"" + String.valueOf(file) + "\"...";
    }
}

