/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import java.util.List;
import parser.ast.ModulesFile;
import parser.ast.SystemDefn;
import parser.visitor.ASTVisitor;
import parser.visitor.DeepCopy;
import prism.PrismLangException;

public class SystemReference
extends SystemDefn {
    private String name;

    public SystemReference(String string) {
        this.name = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void getModules(List<String> list) {
        list.add(this.name);
    }

    @Override
    public void getModules(List<String> list, ModulesFile modulesFile) {
        SystemDefn systemDefn = modulesFile.getSystemDefnByName(this.name);
        if (systemDefn != null) {
            systemDefn.getModules(list, modulesFile);
        }
    }

    @Override
    public void getSynchs(List<String> list) {
    }

    @Override
    public void getSynchs(List<String> list, ModulesFile modulesFile) {
        SystemDefn systemDefn = modulesFile.getSystemDefnByName(this.name);
        if (systemDefn != null) {
            systemDefn.getSynchs(list, modulesFile);
        }
    }

    @Override
    public void getReferences(List<String> list) {
        if (!list.contains(this.name)) {
            list.add(this.name);
        }
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public String toString() {
        return "\"" + this.name + "\"";
    }

    @Override
    public SystemReference deepCopy(DeepCopy deepCopy) {
        return this;
    }

    @Override
    public SystemReference clone() {
        return (SystemReference)super.clone();
    }
}

