/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import java.util.ArrayList;
import java.util.List;
import parser.ast.ASTElement;
import parser.ast.Command;
import parser.ast.Declaration;
import parser.ast.Expression;
import parser.ast.ExpressionIdent;
import parser.ast.ModulesFile;
import parser.visitor.ASTVisitor;
import parser.visitor.DeepCopy;
import prism.PrismLangException;

public class Module
extends ASTElement {
    private String name;
    private ExpressionIdent nameASTElement;
    private ArrayList<Declaration> decls;
    private ArrayList<Command> commands;
    private Expression invariant;
    private ModulesFile parent;
    private String baseModule;
    private ArrayList<String> alphabet;

    public Module(String string) {
        this.name = string;
        this.decls = new ArrayList();
        this.commands = new ArrayList();
        this.invariant = null;
        this.parent = null;
        this.baseModule = null;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setNameASTElement(ExpressionIdent expressionIdent) {
        this.nameASTElement = expressionIdent;
    }

    public void addDeclaration(Declaration declaration) {
        this.decls.add(declaration);
    }

    public void setDeclaration(int n, Declaration declaration) {
        this.decls.set(n, declaration);
    }

    public void addCommand(Command command) {
        this.commands.add(command);
        command.setParent(this);
    }

    public void removeCommand(Command command) {
        this.commands.remove(command);
    }

    public void setCommand(int n, Command command) {
        this.commands.set(n, command);
        command.setParent(this);
    }

    public void setInvariant(Expression expression) {
        this.invariant = expression;
    }

    public void setParent(ModulesFile modulesFile) {
        this.parent = modulesFile;
    }

    public void setBaseModule(String string) {
        this.baseModule = string;
    }

    public void setAlphabet(List<String> list) {
        this.alphabet = list == null ? null : new ArrayList<String>(list);
    }

    public String getName() {
        return this.name;
    }

    public ExpressionIdent getNameASTElement() {
        return this.nameASTElement;
    }

    public int getNumDeclarations() {
        return this.decls.size();
    }

    public Declaration getDeclaration(int n) {
        return this.decls.get(n);
    }

    public List<Declaration> getDeclarations() {
        return this.decls;
    }

    public boolean isVariableName(String string) {
        for (Declaration declaration : this.decls) {
            if (!declaration.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public int getNumCommands() {
        return this.commands.size();
    }

    public Command getCommand(int n) {
        return this.commands.get(n);
    }

    public List<Command> getCommands() {
        return this.commands;
    }

    public Expression getInvariant() {
        return this.invariant;
    }

    public ModulesFile getParent() {
        return this.parent;
    }

    public String getBaseModule() {
        return this.baseModule;
    }

    public List<String> getAllSynchs() {
        if (this.alphabet != null) {
            return this.alphabet;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.getNumCommands();
        for (int i = 0; i < n; ++i) {
            String string = this.getCommand(i).getSynch();
            if (string.equals("") || arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public boolean usesSynch(String string) {
        return this.getAllSynchs().contains(string);
    }

    public boolean isLocalVariable(String string) {
        int n = this.getNumDeclarations();
        for (int i = 0; i < n; ++i) {
            if (!this.getDeclaration(i).getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public String toString() {
        int n;
        Object object = "";
        object = (String)object + "module " + this.name + "\n\n";
        int n2 = this.getNumDeclarations();
        for (n = 0; n < n2; ++n) {
            object = (String)object + "\t" + String.valueOf(this.getDeclaration(n)) + ";\n";
        }
        if (n2 > 0) {
            object = (String)object + "\n";
        }
        if (this.invariant != null) {
            object = (String)object + "\tinvariant " + String.valueOf(this.invariant) + " endinvariant\n\n";
        }
        n2 = this.getNumCommands();
        for (n = 0; n < n2; ++n) {
            object = (String)object + "\t" + String.valueOf(this.getCommand(n)) + ";\n";
        }
        object = (String)object + "\nendmodule";
        return object;
    }

    @Override
    public Module deepCopy(DeepCopy deepCopy) throws PrismLangException {
        this.invariant = deepCopy.copy(this.invariant);
        this.nameASTElement = deepCopy.copy(this.nameASTElement);
        deepCopy.copyAll(this.decls);
        deepCopy.copyAll(this.commands);
        return this;
    }

    @Override
    public Module clone() {
        Module module = (Module)super.clone();
        module.decls = (ArrayList)this.decls.clone();
        module.commands = (ArrayList)this.commands.clone();
        module.alphabet = this.alphabet == null ? null : (ArrayList)this.alphabet.clone();
        return module;
    }
}

