/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import java.math.BigInteger;
import param.BigRational;
import parser.EvaluateContext;
import parser.ast.Expression;
import parser.type.TypeDouble;
import parser.type.TypeInt;
import parser.visitor.ASTVisitor;
import parser.visitor.DeepCopy;
import prism.PrismLangException;

public class ExpressionUnaryOp
extends Expression {
    public static final int NOT = 1;
    public static final int MINUS = 2;
    public static final int PARENTH = 3;
    public static final String[] opSymbols = new String[]{"", "!", "-", "()"};
    protected int op = 0;
    protected Expression operand = null;

    public ExpressionUnaryOp() {
    }

    public ExpressionUnaryOp(int n, Expression expression) {
        this.operand = expression;
        this.op = n;
    }

    public void setOperator(int n) {
        this.op = n;
    }

    public void setOperator(String string) throws PrismLangException {
        for (int i = 1; i < opSymbols.length; ++i) {
            if (!opSymbols[i].equals(string)) continue;
            this.setOperator(i);
            return;
        }
        throw new PrismLangException("Unknown unary operator '" + string + "'");
    }

    public void setOperand(Expression expression) {
        this.operand = expression;
    }

    public int getOperator() {
        return this.op;
    }

    public String getOperatorSymbol() {
        return opSymbols[this.op];
    }

    public Expression getOperand() {
        return this.operand;
    }

    @Override
    public boolean isConstant() {
        return this.operand.isConstant();
    }

    @Override
    public boolean isProposition() {
        return this.operand.isProposition();
    }

    @Override
    public Object evaluate(EvaluateContext evaluateContext) throws PrismLangException {
        Object object = this.operand.evaluate(evaluateContext);
        return this.apply(object, evaluateContext.getEvaluationMode());
    }

    public Object apply(Object object, EvaluateContext.EvalMode evalMode) throws PrismLangException {
        switch (this.op) {
            case 1: {
                return (Boolean)this.getType().castValueTo(object) == false;
            }
            case 2: {
                switch (evalMode) {
                    case FP: {
                        try {
                            if (this.getType() instanceof TypeInt) {
                                int n = (Integer)TypeInt.getInstance().castValueTo(object);
                                return Math.negateExact(n);
                            }
                            double d = (Double)TypeDouble.getInstance().castValueTo(object);
                            return -d;
                        }
                        catch (ArithmeticException arithmeticException) {
                            throw new PrismLangException(arithmeticException.getMessage(), this);
                        }
                    }
                    case EXACT: {
                        if (this.getType() instanceof TypeInt) {
                            BigInteger bigInteger = (BigInteger)TypeInt.getInstance().castValueTo(object);
                            return bigInteger.negate();
                        }
                        BigRational bigRational = (BigRational)TypeDouble.getInstance().castValueTo(object);
                        return bigRational.negate();
                    }
                }
                throw new PrismLangException("Unknown evaluation mode " + String.valueOf((Object)evalMode));
            }
            case 3: {
                return object;
            }
        }
        throw new PrismLangException("Unknown unary operator", this);
    }

    @Override
    public boolean returnsSingleValue() {
        return this.operand.returnsSingleValue();
    }

    @Override
    public Expression.Precedence getPrecedence() {
        switch (this.op) {
            case 1: {
                return Expression.Precedence.NOT;
            }
            case 2: {
                return Expression.Precedence.UNARY_MINUS;
            }
            case 3: {
                return Expression.Precedence.BASIC;
            }
        }
        return null;
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public ExpressionUnaryOp deepCopy(DeepCopy deepCopy) throws PrismLangException {
        this.operand = deepCopy.copy(this.operand);
        return this;
    }

    @Override
    public ExpressionUnaryOp clone() {
        return (ExpressionUnaryOp)super.clone();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.op == 3) {
            stringBuilder.append("(");
        } else {
            stringBuilder.append(opSymbols[this.op]);
        }
        stringBuilder.append(Expression.toStringPrecLt(this.operand, this));
        if (this.op == 3) {
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.op;
        n = 31 * n + (this.operand == null ? 0 : this.operand.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ExpressionUnaryOp expressionUnaryOp = (ExpressionUnaryOp)object;
        if (this.op != expressionUnaryOp.op) {
            return false;
        }
        return !(this.operand == null ? expressionUnaryOp.operand != null : !this.operand.equals(expressionUnaryOp.operand));
    }
}

